/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.sitetemplate.sitesyncunit.wirednetwork;

import com.tplink.smb.omada.backup.api.a.e;
import com.tplink.smb.omada.backup.api.dto.ClearDbDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.wirednetwork.dto.VirtualWanTemplateDTO;
import com.tplink.smb.omada.common.f.f;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.i.a;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.i.h;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.virtualwan.BaseVirtualWanPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.virtualwan.VirtualWanIpv4SettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.virtualwan.VirtualWanIpv4StaticPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.virtualwan.VirtualWanPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.virtualwan.VirtualWanTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.BaseInternetPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.InternetPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.Ipv4DhcpPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.Ipv4StaticPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.WanMultipleIpPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.WanPortIpv4SettingPO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@e(a=f.VIRTUAL_WAN)
public class VirtualWanSiteSyncTemplateUnit
extends com.tplink.smb.omada.backup.api.e {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VirtualWanSiteSyncTemplateUnit.class);
    private final h virtualWanMaintMongoRepository = h.a();
    private final com.tplink.smb.omada.portal.port.mongo.omada.a.a getSequenceNumService = (com.tplink.smb.omada.portal.port.mongo.omada.a.a)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.portal.port.mongo.omada.a.a.class);
    private final a internetMaintMongoRepository = a.a();
    private static final VirtualWanSiteSyncTemplateUnit instance = new VirtualWanSiteSyncTemplateUnit();

    private VirtualWanSiteSyncTemplateUnit() {
    }

    public static VirtualWanSiteSyncTemplateUnit getInstance() {
        return instance;
    }

    public void clearSiteBeforeSyncTemplate(ClearDbDTO clearDbDTO) {
        c omadacId = clearDbDTO.getOmadacId();
        d siteId = clearDbDTO.getSiteId();
        this.virtualWanMaintMongoRepository.b(omadacId, siteId);
    }

    public void siteTemplateSyncToSiteWrite(Object dataObject, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, boolean bindSite) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        VirtualWanTemplateDTO virtualWanTemplateDTO = (VirtualWanTemplateDTO)dataObject;
        List virtualWanTemplatePOList = Optional.ofNullable(virtualWanTemplateDTO).map(VirtualWanTemplateDTO::getVirtualWanTemplate).orElse(new ArrayList());
        this.filterVirtualWanTemplatePOList(omadacId, newSiteId, virtualWanTemplatePOList);
        Map wanIdMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), v2 -> new HashMap());
        List existList = this.virtualWanMaintMongoRepository.a(omadacId, newSiteId);
        HashMap boundExistsMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)existList)) {
            existList.forEach(exist -> {
                if (exist.getTemplateId() != null) {
                    boundExistsMap.put(exist.getTemplateId(), exist);
                }
            });
        }
        for (VirtualWanTemplatePO virtualWanTemplatePO : virtualWanTemplatePOList) {
            VirtualWanPO po = virtualWanTemplatePO.copyFromTemplate();
            po.setSiteId(newSiteId.a());
            if (boundExistsMap.containsKey(po.getTemplateId())) {
                VirtualWanPO exist2 = (VirtualWanPO)boundExistsMap.get(po.getTemplateId());
                po.setId(exist2.getId());
                po.setEntryId(exist2.getEntryId());
                boundExistsMap.remove(po.getTemplateId());
            } else {
                po.setId(null);
                po.setEntryId(Integer.valueOf(this.getSequenceNumService.a(omadacId.a(), newSiteId.a(), VirtualWanPO.class)));
            }
            wanIdMap.put(virtualWanTemplatePO.getId(), this.virtualWanMaintMongoRepository.a(po).getId());
        }
        if (!boundExistsMap.isEmpty()) {
            Set ids = boundExistsMap.values().stream().map(BaseVirtualWanPO::getId).collect(Collectors.toSet());
            this.virtualWanMaintMongoRepository.a(omadacId, newSiteId, ids);
        }
    }

    private void filterVirtualWanTemplatePOList(c omadacId, d newSiteId, List<VirtualWanTemplatePO> virtualWanTemplatePOList) {
        if (CollectionUtils.isEmpty(virtualWanTemplatePOList)) {
            return;
        }
        Optional internetOpt = this.internetMaintMongoRepository.c(omadacId, newSiteId);
        if (internetOpt.isEmpty() || !Boolean.TRUE.equals(((InternetPO)internetOpt.get()).getEnable())) {
            return;
        }
        HashSet<String> allIps = new HashSet<String>();
        List wanPortSettingList = internetOpt.map(BaseInternetPO::getWanPortIpv4Settings).orElse(new ArrayList());
        for (WanPortIpv4SettingPO wanPortSetting : wanPortSettingList) {
            Ipv4DhcpPO ipv4DhcpPO;
            if (Objects.isNull(wanPortSetting)) continue;
            Ipv4StaticPO ipv4StaticPO = Optional.of(wanPortSetting).map(WanPortIpv4SettingPO::getIpv4Static).orElse(null);
            if (!Objects.isNull(ipv4StaticPO)) {
                allIps.addAll(((List)Optional.of(ipv4StaticPO).map(Ipv4StaticPO::getWanMultipleIps).orElse(new ArrayList())).stream().map(WanMultipleIpPO::getIp).toList());
                allIps.add(ipv4StaticPO.getIpaddr());
            }
            if (Objects.isNull(ipv4DhcpPO = (Ipv4DhcpPO)Optional.of(wanPortSetting).map(WanPortIpv4SettingPO::getIpv4Dchp).orElse(null))) continue;
            allIps.addAll(((List)Optional.of(ipv4DhcpPO).map(Ipv4DhcpPO::getWanMultipleIps).orElse(new ArrayList())).stream().map(WanMultipleIpPO::getIp).toList());
        }
        allIps.removeIf(Objects::isNull);
        Set wanVlanPortIds = internetOpt.map(BaseInternetPO::getWanPortIpv4Settings).map(wanPortIpv4SettingPOS -> wanPortIpv4SettingPOS.stream().map(WanPortIpv4SettingPO::getVlanId).collect(Collectors.toSet())).orElse(new HashSet());
        wanVlanPortIds.removeIf(Objects::isNull);
        virtualWanTemplatePOList.removeIf(virtualWanTemplatePO -> {
            boolean ipConflict = allIps.contains(Optional.of(virtualWanTemplatePO).map(BaseVirtualWanPO::getVirtualWanIpv4SettingPO).map(VirtualWanIpv4SettingPO::getVirtualWanIpv4StaticPO).map(VirtualWanIpv4StaticPO::getIpaddr).orElse(null));
            boolean vlanIdConflict = wanVlanPortIds.contains(Optional.of(virtualWanTemplatePO).map(BaseVirtualWanPO::getVirtualWanIpv4SettingPO).map(VirtualWanIpv4SettingPO::getVlanId).orElse(null));
            return ipConflict || vlanIdConflict;
        });
    }
}

