/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.sitetemplate.sitesyncunit.wirednetwork;

import com.tplink.smb.omada.backup.api.a.e;
import com.tplink.smb.omada.backup.api.c.n;
import com.tplink.smb.omada.backup.api.dto.ClearDbDTO;
import com.tplink.smb.omada.backup.core.d.j;
import com.tplink.smb.omada.backup.core.unit.siteconfig.wirednetwork.dto.LanTemplateDTO;
import com.tplink.smb.omada.common.e.h;
import com.tplink.smb.omada.common.f.f;
import com.tplink.smb.omada.device.manage.message.EcspFirstVersionEnum;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.SitePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.i.b;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.landns.LanDnsPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.landns.LanDnsTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lannetwork.BaseLanNetworkPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lannetwork.LanNetworkPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lannetwork.LanNetworkTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lanprofile.LanProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lanprofile.LanProfileTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.BaseInternetPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.InternetPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.WanPortIpv4SettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.osgmodel.OsgModelConfigPO;
import com.tplink.smb.omada.manager.port.mongo.device.ComponentInfoPO;
import com.tplink.smb.omada.manager.port.mongo.device.DevicePO;
import com.tplink.smb.omada.manager.port.mongo.device.osg.c;
import com.tplink.smb.omada.portal.port.mongo.omada.a.a;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@e(a=f.LAN)
public class LanNetworkSiteSyncTemplateUnit
extends com.tplink.smb.omada.backup.api.e {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LanNetworkSiteSyncTemplateUnit.class);
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.g osgModelConfigMainMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.g.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.a internetMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c lanNetworkMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.e lanProfileMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.e.a();
    private final b lanDnsMaintMongoRepository = b.a();
    private final a getSequenceNumService = (a)com.tplink.smb.omada.common.spring.a.b(a.class);
    private final g siteMaintMongoRepository = g.a();
    private final c osgMaintMongoRepository = c.a();
    private final com.tplink.smb.omada.judgement.a.e judgeService = (com.tplink.smb.omada.judgement.a.e)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.judgement.a.e.class);
    private static final LanNetworkSiteSyncTemplateUnit instance = new LanNetworkSiteSyncTemplateUnit();

    private LanNetworkSiteSyncTemplateUnit() {
    }

    public static LanNetworkSiteSyncTemplateUnit getInstance() {
        return instance;
    }

    public void clearSiteBeforeSyncTemplate(ClearDbDTO clearDbDTO) {
        com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId = clearDbDTO.getOmadacId();
        d siteId = clearDbDTO.getSiteId();
        if (clearDbDTO.syncSiteTemplateNoBinding()) {
            this.lanNetworkMaintMongoRepository.e(omadacId, siteId);
            this.lanProfileMaintMongoRepository.c(omadacId, siteId);
            this.lanDnsMaintMongoRepository.c(omadacId, siteId);
            return;
        }
        if (clearDbDTO.firstBindSite()) {
            this.lanProfileMaintMongoRepository.a(omadacId, siteId, n.a);
            this.lanDnsMaintMongoRepository.a(omadacId, siteId, n.a);
        }
    }

    public void siteTemplateSyncToSiteWrite(Object dataObject, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, boolean bindSite) throws com.tplink.smb.omada.backup.api.d.c {
        LanTemplateDTO wiredNetworkDTO = (LanTemplateDTO)dataObject;
        if (wiredNetworkDTO == null) {
            log.warn("omadacId={},siteId={} Wired Network SiteImport dto is null.", (Object)omadacId.a(), (Object)newSiteId.a());
            return;
        }
        String siteTemplateId = this.siteMaintMongoRepository.a(omadacId, newSiteId).map(SitePO::getSiteTemplateId).orElse(null);
        Boolean internetEnable = Optional.ofNullable(this.internetMaintMongoRepository.a(omadacId, siteTemplateId)).map(BaseInternetPO::getEnable).map(Boolean.TRUE::equals).orElse(false);
        this.handleLanNetworkTemplate(omadacId, newSiteId, wiredNetworkDTO, siteImportIdCacheMap, bindSite, internetEnable);
        this.handleLanProfileTemplate(omadacId, newSiteId, wiredNetworkDTO, siteImportIdCacheMap, bindSite);
        this.handleLanDnsTemplate(omadacId, newSiteId, wiredNetworkDTO, siteImportIdCacheMap, bindSite);
        log.debug("omadacId={},siteId={} Wired Network SiteTemplateSyncToSiteWrite Success.", (Object)omadacId.a(), (Object)newSiteId.a());
    }

    private void handleLanDnsTemplate(@Nonnull com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, @Nonnull d newSiteId, @Nonnull LanTemplateDTO wiredNetworkDTO, Map<String, Map<String, String>> siteImportIdCacheMap, boolean bindSite) {
        List existList = this.lanDnsMaintMongoRepository.a(omadacId, newSiteId);
        Map netIdsMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), v2 -> new HashMap());
        Optional.ofNullable(wiredNetworkDTO.getLanDnsTemplate()).ifPresent(lanDns -> {
            HashMap boundExistsMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)existList)) {
                existList.forEach(exist -> {
                    if (exist.getTemplateId() != null) {
                        boundExistsMap.put(exist.getTemplateId(), exist);
                    }
                });
            }
            ArrayList existListCopy = new ArrayList(existList);
            lanDns.forEach(templatePO -> {
                this.handleLanDnsTemplate(omadacId, newSiteId, netIdsMap, boundExistsMap, (LanDnsTemplatePO)templatePO, bindSite);
                existListCopy.removeIf(lanDnsPO -> Objects.equals(lanDnsPO.getTemplateId(), templatePO.getId()));
            });
            if (!CollectionUtils.isEmpty(existListCopy)) {
                existListCopy.forEach(lanDnsPO -> this.lanDnsMaintMongoRepository.a(omadacId, newSiteId, lanDnsPO.getId()));
            }
        });
    }

    private void handleLanDnsTemplate(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, Map<String, String> netIdsMap, Map<String, LanDnsPO> boundExistsMap, LanDnsTemplatePO templatePO, boolean bindSite) {
        LanDnsPO lanDnsPO = templatePO.copyFromLanDnsTemplate();
        lanDnsPO.setOmadacId(omadacId.a());
        lanDnsPO.setSiteId(newSiteId.a());
        if (!CollectionUtils.isEmpty((Collection)lanDnsPO.getLanNetworkIds())) {
            lanDnsPO.setLanNetworkIds(com.tplink.smb.omada.common.util.e.a((List)lanDnsPO.getLanNetworkIds(), netIdsMap));
        }
        if (Boolean.TRUE.equals(bindSite)) {
            lanDnsPO.setId(null);
            lanDnsPO.setEntryId(Integer.valueOf(this.getSequenceNumService.a(omadacId.a(), newSiteId.a(), LanDnsPO.class)));
        } else if (boundExistsMap.containsKey(lanDnsPO.getTemplateId())) {
            LanDnsPO exist = boundExistsMap.get(lanDnsPO.getTemplateId());
            lanDnsPO.setId(exist.getId());
            lanDnsPO.setEntryId(exist.getEntryId());
        } else {
            lanDnsPO.setId(null);
            lanDnsPO.setEntryId(Integer.valueOf(this.getSequenceNumService.a(omadacId.a(), newSiteId.a(), LanDnsPO.class)));
        }
        this.lanDnsMaintMongoRepository.a(lanDnsPO);
    }

    private void handleLanNetworkTemplate(@Nonnull com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, @Nonnull d newSiteId, @Nonnull LanTemplateDTO wiredNetworkDTO, Map<String, Map<String, String>> siteImportIdCacheMap, boolean bindSite, Boolean templateInternetEnable) {
        List existList = this.lanNetworkMaintMongoRepository.a(omadacId, newSiteId);
        Map netIdsMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), v2 -> new HashMap());
        Map<String, String> portalIdMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.ad.A());
        Optional.ofNullable(wiredNetworkDTO.getLanNetworksTemplate()).ifPresent(lanNetworks -> {
            HashMap boundExistsMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)existList)) {
                existList.forEach(exist -> {
                    if (exist.getTemplateId() != null) {
                        boundExistsMap.put(exist.getTemplateId(), exist);
                    }
                });
            }
            this.filterLanNetworkTemplatePOList(omadacId, newSiteId, (List<LanNetworkTemplatePO>)lanNetworks);
            lanNetworks.forEach(lanNetworkTemplatePO -> this.handleLanNetworkTemplate(omadacId, newSiteId, portalIdMap, netIdsMap, boundExistsMap, (LanNetworkTemplatePO)lanNetworkTemplatePO, bindSite, templateInternetEnable));
            if (!CollectionUtils.isEmpty(boundExistsMap)) {
                Set invalidDataIds = boundExistsMap.keySet();
                for (String templateId : invalidDataIds) {
                    this.lanNetworkMaintMongoRepository.d(omadacId, newSiteId, templateId);
                }
            }
        });
        if (Boolean.TRUE.equals(bindSite)) {
            this.lanNetworkMaintMongoRepository.e(omadacId, newSiteId);
        }
    }

    private void filterLanNetworkTemplatePOList(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, List<LanNetworkTemplatePO> lanNetworkTemplatePOList) {
        if (CollectionUtils.isEmpty(lanNetworkTemplatePOList)) {
            return;
        }
        Optional internetOpt = this.internetMaintMongoRepository.c(omadacId, newSiteId);
        if (internetOpt.isEmpty() || !Boolean.TRUE.equals(((InternetPO)internetOpt.get()).getEnable())) {
            return;
        }
        Set wanVlanPortIds = internetOpt.map(BaseInternetPO::getWanPortIpv4Settings).map(wanPortIpv4SettingPOS -> wanPortIpv4SettingPOS.stream().map(WanPortIpv4SettingPO::getVlanId).collect(Collectors.toSet())).orElse(new HashSet());
        wanVlanPortIds.removeIf(Objects::isNull);
        lanNetworkTemplatePOList.removeIf(lanNetworkTemplatePO -> wanVlanPortIds.contains(Optional.of(lanNetworkTemplatePO).map(BaseLanNetworkPO::getVlan).orElse(null)));
    }

    private void handleLanNetworkTemplate(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, Map<String, String> portalIdMap, Map<String, String> netIdsMap, Map<String, LanNetworkPO> boundExistsMap, LanNetworkTemplatePO templatePO, boolean bindSite, Boolean templateInternetEnable) {
        LanNetworkPO lanNetworkPO = templatePO.copyFromTemplate();
        String oldLanNetworkId = templatePO.getId();
        lanNetworkPO.setOmadacId(omadacId.a());
        lanNetworkPO.setSiteId(newSiteId.a());
        if (Boolean.TRUE.equals(bindSite)) {
            this.bindTemplateForSiteLanNetwork(omadacId, newSiteId, lanNetworkPO, templateInternetEnable);
        } else if (boundExistsMap.containsKey(lanNetworkPO.getTemplateId())) {
            LanNetworkPO exist = boundExistsMap.get(lanNetworkPO.getTemplateId());
            boundExistsMap.remove(exist.getTemplateId());
            lanNetworkPO.setId(exist.getId());
            lanNetworkPO.setEntryId(exist.getEntryId());
            lanNetworkPO.setVlanEntryIdMap(exist.getVlanEntryIdMap());
            if (Objects.equals(lanNetworkPO.getDeviceType(), 1)) {
                lanNetworkPO.setDeviceMac(exist.getDeviceMac());
            }
            if (!Boolean.TRUE.equals(templateInternetEnable)) {
                lanNetworkPO.setAllLan(exist.getAllLan());
                lanNetworkPO.setInterfaceIds(exist.getInterfaceIds());
            }
            if (Boolean.TRUE.equals(lanNetworkPO.getPrimary()) && !Boolean.TRUE.equals(lanNetworkPO.getSubnetOverrideEnable())) {
                lanNetworkPO.setSubnetOverrideEnable(exist.getSubnetOverrideEnable());
                lanNetworkPO.setDhcpSettings(exist.getDhcpSettings());
                lanNetworkPO.setGatewaySubnet(exist.getGatewaySubnet());
                lanNetworkPO.setDhcpGuard(exist.getDhcpGuard());
                lanNetworkPO.setDhcpv6Guard(exist.getDhcpv6Guard());
                lanNetworkPO.setDhcpL2RelayEnable(exist.getDhcpL2RelayEnable());
            }
        } else {
            this.bindTemplateForDeletedLanNetwork(omadacId, newSiteId, lanNetworkPO);
        }
        if (!CollectionUtils.isEmpty(portalIdMap) && portalIdMap.containsKey(lanNetworkPO.getPortalId())) {
            lanNetworkPO.setPortalId(portalIdMap.get(lanNetworkPO.getPortalId()));
        }
        netIdsMap.put(oldLanNetworkId, (lanNetworkPO = this.lanNetworkMaintMongoRepository.a(lanNetworkPO)) == null ? null : lanNetworkPO.getId());
    }

    private void bindTemplateForSiteLanNetwork(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d siteId, LanNetworkPO lanNetworkPO, Boolean enable) {
        LanNetworkPO siteNetworkPO = Objects.equals(lanNetworkPO.getVlanType(), 1) ? this.lanNetworkMaintMongoRepository.a(omadacId, siteId, lanNetworkPO.getVlans(), lanNetworkPO.getPurpose()) : this.lanNetworkMaintMongoRepository.a(omadacId, siteId, lanNetworkPO.getVlan(), lanNetworkPO.getPurpose());
        if (siteNetworkPO != null) {
            lanNetworkPO.setId(siteNetworkPO.getId());
            lanNetworkPO.setEntryId(siteNetworkPO.getEntryId());
            lanNetworkPO.setVlanEntryIdMap(siteNetworkPO.getVlanEntryIdMap());
            if (Objects.equals(lanNetworkPO.getDeviceType(), 1)) {
                lanNetworkPO.setDeviceMac(siteNetworkPO.getDeviceMac());
            }
            if (!Boolean.TRUE.equals(enable)) {
                lanNetworkPO.setAllLan(siteNetworkPO.getAllLan());
                lanNetworkPO.setInterfaceIds(siteNetworkPO.getInterfaceIds());
            }
            if (Boolean.TRUE.equals(lanNetworkPO.getPrimary()) && !Boolean.TRUE.equals(lanNetworkPO.getSubnetOverrideEnable())) {
                lanNetworkPO.setSubnetOverrideEnable(siteNetworkPO.getSubnetOverrideEnable());
                lanNetworkPO.setDhcpSettings(siteNetworkPO.getDhcpSettings());
                lanNetworkPO.setGatewaySubnet(siteNetworkPO.getGatewaySubnet());
                lanNetworkPO.setDhcpGuard(siteNetworkPO.getDhcpGuard());
                lanNetworkPO.setDhcpv6Guard(siteNetworkPO.getDhcpv6Guard());
                lanNetworkPO.setDhcpL2RelayEnable(siteNetworkPO.getDhcpL2RelayEnable());
            }
        } else {
            this.bindTemplateForDeletedLanNetwork(omadacId, siteId, lanNetworkPO);
        }
    }

    private void handleLanProfileTemplate(@Nonnull com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, @Nonnull d newSiteId, @Nonnull LanTemplateDTO wiredNetworkDTO, Map<String, Map<String, String>> siteImportIdCacheMap, boolean bindSite) {
        List existList = this.lanProfileMaintMongoRepository.a(omadacId, newSiteId);
        Map netIdsMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), v2 -> new HashMap());
        Optional.ofNullable(wiredNetworkDTO.getLanProfileTemplate()).ifPresent(lanProfiles -> {
            HashMap boundExistsMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)existList)) {
                existList.forEach(exist -> {
                    if (exist.getTemplateId() != null) {
                        boundExistsMap.put(exist.getTemplateId(), exist);
                    }
                });
            }
            ArrayList existListCopy = new ArrayList(existList);
            lanProfiles.forEach(templatePO -> {
                this.handleLanProfileTemplate(omadacId, newSiteId, netIdsMap, boundExistsMap, (LanProfileTemplatePO)templatePO, bindSite);
                existListCopy.removeIf(lanProfilePO -> Objects.equals(lanProfilePO.getTemplateId(), templatePO.getId()));
            });
            if (!CollectionUtils.isEmpty(existListCopy)) {
                existListCopy.forEach(lanProfilePO -> this.lanProfileMaintMongoRepository.a(omadacId, newSiteId, lanProfilePO.getId()));
            }
        });
    }

    private void handleLanProfileTemplate(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, Map<String, String> netIdsMap, Map<String, LanProfilePO> boundExistsMap, LanProfileTemplatePO templatePO, boolean bindSite) {
        LanProfilePO lanProfilePO = templatePO.copyFromTemplate();
        String originalId = lanProfilePO.getId();
        lanProfilePO.setOmadacId(omadacId.a());
        lanProfilePO.setSiteId(newSiteId.a());
        if (Boolean.TRUE.equals(bindSite)) {
            lanProfilePO.setId(null);
            this.fillLanNetworkForSiteLanProfile(lanProfilePO, netIdsMap);
        } else if (boundExistsMap.containsKey(lanProfilePO.getTemplateId())) {
            LanProfilePO exist = boundExistsMap.get(lanProfilePO.getTemplateId());
            lanProfilePO.setId(exist.getId());
            lanProfilePO.setSupportESEnable(exist.getSupportESEnable());
            lanProfilePO.setEsEnable(exist.getEsEnable());
            lanProfilePO.setEsTaggedModified(exist.getEsTaggedModified());
            lanProfilePO.setDot1pPriority(exist.getDot1pPriority());
            lanProfilePO.setTrustMode(exist.getTrustMode());
            this.fillLanNetworkForSiteLanProfile(lanProfilePO, netIdsMap);
        } else {
            lanProfilePO.setId(null);
            this.fillLanNetworkForSiteLanProfile(lanProfilePO, netIdsMap);
            Optional networkTemplatePOOptional = this.lanNetworkMaintMongoRepository.b(omadacId.a(), lanProfilePO.getNativeNetworkId());
            networkTemplatePOOptional.flatMap(networkTemplatePO -> this.lanNetworkMaintMongoRepository.b(omadacId.a(), newSiteId.a(), networkTemplatePO.getId())).ifPresent(siteLanNetworkPO -> lanProfilePO.setNativeNetworkId(siteLanNetworkPO.getId()));
        }
        Optional.ofNullable(this.lanProfileMaintMongoRepository.a(lanProfilePO)).ifPresent(dbLanProfilePO -> netIdsMap.put(originalId, dbLanProfilePO.getId()));
    }

    private void fillLanNetworkForSiteLanProfile(LanProfilePO lanProfilePO, Map<String, String> netIdsMap) {
        if (netIdsMap == null) {
            return;
        }
        lanProfilePO.setNativeNetworkId(netIdsMap.getOrDefault(lanProfilePO.getNativeNetworkId(), lanProfilePO.getNativeNetworkId()));
        if (lanProfilePO.getTagNetworkIds() != null) {
            lanProfilePO.setTagNetworkIds(com.tplink.smb.omada.common.util.e.a((List)lanProfilePO.getTagNetworkIds(), netIdsMap));
        }
        if (lanProfilePO.getTagBridgeVlanMap() != null) {
            lanProfilePO.setTagBridgeVlanMap(j.a(lanProfilePO.getTagBridgeVlanMap(), netIdsMap));
        }
        if (lanProfilePO.getEsEnableTaggedNetworkIds() != null) {
            lanProfilePO.setEsEnableTaggedNetworkIds(com.tplink.smb.omada.common.util.e.a((List)lanProfilePO.getEsEnableTaggedNetworkIds(), netIdsMap));
        }
        if (lanProfilePO.getEsEnableTagBridgeVlanMap() != null) {
            lanProfilePO.setEsEnableTagBridgeVlanMap(j.a(lanProfilePO.getEsEnableTagBridgeVlanMap(), netIdsMap));
        }
        if (lanProfilePO.getUntagNetworkIds() != null) {
            lanProfilePO.setUntagNetworkIds(com.tplink.smb.omada.common.util.e.a((List)lanProfilePO.getUntagNetworkIds(), netIdsMap));
        }
        if (lanProfilePO.getUntagBridgeVlanMap() != null) {
            lanProfilePO.setUntagBridgeVlanMap(j.a(lanProfilePO.getUntagBridgeVlanMap(), netIdsMap));
        }
        lanProfilePO.setVoiceNetworkId(netIdsMap.get(lanProfilePO.getVoiceNetworkId()));
    }

    private void bindTemplateForDeletedLanNetwork(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, LanNetworkPO lanNetworkPO) {
        lanNetworkPO.setId(null);
        this.fillEntryIdAndInterface(omadacId, newSiteId, lanNetworkPO);
        this.fillDeviceMac(omadacId, newSiteId, lanNetworkPO);
    }

    private void fillDeviceMac(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, LanNetworkPO lanNetworkPO) {
        if (Objects.equals(lanNetworkPO.getDeviceType(), 1)) {
            Optional osgPOOptional = this.osgMaintMongoRepository.a(omadacId, newSiteId);
            if (osgPOOptional.isEmpty()) {
                return;
            }
            boolean supportEcspV1 = this.judgeService.a(omadacId.a(), "devices:common:compatible:ecsp_v1");
            boolean isEcspV1Osg = Objects.equals(EcspFirstVersionEnum.V1.getVersion(), osgPOOptional.map(DevicePO::getComponentInfo).map(ComponentInfoPO::getVersion).orElse(null));
            if (supportEcspV1 || !isEcspV1Osg) {
                lanNetworkPO.setDeviceMac((String)osgPOOptional.map(DevicePO::getMac).orElse(null));
            }
        }
    }

    private void fillEntryIdAndInterface(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d siteId, LanNetworkPO lanNetworkPO) {
        lanNetworkPO.setEntryId(Integer.valueOf(this.getSequenceNumService.a(omadacId.a(), siteId.a(), LanNetworkPO.class)));
        this.fillVlanEntryIdMap(omadacId, siteId, lanNetworkPO);
        this.transAllLanToInterfaces(lanNetworkPO, omadacId, siteId);
    }

    private void transAllLanToInterfaces(LanNetworkPO lanNetworkPO, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId) {
        Optional osgModelConfigPO = this.osgModelConfigMainMongoRepository.a(omadacId, newSiteId);
        Optional internetPOOptional = this.internetMaintMongoRepository.c(omadacId, newSiteId);
        if (internetPOOptional.isPresent() && ((InternetPO)internetPOOptional.get()).getEnable().booleanValue() && Boolean.TRUE.equals(lanNetworkPO.getAllLan()) && osgModelConfigPO.isPresent()) {
            lanNetworkPO.setAllLan(Boolean.valueOf(false));
            lanNetworkPO.setInterfaceIds(com.tplink.smb.omada.backup.core.unit.siteconfig.wirednetwork.a.a((OsgModelConfigPO)osgModelConfigPO.get()));
        }
    }

    public void fillVlanEntryIdMap(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d siteId, LanNetworkPO po) {
        if (Objects.equals(1, po.getVlanType())) {
            ArrayList vlans = new ArrayList(po.getVlanList());
            ArrayList entryIds = new ArrayList(this.getSequenceNumService.a(omadacId, siteId, (h)po, (h)po));
            HashMap<Integer, Integer> vlanEntryIdMap = new HashMap<Integer, Integer>(vlans.size());
            for (int i2 = 0; i2 < vlans.size(); ++i2) {
                vlanEntryIdMap.put((Integer)vlans.get(i2), (Integer)entryIds.get(i2));
            }
            po.setVlanEntryIdMap(vlanEntryIdMap);
        }
    }
}

