/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.sitetemplate.sitesyncunit.vrf;

import com.tplink.smb.omada.backup.api.c.n;
import com.tplink.smb.omada.backup.core.unit.siteconfig.osw.vrf.dto.OswVrfBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.osw.vrf.dto.OswVrfListBKDTO;
import com.tplink.smb.omada.common.constant.A;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.f.f;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.device.DevicePO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.e;
import com.tplink.smb.omada.manager.port.mongo.device.osw.vrf.OswVrfPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.vrf.OswVrfTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.x;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.e(a=f.VRF)
public class OswVrfSiteSyncTemplateUnit
extends com.tplink.smb.omada.backup.api.e {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OswVrfSiteSyncTemplateUnit.class);
    private static final OswVrfSiteSyncTemplateUnit instance = new OswVrfSiteSyncTemplateUnit();
    private final e oswMaintMongoRepository = e.a();
    private final x oswVrfMaintMongoRepository = x.a();

    public static OswVrfSiteSyncTemplateUnit getInstance() {
        return instance;
    }

    private OswVrfSiteSyncTemplateUnit() {
    }

    public void siteTemplateSyncToSiteWrite(Object dataObject, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, boolean bindSite) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        OswVrfListBKDTO vrfTemplateDTO = (OswVrfListBKDTO)dataObject;
        List oswPOList = this.oswMaintMongoRepository.a(omadacId.a(), newSiteId.a(), DeviceTypeEnum.c.b());
        if (CollectionUtils.isEmpty((Collection)oswPOList)) {
            return;
        }
        if (Objects.isNull(vrfTemplateDTO) || CollectionUtils.isEmpty(vrfTemplateDTO.getOswVrfBKDTOList())) {
            log.warn("omadacId={},siteId={} Osw Vrf SiteImport dto is null.", (Object)omadacId, (Object)newSiteId);
            return;
        }
        List<OswVrfBKDTO> completedOswVrfBackupList = vrfTemplateDTO.getOswVrfBKDTOList().stream().filter(oswVrfBackupDTO -> Boolean.TRUE.equals(oswVrfBackupDTO.getOswTemplate().getCompleted())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(completedOswVrfBackupList)) {
            log.warn("Failed to siteTemplateSyncToSiteWrite vrf, complated template is null, omadacId {}, siteId {}", (Object)omadacId, (Object)newSiteId);
            return;
        }
        Map<String, List<OswVrfBKDTO>> templateModelMap = completedOswVrfBackupList.stream().collect(Collectors.groupingBy(oswVrfBackup -> oswVrfBackup.getOswTemplate().getCompoundModel()));
        Map<String, List<OswPO>> oswModelMap = oswPOList.stream().collect(Collectors.groupingBy(DevicePO::getCompoundModel));
        boolean alreadyBindSite = oswPOList.stream().anyMatch(osw -> Objects.nonNull(osw.getTemplateId()));
        if (alreadyBindSite) {
            this.handleAlreadyBindSite(omadacId, newSiteId, oswPOList, completedOswVrfBackupList);
            return;
        }
        ArrayList<OswVrfPO> needSaveList = new ArrayList<OswVrfPO>();
        oswModelMap.forEach((compoundModel, oswList) -> {
            List oswVrfBKDTOS;
            OswVrfBKDTO oswVrfBKDTO;
            if (templateModelMap.containsKey(compoundModel) && !Objects.isNull(oswVrfBKDTO = (OswVrfBKDTO)(oswVrfBKDTOS = (List)templateModelMap.get(compoundModel)).stream().filter(oswVrfBackup -> Boolean.TRUE.equals(oswVrfBackup.getOswTemplate().getAutoBind())).findFirst().orElse(null))) {
                oswList.removeIf(oswPO -> oswPO.getMlagName() != null);
                if (CollectionUtils.isEmpty((Collection)oswVrfBKDTO.getOswTemplate().getTemplateSettings()) || !oswVrfBKDTO.getOswTemplate().getTemplateSettings().contains(A.h.b())) {
                    return;
                }
                List<String> macs = oswList.stream().map(DevicePO::getMac).collect(Collectors.toList());
                this.handleVrfRemove(omadacId, newSiteId, macs, oswVrfBKDTO.getOswTemplate());
                List<OswVrfTemplatePO> oswVrfTemplatePOS = oswVrfBKDTO.getOswVrfTemplatePOS();
                oswList.forEach(oswPO -> {
                    if (log.isDebugEnabled()) {
                        log.debug("sync copy vrfTemplates {}, omadacId {}, siteId{}", new Object[]{com.tplink.smb.omada.common.util.x.a((Object)oswVrfTemplatePOS), oswPO.getOmadacId(), oswPO.getSiteId()});
                    }
                    this.handleVrfsWithTemplate(oswVrfTemplatePOS, (OswPO)oswPO, needSaveList);
                });
            }
        });
        this.handleVrfSaveWithTemplate(needSaveList);
    }

    private void handleAlreadyBindSite(c omadacId, d newSiteId, List<OswPO> oswPOList, List<OswVrfBKDTO> completedOswBackupList) {
        Map backupDTOMap = completedOswBackupList.stream().collect(Collectors.toMap(oswBackupDTO -> oswBackupDTO.getOswTemplate().getId(), Function.identity()));
        ArrayList<OswVrfPO> needSaveList = new ArrayList<OswVrfPO>();
        for (OswPO oswPO : oswPOList) {
            OswVrfBKDTO oswVrfBKDTO = Optional.ofNullable(oswPO.getTemplateId()).map(backupDTOMap::get).orElse(null);
            if (Objects.isNull(oswVrfBKDTO)) continue;
            this.handleVrfRemove(omadacId, newSiteId, Collections.singletonList(oswPO.getMac()), oswVrfBKDTO.getOswTemplate());
            this.handleVrfsWithTemplate(oswVrfBKDTO.getOswVrfTemplatePOS(), oswPO, needSaveList);
        }
        this.handleVrfSaveWithTemplate(needSaveList);
    }

    private void handleVrfRemove(c omadacId, d newSiteId, List<String> oswMacs, OswTemplatePO oswTemplatePO) {
        log.debug("handleVrfRemove switch, omadacId {}, siteId {}", (Object)omadacId, (Object)newSiteId);
        if (CollectionUtils.isEmpty((Collection)oswTemplatePO.getTemplateSettings())) {
            return;
        }
        if (oswTemplatePO.getTemplateSettings().contains(A.h.b())) {
            this.oswVrfMaintMongoRepository.a(omadacId.a(), newSiteId.a(), oswMacs);
        }
    }

    private void handleVrfsWithTemplate(List<OswVrfTemplatePO> vrfTemplates, OswPO oswPO, List<OswVrfPO> needSaveList) {
        if (CollectionUtils.isEmpty(vrfTemplates)) {
            return;
        }
        vrfTemplates.forEach(oswVrfTemplatePO -> {
            OswVrfPO oswVrfPO = oswVrfTemplatePO.copyFromTemplate();
            oswVrfPO.setMac(oswPO.getMac());
            oswVrfPO.setSiteId(oswPO.getSiteId());
            oswVrfPO.setOmadacId(oswPO.getOmadacId());
            needSaveList.add(oswVrfPO);
        });
    }

    private void handleVrfSaveWithTemplate(List<OswVrfPO> needSaveList) {
        if (CollectionUtils.isEmpty(needSaveList)) {
            return;
        }
        this.oswVrfMaintMongoRepository.a(new ArrayList<OswVrfPO>(needSaveList), n.a);
    }
}

