/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.sitetemplate.sitesyncunit.vpn;

import com.tplink.smb.omada.backup.api.a.e;
import com.tplink.smb.omada.common.f.f;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.auth.AuthenticationMaintRepository;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@e(a=f.VPN)
public class VpnSiteSyncTemplateUnit
extends com.tplink.smb.omada.backup.api.e {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VpnSiteSyncTemplateUnit.class);
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.vpn.d vpnMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.vpn.d.a();
    private final AuthenticationMaintRepository authenticationMaintRepository = AuthenticationMaintRepository.getInstance();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c lanNetworkMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c.a();
    private static final Integer AUTO_IPSEC = 0;
    private static final Integer SITE_TO_SITE_VPN = 0;
    private static final VpnSiteSyncTemplateUnit instance = new VpnSiteSyncTemplateUnit();

    private VpnSiteSyncTemplateUnit() {
    }

    public static VpnSiteSyncTemplateUnit getInstance() {
        return instance;
    }

    public void siteTemplateSyncToSiteWrite(Object dataObject, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, boolean bindSite) throws com.tplink.smb.omada.backup.api.d.c, IOException {
    }

    public void checkUnsupportedAfterSiteSyncTemplate(c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        List vpnPOS = this.vpnMongoRepository.a(omadacId, newSiteId);
        if (CollectionUtils.isEmpty((Collection)vpnPOS)) {
            return;
        }
        vpnPOS.forEach(vpnPO -> {
            String oldLdapProfileId;
            if (SITE_TO_SITE_VPN.equals(vpnPO.getPurpose()) && AUTO_IPSEC.equals(vpnPO.getSiteVpnType())) {
                return;
            }
            if (!CollectionUtils.isEmpty((Collection)vpnPO.getNetworkList())) {
                List<String> networks = this.getExistedNetworkList(omadacId, newSiteId, vpnPO.getNetworkList());
                if (CollectionUtils.isEmpty(networks)) {
                    this.vpnMongoRepository.a(omadacId, newSiteId, vpnPO.getId());
                    log.info("delete vpn - checkUnsupportedAfterSiteSyncTemplate - lack of network, omadacId {}, siteId {}", (Object)omadacId.a(), (Object)newSiteId.a());
                    return;
                }
                vpnPO.setNetworkList(networks);
            }
            if (Objects.equals(vpnPO.getAuthType(), 1) && (oldLdapProfileId = vpnPO.getLdapProfile()) != null && !this.authenticationMaintRepository.existLdapProfileByOmadacIdAndSiteIdAndId(omadacId, newSiteId, oldLdapProfileId)) {
                this.vpnMongoRepository.a(omadacId, newSiteId, vpnPO.getSiteId());
                log.info("delete vpn - checkUnsupportedAfterSiteSyncTemplate - lack of ldap, omadacId {}, siteId {}", (Object)omadacId.a(), (Object)newSiteId.a());
                return;
            }
            this.vpnMongoRepository.a(vpnPO);
        });
    }

    private List<String> getExistedNetworkList(c omadacId, d siteId, List<String> oldNetworkList) {
        if (CollectionUtils.isEmpty(oldNetworkList)) {
            return Collections.emptyList();
        }
        ArrayList<String> newNetworkList = new ArrayList<String>(oldNetworkList.size());
        for (String networkId : oldNetworkList) {
            Optional optional = this.lanNetworkMaintMongoRepository.a(omadacId.a(), siteId.a(), networkId);
            if (!optional.isPresent()) continue;
            newNetworkList.add(networkId);
        }
        return newNetworkList;
    }
}

