/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.sitetemplate.sitesyncunit.sim;

import com.tplink.smb.omada.backup.api.a.e;
import com.tplink.smb.omada.backup.api.dto.ClearDbDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.mail.dto.MailDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.sim.dto.SimDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.sim.dto.SimSettingsDTO;
import com.tplink.smb.omada.common.f.f;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.mail.MailServerPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.mail.MailServerTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sim.SimSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sim.SimSettingTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sim.sms.setting.SimSmsSettingPO;
import com.tplink.smb.omada.portal.port.mongo.omada.a.a;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@e(a=f.SIM)
public class SimSiteSyncTemplateUnit
extends com.tplink.smb.omada.backup.api.e {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimSiteSyncTemplateUnit.class);
    private static final SimSiteSyncTemplateUnit instance = new SimSiteSyncTemplateUnit();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.sim.a simSettingRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.sim.a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.mail.a mailServerRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.mail.a.a();
    private final a getSequenceNumService = (a)com.tplink.smb.omada.common.spring.a.b(a.class);

    private SimSiteSyncTemplateUnit() {
    }

    public void clearSiteBeforeSyncTemplate(ClearDbDTO clearDbDTO) {
        this.mailServerRepository.c(clearDbDTO.getOmadacId(), clearDbDTO.getSiteId());
        this.simSettingRepository.d(clearDbDTO.getOmadacId(), clearDbDTO.getSiteId());
    }

    public void siteTemplateSyncToSiteWrite(Object dataObject, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, boolean bindSite) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        SimSettingsDTO simSettingsDTO = (SimSettingsDTO)dataObject;
        if (simSettingsDTO == null) {
            return;
        }
        HashMap<String, String> mailMap = new HashMap();
        if (simSettingsDTO.getMailDTO() != null) {
            mailMap = this.syncMailServer(simSettingsDTO.getMailDTO(), omadacId, newSiteId, siteImportIdCacheMap);
        }
        if (simSettingsDTO.getSimDTO() != null) {
            this.syncSim(omadacId, newSiteId, simSettingsDTO.getSimDTO(), mailMap);
        }
    }

    private Map<String, String> syncMailServer(MailDTO mailDTO, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap) {
        HashMap<String, String> mailMap;
        List<MailServerTemplatePO> templates = mailDTO.getServersTemplate();
        Map<Object, Object> map = mailMap = siteImportIdCacheMap.get("mailServerIdMap") == null ? new HashMap() : siteImportIdCacheMap.get("mailServerIdMap");
        if (!CollectionUtils.isEmpty(templates)) {
            templates.forEach(template -> {
                MailServerPO mailServer = template.copyFromTemplate();
                String oldId = template.getId();
                mailServer.setEntryId(Integer.valueOf(this.getSequenceNumService.a(omadacId.a(), newSiteId.a(), this.mailServerRepository.b())));
                mailServer.setOmadacId(omadacId.a());
                mailServer.setSiteId(newSiteId.a());
                mailServer.setId(null);
                mailMap.put(oldId, this.mailServerRepository.b(mailServer));
            });
        }
        siteImportIdCacheMap.put("mailServerIdMap", mailMap);
        return mailMap;
    }

    private void syncSim(c omadacId, d newSiteId, SimDTO sim, Map<String, String> mailServerIdMap) {
        SimSettingTemplatePO settingTemplate = sim.getSettingTemplate();
        if (Objects.isNull(settingTemplate)) {
            log.warn("{} {} the correct Sim SettingTemplate is not existed.", (Object)omadacId, (Object)newSiteId);
            return;
        }
        SimSettingPO simSetting = settingTemplate.copyFromTemplate();
        simSetting.setOmadacId(omadacId.a());
        simSetting.setSiteId(newSiteId.a());
        simSetting.setId(null);
        Optional.ofNullable(simSetting.getSmsSetting()).map(SimSmsSettingPO::getPolicySetting).ifPresent(policy -> {
            if (policy.getMailServer() != null) {
                if (mailServerIdMap == null || mailServerIdMap.get(policy.getMailServer()) == null) {
                    log.warn("{} {} the correct Mail Server ID is not existed.", (Object)omadacId, (Object)newSiteId);
                    return;
                }
                simSetting.getSmsSetting().getPolicySetting().setMailServer((String)mailServerIdMap.get(policy.getMailServer()));
            }
        });
        this.simSettingRepository.b(simSetting);
    }

    @Generated
    public static SimSiteSyncTemplateUnit getInstance() {
        return instance;
    }
}

