/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.sitetemplate.sitesyncunit.servicesetting;

import com.tplink.smb.omada.backup.api.a.e;
import com.tplink.smb.omada.backup.api.dto.ClearDbDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.sitetemplate.dto.MdnsTemplateDTO;
import com.tplink.smb.omada.common.f.f;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.mdns.MdnsProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.mdns.BaseMdnsRulePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.mdns.MdnsRulePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.mdns.MdnsRuleTemplatePO;
import com.tplink.smb.omada.portal.port.mongo.omada.a.a;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@e(a=f.MDNS)
public class MdnsSiteSyncTemplateUnit
extends com.tplink.smb.omada.backup.api.e {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MdnsSiteSyncTemplateUnit.class);
    private static final MdnsSiteSyncTemplateUnit instance = new MdnsSiteSyncTemplateUnit();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.mdns.a mdnsRuleMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.mdns.a.a();
    private final a getSequenceNumService = (a)com.tplink.smb.omada.common.spring.a.b(a.class);
    private static final int MDNS_RULE_AP_TYPE = 0;
    private static final int MDNS_RULE_OSG_TYPE = 1;

    public static MdnsSiteSyncTemplateUnit getInstance() {
        return instance;
    }

    private MdnsSiteSyncTemplateUnit() {
    }

    public void clearSiteBeforeSyncTemplate(ClearDbDTO clearDbDTO) {
        c omadacId = clearDbDTO.getOmadacId();
        d siteId = clearDbDTO.getSiteId();
        if (clearDbDTO.firstBindSite()) {
            this.mdnsRuleMaintMongoRepository.c(omadacId, siteId);
            return;
        }
        this.mdnsRuleMaintMongoRepository.b(omadacId, siteId);
    }

    public void siteTemplateSyncToSiteWrite(Object dataObject, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, boolean bindSite) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        MdnsTemplateDTO mdnsTemplateDTO = (MdnsTemplateDTO)dataObject;
        if (mdnsTemplateDTO == null || CollectionUtils.isEmpty(mdnsTemplateDTO.getMdnsRuleTemplates())) {
            return;
        }
        HashMap<String, String> lanNetworkIdMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.af.A()) == null ? new HashMap<String, String>() : siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.af.A());
        Map profileIdMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Y.A(), k2 -> new HashMap());
        List existList = this.mdnsRuleMaintMongoRepository.a(omadacId, newSiteId);
        HashMap boundExistsMap = new HashMap();
        existList.forEach(exist -> {
            if (exist.getTemplateId() != null) {
                boundExistsMap.put(exist.getTemplateId(), exist);
            }
        });
        for (MdnsRuleTemplatePO mdnsRuleTemplatePO : mdnsTemplateDTO.getMdnsRuleTemplates()) {
            MdnsRulePO po = mdnsRuleTemplatePO.copyFromTemplate();
            String oldProfileId = mdnsRuleTemplatePO.getId();
            po.setOmadacId(omadacId.a());
            po.setSiteId(newSiteId.a());
            if (boundExistsMap.containsKey(po.getTemplateId())) {
                MdnsRulePO exist2 = (MdnsRulePO)boundExistsMap.get(po.getTemplateId());
                po.setId(exist2.getId());
                po.setEntryId(exist2.getEntryId());
            } else {
                po.setId(null);
                po.setEntryId(Integer.valueOf(this.getSequenceNumService.a(omadacId.a(), newSiteId.a(), MdnsProfilePO.class)));
            }
            if (po.getType().equals(0) && po.getApMdnsRule() != null) {
                this.handleApMdnsRule((BaseMdnsRulePO)po, profileIdMap);
            }
            if (po.getType().equals(1) && po.getOsgMdnsRule() != null) {
                this.handleOsgMdnsRule((BaseMdnsRulePO)po, lanNetworkIdMap, profileIdMap);
            }
            profileIdMap.put(oldProfileId, this.mdnsRuleMaintMongoRepository.a(po));
        }
    }

    private void handleApMdnsRule(BaseMdnsRulePO baseMdnsRulePO, Map<String, String> profileMap) {
        List profileIds = baseMdnsRulePO.getApMdnsRule().getProfileIds();
        ArrayList<String> newProfileIds = new ArrayList<String>();
        for (String profileId : profileIds) {
            if (profileId == null) continue;
            String newProfileId = profileMap.getOrDefault(profileId, profileId);
            newProfileIds.add(newProfileId);
        }
        baseMdnsRulePO.getApMdnsRule().setProfileIds(newProfileIds);
    }

    private void handleOsgMdnsRule(BaseMdnsRulePO baseMdnsRulePO, Map<String, String> lanNetworkIdMap, Map<String, String> profileMap) {
        List clientNetworks;
        List serviceNetworks;
        List profileIds;
        List networkIds = baseMdnsRulePO.getOsgMdnsRule().getNetworkIds();
        if (!CollectionUtils.isEmpty((Collection)networkIds)) {
            ArrayList<String> newNetworkIds = new ArrayList<String>();
            for (Object networkId : networkIds) {
                if (networkId == null) continue;
                String newNetworkId = lanNetworkIdMap.get(networkId);
                newNetworkIds.add(newNetworkId);
            }
            baseMdnsRulePO.getOsgMdnsRule().setNetworkIds(newNetworkIds);
        }
        if (!CollectionUtils.isEmpty((Collection)(profileIds = baseMdnsRulePO.getOsgMdnsRule().getProfileIds()))) {
            ArrayList<String> newProfileIds = new ArrayList<String>();
            for (Object profileId : profileIds) {
                if (profileId == null) continue;
                newProfileIds.add(profileMap.getOrDefault(profileId, (String)profileId));
            }
            baseMdnsRulePO.getOsgMdnsRule().setProfileIds(newProfileIds);
        }
        if (!CollectionUtils.isEmpty((Collection)(serviceNetworks = baseMdnsRulePO.getOsgMdnsRule().getServiceNetworks()))) {
            ArrayList<String> newServiceNetworks = new ArrayList<String>();
            for (String networkId : serviceNetworks) {
                if (networkId == null) continue;
                newServiceNetworks.add(lanNetworkIdMap.get(networkId));
            }
            baseMdnsRulePO.getOsgMdnsRule().setServiceNetworks(newServiceNetworks);
        }
        if (!CollectionUtils.isEmpty((Collection)(clientNetworks = baseMdnsRulePO.getOsgMdnsRule().getClientNetworks()))) {
            ArrayList<String> newClientNetworks = new ArrayList<String>();
            for (String networkId : clientNetworks) {
                if (networkId == null) continue;
                newClientNetworks.add(lanNetworkIdMap.get(networkId));
            }
            baseMdnsRulePO.getOsgMdnsRule().setClientNetworks(newClientNetworks);
        }
    }
}

