/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.sitetemplate.sitesyncunit.servicesetting;

import com.tplink.smb.omada.backup.api.a.e;
import com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.dto.iptv.IptvSettingBackupDTO;
import com.tplink.smb.omada.common.f.f;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osg.BaseOsgSiteSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.i.a;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.iptv.BaseIptvSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.iptv.IptvPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.servicesetting.iptv.IptvSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.BaseInternetPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.InternetPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.WanPortIpv4SettingPO;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.SetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@e(a=f.IPTV)
public class IptvSiteSyncTemplateUnit
extends com.tplink.smb.omada.backup.api.e {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IptvSiteSyncTemplateUnit.class);
    private static final IptvSiteSyncTemplateUnit instance = new IptvSiteSyncTemplateUnit();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osg.a osgSiteSettingMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osg.a.a();
    private final a internetMaintMongoRepository = a.a();

    private IptvSiteSyncTemplateUnit() {
    }

    public static IptvSiteSyncTemplateUnit getInstance() {
        return instance;
    }

    public void siteTemplateSyncToSiteWrite(Object dataObject, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, boolean bindSite) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        IptvSettingBackupDTO dto = (IptvSettingBackupDTO)dataObject;
        this.osgSiteSettingMongoRepository.a(omadacId, newSiteId).ifPresent(osgSiteSetting -> {
            if (Objects.nonNull(dto)) {
                IptvSettingPO iptvSettingPO = dto.toPO();
                iptvSettingPO.setOverride(Boolean.valueOf(false));
                boolean conflictWithSiteSetting = this.checkIptvTemplatePoConflictWithSiteSetting(omadacId, newSiteId, iptvSettingPO);
                if (conflictWithSiteSetting) {
                    return;
                }
                Optional.of(iptvSettingPO.getIgmp()).ifPresent(igmpPO -> igmpPO.setVirtualWanId((String)siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), k2 -> new HashMap()).get(igmpPO.getVirtualWanId())));
                osgSiteSetting.setIptv(iptvSettingPO);
                this.osgSiteSettingMongoRepository.a((BaseOsgSiteSettingPO)osgSiteSetting);
            }
        });
    }

    private boolean checkIptvTemplatePoConflictWithSiteSetting(c omadacId, d newSiteId, IptvSettingPO iptvSettingPO) {
        if (Objects.isNull(iptvSettingPO)) {
            return false;
        }
        Optional internetOpt = this.internetMaintMongoRepository.c(omadacId, newSiteId);
        if (internetOpt.isEmpty() || !Boolean.TRUE.equals(((InternetPO)internetOpt.get()).getEnable())) {
            return false;
        }
        Set wanVlanPortIds = internetOpt.map(BaseInternetPO::getWanPortIpv4Settings).map(wanPortIpv4SettingPOS -> wanPortIpv4SettingPOS.stream().map(WanPortIpv4SettingPO::getVlanId).collect(Collectors.toSet())).orElse(new HashSet());
        wanVlanPortIds.removeIf(Objects::isNull);
        Set iptvVlanIdSet = Optional.of(iptvSettingPO).map(BaseIptvSettingPO::getIptv).map(IptvPO::getCustomConfig).map(customConfig -> {
            HashSet<Integer> res = new HashSet<Integer>();
            res.add(customConfig.getIpPhoneVlanId());
            res.add(customConfig.getIptvVlanId());
            return res;
        }).orElse(new HashSet());
        SetUtils.SetView iptvIntersection = SetUtils.intersection((Set)wanVlanPortIds, (Set)iptvVlanIdSet);
        return !CollectionUtils.isEmpty((Collection)iptvIntersection);
    }
}

