/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.sitetemplate.sitesyncunit.portal;

import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.component.schedule.api.ScheduleCenter;
import com.tplink.smb.component.schedule.api.TaskKey;
import com.tplink.smb.eventcenter.api.Event;
import com.tplink.smb.eventcenter.api.EventCenter;
import com.tplink.smb.omada.backup.api.a.e;
import com.tplink.smb.omada.backup.api.dto.ClearDbDTO;
import com.tplink.smb.omada.backup.core.domain.event.SitePortalModifiedDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.FreeAuthPolicyBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.FreeAuthPolicyTemplateBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.MultiPortalBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.PortalAccessControlBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.PortalAccessControlTemplateBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.dto.PortalTemplateBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.portal.v1000800.PortalRestoreHelperV10000800;
import com.tplink.smb.omada.common.f.f;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.portal.api.internal.b;
import com.tplink.smb.omada.portal.api.internal.j;
import com.tplink.smb.omada.portal.port.mongo.omada.access.PortalAccessControlPO;
import com.tplink.smb.omada.portal.port.mongo.omada.freeauthpolicy.FreeAuthPolicyPO;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.PortalMaintRepository;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.PortalPO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@e(a=f.PORTAL)
public class PortalSiteSyncTemplateUnit
extends com.tplink.smb.omada.backup.api.e {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PortalSiteSyncTemplateUnit.class);
    private static final PortalSiteSyncTemplateUnit instance = new PortalSiteSyncTemplateUnit();
    private final PortalMaintRepository portalMaintRepository = PortalMaintRepository.getInstance();
    private final PortalRestoreHelperV10000800 portalBackupRestoreHelper = (PortalRestoreHelperV10000800)a.b(PortalRestoreHelperV10000800.class);
    private final b disconnectRequestInternalService = (b)a.b(b.class);
    private final j queryPortalInternalApiService = (j)a.b(j.class);
    private final CacheService cacheService = (CacheService)a.b(CacheService.class);
    private final ScheduleCenter scheduleCenter = (ScheduleCenter)a.b(ScheduleCenter.class);
    private final EventCenter eventCenter = (EventCenter)a.b(EventCenter.class);
    private static final String PORTAL_ACCESS_CONTROL_CACHE_NAME = "portal:access.control";
    private static final String KEY_OMADAC_ID = "omadac.id";
    private static final String KEY_SITE_ID = "site.id";

    private PortalSiteSyncTemplateUnit() {
    }

    public static PortalSiteSyncTemplateUnit getInstance() {
        return instance;
    }

    public void clearSiteBeforeSyncTemplate(ClearDbDTO clearDbDTO) {
        c omadacId = clearDbDTO.getOmadacId();
        d siteId = clearDbDTO.getSiteId();
        this.portalMaintRepository.deleteAllCustom(omadacId, siteId);
        this.disconnectRequestInternalService.a(clearDbDTO.getOmadacId().a(), clearDbDTO.getSiteId().a());
        this.publishPortalModifiedEvent(omadacId, siteId);
        Optional optional = this.scheduleCenter.findTask(this.buildTaskKey(clearDbDTO.getOmadacId(), clearDbDTO.getSiteId(), "daily"));
        optional.ifPresent(scheduleTask -> this.scheduleCenter.deleteTask(scheduleTask.getTaskKey()));
        optional = this.scheduleCenter.findTask(this.buildTaskKey(clearDbDTO.getOmadacId(), clearDbDTO.getSiteId(), "weekly"));
        optional.ifPresent(scheduleTask -> this.scheduleCenter.deleteTask(scheduleTask.getTaskKey()));
        optional = this.scheduleCenter.findTask(this.buildTaskKey(clearDbDTO.getOmadacId(), clearDbDTO.getSiteId(), "monthly"));
        optional.ifPresent(scheduleTask -> this.scheduleCenter.deleteTask(scheduleTask.getTaskKey()));
    }

    private void publishPortalModifiedEvent(c omadacId, d siteId) {
        SitePortalModifiedDTO sitePortalModifiedDTO = new SitePortalModifiedDTO();
        sitePortalModifiedDTO.setOmadacId(omadacId.a());
        sitePortalModifiedDTO.setSiteId(siteId.a());
        this.eventCenter.send("omada.manager.configuration.site.setting", ((Event.EventBuilder)((Event.EventBuilder)Event.builder().message((Object)x.a((Object)sitePortalModifiedDTO))).filterKey("clear_site_before_sync_template")).build());
    }

    private TaskKey buildTaskKey(c omadacId, d siteId, String suffix) {
        String param = omadacId.a() + ":" + siteId.a() + ":" + suffix;
        return new TaskKey("hotspot_traffic_update_task", param);
    }

    public void siteTemplateSyncToSiteWrite(Object dataObject, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, boolean bindSite) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        MultiPortalBKDTO backupDTO = (MultiPortalBKDTO)dataObject;
        this.restorePortalTemplatesToSetting(backupDTO.getPortalSettingsTemplate(), omadacId, newSiteId, siteImportIdCacheMap);
        HashMap<String, String> freeAuthPolicyIdMap = new HashMap<String, String>();
        this.restoreFreeAuthPoliciesTemplateToSetting(backupDTO.getFreeAuthPoliciesTemplate(), omadacId, newSiteId, freeAuthPolicyIdMap);
        this.restoreAccessControlTemplateToSetting(backupDTO.getPortalAccessControlTemplate(), omadacId, newSiteId, freeAuthPolicyIdMap);
        this.disconnectRequestInternalService.b(omadacId.a(), newSiteId.a());
    }

    private void restorePortalTemplatesToSetting(List<PortalTemplateBKDTO> portalSettings, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap) {
        if (CollectionUtils.isEmpty(portalSettings)) {
            return;
        }
        List portalPOS = this.portalMaintRepository.findPortals(omadacId, newSiteId);
        HashMap boundExistsMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)portalPOS)) {
            portalPOS.forEach(exist -> boundExistsMap.put(exist.getTemplateId(), exist));
        }
        if (!CollectionUtils.isEmpty((Collection)portalPOS)) {
            portalPOS.forEach(portal -> this.portalMaintRepository.deletePortalByOmadacIdAndSiteIdAndId(omadacId, newSiteId, portal.getId()));
        }
        Map portalIdMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.ad.A(), key -> new HashMap());
        for (PortalTemplateBKDTO portalDTO : portalSettings) {
            Map radiusProfileIdMap;
            PortalPO po = this.portalBackupRestoreHelper.a(omadacId.a(), newSiteId.a(), portalDTO);
            if (po.getExternalRadius() != null) {
                radiusProfileIdMap = siteImportIdCacheMap.getOrDefault("radiusProfileIdOriginToCurrent", Collections.emptyMap());
                po.getExternalRadius().setRadiusProfileId((String)radiusProfileIdMap.get(po.getExternalRadius().getRadiusProfileId()));
            }
            if (po.getHotspotRadius() != null) {
                radiusProfileIdMap = siteImportIdCacheMap.getOrDefault("radiusProfileIdOriginToCurrent", Collections.emptyMap());
                po.getHotspotRadius().setRadiusProfileId((String)radiusProfileIdMap.get(po.getHotspotRadius().getRadiusProfileId()));
            }
            if (po.getLdap() != null) {
                Map ldapProfileIdMap = siteImportIdCacheMap.getOrDefault("ldapProfileIdOriginToCurrent", Collections.emptyMap());
                po.getLdap().setLdapProfileId((String)ldapProfileIdMap.get(po.getLdap().getLdapProfileId()));
            }
            if (boundExistsMap.containsKey(po.getTemplateId())) {
                PortalPO exist2 = (PortalPO)boundExistsMap.get(po.getTemplateId());
                po.setId(exist2.getId());
            } else {
                po.setId(null);
            }
            po.setTemplateId(portalDTO.getId());
            po.setOverride(Boolean.valueOf(false));
            PortalPO inserted = this.portalMaintRepository.insertPortal(po);
            portalIdMap.put(portalDTO.getId(), inserted.getId());
        }
    }

    private void restoreFreeAuthPoliciesTemplateToSetting(List<FreeAuthPolicyTemplateBackupDTO> freeAuthPolicies, c omadacId, d newSiteId, Map<String, String> freeAuthPolicyIdMap) {
        if (CollectionUtils.isEmpty(freeAuthPolicies)) {
            return;
        }
        List policyPOS = this.portalMaintRepository.findFreeAuthPolicies(omadacId, newSiteId);
        if (!CollectionUtils.isEmpty((Collection)policyPOS)) {
            policyPOS.forEach(policy -> this.portalMaintRepository.deleteFreeAuthPolicyByOmadacIdAndSiteIdAndId(omadacId, newSiteId, policy.getId()));
        }
        for (FreeAuthPolicyTemplateBackupDTO freeAuthPolicyDTO : freeAuthPolicies) {
            FreeAuthPolicyPO po = FreeAuthPolicyBackupDTO.toPO(omadacId.a(), newSiteId.a(), freeAuthPolicyDTO);
            po.setTemplateId(freeAuthPolicyDTO.getId());
            po.setOverride(Boolean.valueOf(false));
            FreeAuthPolicyPO inserted = this.portalMaintRepository.insertFreeAuthPolicy(po);
            freeAuthPolicyIdMap.put(freeAuthPolicyDTO.getId(), inserted.getId());
        }
    }

    private void restoreAccessControlTemplateToSetting(PortalAccessControlTemplateBKDTO accessControlDTO, c omadacId, d newSiteId, Map<String, String> freeAuthPolicyIdMap) {
        if (accessControlDTO == null) {
            return;
        }
        List newPreAuthAccessPolicyIds = Optional.ofNullable(accessControlDTO.getPreAuthAccessPolicyIds()).map(list -> list.stream().map(freeAuthPolicyIdMap::get).filter(Objects::nonNull).collect(Collectors.toList())).orElse(new ArrayList());
        List newFreeAuthClientPolicyIds = Optional.ofNullable(accessControlDTO.getFreeAuthClientPolicyIds()).map(list -> list.stream().map(freeAuthPolicyIdMap::get).filter(Objects::nonNull).collect(Collectors.toList())).orElse(new ArrayList());
        PortalAccessControlPO po = PortalAccessControlBKDTO.toPO(omadacId.a(), newSiteId.a(), (List<String>)newPreAuthAccessPolicyIds, (List<String>)newFreeAuthClientPolicyIds, accessControlDTO);
        po.setTemplateId(accessControlDTO.getId());
        po.setOverride(Boolean.valueOf(false));
        Optional optCurrentAccessControl = this.portalMaintRepository.findAccessControl(omadacId, newSiteId);
        if (optCurrentAccessControl.isPresent()) {
            po.setId(((PortalAccessControlPO)optCurrentAccessControl.get()).getId());
            this.portalMaintRepository.saveAccessControl(po);
        } else {
            this.portalMaintRepository.insertAccessControl(po);
        }
        this.cacheService.deleteKey(PORTAL_ACCESS_CONTROL_CACHE_NAME, this.buildCacheKey(omadacId, newSiteId));
    }

    private String buildCacheKey(c omadacId, d siteId) {
        return "omadac.id:" + omadacId.a() + ":site.id" + siteId.a();
    }
}

