/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.sitetemplate.sitesyncunit.osw;

import com.tplink.smb.omada.backup.core.unit.siteconfig.osw.dto.OswBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.osw.dto.OswBatchSaveDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.osw.dto.OswDeviceListBKDTO;
import com.tplink.smb.omada.common.constant.A;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.constant.r;
import com.tplink.smb.omada.common.f.f;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.tag.BasePortTagPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.tag.PortTagPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lannetwork.BaseLanNetworkPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lannetwork.LanNetworkPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lanprofile.BaseLanProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lanprofile.LanProfilePO;
import com.tplink.smb.omada.manager.port.mongo.device.DevicePO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.AbstractOswPortSettingPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.BaseOswNetworkPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.DhcpRelayPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.DhcpServerPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswIpSettingPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswIpv6SettingPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswNetworkPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswNetworkTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.e;
import com.tplink.smb.omada.manager.port.mongo.device.osw.j;
import com.tplink.smb.omada.manager.port.mongo.device.osw.lag.OswLagPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.lag.OswLagTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.port.OswPortPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.port.OswPortTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.q;
import com.tplink.smb.omada.manager.port.mongo.device.osw.s;
import com.tplink.smb.omada.manager.port.mongo.device.osw.staticroute.OswStaticRoutingPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.staticroute.OswStaticRoutingTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.t;
import com.tplink.smb.omada.manager.port.mongo.device.osw.vrf.BaseOswVrfPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.vrf.OswVrfPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.x;
import com.tplink.smb.omada.manager.stack.port.mongo.stack.OswStackPO;
import com.tplink.smb.omada.portal.port.mongo.omada.a.a;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.e(a=f.SWITCH)
public class OswSiteSyncTemplateUnit
extends com.tplink.smb.omada.backup.api.e {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OswSiteSyncTemplateUnit.class);
    private final e oswMaintMongoRepository = e.a();
    private final s oswStackMaintMongoRepository = s.a();
    private final j oswNetworkMaintMongoRepository = j.a();
    private final q oswPortMaintMongoRepository = q.a();
    private final com.tplink.smb.omada.manager.port.mongo.device.osw.a oswLagMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.osw.a.a();
    private final t oswStaticRoutingMaintMongoRepository = t.a();
    private final a getSequenceNumService = (a)com.tplink.smb.omada.common.spring.a.b(a.class);
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.e lanProfileMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.e.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c lanNetworkMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.d.a portTagMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.d.a.a();
    private final x oswVrfMaintMongoRepository = x.a();
    private static final OswSiteSyncTemplateUnit instance = new OswSiteSyncTemplateUnit();

    private OswSiteSyncTemplateUnit() {
    }

    public static OswSiteSyncTemplateUnit getInstance() {
        return instance;
    }

    public void siteTemplateSyncToSiteWrite(Object dataObject, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, boolean bindSite) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        OswDeviceListBKDTO oswDeviceListBKDTO = (OswDeviceListBKDTO)dataObject;
        List oswPOList = this.oswMaintMongoRepository.a(omadacId.a(), newSiteId.a(), DeviceTypeEnum.c.b());
        if (CollectionUtils.isEmpty((Collection)oswPOList)) {
            return;
        }
        this.handleOswStackWithOutTemplate(omadacId, newSiteId);
        if (Objects.isNull(oswDeviceListBKDTO) || CollectionUtils.isEmpty(oswDeviceListBKDTO.getOswBackupDTOList())) {
            log.warn("Failed to siteTemplateSyncToSiteWrite omadacId {}, siteId {}", (Object)omadacId, (Object)newSiteId);
            this.handleOswWithOutTemplate(omadacId, newSiteId, oswPOList);
            return;
        }
        List<OswBackupDTO> completedOswBackupList = oswDeviceListBKDTO.getOswBackupDTOList().stream().filter(oswBackupDTO -> Boolean.TRUE.equals(oswBackupDTO.getOswTemplate().getCompleted())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(completedOswBackupList)) {
            log.warn("Failed to siteTemplateSyncToSiteWrite complated template is null omadacId {}, siteId {}", (Object)omadacId, (Object)newSiteId);
            this.handleOswWithOutTemplate(omadacId, newSiteId, oswPOList);
            return;
        }
        Map<String, List<OswBackupDTO>> templateModelMap = completedOswBackupList.stream().collect(Collectors.groupingBy(oswBackup -> oswBackup.getOswTemplate().getCompoundModel()));
        Map<String, List<OswPO>> oswModelMap = oswPOList.stream().collect(Collectors.groupingBy(DevicePO::getCompoundModel));
        boolean alreadyBindSite = oswPOList.stream().anyMatch(osw -> Objects.nonNull(osw.getTemplateId()));
        Map lanNetworkIdMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), v2 -> new HashMap(2));
        Map portTagIdMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.av.A(), v2 -> new HashMap(2));
        HashMap<String, Map<String, OswVrfPO>> vrfMap = new HashMap<String, Map<String, OswVrfPO>>();
        List vrfs = this.oswVrfMaintMongoRepository.b(omadacId.a(), newSiteId.a(), oswPOList.stream().map(DevicePO::getMac).collect(Collectors.toList()));
        vrfs.forEach(curVrf -> {
            Map templateIdMap = vrfMap.computeIfAbsent(curVrf.getMac(), mac -> new HashMap());
            templateIdMap.put(curVrf.getTemplateId(), curVrf);
        });
        if (alreadyBindSite) {
            this.handleAlreadyBindSite(omadacId, newSiteId, oswPOList, lanNetworkIdMap, portTagIdMap, vrfMap, completedOswBackupList);
            return;
        }
        OswBatchSaveDTO oswBatchSaveDTO = new OswBatchSaveDTO();
        oswModelMap.forEach((compoundModel, oswList) -> {
            if (templateModelMap.containsKey(compoundModel)) {
                List oswBackupDTOS = (List)templateModelMap.get(compoundModel);
                OswBackupDTO oswBackupDTO = oswBackupDTOS.stream().filter(oswBackup -> Boolean.TRUE.equals(oswBackup.getOswTemplate().getAutoBind())).findFirst().orElse(null);
                if (Objects.isNull(oswBackupDTO)) {
                    log.warn("Failed to siteTemplateSyncToSiteWrite complated template repeat compoundModel {} omadacId {}, siteId {}", new Object[]{compoundModel, omadacId, newSiteId});
                    this.handleOswWithOutTemplate(omadacId, newSiteId, (List<OswPO>)oswList);
                } else {
                    ArrayList<OswPO> excludeOsws = new ArrayList<OswPO>();
                    oswList.removeIf(oswPO -> {
                        if (oswPO.getMlagName() != null) {
                            excludeOsws.add((OswPO)oswPO);
                            return true;
                        }
                        return false;
                    });
                    this.handleOswSettingRemove(omadacId, newSiteId, (List<OswPO>)oswList, oswBackupDTO.getOswTemplate());
                    this.handleOswPOWithTemplate(oswBackupDTO, (List<OswPO>)oswList, lanNetworkIdMap, portTagIdMap, (Map<String, Map<String, OswVrfPO>>)vrfMap, oswBatchSaveDTO);
                    if (!CollectionUtils.isEmpty(excludeOsws)) {
                        this.handleOswWithOutTemplate(omadacId, newSiteId, excludeOsws);
                    }
                }
            } else {
                log.warn("Failed to siteTemplateSyncToSiteWrite complated template compoundModel {} omadacId {}, siteId {}", new Object[]{compoundModel, omadacId, newSiteId});
                this.handleOswWithOutTemplate(omadacId, newSiteId, (List<OswPO>)oswList);
            }
        });
        this.handleOswSaveWithTemplate(oswBatchSaveDTO);
    }

    private void handleAlreadyBindSite(c omadacId, d newSiteId, List<OswPO> oswPOList, Map<String, String> lanNetworkIdMap, Map<String, String> portTagIdMap, Map<String, Map<String, OswVrfPO>> vrfMap, List<OswBackupDTO> completedOswBackupList) {
        Map backupDTOMap = completedOswBackupList.stream().collect(Collectors.toMap(oswBackupDTO -> oswBackupDTO.getOswTemplate().getId(), Function.identity()));
        OswBatchSaveDTO oswBatchSaveDTO = new OswBatchSaveDTO();
        oswBatchSaveDTO.setBatchSaveOsw(new ArrayList<OswPO>());
        oswBatchSaveDTO.setBatchSaveOswPortPO(new ArrayList<OswPortPO>());
        oswBatchSaveDTO.setBatchSaveOswLagPO(new ArrayList<OswLagPO>());
        oswBatchSaveDTO.setBatchSaveStaticRoutingPO(new ArrayList<OswStaticRoutingPO>());
        oswBatchSaveDTO.setBatchSaveOswNetworkPO(new ArrayList<OswNetworkPO>());
        ArrayList<OswPO> saveOldConfig = new ArrayList<OswPO>();
        for (OswPO oswPO : oswPOList) {
            if (T.c((String)oswPO.getTemplateId()) || !backupDTOMap.containsKey(oswPO.getTemplateId())) {
                saveOldConfig.add(oswPO);
                continue;
            }
            OswBackupDTO oswBackupDTO2 = (OswBackupDTO)backupDTOMap.get(oswPO.getTemplateId());
            this.handleOswSettingRemove(omadacId, newSiteId, oswPO.getMac(), oswBackupDTO2.getOswTemplate());
            this.handleOswWithOldTemplate(oswPO, oswBackupDTO2, oswBatchSaveDTO, lanNetworkIdMap, portTagIdMap, Optional.ofNullable(vrfMap.get(oswPO.getMac())).orElse(new HashMap()));
        }
        if (!CollectionUtils.isEmpty(saveOldConfig)) {
            this.handleOswWithOutTemplate(omadacId, newSiteId, saveOldConfig);
        }
        this.handleOswSaveWithTemplate(oswBatchSaveDTO);
    }

    private void handleOswWithOldTemplate(OswPO oswPO, OswBackupDTO oswBackupDTO, OswBatchSaveDTO oswBatchSaveDTO, Map<String, String> lanNetworkIdMap, Map<String, String> portTagIdMap, Map<String, OswVrfPO> vrfTemplateIdMap) {
        HashMap portTemplateMap = new HashMap();
        HashMap lagTemplateMap = new HashMap();
        HashMap staticRoutingTemplateMap = new HashMap();
        HashMap networkTemplateMap = new HashMap();
        oswBackupDTO.getOswPortTemplatePOS().forEach(oswPortTemplatePO -> portTemplateMap.put(oswPortTemplatePO.getId(), oswPortTemplatePO));
        oswBackupDTO.getOswLagTemplatePOS().forEach(oswLagTemplatePO -> lagTemplateMap.put(oswLagTemplatePO.getId(), oswLagTemplatePO));
        oswBackupDTO.getStaticRoutingTemplates().forEach(oswStaticRoutingTemplatePO -> staticRoutingTemplateMap.put(oswStaticRoutingTemplatePO.getId(), oswStaticRoutingTemplatePO));
        oswBackupDTO.getVlanIfTemplates().forEach(oswNetworkTemplatePO -> networkTemplateMap.put(oswNetworkTemplatePO.getId(), oswNetworkTemplatePO));
        HashMap<Integer, String> newLagMap = new HashMap<Integer, String>();
        OswTemplatePO oswTemplate = oswBackupDTO.getOswTemplate();
        com.tplink.smb.omada.manager.port.mongo.device.osw.d.a((OswPO)oswPO, (OswTemplatePO)oswTemplate);
        oswPO.setMvlanNetworkId(lanNetworkIdMap.getOrDefault(oswTemplate.getMvlanNetworkId(), oswTemplate.getMvlanNetworkId()));
        oswPO.setOverride(Boolean.valueOf(false));
        oswPO.setTemplateId(oswTemplate.getId());
        oswBatchSaveDTO.getBatchSaveOsw().add(oswPO);
        List<OswLagTemplatePO> oswLagTemplatePOS = oswBackupDTO.getOswLagTemplatePOS();
        List<OswPortTemplatePO> oswPortTemplatePOS = oswBackupDTO.getOswPortTemplatePOS();
        List<OswNetworkTemplatePO> vlanIfTemplates = oswBackupDTO.getVlanIfTemplates();
        List<OswStaticRoutingTemplatePO> staticRoutingTemplates = oswBackupDTO.getStaticRoutingTemplates();
        if (log.isDebugEnabled()) {
            log.debug("sync copy vlanIfTemplates {}, omadacId {}, siteId{}", new Object[]{com.tplink.smb.omada.common.util.x.a(vlanIfTemplates), oswPO.getOmadacId(), oswPO.getSiteId()});
        }
        if (CollectionUtils.isEmpty((Collection)oswTemplate.getTemplateSettings())) {
            log.debug("Osw template settings list is empty when site template sync to site write, omadacId: {}, siteId: {}", (Object)oswPO.getOmadacId(), (Object)oswPO.getSiteId());
            return;
        }
        if (oswTemplate.getTemplateSettings().contains(A.a.b())) {
            this.handleOswLagsWithTemplate(oswLagTemplatePOS, oswPO, lanNetworkIdMap, portTagIdMap, newLagMap, oswBatchSaveDTO.getBatchSaveOswLagPO());
            this.handleOswPortsWithTemplate(oswPortTemplatePOS, oswPO, lanNetworkIdMap, portTagIdMap, newLagMap, oswBatchSaveDTO.getBatchSaveOswPortPO());
        }
        if (oswTemplate.getTemplateSettings().contains(A.b.b())) {
            this.handleVlanIfsWithTemplate(vlanIfTemplates, oswPO, lanNetworkIdMap, oswBatchSaveDTO.getBatchSaveOswNetworkPO(), vrfTemplateIdMap);
        }
        if (log.isDebugEnabled()) {
            log.debug("sync copy handleVlanIfsWithTemplate {}, omadacId {}, siteId{}", new Object[]{com.tplink.smb.omada.common.util.x.a(oswBatchSaveDTO.getBatchSaveOswNetworkPO()), oswPO.getOmadacId(), oswPO.getSiteId()});
        }
        if (oswTemplate.getTemplateSettings().contains(A.c.b())) {
            this.handleStaticRoutingsWithTemplate(staticRoutingTemplates, oswPO, oswBatchSaveDTO.getBatchSaveStaticRoutingPO(), vrfTemplateIdMap);
        }
    }

    private void handleOswSaveWithTemplate(OswBatchSaveDTO oswBatchSaveDTO) {
        this.oswMaintMongoRepository.a(oswBatchSaveDTO.getBatchSaveOsw());
        this.oswLagMaintMongoRepository.a(oswBatchSaveDTO.getBatchSaveOswLagPO());
        this.oswPortMaintMongoRepository.a(oswBatchSaveDTO.getBatchSaveOswPortPO());
        this.oswNetworkMaintMongoRepository.a(oswBatchSaveDTO.getBatchSaveOswNetworkPO());
        if (log.isDebugEnabled()) {
            log.debug(" handleOswSaveWithTemplate getBatchSaveOsw{} , getBatchSaveOswNetworkPO{}", (Object)com.tplink.smb.omada.common.util.x.a(oswBatchSaveDTO.getBatchSaveOsw()), (Object)com.tplink.smb.omada.common.util.x.a(oswBatchSaveDTO.getBatchSaveOswNetworkPO()));
        }
        this.oswStaticRoutingMaintMongoRepository.a(oswBatchSaveDTO.getBatchSaveStaticRoutingPO());
    }

    private void handleOswPOWithTemplate(OswBackupDTO oswBackupDTO, List<OswPO> oswList, Map<String, String> lanNetworkIdMap, Map<String, String> portTagIdMap, Map<String, Map<String, OswVrfPO>> vrfMap, OswBatchSaveDTO oswBatchSaveDTO) {
        ArrayList<OswPO> batchSaveOsw = new ArrayList<OswPO>();
        ArrayList<OswLagPO> batchSaveOswLagPO = new ArrayList<OswLagPO>();
        ArrayList<OswPortPO> batchSaveOswPortPO = new ArrayList<OswPortPO>();
        ArrayList<OswNetworkPO> batchSaveOswNetworkPO = new ArrayList<OswNetworkPO>();
        ArrayList<OswStaticRoutingPO> batchSaveStaticRoutingPO = new ArrayList<OswStaticRoutingPO>();
        oswList.forEach(oswPO -> {
            HashMap<Integer, String> newLagMap = new HashMap<Integer, String>();
            OswTemplatePO oswTemplate = oswBackupDTO.getOswTemplate();
            com.tplink.smb.omada.manager.port.mongo.device.osw.d.a((OswPO)oswPO, (OswTemplatePO)oswTemplate);
            oswPO.setMvlanNetworkId(lanNetworkIdMap.getOrDefault(oswTemplate.getMvlanNetworkId(), oswTemplate.getMvlanNetworkId()));
            oswPO.setOverride(Boolean.valueOf(false));
            oswPO.setTemplateId(oswTemplate.getId());
            batchSaveOsw.add((OswPO)oswPO);
            List<OswLagTemplatePO> oswLagTemplatePOS = oswBackupDTO.getOswLagTemplatePOS();
            List<OswPortTemplatePO> oswPortTemplatePOS = oswBackupDTO.getOswPortTemplatePOS();
            List<OswNetworkTemplatePO> vlanIfTemplates = oswBackupDTO.getVlanIfTemplates();
            List<OswStaticRoutingTemplatePO> staticRoutingTemplates = oswBackupDTO.getStaticRoutingTemplates();
            if (log.isDebugEnabled()) {
                log.debug("sync copy vlanIfTemplates {}, omadacId {}, siteId{}", new Object[]{com.tplink.smb.omada.common.util.x.a(vlanIfTemplates), oswPO.getOmadacId(), oswPO.getSiteId()});
            }
            if (CollectionUtils.isEmpty((Collection)oswTemplate.getTemplateSettings())) {
                return;
            }
            if (oswTemplate.getTemplateSettings().contains(A.a.b())) {
                this.handleOswLagsWithTemplate(oswLagTemplatePOS, (OswPO)oswPO, lanNetworkIdMap, portTagIdMap, (Map<Integer, String>)newLagMap, (List<OswLagPO>)batchSaveOswLagPO);
                this.handleOswPortsWithTemplate(oswPortTemplatePOS, (OswPO)oswPO, lanNetworkIdMap, portTagIdMap, (Map<Integer, String>)newLagMap, (List<OswPortPO>)batchSaveOswPortPO);
            }
            if (oswTemplate.getTemplateSettings().contains(A.b.b())) {
                this.handleVlanIfsWithTemplate(vlanIfTemplates, (OswPO)oswPO, lanNetworkIdMap, (List<OswNetworkPO>)batchSaveOswNetworkPO, Optional.ofNullable((Map)vrfMap.get(oswPO.getMac())).orElse(new HashMap()));
            }
            if (log.isDebugEnabled()) {
                log.debug("sync copy handleVlanIfsWithTemplate {}, omadacId {}, siteId{}", new Object[]{com.tplink.smb.omada.common.util.x.a((Object)batchSaveOswNetworkPO), oswPO.getOmadacId(), oswPO.getSiteId()});
            }
            if (oswTemplate.getTemplateSettings().contains(A.c.b())) {
                this.handleStaticRoutingsWithTemplate(staticRoutingTemplates, (OswPO)oswPO, (List<OswStaticRoutingPO>)batchSaveStaticRoutingPO, Optional.ofNullable((Map)vrfMap.get(oswPO.getMac())).orElse(new HashMap()));
            }
        });
        if (Objects.isNull(oswBatchSaveDTO)) {
            oswBatchSaveDTO = new OswBatchSaveDTO();
        }
        oswBatchSaveDTO.saveAll(batchSaveOsw, batchSaveOswLagPO, batchSaveOswPortPO, batchSaveOswNetworkPO, batchSaveStaticRoutingPO);
    }

    private void handleStaticRoutingsWithTemplate(List<OswStaticRoutingTemplatePO> staticRoutingTemplates, OswPO oswPO, List<OswStaticRoutingPO> batchSaveStaticRoutingPO, Map<String, OswVrfPO> vrfTemplateIdMap) {
        staticRoutingTemplates.forEach(oswStaticRoutingTemplatePO -> {
            OswStaticRoutingPO oswStaticRoutingPO = oswStaticRoutingTemplatePO.copyFromTemplate();
            oswStaticRoutingPO.setMac(oswPO.getMac());
            oswStaticRoutingPO.setSiteId(oswPO.getSiteId());
            oswStaticRoutingPO.setOmadacId(oswPO.getOmadacId());
            oswStaticRoutingPO.setEntryId(Integer.valueOf(this.getSequenceNumService.a(oswPO.getOmadacId(), oswPO.getSiteId(), OswStaticRoutingPO.class)));
            oswStaticRoutingPO.setVrfId((String)Optional.ofNullable((OswVrfPO)vrfTemplateIdMap.get(oswStaticRoutingPO.getVrfId())).map(BaseOswVrfPO::getId).orElse(null));
            oswStaticRoutingPO.setNextHopVrfId((String)Optional.ofNullable((OswVrfPO)vrfTemplateIdMap.get(oswStaticRoutingPO.getNextHopVrfId())).map(BaseOswVrfPO::getId).orElse(null));
            batchSaveStaticRoutingPO.add(oswStaticRoutingPO);
        });
    }

    private void handleVlanIfsWithTemplate(List<OswNetworkTemplatePO> vlanIfTemplates, OswPO oswPO, Map<String, String> lanNetworkIdMap, List<OswNetworkPO> batchSaveOswNetworkPO, Map<String, OswVrfPO> vrfTemplateIdMap) {
        vlanIfTemplates.forEach(oswNetworkTemplatePO -> {
            OswNetworkPO oswNetworkPO = oswNetworkTemplatePO.copyFromTemplate();
            oswNetworkPO.setMac(oswPO.getMac());
            oswNetworkPO.setSite(oswPO.getSiteId());
            oswNetworkPO.setOmadacId(oswPO.getOmadacId());
            oswNetworkPO.setLanNetworkId(lanNetworkIdMap.getOrDefault(oswNetworkPO.getLanNetworkId(), oswNetworkPO.getLanNetworkId()));
            oswNetworkPO.setVrfId((String)Optional.ofNullable(oswNetworkPO.getVrfId()).map(vrfTemplateIdMap::get).map(BaseOswVrfPO::getId).orElse(null));
            oswNetworkPO.setVrf((String)Optional.ofNullable(oswNetworkPO.getVrfId()).map(vrfTemplateIdMap::get).map(BaseOswVrfPO::getVrf).orElse(null));
            if (!Objects.isNull(oswNetworkPO.getDhcpServer())) {
                DhcpServerPO dhcpServerPO = this.copyDhcpServer(oswNetworkPO.getDhcpServer());
                dhcpServerPO.setVrfId((String)Optional.ofNullable(dhcpServerPO.getVrfId()).map(vrfTemplateIdMap::get).map(BaseOswVrfPO::getId).orElse(null));
                dhcpServerPO.setVrf((String)Optional.ofNullable(dhcpServerPO.getVrfId()).map(vrfTemplateIdMap::get).map(BaseOswVrfPO::getVrf).orElse(null));
                oswNetworkPO.setDhcpServer(dhcpServerPO);
            }
            if (!Objects.isNull(oswNetworkPO.getDhcpRelay())) {
                DhcpRelayPO dhcpRelayPO = this.copyDhcpRelay(oswNetworkPO.getDhcpRelay());
                dhcpRelayPO.setVrfId((String)Optional.ofNullable(dhcpRelayPO.getVrfId()).map(vrfTemplateIdMap::get).map(BaseOswVrfPO::getId).orElse(null));
                dhcpRelayPO.setVrf((String)Optional.ofNullable(dhcpRelayPO.getVrfId()).map(vrfTemplateIdMap::get).map(BaseOswVrfPO::getVrf).orElse(null));
                oswNetworkPO.setDhcpRelay(dhcpRelayPO);
            }
            if (log.isDebugEnabled()) {
                log.debug("handleVlanIfsWithTemplate oswNetworkPO {}", (Object)com.tplink.smb.omada.common.util.x.a((Object)oswNetworkPO));
            }
            batchSaveOswNetworkPO.add(oswNetworkPO);
        });
    }

    private void handleOswPortsWithTemplate(List<OswPortTemplatePO> oswPortTemplatePOS, OswPO oswPO, Map<String, String> lanNetworkIdMap, Map<String, String> portTagIdMap, Map<Integer, String> newLagMap, List<OswPortPO> batchSaveOswPortPO) {
        oswPortTemplatePOS.forEach(oswPortTemplatePO -> {
            OswPortPO oswPortPO = oswPortTemplatePO.copyFromTemplate();
            oswPortPO.setOswMac(oswPO.getMac());
            oswPortPO.setSiteId(oswPO.getSiteId());
            oswPortPO.setOmadacId(oswPO.getOmadacId());
            oswPortPO.setLanProfileId(lanNetworkIdMap.getOrDefault(oswPortPO.getLanProfileId(), oswPortPO.getLanProfileId()));
            oswPortPO.setLagId(newLagMap.getOrDefault(oswPortPO.getLag(), oswPortPO.getLagId()));
            com.tplink.smb.omada.backup.core.d.a.a((AbstractOswPortSettingPO)oswPortPO, portTagIdMap);
            com.tplink.smb.omada.backup.core.d.a.b((AbstractOswPortSettingPO)oswPortPO, lanNetworkIdMap);
            batchSaveOswPortPO.add(oswPortPO);
        });
    }

    private void handleOswLagsWithTemplate(List<OswLagTemplatePO> oswLagTemplatePOS, OswPO oswPO, Map<String, String> lanNetworkIdMap, Map<String, String> portTagIdMap, Map<Integer, String> newLagMap, List<OswLagPO> batchSaveOswLagPO) {
        oswLagTemplatePOS.forEach(oswLagTemplatePO -> {
            OswLagPO oswLagPO = oswLagTemplatePO.copyFromTemplate();
            oswLagPO.setOswMac(oswPO.getMac());
            oswLagPO.setSiteId(oswPO.getSiteId());
            oswLagPO.setOmadacId(oswPO.getOmadacId());
            String newLagId = this.oswLagMaintMongoRepository.b();
            oswLagPO.setId(newLagId);
            oswLagPO.setLanProfileId(lanNetworkIdMap.getOrDefault(oswLagPO.getLanProfileId(), oswLagPO.getLanProfileId()));
            com.tplink.smb.omada.backup.core.d.a.a((AbstractOswPortSettingPO)oswLagPO, portTagIdMap);
            com.tplink.smb.omada.backup.core.d.a.b((AbstractOswPortSettingPO)oswLagPO, lanNetworkIdMap);
            newLagMap.put(oswLagPO.getLag(), newLagId);
            batchSaveOswLagPO.add(oswLagPO);
        });
    }

    private void handleOswSettingRemove(c omadacId, d newSiteId, List<OswPO> oswList, OswTemplatePO oswTemplatePO) {
        List macs = oswList.stream().map(DevicePO::getMac).collect(Collectors.toList());
        log.debug("handleOswSettingRemove, omadacId {}, siteId {}", (Object)omadacId, (Object)newSiteId);
        if (CollectionUtils.isEmpty((Collection)oswTemplatePO.getTemplateSettings())) {
            return;
        }
        if (oswTemplatePO.getTemplateSettings().contains(A.a.b())) {
            this.oswPortMaintMongoRepository.a(omadacId, newSiteId, macs);
            this.oswLagMaintMongoRepository.a(omadacId, newSiteId, macs);
        }
        if (oswTemplatePO.getTemplateSettings().contains(A.b.b())) {
            this.oswNetworkMaintMongoRepository.a(omadacId, newSiteId, macs);
        }
        if (oswTemplatePO.getTemplateSettings().contains(A.c.b())) {
            this.oswStaticRoutingMaintMongoRepository.a(omadacId, newSiteId, macs);
        }
    }

    private void handleOswSettingRemove(c omadacId, d newSiteId, String oswMac, OswTemplatePO oswTemplatePO) {
        log.debug("handleOswSettingRemove switch, omadacId {}, siteId {}", (Object)omadacId, (Object)newSiteId);
        if (CollectionUtils.isEmpty((Collection)oswTemplatePO.getTemplateSettings())) {
            return;
        }
        if (oswTemplatePO.getTemplateSettings().contains(A.a.b())) {
            this.oswPortMaintMongoRepository.a(omadacId, newSiteId, oswMac);
            this.oswLagMaintMongoRepository.a(omadacId, newSiteId, oswMac);
        }
        if (oswTemplatePO.getTemplateSettings().contains(A.b.b())) {
            this.oswNetworkMaintMongoRepository.a(omadacId, newSiteId, oswMac);
        }
        if (oswTemplatePO.getTemplateSettings().contains(A.c.b())) {
            this.oswStaticRoutingMaintMongoRepository.a(omadacId, newSiteId, oswMac);
        }
    }

    private void handleOswWithOutTemplate(c omadacId, d newSiteId, List<OswPO> oswPOList) {
        Optional defaultLanNetwork = this.lanNetworkMaintMongoRepository.c(omadacId, newSiteId);
        if (!defaultLanNetwork.isPresent()) {
            log.error("Can't find default lanNetwork. {}, {}.", (Object)omadacId, (Object)newSiteId);
            return;
        }
        String defaultLanNetworkId = ((LanNetworkPO)defaultLanNetwork.get()).getId();
        LanProfilePO allLanProfile = this.lanProfileMaintMongoRepository.a(omadacId.a(), newSiteId.a());
        LanProfilePO defaultLanProfile = this.lanProfileMaintMongoRepository.b(omadacId.a(), newSiteId.a());
        if (allLanProfile == null || defaultLanProfile == null) {
            log.error("Can't find ALL and Default LanProfile. {}, {}.", (Object)omadacId, (Object)newSiteId);
            return;
        }
        List allLanNetworks = this.lanNetworkMaintMongoRepository.a(omadacId, newSiteId);
        List lanProfilePOS = this.lanProfileMaintMongoRepository.a(omadacId, newSiteId);
        List allPortTags = this.portTagMaintMongoRepository.b(omadacId.a(), newSiteId.a());
        Map<String, LanNetworkPO> lanNetworkIdMap = allLanNetworks.stream().collect(Collectors.toMap(BaseLanNetworkPO::getId, Function.identity()));
        Map<String, LanProfilePO> lanProfileIdMap = lanProfilePOS.stream().collect(Collectors.toMap(BaseLanProfilePO::getId, Function.identity()));
        Map<String, PortTagPO> portTagIdMap = allPortTags.stream().collect(Collectors.toMap(BasePortTagPO::getId, Function.identity()));
        for (OswPO oswPO : oswPOList) {
            this.handleOswPortsWithOutTemplate(omadacId, oswPO, allLanProfile, defaultLanProfile, lanProfileIdMap, defaultLanNetworkId, lanNetworkIdMap, portTagIdMap);
            this.handleOswLagsWithoutTemplate(omadacId, oswPO, allLanProfile, defaultLanProfile, lanProfileIdMap, defaultLanNetworkId, lanNetworkIdMap, portTagIdMap);
            if (Boolean.TRUE.equals(oswPO.getSupportVlanIf())) {
                this.handleOswVlanIfWithOutTemplate(omadacId, newSiteId, oswPO, allLanNetworks, defaultLanNetworkId);
                continue;
            }
            this.handleOswMvlanWithOutTemplate(omadacId, newSiteId, oswPO, allLanNetworks, defaultLanNetworkId);
        }
        this.oswMaintMongoRepository.a(oswPOList);
    }

    private void handleOswPortsWithOutTemplate(c omadacId, OswPO oswPO, LanProfilePO allLanProfile, LanProfilePO defaultLanProfile, Map<String, LanProfilePO> lanProfileIdMap, String defaultLanNetworkId, Map<String, LanNetworkPO> lanNetworkIdMap, Map<String, PortTagPO> portTagIdMap) {
        List oswPorts = this.oswPortMaintMongoRepository.b(omadacId.a(), oswPO.getMac());
        String profileId = allLanProfile.getId();
        String profileName = allLanProfile.getName();
        if (!CollectionUtils.isEmpty((Collection)oswPorts)) {
            for (OswPortPO oswPortPO : oswPorts) {
                if (!lanProfileIdMap.containsKey(oswPortPO.getLanProfileId())) {
                    oswPortPO.setLanProfileId(profileId);
                    oswPortPO.setLanProfileName(profileName);
                    oswPortPO.setProfileOverrideEnable(Boolean.valueOf(false));
                }
                this.handleOswPortOrLagTagSetWithOutTemplate((AbstractOswPortSettingPO)oswPortPO, portTagIdMap);
                this.handleOswPortOrLagNetworkWithOutTemplate((AbstractOswPortSettingPO)oswPortPO, defaultLanNetworkId, lanNetworkIdMap);
            }
            this.oswPortMaintMongoRepository.a(oswPorts);
        }
    }

    private void handleOswLagsWithoutTemplate(c omadacId, OswPO oswPO, LanProfilePO allLanProfile, LanProfilePO defaultLanProfile, Map<String, LanProfilePO> lanProfileIdMap, String defaultLanNetworkId, Map<String, LanNetworkPO> lanNetworkIdMap, Map<String, PortTagPO> portTagIdMap) {
        List oswLags = this.oswLagMaintMongoRepository.b(omadacId.a(), oswPO.getMac());
        String profileId = allLanProfile.getId();
        String profileName = allLanProfile.getName();
        if (!CollectionUtils.isEmpty((Collection)oswLags)) {
            for (OswLagPO oswLagPO : oswLags) {
                if (!lanProfileIdMap.containsKey(oswLagPO.getLanProfileId())) {
                    oswLagPO.setLanProfileId(profileId);
                    oswLagPO.setLanProfileName(profileName);
                    oswLagPO.setProfileOverrideEnable(Boolean.valueOf(false));
                }
                this.handleOswPortOrLagTagSetWithOutTemplate((AbstractOswPortSettingPO)oswLagPO, portTagIdMap);
                this.handleOswPortOrLagNetworkWithOutTemplate((AbstractOswPortSettingPO)oswLagPO, defaultLanNetworkId, lanNetworkIdMap);
            }
            this.oswLagMaintMongoRepository.a(oswLags);
        }
    }

    private void handleOswPortOrLagTagSetWithOutTemplate(AbstractOswPortSettingPO portSettingPO, Map<String, PortTagPO> portTagIdMap) {
        Set tagSet = portSettingPO.getTagSet();
        HashSet<String> newTagSet = new HashSet<String>();
        if (!CollectionUtils.isEmpty((Collection)tagSet)) {
            for (String tagId : tagSet) {
                if (!portTagIdMap.containsKey(tagId)) continue;
                newTagSet.add(portTagIdMap.get(tagId).getId());
            }
        }
        portSettingPO.setTagSet(newTagSet);
    }

    private void handleOswPortOrLagNetworkWithOutTemplate(AbstractOswPortSettingPO portSettingPO, String defaultLanNetworkId, Map<String, LanNetworkPO> lanNetworkIdMap) {
        boolean nativeNetworkChangeToDefault = false;
        String nativeNetworkId = portSettingPO.getNativeNetworkId();
        Integer nativeBridgeVlan = portSettingPO.getNativeBridgeVlan();
        if (nativeNetworkId != null) {
            LanNetworkPO nativeLanNetworkPO = lanNetworkIdMap.get(nativeNetworkId);
            if (nativeLanNetworkPO != null) {
                portSettingPO.setNativeNetworkId(nativeLanNetworkPO.getId());
                portSettingPO.setNativeBridgeVlan(nativeBridgeVlan);
            } else {
                nativeNetworkChangeToDefault = true;
                portSettingPO.setNativeNetworkId(defaultLanNetworkId);
                portSettingPO.setNativeBridgeVlan(null);
            }
        }
        List tagNetworkIds = portSettingPO.getTagNetworkIds();
        Map tagBridgeVlanMap = Optional.ofNullable(portSettingPO.getTagBridgeVlanMap()).orElse(new HashMap());
        if (tagNetworkIds != null) {
            ArrayList<String> tagNetworkIdsInSite = new ArrayList<String>();
            HashMap<String, Object> tagBridgeVlanMapInSite = new HashMap<String, Object>();
            for (String tagNetworkId : tagNetworkIds) {
                Set tagBridgeVlanSet = (Set)tagBridgeVlanMap.get(tagNetworkId);
                LanNetworkPO tagLanNetworkPO = lanNetworkIdMap.get(tagNetworkId);
                if (tagLanNetworkPO == null) continue;
                tagNetworkIdsInSite.add(tagLanNetworkPO.getId());
                if (CollectionUtils.isEmpty((Collection)tagBridgeVlanSet)) continue;
                tagBridgeVlanMapInSite.put(tagLanNetworkPO.getId(), tagBridgeVlanSet);
            }
            if (nativeNetworkChangeToDefault) {
                tagNetworkIdsInSite.remove(defaultLanNetworkId);
            }
            portSettingPO.setTagNetworkIds(tagNetworkIdsInSite);
            portSettingPO.setTagBridgeVlanMap(tagBridgeVlanMapInSite);
        }
        List untagNetworkIds = portSettingPO.getUntagNetworkIds();
        Map untagBridgeVlanMap = Optional.ofNullable(portSettingPO.getUntagBridgeVlanMap()).orElse(new HashMap());
        if (untagNetworkIds != null) {
            ArrayList<String> untagNetworkIdsInSite = new ArrayList<String>();
            HashMap<String, Set> untagBridgeVlanMapInSite = new HashMap<String, Set>();
            for (String untagNetworkId : untagNetworkIds) {
                Set untagBridgeVlanSet = (Set)untagBridgeVlanMap.get(untagNetworkId);
                LanNetworkPO untagLanNetworkPO = lanNetworkIdMap.get(untagNetworkId);
                if (untagLanNetworkPO == null) continue;
                untagNetworkIdsInSite.add(untagLanNetworkPO.getId());
                if (CollectionUtils.isEmpty((Collection)untagBridgeVlanSet)) continue;
                untagBridgeVlanMapInSite.put(untagLanNetworkPO.getId(), untagBridgeVlanSet);
            }
            if (nativeNetworkChangeToDefault) {
                untagNetworkIdsInSite.add(defaultLanNetworkId);
            }
            portSettingPO.setUntagNetworkIds(untagNetworkIdsInSite);
            portSettingPO.setUntagBridgeVlanMap(untagBridgeVlanMapInSite);
        }
        String voiceNetworkId = portSettingPO.getVoiceNetworkId();
        Integer voiceBridgeVlan = portSettingPO.getVoiceBridgeVlan();
        if (voiceNetworkId != null) {
            LanNetworkPO voiceLanNetworkPO = lanNetworkIdMap.get(voiceNetworkId);
            if (!(voiceLanNetworkPO == null || nativeNetworkChangeToDefault && Objects.equals(defaultLanNetworkId, voiceLanNetworkPO.getId()))) {
                portSettingPO.setVoiceNetworkId(voiceLanNetworkPO.getId());
                portSettingPO.setVoiceBridgeVlan(voiceBridgeVlan);
            } else {
                portSettingPO.setVoiceNetworkEnable(Boolean.valueOf(false));
                portSettingPO.setVoiceNetworkId(null);
                portSettingPO.setVoiceBridgeVlan(null);
            }
        }
    }

    private void handleOswVlanIfWithOutTemplate(c omadacId, d newSiteId, OswPO oswPO, List<LanNetworkPO> allLanNetworks, String defaultLanNetworkId) {
        List existList = this.oswNetworkMaintMongoRepository.a(omadacId.a(), oswPO.getMac());
        Set existLanNetworkIdSet = existList.stream().map(BaseOswNetworkPO::getLanNetworkId).collect(Collectors.toSet());
        Map allLanNetworkMap = allLanNetworks.stream().collect(Collectors.toMap(BaseLanNetworkPO::getId, Function.identity(), (key1, key2) -> key1));
        String oldMvlanNetworkId = oswPO.getMvlanNetworkId();
        ArrayList<OswNetworkPO> needToDelete = new ArrayList<OswNetworkPO>();
        ArrayList<OswNetworkPO> needToSave = new ArrayList<OswNetworkPO>();
        if (!CollectionUtils.isEmpty(allLanNetworks)) {
            for (OswNetworkPO exist : existList) {
                if (allLanNetworkMap.containsKey(exist.getLanNetworkId())) {
                    needToSave.add(exist);
                    continue;
                }
                needToDelete.add(exist);
                if (!Objects.equals(oldMvlanNetworkId, exist.getLanNetworkId())) continue;
                if (!existLanNetworkIdSet.contains(defaultLanNetworkId)) {
                    LanNetworkPO lanNetworkPO = (LanNetworkPO)allLanNetworkMap.get(defaultLanNetworkId);
                    OswNetworkPO oswNetworkPO = this.buildOswNetworkPO(omadacId, newSiteId, oswPO.getMac(), lanNetworkPO);
                    needToSave.add(oswNetworkPO);
                }
                oswPO.setMvlanNetworkId(defaultLanNetworkId);
                Integer vlan = ((LanNetworkPO)allLanNetworkMap.get(defaultLanNetworkId)).getVlan();
                oswPO.setMvlanBridgeVlan(vlan);
            }
            this.oswNetworkMaintMongoRepository.a(omadacId, needToDelete.stream().map(BaseOswNetworkPO::getId).collect(Collectors.toList()));
            this.oswNetworkMaintMongoRepository.a(needToSave);
        }
    }

    private void handleOswStackWithOutTemplate(c omadacId, d newSiteId) {
        List oswStackPOList = this.oswStackMaintMongoRepository.a(omadacId.a(), newSiteId.a());
        if (CollectionUtils.isEmpty((Collection)oswStackPOList)) {
            return;
        }
        Optional defaultLanNetwork = this.lanNetworkMaintMongoRepository.c(omadacId, newSiteId);
        if (!defaultLanNetwork.isPresent()) {
            log.error("Can't find default lanNetwork. {}, {}.", (Object)omadacId, (Object)newSiteId);
            return;
        }
        String defaultLanNetworkId = ((LanNetworkPO)defaultLanNetwork.get()).getId();
        LanProfilePO allLanProfile = this.lanProfileMaintMongoRepository.a(omadacId.a(), newSiteId.a());
        if (allLanProfile == null) {
            log.error("Can't find default ALL LanProfile. {}, {}.", (Object)omadacId, (Object)newSiteId);
            return;
        }
        List allLanNetworks = this.lanNetworkMaintMongoRepository.a(omadacId, newSiteId);
        List lanProfilePOS = this.lanProfileMaintMongoRepository.a(omadacId, newSiteId);
        List allPortTags = this.portTagMaintMongoRepository.b(omadacId.a(), newSiteId.a());
        Map<String, LanNetworkPO> lanNetworkIdMap = allLanNetworks.stream().collect(Collectors.toMap(BaseLanNetworkPO::getId, Function.identity()));
        Map<String, LanProfilePO> lanProfileIdMap = lanProfilePOS.stream().collect(Collectors.toMap(BaseLanProfilePO::getId, Function.identity()));
        Map<String, PortTagPO> portTagIdMap = allPortTags.stream().collect(Collectors.toMap(BasePortTagPO::getId, Function.identity()));
        for (OswStackPO oswStackPO : oswStackPOList) {
            this.handleOswStackLagsWithoutTemplate(omadacId, oswStackPO, allLanProfile, lanProfileIdMap, defaultLanNetworkId, lanNetworkIdMap, portTagIdMap);
            this.handleOswStackVlanIfWithOutTemplate(omadacId, newSiteId, oswStackPO, allLanNetworks, defaultLanNetworkId);
            this.oswStackMaintMongoRepository.a(oswStackPO);
        }
    }

    private void handleOswStackLagsWithoutTemplate(c omadacId, OswStackPO oswStackPO, LanProfilePO allLanProfile, Map<String, LanProfilePO> lanProfileIdMap, String defaultLanNetworkId, Map<String, LanNetworkPO> lanNetworkIdMap, Map<String, PortTagPO> portTagIdMap) {
        List oswLags = this.oswLagMaintMongoRepository.d(omadacId.a(), oswStackPO.getStackId());
        String profileId = allLanProfile.getId();
        String profileName = allLanProfile.getName();
        if (!CollectionUtils.isEmpty((Collection)oswLags)) {
            for (OswLagPO oswLagPO : oswLags) {
                if (!lanProfileIdMap.containsKey(oswLagPO.getLanProfileId())) {
                    oswLagPO.setLanProfileId(profileId);
                    oswLagPO.setLanProfileName(profileName);
                    oswLagPO.setProfileOverrideEnable(Boolean.valueOf(false));
                }
                this.handleOswPortOrLagTagSetWithOutTemplate((AbstractOswPortSettingPO)oswLagPO, portTagIdMap);
                this.handleOswPortOrLagNetworkWithOutTemplate((AbstractOswPortSettingPO)oswLagPO, defaultLanNetworkId, lanNetworkIdMap);
            }
            this.oswLagMaintMongoRepository.a(oswLags);
        }
    }

    private void handleOswStackVlanIfWithOutTemplate(c omadacId, d newSiteId, OswStackPO oswStackPO, List<LanNetworkPO> allLanNetworks, String defaultLanNetworkId) {
        List existList = this.oswNetworkMaintMongoRepository.b(omadacId.a(), oswStackPO.getStackId());
        Set existLanNetworkIdSet = existList.stream().map(BaseOswNetworkPO::getLanNetworkId).collect(Collectors.toSet());
        Map allLanNetworkMap = allLanNetworks.stream().collect(Collectors.toMap(BaseLanNetworkPO::getId, Function.identity(), (key1, key2) -> key1));
        String oldMvlanNetworkId = oswStackPO.getStackSetting().getMvlanNetworkId();
        ArrayList<OswNetworkPO> needToDelete = new ArrayList<OswNetworkPO>();
        ArrayList<OswNetworkPO> needToSave = new ArrayList<OswNetworkPO>();
        if (!CollectionUtils.isEmpty(allLanNetworks)) {
            for (OswNetworkPO exist : existList) {
                if (allLanNetworkMap.containsKey(exist.getLanNetworkId())) {
                    needToSave.add(exist);
                    continue;
                }
                needToDelete.add(exist);
                if (!Objects.equals(oldMvlanNetworkId, exist.getLanNetworkId())) continue;
                if (!existLanNetworkIdSet.contains(defaultLanNetworkId)) {
                    LanNetworkPO lanNetworkPO = (LanNetworkPO)allLanNetworkMap.get(defaultLanNetworkId);
                    OswNetworkPO oswNetworkPO = this.buildOswStackNetworkPO(omadacId, newSiteId, oswStackPO.getStackId(), lanNetworkPO);
                    needToSave.add(oswNetworkPO);
                }
                oswStackPO.getStackSetting().setMvlanNetworkId(defaultLanNetworkId);
                Integer vlan = ((LanNetworkPO)allLanNetworkMap.get(defaultLanNetworkId)).getVlan();
                oswStackPO.getStackSetting().setMvlanBridgeVlan(vlan);
            }
            this.oswNetworkMaintMongoRepository.a(omadacId, needToDelete.stream().map(BaseOswNetworkPO::getId).collect(Collectors.toList()));
            this.oswNetworkMaintMongoRepository.a(needToSave);
        }
    }

    private void handleOswMvlanWithOutTemplate(c omadacId, d newSiteId, OswPO oswPO, List<LanNetworkPO> allLanNetworks, String defaultLanNetworkId) {
        if (oswPO.getMvlanNetworkId() == null && oswPO.getMvlanBridgeVlan() == null) {
            log.warn("Management VLAN is null! {} ,{}, {}", new Object[]{omadacId.a(), newSiteId.a(), oswPO.getMac()});
            return;
        }
        Map allLanNetworkMap = allLanNetworks.stream().collect(Collectors.toMap(BaseLanNetworkPO::getId, Function.identity()));
        if (CollectionUtils.isEmpty(allLanNetworkMap)) {
            log.warn("Site lanNetwork is empty! {} ,{}", (Object)omadacId.a(), (Object)newSiteId.a());
            return;
        }
        if (oswPO.getMvlanNetworkId() != null && !allLanNetworkMap.containsKey(oswPO.getMvlanNetworkId())) {
            oswPO.setMvlanNetworkId(defaultLanNetworkId);
        }
    }

    private OswNetworkPO buildOswNetworkPO(c omadacId, d siteId, String mac, LanNetworkPO lanNetworkPO) {
        OswNetworkPO po = new OswNetworkPO();
        po.setOmadacId(omadacId.a());
        po.setSite(siteId.a());
        po.setMac(mac);
        po.setName(lanNetworkPO.getName());
        po.setStatus(Integer.valueOf(1));
        po.setMode(Integer.valueOf(0));
        po.setVlan(lanNetworkPO.getVlan());
        po.setLanNetworkId(lanNetworkPO.getId());
        OswIpSettingPO oswIpSettingPO = new OswIpSettingPO();
        oswIpSettingPO.setMode(r.b.c);
        oswIpSettingPO.setFallback(Boolean.valueOf(true));
        oswIpSettingPO.setFallbackIp("192.168.0.1");
        oswIpSettingPO.setFallbackMask("255.255.255.0");
        po.setIp(oswIpSettingPO);
        OswIpv6SettingPO oswIpv6SettingPO = new OswIpv6SettingPO();
        oswIpv6SettingPO.setIpv6Enable(Boolean.valueOf(false));
        po.setIpv6(oswIpv6SettingPO);
        return po;
    }

    private OswNetworkPO buildOswStackNetworkPO(c omadacId, d siteId, String stackId, LanNetworkPO lanNetworkPO) {
        OswNetworkPO po = new OswNetworkPO();
        po.setOmadacId(omadacId.a());
        po.setSite(siteId.a());
        po.setStackId(stackId);
        po.setName(lanNetworkPO.getName());
        po.setStatus(Integer.valueOf(1));
        po.setMode(Integer.valueOf(0));
        po.setVlan(lanNetworkPO.getVlan());
        po.setLanNetworkId(lanNetworkPO.getId());
        OswIpSettingPO oswIpSettingPO = new OswIpSettingPO();
        oswIpSettingPO.setMode(r.b.c);
        oswIpSettingPO.setFallback(Boolean.valueOf(true));
        oswIpSettingPO.setFallbackIp("192.168.0.1");
        oswIpSettingPO.setFallbackMask("255.255.255.0");
        po.setIp(oswIpSettingPO);
        OswIpv6SettingPO oswIpv6SettingPO = new OswIpv6SettingPO();
        oswIpv6SettingPO.setIpv6Enable(Boolean.valueOf(false));
        po.setIpv6(oswIpv6SettingPO);
        return po;
    }

    private DhcpServerPO copyDhcpServer(DhcpServerPO dhcpServerPO) {
        DhcpServerPO copy = new DhcpServerPO();
        copy.setIp(dhcpServerPO.getIp());
        copy.setNetmask(dhcpServerPO.getNetmask());
        copy.setRange(dhcpServerPO.getRange());
        copy.setPriDns(dhcpServerPO.getPriDns());
        copy.setSndDns(dhcpServerPO.getSndDns());
        copy.setLeasetime(dhcpServerPO.getLeasetime());
        copy.setGateway(dhcpServerPO.getGateway());
        copy.setOption138(dhcpServerPO.getOption138());
        copy.setOptions(dhcpServerPO.getOptions());
        copy.setVrfId(dhcpServerPO.getVrfId());
        copy.setVrf(dhcpServerPO.getVrf());
        return copy;
    }

    private DhcpRelayPO copyDhcpRelay(DhcpRelayPO dhcpRelayPO) {
        DhcpRelayPO copy = new DhcpRelayPO();
        copy.setAddr(dhcpRelayPO.getAddr());
        copy.setVrfId(dhcpRelayPO.getVrfId());
        copy.setVrf(dhcpRelayPO.getVrf());
        return copy;
    }
}

