/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.sitetemplate.sitesyncunit.osg;

import com.tplink.smb.omada.backup.api.a.e;
import com.tplink.smb.omada.backup.core.restore.q;
import com.tplink.smb.omada.backup.core.unit.siteconfig.osg.dto.OsgDTO;
import com.tplink.smb.omada.common.constant.y;
import com.tplink.smb.omada.common.f.f;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.ssid.SsidPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.wlan.WlanGroupPO;
import com.tplink.smb.omada.manager.port.mongo.device.ap.SsidOverridePO;
import com.tplink.smb.omada.manager.port.mongo.device.osg.OsgPO;
import com.tplink.smb.omada.manager.port.mongo.device.osg.OsgTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.device.osg.b;
import com.tplink.smb.omada.manager.port.mongo.device.osg.c;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.IteratorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@e(a=f.GATEWAY)
public class OsgSiteSyncTemplateUnit
extends com.tplink.smb.omada.backup.api.e {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OsgSiteSyncTemplateUnit.class);
    private static OsgSiteSyncTemplateUnit instance = new OsgSiteSyncTemplateUnit();
    private final c osgMaintMongoRepository = c.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.c ssidMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.c.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.d wlanGroupMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.d.a();
    private final q osgTemplateConfigSyncService = (q)a.b(q.class);

    public static OsgSiteSyncTemplateUnit getInstance() {
        return instance;
    }

    private OsgSiteSyncTemplateUnit() {
    }

    public void siteTemplateSyncToSiteWrite(Object dataObject, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, boolean bindSite) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        OsgDTO osgDTO = (OsgDTO)dataObject;
        Optional osgInDbOpt = this.osgMaintMongoRepository.a(omadacId, newSiteId);
        if (!osgInDbOpt.isPresent()) {
            return;
        }
        OsgPO osgInDb = (OsgPO)osgInDbOpt.get();
        if (Objects.isNull(osgDTO) || Objects.isNull(osgDTO.getOsgTemplate()) || !Boolean.TRUE.equals(osgDTO.getOsgTemplate().getAutoBind())) {
            this.handleWirelessRouterForTemplate(omadacId, newSiteId, osgInDb);
            this.osgMaintMongoRepository.a(osgInDb);
            return;
        }
        OsgTemplatePO osgTemplate = osgDTO.getOsgTemplate();
        b.a((OsgPO)osgInDb, (OsgTemplatePO)osgTemplate);
        if (!Boolean.TRUE.equals(osgInDb.getWirelessRouter())) {
            this.osgMaintMongoRepository.a(osgInDb);
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)osgTemplate.getTemplateSettings()) && osgTemplate.getTemplateSettings().contains(y.c.b())) {
            this.osgTemplateConfigSyncService.b(osgInDb, osgTemplate);
        } else {
            this.handleWirelessRouterForTemplate(omadacId, newSiteId, osgInDb);
        }
        if (Boolean.TRUE.equals(osgInDb.getDeviceMisc().getSupportIppt()) && !CollectionUtils.isEmpty((Collection)osgTemplate.getTemplateSettings()) && osgTemplate.getTemplateSettings().contains(y.c.b())) {
            this.osgTemplateConfigSyncService.a(osgInDb, osgTemplate);
        }
        this.osgMaintMongoRepository.a(osgInDb);
    }

    private void handleWirelessRouterForTemplate(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, OsgPO osgPO) {
        if (!Boolean.TRUE.equals(osgPO.getWirelessRouter())) {
            return;
        }
        WlanGroupPO defaultWlanGroupPO = this.wlanGroupMaintMongoRepository.b(omadacId, newSiteId);
        if (defaultWlanGroupPO == null) {
            log.warn("WlanGroup {} not exist in omadacId {} site-siteName {}", new Object[]{osgPO.getWlanName(), omadacId, newSiteId});
            return;
        }
        WlanGroupPO wlanGroupPO = this.wlanGroupMaintMongoRepository.a(omadacId, newSiteId, osgPO.getWlanId());
        if (wlanGroupPO == null) {
            wlanGroupPO = defaultWlanGroupPO;
        }
        List<SsidPO> ssidList = this.ssidMaintMongoRepository.a(omadacId, newSiteId, wlanGroupPO.getId()).stream().filter(ssid -> this.osgTemplateConfigSyncService.a(ssid.getDeviceType())).collect(Collectors.toList());
        List oldSsidOverridePOList = osgPO.getSsidOverrides() == null ? new ArrayList() : osgPO.getSsidOverrides();
        ArrayList newSsidOverridePOList = new ArrayList();
        ssidList.forEach(ssidPO -> {
            SsidOverridePO oldSsidOverridePO = (SsidOverridePO)IteratorUtils.find(oldSsidOverridePOList.iterator(), ssidOverridePO -> Objects.equals(ssidOverridePO.getIndex(), ssidPO.getEntryId()));
            if (oldSsidOverridePO != null) {
                oldSsidOverridePO.setGlobalSsid(ssidPO.getName());
                oldSsidOverridePO.setSecurity(ssidPO.getSecurity());
                oldSsidOverridePO.setBandInfo(ssidPO.getBand());
                newSsidOverridePOList.add(oldSsidOverridePO);
            } else {
                newSsidOverridePOList.add(new SsidOverridePO().setIndex(ssidPO.getEntryId()).setGlobalSsid(ssidPO.getName()).setSecurity(ssidPO.getSecurity()).setEnable(Boolean.valueOf(false)).setBandInfo(ssidPO.getBand()).setVlanEnable(Boolean.valueOf(false)).setVlanId(Integer.valueOf(1)).setSsidEnable(Boolean.valueOf(true)).setHidePwd(ssidPO.getHidePwd()));
            }
        });
        osgPO.setWlanId(wlanGroupPO.getId());
        osgPO.setWlanName(wlanGroupPO.getName());
        osgPO.setSsidOverrides(newSsidOverridePOList);
    }
}

