/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.sitetemplate.sitesyncunit.firewall;

import com.tplink.smb.omada.backup.api.dto.ClearDbDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.firewall.dto.UrlFilteringDTO;
import com.tplink.smb.omada.common.f.f;
import com.tplink.smb.omada.common.util.e;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.firewall.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.firewall.urlfiltering.UrlFilterGlobalPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.firewall.urlfiltering.UrlFilteringPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.firewall.urlfiltering.UrlFilteringTemplatePO;
import com.tplink.smb.omada.portal.port.mongo.omada.a.a;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.e(a=f.URL_FILTERING)
public class UrlFilterSiteSyncTemplateUnit
extends com.tplink.smb.omada.backup.api.e {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UrlFilterSiteSyncTemplateUnit.class);
    private static UrlFilterSiteSyncTemplateUnit instance = new UrlFilterSiteSyncTemplateUnit();
    private final g urlFilteringMongoRepository = g.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osg.a osgSiteSettingMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osg.a.a();
    private final a getSequenceNumService = (a)com.tplink.smb.omada.common.spring.a.b(a.class);

    public static UrlFilterSiteSyncTemplateUnit getInstance() {
        return instance;
    }

    private UrlFilterSiteSyncTemplateUnit() {
    }

    public void clearSiteBeforeSyncTemplate(ClearDbDTO clearDbDTO) {
        this.urlFilteringMongoRepository.b(clearDbDTO.getOmadacId(), clearDbDTO.getSiteId());
        this.urlFilteringMongoRepository.e(clearDbDTO.getOmadacId(), clearDbDTO.getSiteId());
    }

    public void siteTemplateSyncToSiteWrite(Object dataObject, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, boolean bindSite) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        UrlFilteringDTO urlFilteringDTO = (UrlFilteringDTO)dataObject;
        this.handleUrlFilterGlobal(urlFilteringDTO, omadacId, newSiteId);
        this.handleUrlFiltering(urlFilteringDTO, omadacId, newSiteId, siteImportIdCacheMap);
    }

    private void handleUrlFilterGlobal(UrlFilteringDTO urlFilteringDTO, c omadacId, d newSiteId) throws com.tplink.smb.omada.backup.api.d.c {
        this.urlFilteringMongoRepository.e(omadacId, newSiteId);
        Optional.ofNullable(urlFilteringDTO.getUrlFilterGlobalTemplatePO()).ifPresent(urlFilterGlobalTemplatePO -> {
            UrlFilterGlobalPO urlFilterGlobalPO = urlFilterGlobalTemplatePO.copyFromTemplate();
            urlFilterGlobalPO.setOmadacId(omadacId.a());
            urlFilterGlobalPO.setSiteId(newSiteId.a());
            this.urlFilteringMongoRepository.a(urlFilterGlobalPO);
        });
    }

    private void handleUrlFiltering(UrlFilteringDTO urlFilteringDTO, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap) throws com.tplink.smb.omada.backup.api.d.c {
        this.urlFilteringMongoRepository.b(omadacId, newSiteId);
        if (CollectionUtils.isEmpty(urlFilteringDTO.getUrlFilteringsTemplate())) {
            return;
        }
        List<UrlFilteringPO> urlFilteringPOList = urlFilteringDTO.getUrlFilteringsTemplate().stream().map(UrlFilteringTemplatePO::copyFromTemplate).collect(Collectors.toList());
        urlFilteringPOList.forEach(urlFilteringPO -> {
            urlFilteringPO.setId(null);
            urlFilteringPO.setOmadacId(omadacId.a());
            urlFilteringPO.setSiteId(newSiteId.a());
            urlFilteringPO.setEntryId(Integer.valueOf(this.getSequenceNumService.a(omadacId.a(), newSiteId.a(), UrlFilteringPO.class)));
            this.convertSoureceIds((UrlFilteringPO)urlFilteringPO, siteImportIdCacheMap);
            this.convertTimeRangeId((UrlFilteringPO)urlFilteringPO, siteImportIdCacheMap);
        });
        this.urlFilteringMongoRepository.a(new ArrayList(urlFilteringPOList));
    }

    private void convertSoureceIds(UrlFilteringPO urlFilteringPO, Map<String, Map<String, String>> siteImportIdCacheMap) {
        switch (urlFilteringPO.getSourceType()) {
            case 0: {
                urlFilteringPO.setSourceIds(e.a((List)urlFilteringPO.getSourceIds(), (Map)siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), k2 -> new HashMap())));
                break;
            }
            case 1: {
                urlFilteringPO.setSourceIds(e.a((List)urlFilteringPO.getSourceIds(), (Map)siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Y.A(), k2 -> new HashMap())));
                break;
            }
            case 2: {
                urlFilteringPO.setSourceIds(e.a((List)urlFilteringPO.getSourceIds(), (Map)siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.ag.A(), k2 -> new HashMap())));
                break;
            }
            default: {
                log.error("import url filtering failed in omadac {}. invalid parameter sourceType {}", (Object)urlFilteringPO.getOmadacId(), (Object)urlFilteringPO.getSourceType());
            }
        }
    }

    private void convertTimeRangeId(UrlFilteringPO urlFilteringPO, Map<String, Map<String, String>> siteImportIdCacheMap) {
        Map profileMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Y.A(), k2 -> new HashMap());
        urlFilteringPO.setTimeRangeId((String)profileMap.get(urlFilteringPO.getTimeRangeId()));
    }
}

