/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.sitetemplate.sitesyncunit.firewall;

import com.tplink.smb.omada.backup.api.a.e;
import com.tplink.smb.omada.backup.api.c.n;
import com.tplink.smb.omada.backup.api.dto.ClearDbDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.firewall.dto.AclDTO;
import com.tplink.smb.omada.common.f.f;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osg.BaseOsgSiteSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.firewall.CustomAclMaintRepository;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.firewall.acl.AclPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.firewall.acl.AclPortPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.firewall.acl.AclTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.firewall.acl.CustomAclDevicePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.firewall.customacl.gateway.OsgCustomAclPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.firewall.customacl.gateway.OsgCustomAclTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.group.H;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.group.k;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.group.o;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.group.s;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.group.x;
import com.tplink.smb.omada.portal.port.mongo.omada.a.a;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@e(a=f.ACL)
public class AclSiteSyncTemplateUnit
extends com.tplink.smb.omada.backup.api.e {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AclSiteSyncTemplateUnit.class);
    private static AclSiteSyncTemplateUnit instance = new AclSiteSyncTemplateUnit();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.firewall.a aclMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.firewall.a.a();
    private final CustomAclMaintRepository customAclMaintRepository = CustomAclMaintRepository.getInstance();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osg.a osgSiteSettingMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osg.a.a();
    private final a getSequenceNumService = (a)com.tplink.smb.omada.common.spring.a.b(a.class);
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c lanNetworkMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c.a();
    private final k ipGroupMaintMongoRepository = k.a();
    private final o ipPortGroupMaintMongoRepository = o.a();
    private final s iPv6GroupMaintMongoRepository = s.a();
    private final x iPv6PortGroupMaintMongoRepository = x.a();
    private final H macFilterMaintMongoRepository = H.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.schedule.a scheduleMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.schedule.a.a();
    private final com.tplink.smb.omada.manager.port.mongo.device.osw.x oswVrfMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.osw.x.a();

    public static AclSiteSyncTemplateUnit getInstance() {
        return instance;
    }

    private AclSiteSyncTemplateUnit() {
    }

    public void clearSiteBeforeSyncTemplate(ClearDbDTO clearDbDTO) {
        this.customAclMaintRepository.deleteByOmadacIdAndSiteId(clearDbDTO.getOmadacId(), clearDbDTO.getSiteId());
        if (clearDbDTO.firstBindSite()) {
            this.aclMongoRepository.b(clearDbDTO.getOmadacId(), clearDbDTO.getSiteId(), Integer.valueOf(1));
        }
        this.aclMongoRepository.b(clearDbDTO.getOmadacId(), clearDbDTO.getSiteId(), Integer.valueOf(0));
        this.aclMongoRepository.b(clearDbDTO.getOmadacId(), clearDbDTO.getSiteId(), Integer.valueOf(2));
    }

    public void siteTemplateSyncToSiteWrite(Object dataObject, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, boolean bindSite) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        AclDTO aclDTO = (AclDTO)dataObject;
        if (Objects.isNull(aclDTO)) {
            return;
        }
        this.osgSiteSettingMaintMongoRepository.a(omadacId, newSiteId).ifPresent(osgSiteSetting -> {
            Integer aclConfigAcl = aclDTO.getAclConfigType();
            osgSiteSetting.setAclConfigMode(aclConfigAcl);
            osgSiteSetting.setAclConfigModeOverride(Boolean.valueOf(false));
            this.osgSiteSettingMaintMongoRepository.a((BaseOsgSiteSettingPO)osgSiteSetting);
        });
        this.handleAclTemplate(aclDTO, omadacId, newSiteId, siteImportIdCacheMap, bindSite);
        this.handleCustomAclTemplate(aclDTO, omadacId, newSiteId, siteImportIdCacheMap);
    }

    private void handleCustomAclTemplate(AclDTO aclDTO, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        if (CollectionUtils.isEmpty(aclDTO.getOsgCustomAclsTemplate())) {
            return;
        }
        this.customAclMaintRepository.deleteByOmadacIdAndSiteId(omadacId, newSiteId);
        List osgCustomAclPOList = aclDTO.getOsgCustomAclsTemplate().stream().map(OsgCustomAclTemplatePO::copyFromTemplate).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(osgCustomAclPOList)) {
            ArrayList<OsgCustomAclPO> saved = new ArrayList<OsgCustomAclPO>();
            for (OsgCustomAclPO po : osgCustomAclPOList) {
                po.setId(null);
                po.setOmadacId(omadacId.a());
                po.setSiteId(newSiteId.a());
                po.setEntryId(Integer.valueOf(this.getSequenceNumService.a(omadacId.a(), newSiteId.a(), OsgCustomAclPO.class)));
                saved.add(po);
            }
            this.customAclMaintRepository.saveAll(saved);
        }
    }

    private void handleAclTemplate(AclDTO aclDTO, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, boolean bindSite) {
        List<String> deleteIds;
        List switchAcls;
        Map wiredNetworkMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), k2 -> new HashMap());
        Map profileMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Y.A(), k2 -> new HashMap());
        Map wirelessNetworkMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.ag.A(), k2 -> new HashMap());
        Map vpnMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.al.A(), k2 -> new HashMap());
        if (!(Boolean.TRUE.equals(bindSite) || CollectionUtils.isEmpty((Collection)(switchAcls = this.aclMongoRepository.a(omadacId, newSiteId, Integer.valueOf(1)))) || CollectionUtils.isEmpty(deleteIds = this.findDeleteSwitchAcl(omadacId, newSiteId, switchAcls)))) {
            this.aclMongoRepository.b(deleteIds);
        }
        if (CollectionUtils.isEmpty(aclDTO.getAclsTemplate())) {
            return;
        }
        List<AclPO> aclPOList = aclDTO.getAclsTemplate().stream().map(AclTemplatePO::copyFromTemplate).collect(Collectors.toList());
        aclPOList.forEach(aclPO -> {
            aclPO.setId(null);
            aclPO.setOmadacId(omadacId.a());
            aclPO.setSiteId(newSiteId.a());
            aclPO.setEntryId(Integer.valueOf(this.getSequenceNumService.a(omadacId.a(), newSiteId.a(), AclPO.class)));
            aclPO.setVlanNetworkId((String)wiredNetworkMap.get(aclPO.getVlanNetworkId()));
            if (aclPO.getDirection() != null && !CollectionUtils.isEmpty((Collection)aclPO.getDirection().getVpnInIds())) {
                aclPO.getDirection().setVpnInIds(com.tplink.smb.omada.common.util.e.a((List)aclPO.getDirection().getVpnInIds(), (Map)vpnMap));
            }
            if (aclPO.getTimeRangeId() != null) {
                aclPO.setTimeRangeId((String)profileMap.get(aclPO.getTimeRangeId()));
            }
            switch (aclPO.getSourceType()) {
                case 0: 
                case 11: {
                    aclPO.setSourceIds(com.tplink.smb.omada.common.util.e.a((List)aclPO.getSourceIds(), (Map)wiredNetworkMap));
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    aclPO.setSourceIds(com.tplink.smb.omada.common.util.e.a((List)aclPO.getSourceIds(), (Map)profileMap));
                    break;
                }
                case 4: {
                    aclPO.setSourceIds(com.tplink.smb.omada.common.util.e.a((List)aclPO.getSourceIds(), (Map)wirelessNetworkMap));
                    break;
                }
                default: {
                    log.error("import acl failed in omadac {}. invalid parameter sourceType {}", (Object)omadacId, (Object)aclPO.getSourceType());
                }
            }
            switch (aclPO.getDestinationType()) {
                case 0: 
                case 11: {
                    aclPO.setDestinationIds(com.tplink.smb.omada.common.util.e.a((List)aclPO.getDestinationIds(), (Map)wiredNetworkMap));
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    aclPO.setDestinationIds(com.tplink.smb.omada.common.util.e.a((List)aclPO.getDestinationIds(), (Map)profileMap));
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    log.error("import acl failed in omadac {}. invalid parameter destinationType {}", (Object)omadacId, (Object)aclPO.getDestinationType());
                }
            }
        });
        this.aclMongoRepository.a(new ArrayList(aclPOList));
    }

    private List<String> findDeleteSwitchAcl(c omadacId, d newSiteId, List<AclPO> switchAcls) {
        ArrayList<String> deleteIds = new ArrayList<String>();
        for (AclPO oswAcl : switchAcls) {
            String timeRangeId;
            String networkId;
            if (Objects.nonNull(oswAcl.getVlanNetworkId()) && !Boolean.TRUE.equals(this.lanNetworkMaintMongoRepository.c(omadacId, newSiteId, networkId = oswAcl.getVlanNetworkId()))) {
                deleteIds.add(oswAcl.getId());
                continue;
            }
            boolean sourceDelete = this.checkAndDeleteSourceOrDestination(omadacId, newSiteId, oswAcl.getSourceIds(), oswAcl.getSourceType());
            if (sourceDelete) {
                deleteIds.add(oswAcl.getId());
                continue;
            }
            boolean destinationDelete = this.checkAndDeleteSourceOrDestination(omadacId, newSiteId, oswAcl.getDestinationIds(), oswAcl.getDestinationType());
            if (destinationDelete) {
                deleteIds.add(oswAcl.getId());
                continue;
            }
            if (Objects.nonNull(oswAcl.getTimeRangeId()) && !Boolean.TRUE.equals(this.scheduleMaintMongoRepository.a(omadacId, newSiteId, timeRangeId = oswAcl.getTimeRangeId()))) {
                deleteIds.add(oswAcl.getId());
                continue;
            }
            boolean vrfDelete = this.checkAndDeleteVrf(omadacId, newSiteId, oswAcl.getCustomAclPorts(), oswAcl.getCustomAclDevices());
            if (!vrfDelete) continue;
            deleteIds.add(oswAcl.getId());
        }
        return deleteIds;
    }

    private boolean checkAndDeleteSourceOrDestination(c omadacId, d siteId, List<String> idList, Integer type) {
        if (idList == null) {
            return true;
        }
        switch (type) {
            case 0: {
                List lanNetworkPOS = this.lanNetworkMaintMongoRepository.a(omadacId, siteId, idList);
                return !Objects.equals(lanNetworkPOS.size(), idList.size());
            }
            case 1: {
                List ipGroupPOS = this.ipGroupMaintMongoRepository.a(omadacId, siteId, idList);
                return !Objects.equals(ipGroupPOS.size(), idList.size());
            }
            case 2: {
                List ipPortGroupPOS = this.ipPortGroupMaintMongoRepository.a(omadacId, siteId, idList);
                return !Objects.equals(ipPortGroupPOS.size(), idList.size());
            }
            case 6: {
                List iPv6GroupPOS = this.iPv6GroupMaintMongoRepository.a(omadacId, siteId, idList);
                int size = iPv6GroupPOS.size();
                if (idList.contains("BI-IPv6Group_Any")) {
                    ++size;
                }
                return !Objects.equals(size, idList.size());
            }
            case 7: {
                List iPv6PortGroupPOS = this.iPv6PortGroupMaintMongoRepository.a(omadacId, siteId, idList);
                return !Objects.equals(iPv6PortGroupPOS.size(), idList.size());
            }
            case 3: {
                List macFilterPOS = this.macFilterMaintMongoRepository.a(omadacId, siteId, idList);
                return !Objects.equals(macFilterPOS.size(), idList.size());
            }
        }
        return true;
    }

    private boolean checkAndDeleteVrf(c omadacId, d siteId, List<AclPortPO> customAclPorts, List<CustomAclDevicePO> customAclDevices) {
        HashSet vrfIds = new HashSet();
        vrfIds.addAll(Optional.ofNullable(customAclPorts).map(ports -> ports.stream().map(AclPortPO::getVrfId).filter(vrfId -> !T.a((String)vrfId)).collect(Collectors.toSet())).orElse(new HashSet()));
        vrfIds.addAll(Optional.ofNullable(customAclDevices).map(devices -> devices.stream().map(CustomAclDevicePO::getVrfId).filter(vrfId -> !T.a((String)vrfId)).collect(Collectors.toSet())).orElse(new HashSet()));
        if (CollectionUtils.isEmpty(vrfIds)) {
            return false;
        }
        Map vrfPOMap = this.oswVrfMaintMongoRepository.a(omadacId, siteId.a(), vrfIds, n.a);
        return !Objects.equals(vrfPOMap.size(), vrfIds.size());
    }
}

