/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.sitetemplate.sitesyncunit.auth;

import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.backup.api.a.e;
import com.tplink.smb.omada.backup.api.dto.ClearDbDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.b;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.AuthenticationBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.RadiusProfileBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.RadiusProfileTemplateBKDTO;
import com.tplink.smb.omada.common.f.f;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.auth.AuthenticationMaintRepository;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.radiusprofile.RadiusProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.radiusprofile.embed.RadiusAcctServerPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.radiusprofile.embed.RadiusAuthServerPO;
import com.tplink.smb.omada.portal.port.mongo.omada.a.a;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@e(a=f.RADIUS_PROFILE)
public class RadiusProfileSiteSyncTemplateUnit
extends com.tplink.smb.omada.backup.api.e {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RadiusProfileSiteSyncTemplateUnit.class);
    private final AuthenticationMaintRepository authenticationMaintRepository = AuthenticationMaintRepository.getInstance();
    private static final RadiusProfileSiteSyncTemplateUnit instance = new RadiusProfileSiteSyncTemplateUnit();

    private RadiusProfileSiteSyncTemplateUnit() {
    }

    public static RadiusProfileSiteSyncTemplateUnit getInstance() {
        return instance;
    }

    public void clearSiteBeforeSyncTemplate(ClearDbDTO clearDbDTO) {
        if (clearDbDTO.getSiteId() == null) {
            return;
        }
        this.authenticationMaintRepository.deleteRadiusAllCustomAndAssociatedVpn(clearDbDTO.getOmadacId(), clearDbDTO.getSiteId());
    }

    public void siteTemplateSyncToSiteWrite(Object dataObject, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, boolean bindSite) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        AuthenticationBKDTO backupDTO = (AuthenticationBKDTO)dataObject;
        this.restoreRadiusProfiles(omadacId, newSiteId, backupDTO.getRadiusProfilesTemplate().stream().map(RadiusProfileTemplateBKDTO::toPO).map(RadiusProfileBKDTO::fromTemplatePO).collect(Collectors.toList()), siteImportIdCacheMap, false);
    }

    private void restoreRadiusProfiles(c omadacId, d siteId, List<RadiusProfileBKDTO> radiusProfiles, Map<String, Map<String, String>> siteImportIdCacheMap, boolean needUnbind) {
        Object existsList;
        if (CollectionUtils.isEmpty(radiusProfiles)) {
            return;
        }
        HashMap<String, String> idCache = new HashMap<String, String>();
        HashMap boundExistsMap = new HashMap();
        if (!needUnbind && !CollectionUtils.isEmpty((Collection)(existsList = this.authenticationMaintRepository.findRadiusProfiles(omadacId, siteId)))) {
            existsList.forEach(existsPO -> {
                if (existsPO.getTemplateId() != null) {
                    boundExistsMap.put(existsPO.getTemplateId(), existsPO.getId());
                }
            });
        }
        for (RadiusProfileBKDTO radiusBackupDTO : radiusProfiles) {
            RadiusProfilePO po = RadiusProfileBKDTO.toPO(radiusBackupDTO);
            if (Boolean.TRUE.equals(po.getBuiltInServer())) {
                RadiusProfilePO existBuiltProfile = this.authenticationMaintRepository.findBuiltInProfile();
                if (existBuiltProfile == null) continue;
                idCache.put(radiusBackupDTO.getId(), existBuiltProfile.getId());
                continue;
            }
            po.setOmadacId(omadacId.a());
            po.setSiteId(siteId.a());
            if (po.getEntryId() == null) {
                a getSequenceNumService = (a)com.tplink.smb.omada.common.spring.a.b(a.class);
                po.setEntryId(getSequenceNumService.b(omadacId.a(), siteId.a(), RadiusProfilePO.class));
            }
            if (needUnbind) {
                po.setId(null);
                po.setOverride(null);
                po.setTemplateId(null);
            } else if (boundExistsMap.containsKey(po.getTemplateId())) {
                String existsPOId = (String)boundExistsMap.get(po.getTemplateId());
                po.setId(existsPOId);
                boundExistsMap.remove(po.getTemplateId());
            } else {
                po.setId(null);
            }
            HashMap profileMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.Y.A()) == null ? new HashMap() : siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.Y.A());
            List authServer = po.getAuthServer();
            for (RadiusAuthServerPO radiusAuthServerPO : authServer) {
                String clientCert;
                if (!Boolean.TRUE.equals(radiusAuthServerPO.getRadSecEnable())) continue;
                String caCert = radiusAuthServerPO.getCaCert();
                if (caCert != null) {
                    radiusAuthServerPO.setCaCert(profileMap.getOrDefault(caCert, caCert));
                }
                if ((clientCert = radiusAuthServerPO.getClientCert()) == null) continue;
                radiusAuthServerPO.setClientCert(profileMap.getOrDefault(clientCert, clientCert));
            }
            if (Boolean.TRUE.equals(po.getRadiusAccountingEnable())) {
                List acctServer = po.getAcctServer();
                for (RadiusAcctServerPO radiusAcctServerPO : acctServer) {
                    String clientCert;
                    if (!Boolean.TRUE.equals(radiusAcctServerPO.getRadSecEnable())) continue;
                    String caCert = radiusAcctServerPO.getCaCert();
                    if (caCert != null) {
                        radiusAcctServerPO.setCaCert(profileMap.getOrDefault(caCert, caCert));
                    }
                    if ((clientCert = radiusAcctServerPO.getClientCert()) == null) continue;
                    radiusAcctServerPO.setClientCert(profileMap.getOrDefault(clientCert, clientCert));
                }
            }
            RadiusProfilePO inserted = this.authenticationMaintRepository.saveAndReturn(po);
            idCache.put(radiusBackupDTO.getId(), inserted.getId());
            DomainEventBusHolder.getPublisher().publishSync(((b.a)((Object)((b.a)((Object)((b.a)((Object)((b.a)((Object)b.a().a(omadacId))).a(siteId))).a(radiusBackupDTO.getId()))).b(inserted.getId()))).b());
        }
        if (!CollectionUtils.isEmpty(boundExistsMap)) {
            HashSet idSet = new HashSet(boundExistsMap.values());
            this.authenticationMaintRepository.deleteRadiusByOmadacIdAndSiteIdAndIds(omadacId, siteId, idSet);
        }
        siteImportIdCacheMap.put("radiusProfileIdOriginToCurrent", idCache);
    }
}

