/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.sitetemplate.sitesyncunit.auth;

import com.tplink.smb.omada.backup.api.a.e;
import com.tplink.smb.omada.backup.api.dto.ClearDbDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.AuthenticationBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.LdapProfileBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.LdapProfileTemplateBKDTO;
import com.tplink.smb.omada.common.f.f;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.auth.AuthenticationMaintRepository;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.ldap.LdapProfilePO;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@e(a=f.LDAP_PROFILE)
public class LdapSiteSyncTemplateUnit
extends com.tplink.smb.omada.backup.api.e {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LdapSiteSyncTemplateUnit.class);
    private final AuthenticationMaintRepository authenticationMaintRepository = AuthenticationMaintRepository.getInstance();
    private static final LdapSiteSyncTemplateUnit instance = new LdapSiteSyncTemplateUnit();

    private LdapSiteSyncTemplateUnit() {
    }

    public static LdapSiteSyncTemplateUnit getInstance() {
        return instance;
    }

    public void clearSiteBeforeSyncTemplate(ClearDbDTO clearDbDTO) {
        if (clearDbDTO.getSiteId() == null) {
            return;
        }
        this.authenticationMaintRepository.deleteLdapAllCustomAndAssociatedVpn(clearDbDTO.getOmadacId(), clearDbDTO.getSiteId());
    }

    public void siteTemplateSyncToSiteWrite(Object dataObject, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, boolean bindSite) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        AuthenticationBKDTO bkdto = (AuthenticationBKDTO)dataObject;
        if (bkdto == null || CollectionUtils.isEmpty(bkdto.getLdapProfilesTemplate())) {
            return;
        }
        List ldapProfiles = bkdto.getLdapProfilesTemplate().stream().map(LdapProfileTemplateBKDTO::toTemplatePO).map(LdapProfileBKDTO::fromTemplatePO).collect(Collectors.toList());
        HashMap<String, String> idCache = new HashMap<String, String>();
        HashMap boundExistsMap = new HashMap();
        List existsList = this.authenticationMaintRepository.findLdapProfiles(omadacId, newSiteId);
        if (!CollectionUtils.isEmpty((Collection)existsList)) {
            existsList.forEach(existsPO -> {
                if (existsPO.getTemplateId() != null) {
                    boundExistsMap.put(existsPO.getTemplateId(), existsPO.getId());
                }
            });
        }
        for (LdapProfileBKDTO dto : ldapProfiles) {
            LdapProfilePO po = LdapProfileBKDTO.toPO(dto);
            po.setOmadacId(omadacId.a());
            po.setSiteId(newSiteId.a());
            if (boundExistsMap.containsKey(po.getTemplateId())) {
                String existsPOId = (String)boundExistsMap.get(po.getTemplateId());
                po.setId(existsPOId);
                boundExistsMap.remove(po.getTemplateId());
            } else {
                po.setId(null);
            }
            LdapProfilePO saved = this.authenticationMaintRepository.save(po);
            idCache.put(dto.getId(), saved.getId());
        }
        if (!CollectionUtils.isEmpty(boundExistsMap)) {
            HashSet idSet = new HashSet(boundExistsMap.values());
            this.authenticationMaintRepository.deleteLdapByOmadacIdAndSiteIdAndIds(omadacId, newSiteId, idSet);
        }
        siteImportIdCacheMap.put("ldapProfileIdOriginToCurrent", idCache);
    }
}

