/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.sitetemplate.sitesyncunit.ap;

import com.tplink.smb.omada.backup.api.a.e;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.f.f;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.ssid.SsidPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.wlan.WlanGroupPO;
import com.tplink.smb.omada.manager.port.mongo.device.ap.ApLanPortSettingPO;
import com.tplink.smb.omada.manager.port.mongo.device.ap.ApPO;
import com.tplink.smb.omada.manager.port.mongo.device.ap.SsidOverridePO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.IteratorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@e(a=f.AP)
public class ApSiteSyncTemplateUnit
extends com.tplink.smb.omada.backup.api.e {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApSiteSyncTemplateUnit.class);
    private final com.tplink.smb.omada.manager.port.mongo.device.ap.d apMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.ap.d.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.d wlanGroupMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.d.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.c ssidMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.c.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c lanNetworkMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c.a();
    private static final ApSiteSyncTemplateUnit instance = new ApSiteSyncTemplateUnit();

    private ApSiteSyncTemplateUnit() {
    }

    public static ApSiteSyncTemplateUnit getInstance() {
        return instance;
    }

    public void siteTemplateSyncToSiteWrite(Object dataObject, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, boolean bindSite) throws com.tplink.smb.omada.backup.api.d.c, IOException {
    }

    public void checkUnsupportedAfterSiteSyncTemplate(c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        List apPOList = this.apMaintMongoRepository.a(omadacId.a(), newSiteId.a(), DeviceTypeEnum.a.b());
        if (CollectionUtils.isEmpty((Collection)apPOList)) {
            return;
        }
        WlanGroupPO defaultWlanGroupPO = this.wlanGroupMaintMongoRepository.b(omadacId, newSiteId);
        if (defaultWlanGroupPO == null) {
            log.error("default wlanGroup not exist in omadacId {} siteId {}", (Object)omadacId, (Object)newSiteId);
            return;
        }
        for (ApPO apPO : apPOList) {
            this.handleMvlanByTemplateSyncToSite(apPO, omadacId, newSiteId);
            this.handleLanPortByTemplateSyncToSite(apPO, omadacId, newSiteId);
            this.handleWlanSsidByTemplateSyncToSite(apPO, omadacId, newSiteId, defaultWlanGroupPO);
        }
        this.apMaintMongoRepository.a(apPOList);
    }

    private void handleMvlanByTemplateSyncToSite(ApPO apPO, c omadacId, d siteId) {
        Optional lanNetworkPOOpt;
        if (Boolean.TRUE.equals(apPO.getMvlanEnable()) && apPO.getMvlanNetworkId() != null && !(lanNetworkPOOpt = this.lanNetworkMaintMongoRepository.a(omadacId.a(), siteId.a(), apPO.getMvlanNetworkId())).isPresent()) {
            apPO.setMvlanEnable(Boolean.valueOf(false));
            apPO.setMvlanNetworkId(null);
            apPO.setMvlanBridgeVlan(null);
        }
        if (apPO.getApMvlanSetting() == null) {
            return;
        }
        if (Objects.equals(1, apPO.getApMvlanSetting().getMode()) && apPO.getApMvlanSetting().getLanNetworkId() != null && !(lanNetworkPOOpt = this.lanNetworkMaintMongoRepository.a(omadacId.a(), siteId.a(), apPO.getApMvlanSetting().getLanNetworkId())).isPresent()) {
            apPO.getApMvlanSetting().setMode(Integer.valueOf(0));
            apPO.getApMvlanSetting().setLanNetworkId(null);
            apPO.getApMvlanSetting().setBridgeVlan(null);
        }
    }

    private void handleLanPortByTemplateSyncToSite(ApPO apPO, c omadacId, d siteId) {
        List lanPortSettings = apPO.getLanPortSettings();
        if (CollectionUtils.isEmpty((Collection)lanPortSettings)) {
            return;
        }
        for (ApLanPortSettingPO apLanPortSettingPO : lanPortSettings) {
            Optional lanNetworkPOOpt;
            String localVlanNetworkId = apLanPortSettingPO.getLocalVlanNetworkId();
            if (T.a((String)localVlanNetworkId) || (lanNetworkPOOpt = this.lanNetworkMaintMongoRepository.a(omadacId.a(), siteId.a(), localVlanNetworkId)).isPresent()) continue;
            apLanPortSettingPO.setLocalVlanEnable(Boolean.valueOf(false));
            apLanPortSettingPO.setLocalVlanNetworkId(null);
            apLanPortSettingPO.setLocalVlanNetworkVlanId(null);
            apLanPortSettingPO.setTaggedNetworkId(null);
            apLanPortSettingPO.setUntaggedNetworkId(null);
        }
    }

    private void handleWlanSsidByTemplateSyncToSite(ApPO apPO, c omadacId, d siteId, WlanGroupPO defaultWlanGroupPO) {
        if (apPO.getWlanId() == null) {
            return;
        }
        WlanGroupPO wlanGroupPO = this.wlanGroupMaintMongoRepository.a(omadacId, siteId, apPO.getWlanId());
        if (wlanGroupPO == null) {
            wlanGroupPO = defaultWlanGroupPO;
        }
        List<SsidPO> ssidList = this.ssidMaintMongoRepository.a(omadacId, siteId, wlanGroupPO.getId()).stream().filter(ssid -> this.deviceTypeContainsEap(ssid.getDeviceType())).collect(Collectors.toList());
        List oldSsidOverridePOList = apPO.getSsidOverrides() == null ? new ArrayList() : apPO.getSsidOverrides();
        ArrayList newSsidOverridePOList = new ArrayList();
        ssidList.forEach(ssidPO -> {
            SsidOverridePO oldSsidOverridePO = (SsidOverridePO)IteratorUtils.find(oldSsidOverridePOList.iterator(), ssidOverridePO -> Objects.equals(ssidOverridePO.getIndex(), ssidPO.getEntryId()));
            if (oldSsidOverridePO != null) {
                oldSsidOverridePO.setGlobalSsid(ssidPO.getName());
                oldSsidOverridePO.setSecurity(ssidPO.getSecurity());
                oldSsidOverridePO.setBandInfo(ssidPO.getBand());
                newSsidOverridePOList.add(oldSsidOverridePO);
            } else {
                newSsidOverridePOList.add(new SsidOverridePO().setIndex(ssidPO.getEntryId()).setGlobalSsid(ssidPO.getName()).setSecurity(ssidPO.getSecurity()).setEnable(Boolean.valueOf(false)).setBandInfo(ssidPO.getBand()).setVlanEnable(Boolean.valueOf(false)).setVlanId(Integer.valueOf(1)).setSsidEnable(Boolean.valueOf(true)).setHidePwd(ssidPO.getHidePwd()));
            }
        });
        apPO.setWlanId(wlanGroupPO.getId());
        apPO.setWlanName(wlanGroupPO.getName());
        apPO.setSsidOverrides(newSsidOverridePOList);
    }

    public boolean deviceTypeContainsEap(Integer deviceType) {
        if (deviceType == null) {
            return true;
        }
        return (deviceType & 1) > 0;
    }
}

