/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.restore;

import com.tplink.smb.eventcenter.api.Event;
import com.tplink.smb.eventcenter.api.EventCenter;
import com.tplink.smb.omada.backup.api.c.j;
import com.tplink.smb.omada.backup.api.c.n;
import com.tplink.smb.omada.backup.core.backup.r;
import com.tplink.smb.omada.backup.core.restore.F;
import com.tplink.smb.omada.backup.core.restore.M;
import com.tplink.smb.omada.backup.core.restore.b.a;
import com.tplink.smb.omada.backup.core.restore.h;
import com.tplink.smb.omada.backup.core.restore.m;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.UserInfoBriefDTO;
import com.tplink.smb.omada.common.constant.x;
import com.tplink.smb.omada.identityaccess.api.internal.dto.ModifyUserBySiteManagedDTO;
import com.tplink.smb.omada.identityaccess.api.internal.g;
import com.tplink.smb.omada.identityaccess.port.mongo.omadac.OmadacPO;
import com.tplink.smb.omada.logmanager.api.internal.dto.audit.AuditLogKeyEnumDTO;
import com.tplink.smb.omada.maintenance.api.stomp.wo.SiteMigrateWO;
import com.tplink.smb.omada.maintenance.api.stomp.wo.StompMessageEvent;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.DeleteSiteListDTO;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.b;
import com.tplink.smb.omada.manager.device.migration.restore.dto.MigrationRequestDTO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class G {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(G.class);
    @Autowired
    private com.tplink.smb.omada.lock.a.c b;
    @Autowired
    private h c;
    @Autowired
    private m d;
    private final com.tplink.smb.omada.identityaccess.port.mongo.g e = com.tplink.smb.omada.identityaccess.port.mongo.g.a();
    @Autowired
    private com.tplink.smb.omada.backup.core.c.a f;
    @Autowired
    private a g;
    @Autowired
    private EventCenter h;
    @Autowired
    private M i;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.site.a j;
    @Autowired
    private g k;
    @Autowired
    private com.tplink.smb.omada.lock.a.b l;
    @Autowired
    private r m;
    @Autowired
    private F n;
    @Autowired
    private com.tplink.smb.omada.manager.device.migration.restore.a.a o;
    @Autowired
    private com.tplink.smb.omada.manager.device.api.internal.device.b p;
    @Autowired
    private com.tplink.smb.omada.maintenance.domain.model.a.a q;

    public void a(com.tplink.smb.omada.backup.core.a.d command, Consumer<OperationResponse> completeConsumer) {
        UserInfoBriefDTO userInfoBriefDTO = command.j();
        String targetCustomerId = command.f();
        String sourceCustomerName = command.d();
        String targetCustomerName = command.g();
        String siteName = command.h();
        this.d.a(targetCustomerId, System.nanoTime(), () -> {
            a.info("OmadacId = {}, siteId/site TemplateId = {}, site/site template copy begin.", (Object)targetCustomerId, (Object)command.e());
            if (!this.f.c()) {
                a.debug("omadacId={} copy site reach limit", (Object)targetCustomerId);
                completeConsumer.accept(new OperationResponse(com.tplink.smb.omada.common.g.b.bA));
                this.q.a(command.b(), AuditLogKeyEnumDTO.SITE_MIGRATE_TO_CUSTOMER.name(), userInfoBriefDTO, command.k(), Boolean.FALSE, new String[]{siteName, sourceCustomerName, targetCustomerName});
                return;
            }
            a.debug("omadacId={}, siteId {} migrate site to customer {} start", new Object[]{command.c(), command.e(), command.f()});
            OperationResponse ops = this.a(targetCustomerId, command.l());
            if (!ops.success()) {
                this.f.e();
                completeConsumer.accept(ops);
                this.q.a(command.b(), AuditLogKeyEnumDTO.SITE_MIGRATE_TO_CUSTOMER.name(), userInfoBriefDTO, command.k(), Boolean.FALSE, new String[]{siteName, sourceCustomerName, targetCustomerName});
                return;
            }
            completeConsumer.accept(OperationResponse.SUCCESS);
            OperationResponse operationResponse = this.a(new c(command.c()), new c(targetCustomerId), new d(command.e()), siteName, command.l(), userInfoBriefDTO.getId());
            if (!operationResponse.success()) {
                this.a(operationResponse, command.l().a());
                this.g.b(targetCustomerId, operationResponse.getErrorCode());
            } else {
                this.g.b(targetCustomerId);
            }
            this.q.a(command.b(), AuditLogKeyEnumDTO.SITE_MIGRATE_TO_CUSTOMER.name(), userInfoBriefDTO, command.k(), Boolean.valueOf(operationResponse.success()), new String[]{siteName, sourceCustomerName, targetCustomerName});
            this.a(command, com.tplink.smb.omada.common.g.b.a((int)operationResponse.getErrorCode()));
            this.f.e();
        });
    }

    private void a(OperationResponse response, n typeEnum) {
        if (com.tplink.smb.omada.backup.api.c.n.a.equals((Object)typeEnum)) {
            return;
        }
        if (Objects.equals(com.tplink.smb.omada.common.g.b.wx.b(), response.getErrorCode())) {
            response.setErrorCode(com.tplink.smb.omada.common.g.b.On.b());
            response.setMsg(com.tplink.smb.omada.common.g.b.On.c());
        }
        if (Objects.equals(com.tplink.smb.omada.common.g.b.ww.b(), response.getErrorCode())) {
            response.setErrorCode(com.tplink.smb.omada.common.g.b.fn.b());
            response.setMsg(com.tplink.smb.omada.common.g.b.fn.c());
        }
        if (Objects.equals(com.tplink.smb.omada.common.g.b.fx.b(), response.getErrorCode())) {
            response.setErrorCode(com.tplink.smb.omada.common.g.b.Or.b());
            response.setMsg(com.tplink.smb.omada.common.g.b.Or.c());
        }
        if (Objects.equals(com.tplink.smb.omada.common.g.b.fu.b(), response.getErrorCode())) {
            response.setErrorCode(com.tplink.smb.omada.common.g.b.OI.b());
            response.setMsg(com.tplink.smb.omada.common.g.b.OI.c());
        }
    }

    private OperationResponse a(String omadacId, j operationType) {
        if (Thread.currentThread().isInterrupted()) {
            a.warn("Server try to shut down, omadacId={} refuse restore request", (Object)omadacId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.bA);
        }
        if (this.g.a(omadacId, com.tplink.smb.omada.backup.api.c.n.a.equals((Object)operationType.a()) ? com.tplink.smb.omada.backup.api.c.g.b : com.tplink.smb.omada.backup.api.c.g.d)) {
            return this.a(omadacId);
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.eg);
    }

    private OperationResponse a(String omadacId) {
        OperationResponse response;
        Optional omadacPOOptional = this.e.a(new c(omadacId));
        if (!omadacPOOptional.isPresent()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.aA);
        }
        if (com.tplink.smb.omada.common.f.c.a.a(com.tplink.smb.omada.common.f.c.a((Integer)((OmadacPO)omadacPOOptional.get()).getPattern())) && !(response = this.a((OmadacPO)omadacPOOptional.get())).success()) {
            return response;
        }
        OperationResponse ops = this.g.c(omadacId, com.tplink.smb.omada.backup.api.c.g.b);
        if (!ops.success()) {
            return ops;
        }
        return OperationResponse.SUCCESS;
    }

    private OperationResponse a(OmadacPO customer) {
        if (this.g.c(customer.getMspId())) {
            a.debug("mspId={} is restoring", (Object)customer.getMspId());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.eg);
        }
        Optional mspOptional = this.e.a(new c(customer.getMspId()));
        if (!mspOptional.isPresent()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.aA);
        }
        return OperationResponse.SUCCESS;
    }

    private OperationResponse a(c sourceOmadacId, c targetOmadacId, d copiedSiteId, String siteName, j operationType, String userId) {
        return (OperationResponse)this.l.b(sourceOmadacId.a(), () -> {
            OperationResponse<String> ops = this.c.a(sourceOmadacId, targetOmadacId, copiedSiteId.a(), siteName, com.tplink.smb.omada.backup.api.c.n.a);
            if (!ops.success()) {
                return ops;
            }
            String newSiteId = (String)ops.getResult();
            OperationResponse response = (OperationResponse)this.b.a(targetOmadacId.a(), copiedSiteId.a(), () -> {
                try {
                    OperationResponse refreshOps = this.i.a(targetOmadacId, new d(newSiteId), true, com.tplink.smb.omada.backup.api.c.n.a);
                    if (!refreshOps.success()) {
                        return refreshOps;
                    }
                    OperationResponse migrateRes = this.a(sourceOmadacId, copiedSiteId, targetOmadacId, new d(newSiteId), operationType);
                    if (!migrateRes.success()) {
                        return migrateRes;
                    }
                    OperationResponse migrateDeviceResp = this.a(sourceOmadacId.a(), copiedSiteId.a(), targetOmadacId.a(), newSiteId);
                    if (!migrateDeviceResp.success()) {
                        a.warn("migrate device fail, source omadacId:{}, target omadacId :{}, errorCode: {}, msg:{}", new Object[]{sourceOmadacId, targetOmadacId, migrateDeviceResp.getErrorCode(), migrateDeviceResp.getMsg()});
                        return migrateDeviceResp;
                    }
                    OperationResponse deleteRes = this.j.a(new DeleteSiteListDTO(sourceOmadacId.a(), Collections.singletonList(copiedSiteId.a()), userId, Integer.valueOf(com.tplink.smb.omada.backup.api.c.n.a.a())));
                    if (!deleteRes.success()) {
                        return deleteRes;
                    }
                    refreshOps = this.i.a(targetOmadacId, new d(newSiteId), null, com.tplink.smb.omada.backup.api.c.n.a);
                    if (!refreshOps.success()) {
                        return refreshOps;
                    }
                    OperationResponse res = this.k.a(ModifyUserBySiteManagedDTO.builder().omadacId(targetOmadacId.a()).siteId(newSiteId).siteName(siteName).operationType(x.a.b()).userId(userId).build());
                    if (!res.success()) {
                        a.warn("Site {} modifyUserBySiteManaged omadac {}.", (Object)newSiteId, (Object)targetOmadacId.a());
                        return new OperationResponse(res.getErrorCode(), res.getMsg(), null);
                    }
                    a.info("omadacId={} copy site {} success.", (Object)targetOmadacId.a(), (Object)newSiteId);
                    return OperationResponse.SUCCESS;
                }
                catch (Exception e2) {
                    a.warn("omadacId={} siteId={} siteCopy Operation failed.", new Object[]{targetOmadacId, copiedSiteId, e2});
                    return new OperationResponse(com.tplink.smb.omada.common.g.b.wx);
                }
            }, () -> {
                a.warn("omadacId={} siteId={} siteCopy Operation failed because Site Busy.", (Object)targetOmadacId, (Object)copiedSiteId);
                return new OperationResponse(com.tplink.smb.omada.common.g.b.fi);
            });
            if (response.success()) {
                return OperationResponse.success((Object)newSiteId);
            }
            this.a(targetOmadacId, new d(newSiteId), userId);
            return response;
        }, () -> new OperationResponse(com.tplink.smb.omada.common.g.b.bA));
    }

    private void a(c omadacId, d newSiteId, String userId) {
        this.j.a(new DeleteSiteListDTO(omadacId.a(), Collections.singletonList(newSiteId.a()), userId, Integer.valueOf(com.tplink.smb.omada.backup.api.c.n.a.a())));
    }

    private void a(com.tplink.smb.omada.backup.core.a.d command, com.tplink.smb.omada.common.g.b errorCode) {
        SiteMigrateWO wo = new SiteMigrateWO();
        wo.setErrorCode(errorCode.b());
        wo.setMsg(errorCode.c());
        wo.setSourceCustomerName(command.d());
        wo.setTargetCustomerName(command.g());
        wo.setSiteName(command.h());
        StompMessageEvent globalStompMessageEvent = new StompMessageEvent();
        globalStompMessageEvent.setOmadacId(command.b());
        globalStompMessageEvent.setEventType(com.tplink.smb.omada.common.q.c.z.a());
        globalStompMessageEvent.setData((Object)wo);
        this.h.send("omada.apigateway.websocket.stompevent", ((Event.EventBuilder)Event.builder().message((Object)com.tplink.smb.omada.common.util.x.a((Object)globalStompMessageEvent))).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private OperationResponse a(c omadacId, d sourceSiteId, c newCustomerId, d targetSiteId, j operationType) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        HashMap<String, Boolean> restoreCacheMap = new HashMap<String, Boolean>(16);
        restoreCacheMap.put("skipConfirm", true);
        restoreCacheMap.put("skipDevice", false);
        File tmpFile = com.tplink.smb.omada.common.util.file.c.a(null);
        try (FileOutputStream outputStream = new FileOutputStream(tmpFile);){
            OperationResponse operationResponse = this.m.a(outputStream, omadacId, sourceSiteId);
            if (!operationResponse.success()) {
                OperationResponse operationResponse2 = operationResponse;
                return operationResponse2;
            }
        }
        catch (Exception e2) {
            a.warn("omadacId={} siteId={} import error, ", new Object[]{omadacId, targetSiteId, e2});
            return new OperationResponse(com.tplink.smb.omada.common.g.b.wx);
        }
        try {
            OperationResponse operationResponse;
            FileInputStream fileInputStream = new FileInputStream(tmpFile);
            try {
                OperationResponse response;
                operationResponse = response = this.n.a((InputStream)fileInputStream, targetSiteId, newCustomerId, true, false, operationType);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fileInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e3) {
                    a.warn("omadacId={} siteId={} import error, ", new Object[]{omadacId, targetSiteId, e3});
                    OperationResponse operationResponse3 = new OperationResponse(com.tplink.smb.omada.common.g.b.wx);
                    return operationResponse3;
                }
            }
            fileInputStream.close();
            return operationResponse;
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    private OperationResponse a(String sourceOmadacId, String sourceSiteId, String targetOmadacId, String targetSiteId) {
        Set onlineDeviceMacSet = this.p.d(com.tplink.smb.omada.manager.device.api.internal.device.dto.b.a().a(sourceOmadacId).b(sourceSiteId).b());
        a.trace("omadacId:{}, siteId:{}, online device list:{}", new Object[]{sourceOmadacId, sourceSiteId, onlineDeviceMacSet});
        if (CollectionUtils.isEmpty((Collection)onlineDeviceMacSet)) {
            a.debug("no device in omadacId: {}, siteId: {}, skip", (Object)sourceOmadacId, (Object)sourceSiteId);
            return OperationResponse.SUCCESS;
        }
        a.info("try to migrate device sourceOmadacId:{} , sourceSiteId:{}, target omadacId {}, target siteId:{}", new Object[]{sourceOmadacId, sourceSiteId, targetOmadacId, targetSiteId});
        MigrationRequestDTO migrationRequestDTO = new MigrationRequestDTO();
        migrationRequestDTO.setOmadacId(sourceOmadacId);
        migrationRequestDTO.setSiteId(sourceSiteId);
        migrationRequestDTO.setDestOmadacId(targetOmadacId);
        migrationRequestDTO.setDestSiteId(targetSiteId);
        migrationRequestDTO.setSelectType("all");
        OperationResponse response = this.o.a(migrationRequestDTO);
        return response;
    }
}

