/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.restore;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.mongodb.MongoException;
import com.tplink.smb.omada.backup.api.c.n;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.cache.RestoreResult;
import com.tplink.smb.omada.backup.core.cache.e;
import com.tplink.smb.omada.backup.core.restore.E;
import com.tplink.smb.omada.backup.core.restore.b.a;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.x;
import com.tplink.smb.omada.common.util.b.j;
import com.tplink.smb.omada.identityaccess.api.internal.dto.ModifyUserBySiteManagedDTO;
import com.tplink.smb.omada.identityaccess.api.internal.g;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.DeleteSiteListDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.QuerySiteDTO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.BaseSitePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.SitePO;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import lombok.Generated;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class F {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(F.class);
    private com.tplink.smb.omada.backup.core.unit.base.maininfo.b b = com.tplink.smb.omada.backup.core.unit.base.maininfo.b.a();
    @Autowired
    private com.tplink.smb.omada.maintenance.compatible.service.a c;
    @Autowired
    private com.tplink.smb.omada.lock.a.c d;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.site.a e;
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.g f = com.tplink.smb.omada.manager.port.mongo.configuration.site.g.a();
    @Autowired
    private com.tplink.smb.omada.backup.core.unit.siteconfig.servicesetting.restore.a g;
    @Autowired
    private g h;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.a i;
    @Autowired
    private com.tplink.smb.omada.portal.api.internal.c j;
    @Autowired
    private e k;
    @Autowired
    private a l;
    @Autowired
    private E m;
    @Autowired
    private com.tplink.smb.omada.backup.core.unit.devicebrief.c n;
    private final com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.d o = com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.d.a();
    private static final Pattern p = Pattern.compile("^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,62}[^ ]$");

    public OperationResponse<String> a(InputStream in, c omadacId, String siteName, boolean skipConfirm, boolean skipDevice, String userId) {
        OperationResponse<String> ops = this.a(omadacId, siteName);
        if (!ops.success()) {
            return ops;
        }
        d importSiteId = new d((String)ops.getResult());
        OperationResponse refreshOps = this.a(omadacId, importSiteId, true);
        if (!refreshOps.success()) {
            return refreshOps;
        }
        OperationResponse response = (OperationResponse)this.d.b(omadacId.a(), importSiteId.a(), () -> {
            OperationResponse operationResponse = OperationResponse.SUCCESS;
            try {
                operationResponse = this.a(in, importSiteId, omadacId, skipConfirm, skipDevice, com.tplink.smb.omada.backup.api.c.j.c);
            }
            catch (com.tplink.smb.omada.backup.api.d.b e2) {
                a.info("siteImport finished, notInWhitelistModelSet {}, omadacId {}", (Object)e2.a(), (Object)omadacId);
                this.e.a(new DeleteSiteListDTO(omadacId.a(), Collections.singletonList(importSiteId.a()), userId, Integer.valueOf(com.tplink.smb.omada.backup.api.c.n.a.a())));
                RestoreResult result = RestoreResult.buildDeviceWhitelistInCompatibleResult(e2.a());
                this.l.b(omadacId.a());
                this.a(omadacId, importSiteId, false);
                this.k.a(omadacId.a(), result);
                this.l.e(omadacId.a());
                return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)result);
            }
            catch (com.tplink.smb.omada.backup.api.d.c e3) {
                this.e.a(new DeleteSiteListDTO(omadacId.a(), Collections.singletonList(importSiteId.a()), userId, Integer.valueOf(com.tplink.smb.omada.backup.api.c.n.a.a())));
                if (e3.b() != null) {
                    if (e3.b().equals((Object)com.tplink.smb.omada.common.g.b.eq)) {
                        a.info("import site failed, error msg {}, omadacId={}", (Object)e3.b().c(), (Object)omadacId);
                    } else if (!e3.b().equals((Object)com.tplink.smb.omada.common.g.b.bA)) {
                        a.error("import site failed, error msg {}, omadacId={}", (Object)e3.b().c(), (Object)omadacId);
                    }
                    return new OperationResponse(e3.b());
                }
                return new OperationResponse(com.tplink.smb.omada.common.g.b.ws);
            }
            catch (MongoException e4) {
                a.warn("omadacId={} MongoException error occurred while import site", (Object)omadacId, (Object)e4);
                this.e.a(new DeleteSiteListDTO(omadacId.a(), Collections.singletonList(importSiteId.a()), userId, Integer.valueOf(com.tplink.smb.omada.backup.api.c.n.a.a())));
                return new OperationResponse(com.tplink.smb.omada.common.g.b.et);
            }
            catch (Exception e5) {
                a.warn("omadacId={} Unexpected error occurred while importing site. Delete error site.", (Object)omadacId);
                a.warn(e5.getMessage(), (Throwable)e5);
                this.e.a(new DeleteSiteListDTO(omadacId.a(), Collections.singletonList(importSiteId.a()), userId, Integer.valueOf(com.tplink.smb.omada.backup.api.c.n.a.a())));
                return new OperationResponse(com.tplink.smb.omada.common.g.b.ws);
            }
            if (operationResponse.success()) {
                OperationResponse initializeOptRes = this.h.a(ModifyUserBySiteManagedDTO.builder().omadacId(omadacId.a()).siteId(importSiteId.a()).siteName(siteName).operationType(x.a.b()).userId(userId).build());
                if (!initializeOptRes.success()) {
                    a.warn("Site {} initialize failed in omadac {}.", (Object)importSiteId, (Object)omadacId);
                    return new OperationResponse(initializeOptRes.getErrorCode(), initializeOptRes.getMsg(), null);
                }
                a.info("omadacId={} import site {} success.", (Object)omadacId, (Object)importSiteId);
                return new OperationResponse(com.tplink.smb.omada.common.g.b.a);
            }
            a.warn("omadacId={} siteId={} importSiteId={} Unexpected error occurred while import site, error msg {}. Delete error site.", new Object[]{omadacId, importSiteId, importSiteId, operationResponse.getMsg()});
            this.e.a(new DeleteSiteListDTO(omadacId.a(), Collections.singletonList(importSiteId.a()), userId, Integer.valueOf(com.tplink.smb.omada.backup.api.c.n.a.a())));
            return operationResponse;
        }, () -> {
            a.warn("omadacId={} siteId={} importSiteId={} siteImport Operation failed because Site Busy.", new Object[]{omadacId, importSiteId, importSiteId});
            return new OperationResponse(com.tplink.smb.omada.common.g.b.fi);
        });
        refreshOps = this.a(omadacId, importSiteId, (Boolean)null);
        if (!refreshOps.success()) {
            return refreshOps;
        }
        if (response.success()) {
            return OperationResponse.success((Object)importSiteId.a());
        }
        return response;
    }

    private OperationResponse<String> a(c omadacId, String siteName) {
        if (!p.matcher(siteName).matches()) {
            a.warn("omadacId={} Invalid site name, Site name must be 1-64 characters.", (Object)omadacId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.ft);
        }
        if (this.f.a(omadacId, siteName, com.tplink.smb.omada.backup.api.c.n.a)) {
            a.warn("omada:{} site {} to create is already existed while importing site.", (Object)omadacId, (Object)siteName);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.fu);
        }
        long siteCount = this.f.a(omadacId, com.tplink.smb.omada.backup.api.c.n.a);
        if (siteCount >= (long)this.o.a(omadacId, com.tplink.smb.omada.backup.api.c.n.a)) {
            a.debug("omadacId={} site size {} has reached maximum", (Object)omadacId, (Object)siteCount);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.fx);
        }
        SitePO sitePO = ((SitePO.SitePOBuilder)((SitePO.SitePOBuilder)((SitePO.SitePOBuilder)SitePO.builder().omadacId(omadacId.a())).name(siteName)).primary(Boolean.valueOf(false)).timeZone("UTC")).build();
        String siteId = this.f.b((BaseSitePO)sitePO);
        a.info("Site {} name={} create success in omadac {}.", new Object[]{sitePO.getId(), siteName, sitePO.getOmadacId()});
        return OperationResponse.success((Object)siteId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResponse a(InputStream in, d siteId, c omadacId, boolean skipConfirm, boolean skipDevice, com.tplink.smb.omada.backup.api.c.j operationTypeEnum) {
        OperationResponse operationResponse;
        a.info("OmadacId={} SiteImport begin, ImportedSiteId:{}.", (Object)omadacId, (Object)siteId);
        HashMap<String, Object> restoreCacheMap = new HashMap<String, Object>(16);
        restoreCacheMap.put("skipConfirm", skipDevice || skipConfirm);
        restoreCacheMap.put("skipDevice", skipDevice);
        restoreCacheMap.put("operationType", operationTypeEnum.b());
        HashMap<String, Map<String, String>> siteImportIdCacheMap = new HashMap<String, Map<String, String>>(16);
        try (CipherInputStream cipherInputStream = com.tplink.smb.omada.common.util.b.j.a((InputStream)in);
             GZIPInputStream gzipInputStream = new GZIPInputStream((InputStream)cipherInputStream);
             JsonParser jsonParser = new JsonFactory().createParser((InputStream)gzipInputStream);){
            b jsonParserWrapper = new b(jsonParser);
            jsonParserWrapper.a();
            OperationResponse response = this.a(omadacId, jsonParserWrapper, restoreCacheMap);
            if (!response.success()) {
                OperationResponse operationResponse2 = response;
                return operationResponse2;
            }
            this.a(jsonParserWrapper, omadacId, siteId, siteImportIdCacheMap, restoreCacheMap);
            this.c.a(omadacId.a(), siteId.a(), ((String[])restoreCacheMap.get(com.tplink.smb.omada.backup.api.c.d.a.A()))[0]);
            this.a(omadacId, siteId, restoreCacheMap);
            this.i.b(new QuerySiteDTO(omadacId.a(), siteId.a()));
            this.g.a(omadacId.a(), siteId.a());
            if (com.tplink.smb.omada.common.util.system.a.b()) {
                this.e.a(siteId.a());
            }
            a.debug("Handle site import special process for site {} on {}", (Object)siteId, (Object)omadacId);
            this.m.a(restoreCacheMap, omadacId);
        }
        catch (com.tplink.smb.omada.backup.api.d.b e2) {
            a.info("siteImport failed, notInWhitelistModelSet {}, omadacId {}", (Object)e2.a(), (Object)omadacId);
            throw e2;
        }
        catch (com.tplink.smb.omada.backup.api.d.c e3) {
            if (Objects.equals(com.tplink.smb.omada.common.g.b.eA, e3.b())) {
                a.warn(e3.getMessage());
            }
            throw e3;
        }
        catch (EOFException e4) {
            a.warn("EOFException in site import omadacId={}", (Object)omadacId.a(), (Object)e4);
            operationResponse = new OperationResponse(com.tplink.smb.omada.common.g.b.ei);
            return operationResponse;
        }
        catch (IOException e5) {
            a.error("IOException in site import omadacId={}", (Object)omadacId.a(), (Object)e5);
            operationResponse = new OperationResponse(com.tplink.smb.omada.common.g.b.ws);
            return operationResponse;
        }
        finally {
            com.tplink.smb.omada.backup.core.factory.c.a(omadacId.a());
        }
        a.info("OmadacId={} SiteImport end, ImportedSiteKey:{}.", (Object)omadacId, (Object)siteId);
        return OperationResponse.SUCCESS;
    }

    private void a(c omadacId, d siteId, Map<String, Object> restoreCacheMap) {
        Set deviceMacsToForget = restoreCacheMap.getOrDefault(com.tplink.smb.omada.backup.api.c.d.D.A(), new HashSet());
        this.n.a(omadacId, deviceMacsToForget);
        this.j.a(omadacId.a(), Collections.singleton(siteId.a()));
    }

    private OperationResponse a(c omadacId, b jsonParserWrapper, Map<String, Object> restoreCacheMap) throws IOException {
        JsonToken token = jsonParserWrapper.c();
        if (!JsonToken.START_OBJECT.equals((Object)token)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.wt);
        }
        jsonParserWrapper.c();
        if (JsonToken.FIELD_NAME.equals((Object)jsonParserWrapper.d())) {
            String fileKey = jsonParserWrapper.f();
            if (!com.tplink.smb.omada.backup.api.c.d.a.A().equals(fileKey)) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.wt);
            }
            return this.b.a(jsonParserWrapper, omadacId, null, false, restoreCacheMap);
        }
        a.warn("file illegal");
        return new OperationResponse(com.tplink.smb.omada.common.g.b.wt);
    }

    private void a(b jsonParserWrapper, c omadacId, d siteId, Map<String, Map<String, String>> siteImportIdCacheMap, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        while (!JsonToken.END_OBJECT.equals((Object)jsonParserWrapper.c())) {
            if (Thread.currentThread().isInterrupted()) {
                a.warn("Server try to shut down, omadacId={} import site will stop", (Object)omadacId);
                throw new com.tplink.smb.omada.backup.api.d.c(com.tplink.smb.omada.common.g.b.bA);
            }
            if (!JsonToken.FIELD_NAME.equals((Object)jsonParserWrapper.d())) continue;
            String fileKey = jsonParserWrapper.f();
            com.tplink.smb.omada.backup.api.c.d functionKeyEnum = com.tplink.smb.omada.backup.api.c.d.a((String)fileKey);
            if (functionKeyEnum == null) {
                a.warn("file key {} is not compatible, skip this one", (Object)fileKey);
                com.tplink.smb.omada.backup.core.unit.a.b.a().siteImport(jsonParserWrapper, omadacId, siteId, siteImportIdCacheMap, restoreCacheMap);
                continue;
            }
            com.tplink.smb.omada.backup.api.c unit = com.tplink.smb.omada.backup.core.factory.d.a(functionKeyEnum);
            if (unit == null) {
                a.warn("OmadacId={} empty siteImport unit, function key {}", (Object)omadacId, (Object)fileKey);
                throw new com.tplink.smb.omada.backup.api.d.c("An empty restore unit.");
            }
            unit.siteImport(jsonParserWrapper, omadacId, siteId, siteImportIdCacheMap, restoreCacheMap);
        }
    }

    private OperationResponse a(c omadacId, d siteId, Boolean restoring) {
        a.debug("omadacId={},siteId={}, setDbRestoringStatus={}", new Object[]{omadacId, siteId, restoring});
        try {
            this.f.a(omadacId, siteId, restoring);
        }
        catch (Exception e2) {
            a.warn("Fail to refresh db restoring status", (Throwable)e2);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.ws);
        }
        return OperationResponse.SUCCESS;
    }
}

