/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.config;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tplink.smb.omada.backup.core.config.RestoreProperties;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={RestoreProperties.class})
public class RestoreConfig {
    @Lazy
    @Bean(name={"restoreScheduledWorkGroup"})
    @ConditionalOnMissingBean(name={"restoreScheduledWorkGroup"})
    public ScheduledThreadPoolExecutor restoreScheduledWorkGroup(RestoreProperties restoreProperties) {
        int coreSize = restoreProperties.getThreadPoolSize();
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(coreSize, new ThreadFactoryBuilder().setNameFormat("restore-work-group-%d").build());
        executor.setKeepAliveTime(1L, TimeUnit.HOURS);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }
}

