/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.config;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tplink.smb.omada.backup.core.config.BackupProperties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={BackupProperties.class})
public class BackupThreadConfig {
    @Lazy
    @Bean(name={"backupWorkGroup"})
    @ConditionalOnMissingBean(name={"backupWorkGroup"})
    public ThreadPoolExecutor backupWorkGroup(BackupProperties backupProperties) {
        int coreSize = backupProperties.getThreadPoolCoreSize();
        int maxSize = backupProperties.getThreadMaxPoolSize();
        return new ThreadPoolExecutor(coreSize, maxSize, 1L, TimeUnit.HOURS, new LinkedBlockingQueue<Runnable>(backupProperties.getThreadPoolQueueSize()), new ThreadFactoryBuilder().setNameFormat("backup-work-group-%d").build());
    }
}

