/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.backup;

import com.tplink.smb.omada.backup.core.backup.autobackup.schedule.DataExportQueryDTO;
import com.tplink.smb.omada.backup.core.backup.autobackup.schedule.e;
import com.tplink.smb.omada.backup.core.backup.h;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.gridquery.b;
import com.tplink.smb.omada.common.util.j;
import com.tplink.smb.omada.common.util.p;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.configuration.api.internal.dto.DstInfoDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.SiteDTO;
import com.tplink.smb.omada.monitor.port.mongo.insight.wids.WidsDataPO;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class s
implements e {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(s.class);
    private final com.tplink.smb.omada.monitor.port.mongo.a.a.c b = com.tplink.smb.omada.monitor.port.mongo.a.a.c.a();
    @Autowired
    private h c;

    @Override
    public OperationResponse a(c omadacId, DataExportQueryDTO dataExportQueryDTO) {
        a.debug("export WIDS , omadacId={}", (Object)omadacId.a());
        Map<String, SiteDTO> idSiteDTOMap = this.c.a(omadacId, dataExportQueryDTO);
        if (CollectionUtils.isEmpty(idSiteDTOMap)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, "empty site", null);
        }
        Map<String, DstInfoDTO> siteDstMap = this.c.a(omadacId, idSiteDTOMap);
        if (CollectionUtils.isEmpty(siteDstMap)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.fi, "Get site dst info failed.", null);
        }
        OperationResponse<b> queryDataOpt = this.c.a(dataExportQueryDTO);
        if (!queryDataOpt.success()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d, null);
        }
        StringBuilder filePrefix = new StringBuilder().append("WIDSData_").append(dataExportQueryDTO.getFileDataPartFormat());
        OperationResponse response = OperationResponse.SUCCESS;
        for (Map.Entry<String, SiteDTO> entry : idSiteDTOMap.entrySet()) {
            SiteDTO siteDTO = entry.getValue();
            String siteId = entry.getKey();
            DstInfoDTO dstInfoDTO = siteDstMap.get(siteId);
            response = this.a(omadacId, siteId, (b)queryDataOpt.getResult(), siteDTO, dstInfoDTO, filePrefix.toString(), dataExportQueryDTO.getTmpFilePath(), dataExportQueryDTO.getBatchLimit(), com.tplink.smb.omada.maintenance.common.b.h);
            if (response.success()) continue;
            a.warn("Export WIDS data .csv files failed. omadacId:{}, siteId:{}", (Object)omadacId, (Object)siteId);
        }
        return response;
    }

    @Override
    public com.tplink.smb.omada.maintenance.common.c a() {
        return com.tplink.smb.omada.maintenance.common.c.h;
    }

    public OperationResponse a(c omadacId, String siteId, b queryData, SiteDTO siteDTO, DstInfoDTO dstInfoDTO, String filePrefix, String tmpFilePath, Integer batchLimit, Integer format) {
        String fileName;
        OperationResponse exportResponse;
        AtomicInteger batchPerCount = new AtomicInteger(batchLimit);
        AtomicInteger suffixCount = new AtomicInteger(com.tplink.smb.omada.maintenance.common.b.b);
        ArrayList<WidsDataPO> widsDataPOS = new ArrayList<WidsDataPO>();
        AtomicReference<OperationResponse> response = new AtomicReference<OperationResponse>(OperationResponse.SUCCESS);
        this.b.a(omadacId, new d(siteId), queryData, widsDataPO -> {
            widsDataPOS.add((WidsDataPO)widsDataPO);
            batchPerCount.getAndSet(batchPerCount.get() - 1);
            if (batchPerCount.get() <= 0) {
                String fileName = filePrefix + "_" + siteDTO.getSiteName() + "_" + suffixCount.get();
                OperationResponse exportResponse = this.a(omadacId, new d(siteId), fileName, tmpFilePath, widsDataPOS, dstInfoDTO, siteDTO, format);
                if (!exportResponse.success()) {
                    response.set(exportResponse);
                    return;
                }
                widsDataPOS.clear();
                batchPerCount.getAndSet(batchLimit);
                suffixCount.getAndSet(suffixCount.get() + 1);
            }
        });
        if (!response.get().success()) {
            return response.get();
        }
        if (!CollectionUtils.isEmpty(widsDataPOS)) {
            a.debug("widsDataPO's start time:{}, omadacId:{}, siteId:{}", new Object[]{((WidsDataPO)widsDataPOS.get(0)).getStartTime(), omadacId, siteId});
        }
        if (!CollectionUtils.isEmpty(widsDataPOS) && !(exportResponse = this.a(omadacId, new d(siteId), fileName = filePrefix + "_" + siteDTO.getSiteName() + "_" + suffixCount.get(), tmpFilePath, widsDataPOS, dstInfoDTO, siteDTO, format)).success()) {
            return exportResponse;
        }
        widsDataPOS.clear();
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a);
    }

    private OperationResponse a(c omadacId, d siteId, String fileName, String fileDir, List<WidsDataPO> widsDataPOS, DstInfoDTO dstInfoDTO, SiteDTO siteDTO, Integer format) {
        OperationResponse operationResponse;
        String fullPath = fileDir + File.separator + fileName;
        if (com.tplink.smb.omada.maintenance.common.b.h.equals(format)) {
            fullPath = fullPath + ".csv";
        } else if (com.tplink.smb.omada.maintenance.common.b.i.equals(format)) {
            fullPath = fullPath + ".xlsx";
        } else {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        FileOutputStream outputStream = new FileOutputStream(fullPath);
        try {
            List<Map<String, Object>> listMap = this.a(widsDataPOS, siteDTO, dstInfoDTO);
            ArrayList keys = new ArrayList(com.tplink.smb.omada.maintenance.common.b.aq.keySet());
            ArrayList columnNames = new ArrayList(com.tplink.smb.omada.maintenance.common.b.aq.values());
            if (com.tplink.smb.omada.maintenance.common.b.h.equals(format)) {
                String content = j.a(listMap, (String[])keys.toArray(new String[0]), (String[])columnNames.toArray(new String[0]));
                ((OutputStream)outputStream).write(content.getBytes(StandardCharsets.UTF_8));
                outputStream.flush();
            } else if (com.tplink.smb.omada.maintenance.common.b.i.equals(format)) {
                try (Workbook workbook = p.a(listMap, (String[])keys.toArray(new String[0]), (String[])columnNames.toArray(new String[0]));){
                    workbook.write((OutputStream)outputStream);
                    outputStream.flush();
                    if (workbook instanceof SXSSFWorkbook) {
                        ((SXSSFWorkbook)workbook).dispose();
                    }
                }
            }
            operationResponse = OperationResponse.SUCCESS;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioException) {
                a.warn("export WIDS data csv/xlsx file failed. omadacId:{}, siteId:{}", (Object)omadacId, (Object)siteId);
                return OperationResponse.PARAM_ERROR;
            }
        }
        ((OutputStream)outputStream).close();
        return operationResponse;
    }

    private List<Map<String, Object>> a(List<WidsDataPO> widsDataPOS, SiteDTO siteDTO, DstInfoDTO dstInfoDTO) {
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        String timeZone = siteDTO.getTimezone();
        for (WidsDataPO widsDataPO : widsDataPOS) {
            LinkedHashMap<String, Object> mapValue = new LinkedHashMap<String, Object>();
            String stationMAC = widsDataPO.getStationMac() == null ? String.join((CharSequence)", ", widsDataPO.getStationMacList()) : widsDataPO.getStationMac();
            mapValue.put("station_mac", stationMAC);
            mapValue.put("detect_mac", widsDataPO.getDetectMac());
            mapValue.put("channel", widsDataPO.getChannel() + " (" + this.a(widsDataPO.getBand()) + ")");
            Long startTime = widsDataPO.getStartTime();
            mapValue.put("start_time", this.c.a(timeZone, "yyyy-MM-dd hh:mm:ss a", startTime, dstInfoDTO));
            mapValue.put("type", widsDataPO.getName());
            mapValue.put("level", this.b(widsDataPO.getLevel()));
            listMap.add(mapValue);
        }
        return listMap;
    }

    private String a(Integer band) {
        com.tplink.smb.omada.monitor.api.shared.a.c radioEnum = com.tplink.smb.omada.monitor.api.shared.a.c.a((Integer)band);
        switch (radioEnum) {
            case a: {
                return "2.4 GHz";
            }
            case b: {
                return "5 GHz";
            }
            case c: {
                return "5 GHz-2";
            }
            case d: {
                return "6 GHz";
            }
        }
        a.warn("unknown band:{}", (Object)band);
        return "";
    }

    private String b(Integer level) {
        if (level == 0) {
            return "Alert";
        }
        if (level == 1) {
            return "Major";
        }
        if (level == 2) {
            return "Normal";
        }
        a.warn("unknown event level:{}", (Object)level);
        return "";
    }
}

