/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.backup;

import com.tplink.smb.omada.backup.core.backup.autobackup.schedule.DataExportQueryDTO;
import com.tplink.smb.omada.backup.core.backup.autobackup.schedule.e;
import com.tplink.smb.omada.backup.core.backup.h;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.gridquery.b;
import com.tplink.smb.omada.common.util.j;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.configuration.api.internal.dto.DstInfoDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.SiteDTO;
import com.tplink.smb.omada.monitor.port.mongo.a.a.a;
import com.tplink.smb.omada.monitor.port.mongo.insight.rogueap.RogueApPO;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class p
implements e {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(p.class);
    private final a b = com.tplink.smb.omada.monitor.port.mongo.a.a.a.a();
    @Autowired
    private h c;

    @Override
    public OperationResponse a(c omadacId, DataExportQueryDTO dataExportQueryDTO) {
        a.debug("export Rogue Ap , omadacId={}", (Object)omadacId.a());
        Map<String, SiteDTO> idSiteDTOMap = this.c.a(omadacId, dataExportQueryDTO);
        if (CollectionUtils.isEmpty(idSiteDTOMap)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, "empty site", null);
        }
        Map<String, DstInfoDTO> siteDstMap = this.c.a(omadacId, idSiteDTOMap);
        if (CollectionUtils.isEmpty(siteDstMap)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.fi, "Get site dst info failed.", null);
        }
        OperationResponse<b> queryDataOpt = this.c.a(dataExportQueryDTO);
        if (!queryDataOpt.success()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d, null);
        }
        StringBuilder filePrefix = new StringBuilder().append("RougeAp_").append(dataExportQueryDTO.getFileDataPartFormat());
        OperationResponse response = OperationResponse.SUCCESS;
        for (Map.Entry<String, SiteDTO> entry : idSiteDTOMap.entrySet()) {
            SiteDTO siteDTO = entry.getValue();
            String siteId = entry.getKey();
            DstInfoDTO dstInfoDTO = siteDstMap.get(siteId);
            response = this.a(omadacId, siteId, (b)queryDataOpt.getResult(), siteDTO, dstInfoDTO, filePrefix.toString(), dataExportQueryDTO.getTmpFilePath(), dataExportQueryDTO.getBatchLimit(), com.tplink.smb.omada.maintenance.common.b.h);
            if (response.success()) continue;
            a.warn("Export rogueAp .csv files failed. omadacId:{}, siteId:{}", (Object)omadacId, (Object)siteId);
        }
        return response;
    }

    @Override
    public com.tplink.smb.omada.maintenance.common.c a() {
        return com.tplink.smb.omada.maintenance.common.c.d;
    }

    public OperationResponse a(c omadacId, String siteId, b queryData, SiteDTO siteDTO, DstInfoDTO dstInfoDTO, String filePrefix, String tmpFilePath, Integer batchLimit, Integer format) {
        String fileName;
        OperationResponse exportResponse;
        AtomicInteger batchPerCount = new AtomicInteger(batchLimit);
        AtomicInteger suffixCount = new AtomicInteger(com.tplink.smb.omada.maintenance.common.b.b);
        ArrayList<RogueApPO> rogueAps = new ArrayList<RogueApPO>();
        AtomicReference<OperationResponse> response = new AtomicReference<OperationResponse>(OperationResponse.SUCCESS);
        this.b.a(omadacId, new d(siteId), queryData, rogueAp -> {
            rogueAps.add((RogueApPO)rogueAp);
            batchPerCount.getAndSet(batchPerCount.get() - 1);
            if (batchPerCount.get() <= 0) {
                String fileName = filePrefix + "_" + siteDTO.getSiteName() + "_" + suffixCount.get();
                OperationResponse exportResponse = this.a(omadacId, new d(siteId), fileName, tmpFilePath, rogueAps, dstInfoDTO, siteDTO, format);
                if (!exportResponse.success()) {
                    response.set(exportResponse);
                    return;
                }
                rogueAps.clear();
                batchPerCount.getAndSet(batchLimit);
                suffixCount.getAndSet(suffixCount.get() + 1);
            }
        });
        if (!response.get().success()) {
            return response.get();
        }
        if (!CollectionUtils.isEmpty(rogueAps) && !(exportResponse = this.a(omadacId, new d(siteId), fileName = filePrefix + "_" + siteDTO.getSiteName() + "_" + suffixCount.get(), tmpFilePath, rogueAps, dstInfoDTO, siteDTO, format)).success()) {
            return exportResponse;
        }
        rogueAps.clear();
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a);
    }

    private OperationResponse a(c omadacId, d siteId, String fileName, String fileDir, List<RogueApPO> rogueAps, DstInfoDTO dstInfoDTO, SiteDTO siteDTO, Integer format) {
        OperationResponse operationResponse;
        String fullPath = fileDir + File.separator + fileName;
        if (com.tplink.smb.omada.maintenance.common.b.h.equals(format)) {
            fullPath = fullPath + ".csv";
        } else if (com.tplink.smb.omada.maintenance.common.b.i.equals(format)) {
            fullPath = fullPath + ".xlsx";
        } else {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        FileOutputStream outputStream = new FileOutputStream(fullPath);
        try {
            List<Map<String, Object>> listMap = this.a(rogueAps, siteDTO, dstInfoDTO);
            ArrayList keys = new ArrayList(com.tplink.smb.omada.maintenance.common.b.ae.keySet());
            ArrayList columnNames = new ArrayList(com.tplink.smb.omada.maintenance.common.b.ae.values());
            if (com.tplink.smb.omada.maintenance.common.b.h.equals(format)) {
                String content = j.a(listMap, (String[])keys.toArray(new String[0]), (String[])columnNames.toArray(new String[0]));
                ((OutputStream)outputStream).write(content.getBytes(StandardCharsets.UTF_8));
                outputStream.flush();
            } else if (com.tplink.smb.omada.maintenance.common.b.i.equals(format)) {
                try (Workbook workbook = com.tplink.smb.omada.common.util.p.a(listMap, (String[])keys.toArray(new String[0]), (String[])columnNames.toArray(new String[0]));){
                    workbook.write((OutputStream)outputStream);
                    outputStream.flush();
                    if (workbook instanceof SXSSFWorkbook) {
                        ((SXSSFWorkbook)workbook).dispose();
                    }
                }
            }
            operationResponse = OperationResponse.SUCCESS;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioException) {
                a.warn("export rogueAp csv/xlsx file failed. omadacId:{}, siteId:{}", (Object)omadacId, (Object)siteId);
                return OperationResponse.PARAM_ERROR;
            }
        }
        ((OutputStream)outputStream).close();
        return operationResponse;
    }

    private List<Map<String, Object>> a(List<RogueApPO> rogueAps, SiteDTO siteDTO, DstInfoDTO dstInfoDTO) {
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        String timeZone = siteDTO.getTimezone();
        String siteName = siteDTO.getSiteName();
        for (RogueApPO rogueAp : rogueAps) {
            LinkedHashMap<String, Object> mapValue = new LinkedHashMap<String, Object>();
            mapValue.put("ssid", rogueAp.getSsid());
            mapValue.put("bssid", rogueAp.getBssid());
            mapValue.put("channel", rogueAp.getChannel() + " (" + com.tplink.smb.omada.maintenance.common.d.a((int)rogueAp.getMode()) + ")");
            String security = com.tplink.smb.omada.maintenance.common.e.b((Integer)rogueAp.getSecurity());
            mapValue.put("security", security);
            mapValue.put("beacon", rogueAp.getBeacon());
            mapValue.put("apName", "Nearest " + rogueAp.getApName());
            mapValue.put("signal", this.a(rogueAp.getSignal()) + "%(" + rogueAp.getSignal() + "dBm)");
            Long lastSeen = rogueAp.getLastSeen();
            mapValue.put("last_seen", this.c.a(timeZone, "yyyy-MM-dd hh:mm:ss a", lastSeen, dstInfoDTO));
            mapValue.put("siteName", siteName);
            listMap.add(mapValue);
        }
        return listMap;
    }

    private int a(Integer rssi) {
        if (rssi < -90) {
            return 0;
        }
        if (rssi > -50) {
            return 100;
        }
        return (int)Math.round(2.5 * (double)rssi.intValue() + 225.0);
    }
}

