/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.backup;

import com.google.common.collect.ImmutableList;
import com.tplink.smb.omada.backup.core.backup.autobackup.schedule.DataExportQueryDTO;
import com.tplink.smb.omada.backup.core.backup.autobackup.schedule.e;
import com.tplink.smb.omada.backup.core.backup.h;
import com.tplink.smb.omada.backup.core.domain.I;
import com.tplink.smb.omada.client.port.mongo.omada.a;
import com.tplink.smb.omada.client.port.mongo.omada.client.ClientPO;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.util.H;
import com.tplink.smb.omada.common.util.j;
import com.tplink.smb.omada.common.util.p;
import com.tplink.smb.omada.maintenance.common.b;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.configuration.api.internal.dto.DstInfoDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.SiteDTO;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class m
implements e {
    @Generated
    private static final Logger b = LoggerFactory.getLogger(m.class);
    private static final ImmutableList<H<String, String>> c = ImmutableList.builder().add((Object)H.a((Object)"name", (Object)"USERNAME")).add((Object)H.a((Object)"macAddress", (Object)"MAC ADDRESS")).add((Object)H.a((Object)"wireless", (Object)"WIRELESS")).add((Object)H.a((Object)"guest", (Object)"GUEST")).add((Object)H.a((Object)"download", (Object)"DOWNLOAD")).add((Object)H.a((Object)"upload", (Object)"UPLOAD")).add((Object)H.a((Object)"duration", (Object)"DURATION")).add((Object)H.a((Object)"lastSeen", (Object)"LAST SEEN")).add((Object)H.a((Object)"block", (Object)"BLOCK")).add((Object)H.a((Object)"manager", (Object)"MANAGER")).add((Object)H.a((Object)"lockToWirelessDevice", (Object)"LOCK TO WIRELESS DEVICE")).build();
    private static final ImmutableList<String> d = com.tplink.smb.omada.maintenance.common.b.a(c, H::getRight);
    private static final ImmutableList<String> e = com.tplink.smb.omada.maintenance.common.b.a(c, H::getLeft);
    @Autowired
    private h f;
    private final a g = com.tplink.smb.omada.client.port.mongo.omada.a.a();
    @Value(value="${data.export.limit.known-client:1000000}")
    private long h = 1000000L;
    public static final String a = "-";

    @Override
    public OperationResponse a(c omadacId, DataExportQueryDTO dataExportQueryDTO) {
        b.debug("export KnownClientData , omadacId={}", (Object)omadacId.a());
        Map<String, SiteDTO> idSiteDTOMap = this.f.a(omadacId, dataExportQueryDTO);
        if (CollectionUtils.isEmpty(idSiteDTOMap)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, "empty site", null);
        }
        Map<String, DstInfoDTO> siteDstMap = this.f.a(omadacId, idSiteDTOMap);
        if (CollectionUtils.isEmpty(siteDstMap)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.fi, "Get site dst info failed.", null);
        }
        OperationResponse<com.tplink.smb.omada.common.gridquery.b> queryDataOpt = this.f.a(dataExportQueryDTO);
        if (!queryDataOpt.success()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d, null);
        }
        StringBuilder filePrefix = new StringBuilder().append("Client_").append(dataExportQueryDTO.getFileDataPartFormat());
        OperationResponse<?> response = OperationResponse.SUCCESS;
        for (Map.Entry<String, SiteDTO> entry : idSiteDTOMap.entrySet()) {
            SiteDTO siteDTO = entry.getValue();
            d siteId = new d(entry.getKey());
            DstInfoDTO dstInfoDTO = siteDstMap.get(siteId.a());
            response = this.a(omadacId, siteId, (com.tplink.smb.omada.common.gridquery.b)queryDataOpt.getResult(), siteDTO, dstInfoDTO, filePrefix.toString(), dataExportQueryDTO.getTmpFilePath(), dataExportQueryDTO.getBatchLimit(), com.tplink.smb.omada.maintenance.common.b.h);
            if (response.success()) continue;
            b.warn("Export known client .csv files failed. omadacId:{}, siteId:{}", (Object)omadacId, (Object)siteId);
        }
        return response;
    }

    @Override
    public com.tplink.smb.omada.maintenance.common.c a() {
        return com.tplink.smb.omada.maintenance.common.c.a;
    }

    public OperationResponse<?> a(c omadacId, Set<d> siteIds, com.tplink.smb.omada.common.gridquery.b queryData) {
        if (CollectionUtils.isEmpty(siteIds)) {
            return OperationResponse.success((Object)this.h);
        }
        if (siteIds.size() == 1) {
            d siteId = (d)siteIds.stream().findFirst().get();
            return this.g.b(omadacId, siteId, queryData, this.h);
        }
        AtomicLong limiter = new AtomicLong(this.h);
        for (d siteId : siteIds) {
            if (limiter.get() < 0L) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.eE, (Object)this.h);
            }
            OperationResponse countRes = this.g.a(omadacId, siteId, queryData, limiter.get());
            if (!countRes.success()) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.eE, (Object)this.h);
            }
            limiter.addAndGet(-((Long)countRes.getResult()).longValue());
        }
        return OperationResponse.success((Object)this.h);
    }

    public OperationResponse<?> a(c omadacId, d siteId, com.tplink.smb.omada.common.gridquery.b queryData, SiteDTO siteDTO, DstInfoDTO dstInfoDTO, String filePrefix, String tmpFilePath, Integer batchLimit, Integer format) {
        String fileName;
        OperationResponse<?> exportResponse;
        AtomicInteger suffixCount;
        ArrayList<ClientPO> clients = new ArrayList<ClientPO>();
        AtomicInteger batchPerCount = new AtomicInteger(batchLimit);
        OperationResponse optRes = this.g.a(omadacId, siteId, queryData, arg_0 -> this.a(clients, batchPerCount, filePrefix, siteDTO, suffixCount = new AtomicInteger(com.tplink.smb.omada.maintenance.common.b.b), omadacId, siteId, tmpFilePath, dstInfoDTO, format, batchLimit, arg_0));
        if (!optRes.success()) {
            return optRes;
        }
        if (!CollectionUtils.isEmpty(clients) && !(exportResponse = this.a(omadacId, siteId, fileName = filePrefix + "_" + siteDTO.getSiteName() + "_" + suffixCount.get(), tmpFilePath, clients, dstInfoDTO, siteDTO, format)).success()) {
            return exportResponse;
        }
        clients.clear();
        return OperationResponse.SUCCESS;
    }

    private OperationResponse<?> a(@Nonnull c omadacId, @Nonnull d siteId, @Nonnull String fileName, @Nonnull String fileDir, @Nonnull List<ClientPO> clients, @Nonnull DstInfoDTO dstInfoDTO, @Nonnull SiteDTO siteDTO, @Nonnull Integer format) {
        OperationResponse operationResponse;
        String fullPath = fileDir + File.separator + fileName;
        if (com.tplink.smb.omada.maintenance.common.b.h.equals(format)) {
            fullPath = fullPath + ".csv";
        } else if (com.tplink.smb.omada.maintenance.common.b.i.equals(format)) {
            fullPath = fullPath + ".xlsx";
        } else {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        FileOutputStream outputStream = new FileOutputStream(fullPath);
        try {
            List<Map<String, Object>> listMap = this.a(clients, siteDTO, dstInfoDTO);
            if (com.tplink.smb.omada.maintenance.common.b.h.equals(format)) {
                j.a(listMap, e, d, (OutputStream)outputStream);
                outputStream.flush();
            } else if (com.tplink.smb.omada.maintenance.common.b.i.equals(format)) {
                try (Workbook workbook = p.a(listMap, (String[])((String[])e.toArray((Object[])new String[0])), (String[])((String[])d.toArray((Object[])new String[0])));){
                    workbook.write((OutputStream)outputStream);
                    outputStream.flush();
                    if (workbook instanceof SXSSFWorkbook) {
                        ((SXSSFWorkbook)workbook).dispose();
                    }
                }
            }
            operationResponse = OperationResponse.SUCCESS;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioException) {
                b.warn("export client history csv file failed. omadacId:{}, siteId:{}", (Object)omadacId, (Object)siteId);
                return OperationResponse.PARAM_ERROR;
            }
        }
        ((OutputStream)outputStream).close();
        return operationResponse;
    }

    private List<Map<String, Object>> a(List<ClientPO> clients, SiteDTO siteDTO, DstInfoDTO dstInfoDTO) {
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        String timeZone = siteDTO.getTimezone();
        String siteName = siteDTO.getSiteName();
        for (ClientPO client : clients) {
            LinkedHashMap<String, Object> mapValue = new LinkedHashMap<String, Object>();
            for (I clientListColumnEnum : I.values()) {
                if (Objects.equals((Object)I.h, (Object)clientListColumnEnum)) {
                    Long lastSeen = client.getLastSeen();
                    mapValue.put(clientListColumnEnum.a(), this.f.a(timeZone, "yyyy-MM-dd hh:mm:ss a", lastSeen, dstInfoDTO));
                    continue;
                }
                mapValue.put(clientListColumnEnum.a(), Optional.ofNullable(clientListColumnEnum.a(client)).orElse(a));
            }
            mapValue.put("siteName", siteName);
            listMap.add(mapValue);
        }
        return listMap;
    }

    private /* synthetic */ OperationResponse a(List clients, AtomicInteger batchPerCount, String filePrefix, SiteDTO siteDTO, AtomicInteger suffixCount, c omadacId, d siteId, String tmpFilePath, DstInfoDTO dstInfoDTO, Integer format, Integer batchLimit, ClientPO client) {
        clients.add(client);
        batchPerCount.getAndSet(batchPerCount.get() - 1);
        if (batchPerCount.get() <= 0) {
            String fileName = filePrefix + "_" + siteDTO.getSiteName() + "_" + suffixCount.get();
            OperationResponse<?> exportResponse = this.a(omadacId, siteId, fileName, tmpFilePath, clients, dstInfoDTO, siteDTO, format);
            if (!exportResponse.success()) {
                return exportResponse;
            }
            clients.clear();
            batchPerCount.getAndSet(batchLimit);
            suffixCount.getAndSet(suffixCount.get() + 1);
        }
        return OperationResponse.SUCCESS;
    }
}

