/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.backup;

import com.tplink.smb.omada.backup.core.backup.autobackup.schedule.DataExportQueryDTO;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.P;
import com.tplink.smb.omada.common.gridquery.b;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.ae;
import com.tplink.smb.omada.dispatcher.common.response.ApiResponseWrapper;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.manager.configuration.api.internal.dto.DstInfoDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.a;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.QuerySiteDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.QuerySiteListDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.SiteDTO;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class h {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(h.class);
    @Autowired
    private a b;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.a c;

    public Map<String, DstInfoDTO> a(@Nonnull c omadacId, @Nonnull Map<String, SiteDTO> idSiteDTOMap) {
        if (CollectionUtils.isEmpty(idSiteDTOMap)) {
            return Collections.emptyMap();
        }
        HashMap<String, DstInfoDTO> siteDstMap = new HashMap<String, DstInfoDTO>(idSiteDTOMap.size());
        for (Map.Entry<String, SiteDTO> entry : idSiteDTOMap.entrySet()) {
            DstInfoDTO dstInfoDTO = (DstInfoDTO)this.c.a(new QuerySiteDTO(omadacId.a(), entry.getKey())).getResult();
            if (Objects.isNull(dstInfoDTO)) {
                a.warn("Get site dst info failed. OmadacId:{}, SiteId:{}", (Object)omadacId, (Object)entry.getKey());
                return Collections.emptyMap();
            }
            siteDstMap.put(entry.getKey(), dstInfoDTO);
        }
        return siteDstMap;
    }

    public Map<String, SiteDTO> a(@Nonnull c omadacId, @Nonnull DataExportQueryDTO dataExportQueryDTO) {
        List<String> siteIds = dataExportQueryDTO.getSiteIds();
        OperationResponse siteDtoListOpt = this.b.a(new QuerySiteListDTO().setOmadacId(omadacId.a()));
        if (!siteDtoListOpt.success()) {
            return Collections.emptyMap();
        }
        Map<String, Object> idSiteDTOMap = !CollectionUtils.isEmpty(siteIds) ? ((List)siteDtoListOpt.getResult()).stream().filter(siteDTO -> siteIds.contains(siteDTO.getId())).collect(Collectors.toMap(SiteDTO::getId, Function.identity())) : ((List)siteDtoListOpt.getResult()).stream().collect(Collectors.toMap(SiteDTO::getId, Function.identity()));
        return idSiteDTOMap;
    }

    public OperationResponse<b> a(@Nonnull DataExportQueryDTO dataExportQueryDTO) {
        b queryData = new b();
        if (dataExportQueryDTO.getStartMills() > dataExportQueryDTO.getEndMills()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d, (Object)queryData);
        }
        HashMap<String, Long> filterMap = new HashMap<String, Long>();
        filterMap.put("timeStart", dataExportQueryDTO.getStartMills());
        filterMap.put("timeEnd", dataExportQueryDTO.getEndMills());
        queryData.a(filterMap);
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)queryData);
    }

    public String a(String timezoneId, String format, Long timeStamp, DstInfoDTO dstInfo) {
        if (timeStamp == null) {
            return "-";
        }
        LocalDateTime localDateTime = new Date(timeStamp).toInstant().atOffset(ZoneOffset.of(P.b((String)timezoneId))).toLocalDateTime();
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern(format, Locale.ROOT);
        if (this.a(timeStamp, dstInfo)) {
            localDateTime = localDateTime.plus(dstInfo.getOffset(), ChronoUnit.MILLIS);
        }
        return localDateTime.format(timeFormatter);
    }

    public String a() {
        Object rootPath = OmadacType.s() ? com.tplink.smb.omada.common.util.file.c.a : System.getProperty("eap.home") + File.separator + "data";
        return rootPath;
    }

    public void a(@Nonnull File tmpDir) {
        if (tmpDir.isDirectory()) {
            File[] files = tmpDir.listFiles();
            if (files == null || files.length == 0) {
                a.info("Clear tmp data export file {} {}", (Object)tmpDir.getName(), (Object)tmpDir.getPath());
                tmpDir.delete();
            } else {
                for (File childFile : files) {
                    this.a(childFile);
                }
                this.a(tmpDir);
            }
        } else {
            a.info("Clear tmp data export file {} {}", (Object)tmpDir.getName(), (Object)tmpDir.getPath());
            tmpDir.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(@Nonnull String omadacId, @Nullable String siteId, @Nonnull File tempDir, ApiResponseWrapper response, String zipName) {
        response.setHeader("Pragma", "public");
        response.setHeader("Cache-Control", "max-age=30");
        response.setHeader("Content-Disposition", "attachment; filename=" + zipName + ".zip");
        response.setHeader("Content-Type", "application/octet-stream");
        try (OutputStream outputStream = response.getOutputStream();){
            if (tempDir.isDirectory()) {
                ae.a((OutputStream)outputStream, null, (File[])tempDir.listFiles());
            }
        }
        catch (IOException e2) {
            if (Objects.isNull(siteId)) {
                a.error("omadacId={} export data error!", (Object)omadacId, (Object)e2);
            } else {
                a.error("omadacId={} siteId={} export data error!", new Object[]{omadacId, siteId, e2});
            }
        }
        finally {
            this.a(tempDir);
        }
    }

    private boolean a(long currentTime, DstInfoDTO dstInfo) {
        return Boolean.TRUE.equals(dstInfo.getEnable()) && (currentTime > dstInfo.getStartTime() && currentTime < dstInfo.getEndTime() || currentTime > dstInfo.getLastStart() && currentTime < dstInfo.getLastEnd() || currentTime > dstInfo.getNextStart() && currentTime < dstInfo.getNextEnd());
    }
}

