/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.backup;

import com.google.common.collect.ImmutableList;
import com.tplink.smb.omada.backup.core.backup.autobackup.schedule.DataExportQueryDTO;
import com.tplink.smb.omada.backup.core.backup.autobackup.schedule.e;
import com.tplink.smb.omada.backup.core.backup.h;
import com.tplink.smb.omada.backup.core.domain.i;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.util.H;
import com.tplink.smb.omada.common.util.j;
import com.tplink.smb.omada.common.util.p;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.configuration.api.internal.dto.DstInfoDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.omadac.b;
import com.tplink.smb.omada.manager.configuration.api.internal.omadac.dto.UiInterfaceDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.SiteDTO;
import com.tplink.smb.omada.portal.port.mongo.data.authrecord.AuthRecordMaintRepository;
import com.tplink.smb.omada.portal.port.mongo.data.authrecord.AuthRecordPO;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class f
implements e {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(f.class);
    private static final ImmutableList<H<String, String>> b = ImmutableList.builder().add((Object)H.a((Object)"clientName", (Object)"Name")).add((Object)H.a((Object)"clientMac", (Object)"MAC ADDRESS")).add((Object)H.a((Object)"ipAddress", (Object)"IP ADDRESS")).add((Object)H.a((Object)"ssidName", (Object)"SSID/NETWORK")).add((Object)H.a((Object)"authType", (Object)"AUTHORIZED BY")).add((Object)H.a((Object)"totalDownload", (Object)"DOWNLOAD")).add((Object)H.a((Object)"totalUpload", (Object)"UPLOAD")).add((Object)H.a((Object)"start", (Object)"START TIME")).add((Object)H.a((Object)"duration", (Object)"DURATION")).add((Object)H.a((Object)"valid", (Object)"STATUS")).add((Object)H.a((Object)"end", (Object)"EXPIRATION TIME")).add((Object)H.a((Object)"siteName", (Object)"siteName")).build();
    private static final ImmutableList<String> c = com.tplink.smb.omada.maintenance.common.b.a(b, H::getLeft);
    private static final ImmutableList<String> d = com.tplink.smb.omada.maintenance.common.b.a(b, H::getRight);
    private final AuthRecordMaintRepository e = AuthRecordMaintRepository.getInstance();
    @Autowired
    private h f;
    @Autowired
    private b g;

    @Override
    public OperationResponse a(c omadacId, DataExportQueryDTO dataExportQueryDTO) {
        a.debug("export ClientPortalAuth , omadacId={}", (Object)omadacId.a());
        Map<String, SiteDTO> idSiteDTOMap = this.f.a(omadacId, dataExportQueryDTO);
        if (CollectionUtils.isEmpty(idSiteDTOMap)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, "empty site", null);
        }
        Map<String, DstInfoDTO> siteDstMap = this.f.a(omadacId, idSiteDTOMap);
        if (CollectionUtils.isEmpty(siteDstMap)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.fi, "Get site dst info failed.", null);
        }
        OperationResponse<com.tplink.smb.omada.common.gridquery.b> queryDataOpt = this.f.a(dataExportQueryDTO);
        if (!queryDataOpt.success()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d, null);
        }
        StringBuilder filePrefix = new StringBuilder().append("AuthedClients_").append(dataExportQueryDTO.getFileDataPartFormat());
        OperationResponse response = OperationResponse.SUCCESS;
        for (Map.Entry<String, SiteDTO> entry : idSiteDTOMap.entrySet()) {
            SiteDTO siteDTO = entry.getValue();
            String siteId = entry.getKey();
            DstInfoDTO dstInfoDTO = siteDstMap.get(siteId);
            response = this.a(omadacId, siteId, (com.tplink.smb.omada.common.gridquery.b)queryDataOpt.getResult(), siteDTO, dstInfoDTO, filePrefix.toString(), dataExportQueryDTO.getTmpFilePath(), dataExportQueryDTO.getBatchLimit(), com.tplink.smb.omada.maintenance.common.b.h);
            if (response.success()) continue;
            a.warn("Export authed client .csv files failed. omadacId:{}, siteId:{}", (Object)omadacId, (Object)siteId);
        }
        return response;
    }

    @Override
    public com.tplink.smb.omada.maintenance.common.c a() {
        return com.tplink.smb.omada.maintenance.common.c.f;
    }

    public OperationResponse a(c omadacId, String siteId, com.tplink.smb.omada.common.gridquery.b queryData, SiteDTO siteDTO, DstInfoDTO dstInfoDTO, String filePrefix, String tmpFilePath, Integer batchLimit, Integer format) {
        String fileName;
        OperationResponse exportResponse;
        AtomicInteger batchPerCount = new AtomicInteger(batchLimit);
        AtomicInteger suffixCount = new AtomicInteger(com.tplink.smb.omada.maintenance.common.b.b);
        ArrayList<AuthRecordPO> authClients = new ArrayList<AuthRecordPO>();
        AtomicReference<OperationResponse> response = new AtomicReference<OperationResponse>(OperationResponse.SUCCESS);
        this.e.queryForExport(omadacId, new d(siteId), queryData, authClient -> {
            authClients.add((AuthRecordPO)authClient);
            batchPerCount.getAndSet(batchPerCount.get() - 1);
            if (batchPerCount.get() <= 0) {
                String fileName = filePrefix + "_" + siteDTO.getSiteName() + "_" + suffixCount.get();
                OperationResponse exportResponse = this.a(omadacId, new d(siteId), fileName, tmpFilePath, authClients, dstInfoDTO, siteDTO, format);
                if (!exportResponse.success()) {
                    response.set(exportResponse);
                    return;
                }
                authClients.clear();
                batchPerCount.getAndSet(batchLimit);
                suffixCount.getAndSet(suffixCount.get() + 1);
            }
        });
        if (!response.get().success()) {
            return response.get();
        }
        if (!CollectionUtils.isEmpty(authClients) && !(exportResponse = this.a(omadacId, new d(siteId), fileName = filePrefix + "_" + siteDTO.getSiteName() + "_" + suffixCount.get(), tmpFilePath, authClients, dstInfoDTO, siteDTO, format)).success()) {
            return exportResponse;
        }
        authClients.clear();
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a);
    }

    private OperationResponse a(c omadacId, d siteId, String fileName, String fileDir, List<AuthRecordPO> authClients, DstInfoDTO dstInfoDTO, SiteDTO siteDTO, Integer format) {
        OperationResponse operationResponse;
        String fullPath = fileDir + File.separator + fileName;
        if (com.tplink.smb.omada.maintenance.common.b.h.equals(format)) {
            fullPath = fullPath + ".csv";
        } else if (com.tplink.smb.omada.maintenance.common.b.i.equals(format)) {
            fullPath = fullPath + ".xlsx";
        } else {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        FileOutputStream outputStream = new FileOutputStream(fullPath);
        try {
            List<Map<String, Object>> listMap = this.a(omadacId, authClients, siteDTO, dstInfoDTO);
            if (com.tplink.smb.omada.maintenance.common.b.h.equals(format)) {
                j.a(listMap, c, d, (OutputStream)outputStream);
                outputStream.flush();
            } else if (com.tplink.smb.omada.maintenance.common.b.i.equals(format)) {
                try (Workbook workbook = p.a(listMap, (String[])((String[])c.toArray((Object[])new String[0])), (String[])((String[])d.toArray((Object[])new String[0])));){
                    workbook.write((OutputStream)outputStream);
                    outputStream.flush();
                    if (workbook instanceof SXSSFWorkbook) {
                        ((SXSSFWorkbook)workbook).dispose();
                    }
                }
            }
            operationResponse = OperationResponse.SUCCESS;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioException) {
                a.warn("export authed clients csv/xlsx file failed. omadacId:{}, siteId:{}", (Object)omadacId, (Object)siteId);
                return OperationResponse.PARAM_ERROR;
            }
        }
        ((OutputStream)outputStream).close();
        return operationResponse;
    }

    private List<Map<String, Object>> a(c omadacId, List<AuthRecordPO> authClients, SiteDTO siteDTO, DstInfoDTO dstInfoDTO) {
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        String timeZone = siteDTO.getTimezone();
        String siteName = siteDTO.getSiteName();
        OperationResponse uiInterfaceOps = this.g.f(omadacId.a());
        boolean use24hour = false;
        if (uiInterfaceOps.success()) {
            use24hour = Optional.ofNullable((UiInterfaceDTO)uiInterfaceOps.getResult()).map(UiInterfaceDTO::getEnable24HourClock).orElse(false);
        }
        for (AuthRecordPO authRecord : authClients) {
            LinkedHashMap<String, Object> mapValue = new LinkedHashMap<String, Object>();
            for (i authClientListColumnEnum : i.values()) {
                if (Objects.equals((Object)i.h, (Object)authClientListColumnEnum)) {
                    Long start = authRecord.getStart();
                    mapValue.put(authClientListColumnEnum.a(), this.f.a(timeZone, use24hour ? "YYYY-MM-dd HH:mm:ss" : "yyyy-MM-dd hh:mm:ss a", start, dstInfoDTO));
                    continue;
                }
                if (Objects.equals((Object)i.k, (Object)authClientListColumnEnum)) {
                    Long end = authRecord.getEnd();
                    mapValue.put(authClientListColumnEnum.a(), this.f.a(timeZone, use24hour ? "YYYY-MM-dd HH:mm:ss" : "yyyy-MM-dd hh:mm:ss a", end, dstInfoDTO));
                    continue;
                }
                mapValue.put(authClientListColumnEnum.a(), authClientListColumnEnum.a(authRecord));
            }
            mapValue.put("siteName", siteName);
            listMap.add(mapValue);
        }
        return listMap;
    }
}

