/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.backup;

import com.google.common.collect.ImmutableList;
import com.tplink.smb.omada.backup.core.backup.autobackup.schedule.DataExportQueryDTO;
import com.tplink.smb.omada.backup.core.backup.h;
import com.tplink.smb.omada.backup.core.domain.u;
import com.tplink.smb.omada.client.port.mongo.data.a.b;
import com.tplink.smb.omada.client.port.mongo.data.history.ClientHistoryPO;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.util.H;
import com.tplink.smb.omada.common.util.j;
import com.tplink.smb.omada.common.util.p;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.configuration.api.internal.dto.DstInfoDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.SiteDTO;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class e
implements com.tplink.smb.omada.backup.core.backup.autobackup.schedule.e {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(e.class);
    private static final ImmutableList<H<String, String>> b = ImmutableList.builder().add((Object)H.a((Object)"name", (Object)"USERNAME")).add((Object)H.a((Object)"macAddress", (Object)"MAC ADDRESS")).add((Object)H.a((Object)"ipAddress", (Object)"IP ADDRESS")).add((Object)H.a((Object)"deviceType", (Object)"DEVICE TYPE")).add((Object)H.a((Object)"apPort", (Object)"AP/PORT")).add((Object)H.a((Object)"associatedTime", (Object)"ASSOCIATED TIME")).add((Object)H.a((Object)"lastOnlineTime", (Object)"LAST ONLINE TIME")).add((Object)H.a((Object)"wirelessConnection", (Object)"WIRELESS CONNECTION")).add((Object)H.a((Object)"download", (Object)"DOWNLOAD")).add((Object)H.a((Object)"upload", (Object)"UPLOAD")).add((Object)H.a((Object)"uptime", (Object)"UPTIME")).add((Object)H.a((Object)"associatedSuccess", (Object)"ASSOCIATED SUCCESS")).add((Object)H.a((Object)"siteName", (Object)"SITE NAME")).add((Object)H.a((Object)"authInfo", (Object)"AUTHENTICATION TYPE")).build();
    private static final ImmutableList<String> c = com.tplink.smb.omada.maintenance.common.b.a(b, H::getLeft);
    private static final ImmutableList<String> d = com.tplink.smb.omada.maintenance.common.b.a(b, H::getRight);
    @Autowired
    private h e;
    private final b f = com.tplink.smb.omada.client.port.mongo.data.a.b.a();
    @Value(value="${data.export.limit.client-history:1000000}")
    private long g = 1000000L;

    @Override
    public OperationResponse a(c omadacId, DataExportQueryDTO dataExportQueryDTO) {
        a.debug("export ClientHistoryData , omadacId={}", (Object)omadacId.a());
        Map<String, SiteDTO> idSiteDTOMap = this.e.a(omadacId, dataExportQueryDTO);
        if (CollectionUtils.isEmpty(idSiteDTOMap)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, "empty site", null);
        }
        Map<String, DstInfoDTO> siteDstMap = this.e.a(omadacId, idSiteDTOMap);
        if (CollectionUtils.isEmpty(siteDstMap)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.fi, "Get site dst info failed.", null);
        }
        OperationResponse<com.tplink.smb.omada.common.gridquery.b> queryDataOpt = this.e.a(dataExportQueryDTO);
        if (!queryDataOpt.success()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d, null);
        }
        StringBuilder filePrefix = new StringBuilder().append("ClientHistory_").append(dataExportQueryDTO.getFileDataPartFormat());
        OperationResponse<?> response = OperationResponse.SUCCESS;
        for (Map.Entry<String, SiteDTO> entry : idSiteDTOMap.entrySet()) {
            SiteDTO siteDTO = entry.getValue();
            String siteId = entry.getKey();
            DstInfoDTO dstInfoDTO = siteDstMap.get(siteId);
            response = this.a(omadacId, new d(siteId), (com.tplink.smb.omada.common.gridquery.b)queryDataOpt.getResult(), siteDTO, dstInfoDTO, filePrefix.toString(), dataExportQueryDTO.getTmpFilePath(), dataExportQueryDTO.getBatchLimit(), com.tplink.smb.omada.maintenance.common.b.h);
            if (response.success()) continue;
            a.warn("Export client histories .csv files failed. omadacId:{}, siteId:{}", (Object)omadacId, (Object)siteId);
        }
        return response;
    }

    @Override
    public com.tplink.smb.omada.maintenance.common.c a() {
        return com.tplink.smb.omada.maintenance.common.c.b;
    }

    public OperationResponse<Long> a(c omadacId, Set<d> siteIds, com.tplink.smb.omada.common.gridquery.b queryData) {
        AtomicLong limiter = new AtomicLong(this.g);
        for (d siteId : siteIds) {
            if (limiter.get() < 0L) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.eE, (Object)this.g);
            }
            OperationResponse countRes = this.f.a(omadacId, siteId, queryData, limiter.get());
            if (!countRes.success()) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.eE, (Object)this.g);
            }
            limiter.addAndGet(-((Long)countRes.getResult()).longValue());
        }
        return OperationResponse.success((Object)this.g);
    }

    public OperationResponse<?> a(c omadacId, d siteId, com.tplink.smb.omada.common.gridquery.b queryData, SiteDTO siteDTO, DstInfoDTO dstInfoDTO, String filePrefix, String tmpFilePath, Integer batchLimit, int format) {
        String fileName;
        OperationResponse exportResponse;
        AtomicInteger suffixCount;
        ArrayList<ClientHistoryPO> clientHistories = new ArrayList<ClientHistoryPO>();
        AtomicInteger batchPerCount = new AtomicInteger(batchLimit);
        OperationResponse response = this.f.a(omadacId, siteId, queryData, arg_0 -> this.a(clientHistories, batchPerCount, filePrefix, siteDTO, suffixCount = new AtomicInteger(com.tplink.smb.omada.maintenance.common.b.b), omadacId, siteId, tmpFilePath, dstInfoDTO, format, batchLimit, arg_0));
        if (!response.success()) {
            return response;
        }
        if (!CollectionUtils.isEmpty(clientHistories) && !(exportResponse = this.a(omadacId, siteId, fileName = filePrefix + "_" + siteDTO.getSiteName() + "_" + suffixCount.get(), tmpFilePath, clientHistories, dstInfoDTO, siteDTO, format)).success()) {
            return exportResponse;
        }
        return OperationResponse.SUCCESS;
    }

    private OperationResponse a(@Nonnull c omadacId, @Nonnull d siteId, @Nonnull String fileName, @Nonnull String fileDir, @Nonnull List<ClientHistoryPO> clientHistories, @Nonnull DstInfoDTO dstInfoDTO, @Nonnull SiteDTO siteDTO, Integer format) {
        OperationResponse operationResponse;
        String fullPath = fileDir + File.separator + fileName;
        if (com.tplink.smb.omada.maintenance.common.b.h.equals(format)) {
            fullPath = fullPath + ".csv";
        } else if (com.tplink.smb.omada.maintenance.common.b.i.equals(format)) {
            fullPath = fullPath + ".xlsx";
        } else {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        FileOutputStream outputStream = new FileOutputStream(fullPath);
        try {
            List<Map<String, Object>> listMap = this.a(clientHistories, siteDTO, dstInfoDTO);
            if (com.tplink.smb.omada.maintenance.common.b.h.equals(format)) {
                j.a(listMap, c, d, (OutputStream)outputStream);
                outputStream.flush();
            } else if (com.tplink.smb.omada.maintenance.common.b.i.equals(format)) {
                try (Workbook workbook = p.a(listMap, (String[])((String[])c.toArray((Object[])new String[0])), (String[])((String[])d.toArray((Object[])new String[0])));){
                    workbook.write((OutputStream)outputStream);
                    outputStream.flush();
                    if (workbook instanceof SXSSFWorkbook) {
                        ((SXSSFWorkbook)workbook).dispose();
                    }
                }
            }
            operationResponse = OperationResponse.SUCCESS;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioException) {
                a.warn("export client history csv file failed. omadacId:{}, siteId:{}", (Object)omadacId, (Object)siteId);
                return OperationResponse.PARAM_ERROR;
            }
        }
        ((OutputStream)outputStream).close();
        return operationResponse;
    }

    private List<Map<String, Object>> a(List<ClientHistoryPO> clientHistories, SiteDTO siteDTO, DstInfoDTO dstInfoDTO) {
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        String timeZone = siteDTO.getTimezone();
        String siteName = siteDTO.getSiteName();
        for (ClientHistoryPO clientHistory : clientHistories) {
            LinkedHashMap<String, Object> mapValue = new LinkedHashMap<String, Object>();
            for (u clientHistoryColumnEnum : u.values()) {
                if (Objects.equals((Object)u.g, (Object)clientHistoryColumnEnum)) {
                    Long associated = clientHistory.getAssociated();
                    mapValue.put(clientHistoryColumnEnum.a(), this.e.a(timeZone, "yyyy-MM-dd hh:mm:ss a", associated, dstInfoDTO));
                    continue;
                }
                if (Objects.equals((Object)u.h, (Object)clientHistoryColumnEnum)) {
                    Long lastSeen = clientHistory.getLastSeen();
                    mapValue.put(clientHistoryColumnEnum.a(), this.e.a(timeZone, "yyyy-MM-dd hh:mm:ss a", lastSeen, dstInfoDTO));
                    continue;
                }
                mapValue.put(clientHistoryColumnEnum.a(), clientHistoryColumnEnum.a(clientHistory));
            }
            mapValue.put("siteName", siteName);
            listMap.add(mapValue);
        }
        return listMap;
    }

    private /* synthetic */ OperationResponse a(List clientHistories, AtomicInteger batchPerCount, String filePrefix, SiteDTO siteDTO, AtomicInteger suffixCount, c omadacId, d siteId, String tmpFilePath, DstInfoDTO dstInfoDTO, int format, Integer batchLimit, ClientHistoryPO clientHistory) {
        clientHistories.add(clientHistory);
        batchPerCount.getAndSet(batchPerCount.get() - 1);
        if (batchPerCount.get() <= 0) {
            String fileName = filePrefix + "_" + siteDTO.getSiteName() + "_" + suffixCount.get();
            OperationResponse exportResponse = this.a(omadacId, siteId, fileName, tmpFilePath, clientHistories, dstInfoDTO, siteDTO, format);
            if (!exportResponse.success()) {
                return exportResponse;
            }
            clientHistories.clear();
            batchPerCount.getAndSet(batchLimit);
            suffixCount.getAndSet(suffixCount.get() + 1);
        }
        return OperationResponse.SUCCESS;
    }
}

