/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.backup;

import com.tplink.smb.component.storage.api.repository.FileRepository;
import com.tplink.smb.omada.backup.api.c.g;
import com.tplink.smb.omada.backup.api.c.h;
import com.tplink.smb.omada.backup.api.web.dto.SelfRestoreFileVO;
import com.tplink.smb.omada.backup.core.backup.BackupFileStorageConfigProperties;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.b.c;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.dispatcher.common.response.ApiResponseWrapper;
import com.tplink.smb.omada.maintenance.domain.model.b.a;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class b {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(b.class);
    @Autowired
    private FileRepository b;
    @Autowired
    private com.tplink.smb.omada.maintenance.domain.model.b.b c;
    @Autowired
    private BackupFileStorageConfigProperties d;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OperationResponse a(String omadacId, String siteId, File file, String fileName, g backupLevel, h backupType, long backupTime) {
        try (FileInputStream in = new FileInputStream(file);){
            String prefix = this.a(omadacId, siteId, backupLevel);
            if (Objects.isNull(prefix)) {
                OperationResponse operationResponse = OperationResponse.PARAM_ERROR;
                return operationResponse;
            }
            int expireDays = this.d.getExpireDays();
            a.debug("backup file expire days: {}", (Object)expireDays);
            String savingFileName = com.tplink.smb.omada.common.util.b.c.c((byte[])fileName.getBytes()).replace("=", "_").replace("+", "_");
            String fileId = this.b.saveFile(prefix, null, savingFileName, (InputStream)in, expireDays);
            if (T.a((String)fileId)) {
                a.error("Fail to save backup file {} in omadac {} siteId {}", new Object[]{savingFileName, omadacId, siteId});
                OperationResponse operationResponse = OperationResponse.GENERAL_ERROR;
                return operationResponse;
            }
            OperationResponse operationResponse = this.a(omadacId, siteId, backupLevel, backupType, fileId, fileName, file.length(), backupTime);
            return operationResponse;
        }
        catch (Exception e2) {
            a.warn("Fail to save backup file to cloud server, omadacId: {}", (Object)omadacId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.ek);
        }
    }

    public OperationResponse a(String omadacId, String siteId, g backupLevel, h backupType, String fileId, String fileName, long fileSize, long backupTime) {
        a backupFile = new a();
        backupFile.b(omadacId).c(siteId).d(fileId).a(backupLevel).a(backupType).e(fileName).b(Long.valueOf(fileSize)).a(Long.valueOf(backupTime));
        this.c.a(backupFile);
        this.a(omadacId, siteId, backupLevel, backupType);
        return OperationResponse.SUCCESS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OperationResponse a(String fileName, String fileId, ApiResponseWrapper response) {
        try (OutputStream outputStream = response.getOutputStream();){
            response.setHeader("Cache-Control", "max-age:3");
            response.setHeader("Content-Type", "application/octet-stream;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment;fileName=" + URLEncoder.encode(fileName, "UTF-8"));
            boolean state = this.b.readFile(fileId, outputStream);
            outputStream.flush();
            if (state) {
                OperationResponse operationResponse2 = new OperationResponse(com.tplink.smb.omada.common.g.b.a);
                return operationResponse2;
            }
            a.warn("fail to get file from s3, file={}", (Object)fileId);
            OperationResponse operationResponse = new OperationResponse(com.tplink.smb.omada.common.g.b.d);
            return operationResponse;
        }
        catch (IOException e2) {
            a.warn(e2.getMessage(), (Throwable)e2);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
    }

    public OperationResponse<InputStream> a(String omadacId, String siteId, SelfRestoreFileVO fileVO) {
        OperationResponse operationResponse;
        Optional optional = this.c.a(omadacId, siteId, fileVO.getFileName());
        if (!optional.isPresent() || !Objects.equals(((a)optional.get()).d(), fileVO.getFileId())) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        File file = com.tplink.smb.omada.common.util.file.c.a(null);
        FileOutputStream outputStream = new FileOutputStream(file);
        try {
            this.b.readFile(fileVO.getFileId(), (OutputStream)outputStream);
            outputStream.flush();
            operationResponse = OperationResponse.success((Object)new FileInputStream(file));
        }
        catch (Throwable throwable) {
            try {
                try {
                    try {
                        ((OutputStream)outputStream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    return new OperationResponse(com.tplink.smb.omada.common.g.b.eh);
                }
            }
            catch (Exception e3) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.eh);
            }
        }
        ((OutputStream)outputStream).close();
        return operationResponse;
    }

    public OperationResponse<InputStream> a(String fileId) {
        OperationResponse operationResponse;
        File file = com.tplink.smb.omada.common.util.file.c.a(null);
        FileOutputStream outputStream = new FileOutputStream(file);
        try {
            this.b.readFile(fileId, (OutputStream)outputStream);
            outputStream.flush();
            operationResponse = OperationResponse.success((Object)new FileInputStream(file));
        }
        catch (Throwable throwable) {
            try {
                try {
                    try {
                        ((OutputStream)outputStream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    return new OperationResponse(com.tplink.smb.omada.common.g.b.eh);
                }
            }
            catch (Exception e3) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.eh);
            }
        }
        ((OutputStream)outputStream).close();
        return operationResponse;
    }

    public OperationResponse a(String omadacId, String siteId, String fileName, String fileId) {
        Optional optional = this.c.a(omadacId, siteId, fileName);
        if (!optional.isPresent() || !Objects.equals(((a)optional.get()).d(), fileId)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        this.c.a(((a)optional.get()).a());
        this.b.deleteFile(fileId);
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a);
    }

    public List<a> a(String omadacId, String backupLevel, String siteId, Integer backupType) {
        List backupFiles = this.c.b(omadacId, backupLevel, siteId, backupType);
        backupFiles.sort((o1, o2) -> (int)(o2.h() - o1.h()));
        return backupFiles;
    }

    private String a(String omadacId, String siteId, g backupLevel) {
        switch (backupLevel) {
            case c: 
            case a: {
                return omadacId + "/BLANK";
            }
            case b: {
                return omadacId + "/" + siteId;
            }
        }
        return null;
    }

    private void a(String omadacId, String siteId, g backupLevel, h backupType) {
        int limitCnt = this.a(backupLevel);
        List backupFiles = this.c.a(omadacId, siteId, backupLevel.a(), backupType.a());
        if (g.b.equals((Object)backupLevel) && h.a.equals((Object)backupType)) {
            backupFiles.addAll(this.c.a(omadacId, siteId, backupLevel.a(), h.f.a()));
        }
        if (backupFiles.size() <= limitCnt) {
            return;
        }
        backupFiles.sort(Comparator.comparing(a::h));
        a deleteFile = (a)backupFiles.get(0);
        if (!this.b.deleteFile(deleteFile.d())) {
            a.warn("remove backup file failed: {}", (Object)x.a((Object)deleteFile));
        }
        this.c.a(deleteFile.a());
    }

    private int a(g backupLevel) {
        int cnt = 0;
        switch (backupLevel) {
            case c: 
            case a: {
                cnt = this.d.getGlobalNum();
                break;
            }
            case b: {
                cnt = this.d.getSiteNum();
                break;
            }
        }
        return cnt;
    }
}

