/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.backup;

import com.tplink.smb.omada.backup.core.backup.autobackup.schedule.DataExportQueryDTO;
import com.tplink.smb.omada.backup.core.backup.autobackup.schedule.e;
import com.tplink.smb.omada.backup.core.backup.h;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.j;
import com.tplink.smb.omada.common.util.p;
import com.tplink.smb.omada.logmanager.port.mongo.log.AbstractAuditLogPO;
import com.tplink.smb.omada.maintenance.common.b.a.a.b;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.manager.configuration.api.internal.dto.DstInfoDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.omadac.dto.GeneralSettingDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.QuerySiteDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.SiteDTO;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class a
implements e {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(a.class);
    @Autowired
    private h b;
    private final com.tplink.smb.omada.logmanager.port.mongo.data.a c = com.tplink.smb.omada.logmanager.port.mongo.data.a.a();
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.a d;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.omadac.b e;

    @Override
    public OperationResponse a(c omadacId, DataExportQueryDTO dataExportQueryDTO) {
        a.debug("export audit log , omadacId={}", (Object)omadacId.a());
        OperationResponse globalExportResponse = this.b(omadacId, dataExportQueryDTO);
        if (!globalExportResponse.success()) {
            return globalExportResponse;
        }
        OperationResponse siteExportResponse = this.c(omadacId, dataExportQueryDTO);
        if (!siteExportResponse.success()) {
            return siteExportResponse;
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a);
    }

    private OperationResponse b(c omadacId, DataExportQueryDTO dataExportQueryDTO) {
        OperationResponse<com.tplink.smb.omada.common.gridquery.b> queryDataOpt = this.b.a(dataExportQueryDTO);
        if (!queryDataOpt.success()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d, null);
        }
        OperationResponse dstInfoDTOOpt = this.d.a(new QuerySiteDTO().setOmadacId(omadacId.a()));
        if (!dstInfoDTOOpt.success()) {
            a.warn("Get global dst info failed. OmadacId:{}", (Object)omadacId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.fi, "Get global dst info failed.", null);
        }
        StringBuilder filePrefix = new StringBuilder().append("GlobalAuditLog_").append(dataExportQueryDTO.getFileDataPartFormat());
        OperationResponse response = this.a(omadacId, (com.tplink.smb.omada.common.gridquery.b)queryDataOpt.getResult(), (DstInfoDTO)dstInfoDTOOpt.getResult(), filePrefix.toString(), dataExportQueryDTO.getTmpFilePath(), dataExportQueryDTO.getBatchLimit(), com.tplink.smb.omada.maintenance.common.b.h);
        if (!response.success()) {
            a.warn("Export global audit logs .csv files failed. omadacId:{}", (Object)omadacId);
        }
        return response;
    }

    private OperationResponse c(c omadacId, DataExportQueryDTO dataExportQueryDTO) {
        Map<String, SiteDTO> idSiteDTOMap = this.b.a(omadacId, dataExportQueryDTO);
        if (CollectionUtils.isEmpty(idSiteDTOMap)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, "empty site", null);
        }
        Map<String, DstInfoDTO> siteDstMap = this.b.a(omadacId, idSiteDTOMap);
        if (CollectionUtils.isEmpty(siteDstMap)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.fi, "Get site dst info failed.", null);
        }
        OperationResponse<com.tplink.smb.omada.common.gridquery.b> queryDataOpt = this.b.a(dataExportQueryDTO);
        if (!queryDataOpt.success()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d, null);
        }
        StringBuilder filePrefix = new StringBuilder().append("SiteAuditLog_").append(dataExportQueryDTO.getFileDataPartFormat());
        OperationResponse response = OperationResponse.SUCCESS;
        for (Map.Entry<String, SiteDTO> entry : idSiteDTOMap.entrySet()) {
            SiteDTO siteDTO = entry.getValue();
            String siteId = entry.getKey();
            DstInfoDTO dstInfoDTO = siteDstMap.get(siteId);
            response = this.a(omadacId, siteId, (com.tplink.smb.omada.common.gridquery.b)queryDataOpt.getResult(), siteDTO, dstInfoDTO, filePrefix.toString(), dataExportQueryDTO.getTmpFilePath(), dataExportQueryDTO.getBatchLimit(), com.tplink.smb.omada.maintenance.common.b.h);
            if (response.success()) continue;
            a.warn("Export site audit log .csv files failed. omadacId:{}, siteId:{}", (Object)omadacId, (Object)siteId);
        }
        return response;
    }

    @Override
    public com.tplink.smb.omada.maintenance.common.c a() {
        return com.tplink.smb.omada.maintenance.common.c.g;
    }

    private OperationResponse a(c omadacId, com.tplink.smb.omada.common.gridquery.b queryData, DstInfoDTO dstInfoDTO, String filePrefix, String tmpFilePath, Integer batchLimit, Integer format) {
        String fileName;
        OperationResponse exportResponse;
        AtomicInteger batchPerCount = new AtomicInteger(batchLimit);
        AtomicInteger suffixCount = new AtomicInteger(com.tplink.smb.omada.maintenance.common.b.b);
        ArrayList<AbstractAuditLogPO> globalAuditLogs = new ArrayList<AbstractAuditLogPO>();
        AtomicReference<OperationResponse> response = new AtomicReference<OperationResponse>(OperationResponse.SUCCESS);
        this.c.a(omadacId, null, queryData, auditLog -> {
            globalAuditLogs.add((AbstractAuditLogPO)auditLog);
            batchPerCount.getAndSet(batchPerCount.get() - 1);
            if (batchPerCount.get() <= 0) {
                String fileName = filePrefix + "_Global_" + suffixCount.get();
                OperationResponse exportResponse = this.a(null, omadacId, null, fileName, tmpFilePath, globalAuditLogs, dstInfoDTO, null, format);
                if (!exportResponse.success()) {
                    response.set(exportResponse);
                    return;
                }
                globalAuditLogs.clear();
                batchPerCount.getAndSet(batchLimit);
                suffixCount.getAndSet(suffixCount.get() + 1);
            }
        });
        if (!response.get().success()) {
            return response.get();
        }
        if (!CollectionUtils.isEmpty(globalAuditLogs) && !(exportResponse = this.a(null, omadacId, null, fileName = filePrefix + "_Global_" + suffixCount.get(), tmpFilePath, globalAuditLogs, dstInfoDTO, null, format)).success()) {
            return exportResponse;
        }
        globalAuditLogs.clear();
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a);
    }

    public OperationResponse a(c omadacId, String siteId, com.tplink.smb.omada.common.gridquery.b queryData, SiteDTO siteDTO, DstInfoDTO dstInfoDTO, String filePrefix, String tmpFilePath, Integer batchLimit, Integer format) {
        String fileName;
        OperationResponse exportResponse;
        AtomicInteger batchPerCount = new AtomicInteger(batchLimit);
        AtomicInteger suffixCount = new AtomicInteger(com.tplink.smb.omada.maintenance.common.b.b);
        ArrayList<AbstractAuditLogPO> auditLogs = new ArrayList<AbstractAuditLogPO>();
        AtomicReference<OperationResponse> response = new AtomicReference<OperationResponse>(OperationResponse.SUCCESS);
        this.c.a(omadacId, siteId, queryData, auditLog -> {
            auditLogs.add((AbstractAuditLogPO)auditLog);
            batchPerCount.getAndSet(batchPerCount.get() - 1);
            if (batchPerCount.get() <= 0) {
                String fileName = filePrefix + "_" + siteDTO.getSiteName() + "_" + suffixCount.get();
                OperationResponse exportResponse = this.a(null, omadacId, siteId, fileName, tmpFilePath, auditLogs, dstInfoDTO, siteDTO, format);
                if (!exportResponse.success()) {
                    response.set(exportResponse);
                    return;
                }
                auditLogs.clear();
                batchPerCount.getAndSet(batchLimit);
                suffixCount.getAndSet(suffixCount.get() + 1);
            }
        });
        if (!response.get().success()) {
            return response.get();
        }
        if (!CollectionUtils.isEmpty(auditLogs) && !(exportResponse = this.a(null, omadacId, siteId, fileName = filePrefix + "_" + siteDTO.getSiteName() + "_" + suffixCount.get(), tmpFilePath, auditLogs, dstInfoDTO, siteDTO, format)).success()) {
            return exportResponse;
        }
        auditLogs.clear();
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a);
    }

    private OperationResponse a(@Nullable b mspId, c omadacId, @Nullable String siteId, String fileName, String fileDir, List<AbstractAuditLogPO> auditLogs, DstInfoDTO dstInfoDTO, @Nullable SiteDTO siteDTO, @Nonnull Integer format) {
        OperationResponse operationResponse;
        String fullPath = fileDir + File.separator + fileName;
        if (com.tplink.smb.omada.maintenance.common.b.h.equals(format)) {
            fullPath = fullPath + ".csv";
        } else if (com.tplink.smb.omada.maintenance.common.b.i.equals(format)) {
            fullPath = fullPath + ".xlsx";
        } else {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        FileOutputStream outputStream = new FileOutputStream(fullPath);
        try {
            List<Map<String, Object>> listMap = this.a(mspId, omadacId, siteId, auditLogs, dstInfoDTO, siteDTO);
            ArrayList keys = new ArrayList(com.tplink.smb.omada.maintenance.common.b.ag.keySet());
            ArrayList columnNames = new ArrayList(com.tplink.smb.omada.maintenance.common.b.ag.values());
            if (Objects.isNull(siteDTO)) {
                keys = new ArrayList(com.tplink.smb.omada.maintenance.common.b.ah.keySet());
                columnNames = new ArrayList(com.tplink.smb.omada.maintenance.common.b.ah.values());
            }
            if (com.tplink.smb.omada.maintenance.common.b.h.equals(format)) {
                String content = j.a(listMap, (String[])keys.toArray(new String[0]), (String[])columnNames.toArray(new String[0]));
                ((OutputStream)outputStream).write(content.getBytes(StandardCharsets.UTF_8));
                outputStream.flush();
            } else if (com.tplink.smb.omada.maintenance.common.b.i.equals(format)) {
                try (Workbook workbook = p.a(listMap, (String[])keys.toArray(new String[0]), (String[])columnNames.toArray(new String[0]));){
                    workbook.write((OutputStream)outputStream);
                    outputStream.flush();
                    if (workbook instanceof SXSSFWorkbook) {
                        ((SXSSFWorkbook)workbook).dispose();
                    }
                }
            }
            operationResponse = OperationResponse.SUCCESS;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioException) {
                if (T.a((String)siteId)) {
                    a.warn("export global audit logs .csv file failed. omadacId:{}", (Object)omadacId);
                } else {
                    a.warn("export site audit logs .csv file failed. omadacId:{}, siteId:{}", (Object)omadacId, (Object)siteId);
                }
                return OperationResponse.PARAM_ERROR;
            }
        }
        ((OutputStream)outputStream).close();
        return operationResponse;
    }

    private List<Map<String, Object>> a(b mspId, c omadacId, String siteId, List<AbstractAuditLogPO> auditLogs, DstInfoDTO dstInfoDTO, SiteDTO siteDTO) {
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        String logLevelName = "";
        String timeZone = "utc";
        if (Objects.nonNull(siteDTO)) {
            logLevelName = siteDTO.getSiteName();
            timeZone = siteDTO.getTimezone();
        } else {
            OperationResponse omadacOpt = this.e.a(omadacId.a());
            if (omadacOpt.success()) {
                logLevelName = ((GeneralSettingDTO)omadacOpt.getResult()).getOmadacName();
                timeZone = ((GeneralSettingDTO)omadacOpt.getResult()).getTimeZone();
            }
        }
        for (AbstractAuditLogPO po : auditLogs) {
            LinkedHashMap<String, Object> mapValue = new LinkedHashMap<String, Object>();
            if (Objects.isNull(siteDTO)) {
                mapValue.put("controllerName", logLevelName);
            } else {
                mapValue.put("siteName", logLevelName);
            }
            for (com.tplink.smb.omada.backup.core.domain.a auditLogColumnEnum : com.tplink.smb.omada.backup.core.domain.a.values()) {
                if (Objects.equals((Object)com.tplink.smb.omada.backup.core.domain.a.a, (Object)auditLogColumnEnum)) {
                    Long time = po.getTime();
                    mapValue.put(auditLogColumnEnum.a(), this.b.a(timeZone, "yyyy-MM-dd hh:mm:ss a", time, dstInfoDTO));
                    continue;
                }
                mapValue.put(auditLogColumnEnum.a(), auditLogColumnEnum.a(po));
            }
            listMap.add(mapValue);
        }
        return listMap;
    }
}

