/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.b.b;

import com.tplink.smb.omada.backup.api.web.dto.FileServerConfigVO;
import com.tplink.smb.omada.backup.api.web.dto.FileServerRestoreVO;
import com.tplink.smb.omada.backup.api.web.dto.SelfRestoreFileVO;
import com.tplink.smb.omada.backup.core.backup.k;
import com.tplink.smb.omada.backup.core.backup.q;
import com.tplink.smb.omada.backup.core.cache.RestoreResult;
import com.tplink.smb.omada.backup.core.cache.e;
import com.tplink.smb.omada.backup.core.restore.m;
import com.tplink.smb.omada.backup.core.restore.w;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.common.util.SessionUtils;
import com.tplink.smb.omada.dispatcher.common.util.UserIpUtils;
import com.tplink.smb.omada.identityaccess.api.internal.dto.GetCurrentInfoDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.UserDTO;
import com.tplink.smb.omada.identityaccess.api.internal.g;
import com.tplink.smb.omada.identityaccess.port.mongo.omadac.OmadacPO;
import com.tplink.smb.omada.logmanager.api.internal.dto.audit.AuditLogKeyEnumDTO;
import com.tplink.smb.omada.maintenance.common.a.o;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.maintenance.domain.model.e.a;
import com.tplink.smb.omada.maintenance.domain.model.f.h;
import com.tplink.smb.omada.maintenance.port.mongo.f;
import java.io.InputStream;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class b {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(b.class);
    @Autowired
    private com.tplink.smb.omada.lock.a.b b;
    @Autowired
    private w c;
    @Autowired
    private com.tplink.smb.omada.backup.core.restore.b.a d;
    @Autowired
    private e e;
    @Autowired
    private g f;
    @Autowired
    private a g;
    @Autowired
    private com.tplink.smb.omada.maintenance.domain.model.h.d h;
    @Autowired
    private k i;
    @Autowired
    private com.tplink.smb.omada.maintenance.domain.model.a.a j;
    private final com.tplink.smb.omada.identityaccess.port.mongo.g k = com.tplink.smb.omada.identityaccess.port.mongo.g.a();
    @Autowired
    private m l;
    @Autowired
    private com.tplink.smb.omada.lock.a.c m;
    @Autowired
    private com.tplink.smb.omada.backup.core.backup.b n;
    @Autowired
    private com.tplink.smb.omada.backup.core.c.a o;
    @Autowired
    private q p;

    public OperationResponse a(String omadacId, h serverSetting, String filePath, boolean skipDevice, boolean skipConfirm, UserDTO currentUser, String ip) {
        try {
            OperationResponse response = this.a(omadacId);
            if (!response.success()) {
                this.d.b(omadacId, response.getErrorCode());
                return response;
            }
            a.info("omadacId={} restore beginning...", (Object)omadacId);
            boolean isExecuteSuccess = com.tplink.smb.omada.common.concurrent.thread.b.a(() -> {
                if (!this.o.c()) {
                    a.debug("omadacId={} file server restore reach limit", (Object)omadacId);
                    this.d.b(omadacId, com.tplink.smb.omada.common.g.b.bA.b());
                    return;
                }
                a.debug("omadacId={} is downloading file from the remote file server", (Object)omadacId);
                OperationResponse<InputStream> ops = this.i.a(serverSetting, omadacId, filePath);
                if (!ops.success()) {
                    a.warn("omadacId={} fail to download file from the remote file server", (Object)omadacId);
                    this.d.b(omadacId, ops.getErrorCode());
                    this.j.a(omadacId, null, AuditLogKeyEnumDTO.RESTORE.name(), currentUser, ip, Boolean.valueOf(false), new String[0]);
                } else {
                    this.g.a(omadacId, serverSetting, com.tplink.smb.omada.maintenance.common.a.o.a);
                    this.a(omadacId, (InputStream)ops.getResult(), currentUser, ip, skipConfirm, skipDevice);
                }
                this.o.e();
            });
            if (!isExecuteSuccess) {
                this.d.b(omadacId, com.tplink.smb.omada.common.g.b.eh.b());
                this.j.a(omadacId, null, AuditLogKeyEnumDTO.RESTORE.name(), currentUser, ip, Boolean.valueOf(false), new String[0]);
                return new OperationResponse(com.tplink.smb.omada.common.g.b.eh);
            }
        }
        catch (Exception e2) {
            a.warn("omadacId={} restore failed", (Object)omadacId, (Object)e2);
            this.d.b(omadacId, com.tplink.smb.omada.common.g.b.eh.b());
            this.o.e();
            this.j.a(omadacId, null, AuditLogKeyEnumDTO.RESTORE.name(), currentUser, ip, Boolean.valueOf(false), new String[0]);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.eh);
        }
        return OperationResponse.SUCCESS;
    }

    public OperationResponse a(String omadacId, String siteId, FileServerRestoreVO restoreVO, UserDTO currentUser, String ip, Consumer<OperationResponse> completeConsumer) {
        OperationResponse response = this.b(omadacId);
        if (!response.success()) {
            this.d.b(omadacId, response.getErrorCode());
            completeConsumer.accept(response);
            return response;
        }
        a.info("omadacId={} siteId={} restore beginning...", (Object)omadacId, (Object)siteId);
        boolean isExecuteSuccess = com.tplink.smb.omada.common.concurrent.thread.b.a(() -> {
            a.debug("omadacId={} site={} is downloading site file from the remote file server", (Object)omadacId, (Object)siteId);
            OperationResponse resultOps = new OperationResponse(com.tplink.smb.omada.common.g.b.eh);
            try {
                if (!this.o.c()) {
                    a.debug("omadacId={} file server site restore reach limit", (Object)omadacId);
                    resultOps = new OperationResponse(com.tplink.smb.omada.common.g.b.bA);
                    this.d.b(omadacId, resultOps.getErrorCode());
                    completeConsumer.accept(response);
                    return;
                }
                h serverSetting = this.a(omadacId, siteId, restoreVO);
                OperationResponse inOps = this.i.a(serverSetting, omadacId, restoreVO.getFilePath());
                if (inOps.success()) {
                    a.debug("success download file from remote file server");
                    this.h.a(omadacId, siteId, serverSetting, com.tplink.smb.omada.maintenance.common.a.o.a);
                    resultOps = this.a((InputStream)inOps.getResult(), new c(omadacId), new d(siteId), currentUser);
                } else {
                    resultOps = inOps;
                }
            }
            catch (Exception e2) {
                a.warn("omadacId={} siteId={} restore failed", new Object[]{omadacId, siteId, e2});
            }
            finally {
                if (!resultOps.success()) {
                    this.d.b(omadacId, resultOps.getErrorCode());
                } else {
                    this.d.b(omadacId);
                }
                this.o.e();
                this.j.a(omadacId, siteId, AuditLogKeyEnumDTO.RESTORE.name(), currentUser, ip, Boolean.valueOf(resultOps.success()), new String[0]);
            }
            completeConsumer.accept(resultOps);
        });
        if (!isExecuteSuccess) {
            this.d.b(omadacId, com.tplink.smb.omada.common.g.b.eh.b());
            this.o.e();
            this.j.a(omadacId, siteId, AuditLogKeyEnumDTO.RESTORE.name(), currentUser, ip, Boolean.valueOf(false), new String[0]);
            completeConsumer.accept(new OperationResponse(com.tplink.smb.omada.common.g.b.eh));
            return new OperationResponse(com.tplink.smb.omada.common.g.b.eh);
        }
        return OperationResponse.SUCCESS;
    }

    public OperationResponse a(String mspId, com.tplink.smb.omada.common.access.e controlType, FileServerRestoreVO restoreVO) {
        Optional omadacPOOptional = this.k.a((c)new com.tplink.smb.omada.maintenance.common.b.a.a.b(mspId));
        if (!omadacPOOptional.isPresent()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.aA);
        }
        Set customers = ((OmadacPO)omadacPOOptional.get()).getCustomers();
        OperationResponse currentInfo = this.f.a(new GetCurrentInfoDTO(SessionUtils.getSessionId(), controlType, mspId));
        if (!currentInfo.success()) {
            return new OperationResponse(currentInfo.getErrorCode(), currentInfo.getMsg(), null);
        }
        UserDTO currentUser = (UserDTO)currentInfo.getResult();
        Optional localUserIp = UserIpUtils.getLocalUserIp();
        try {
            OperationResponse response = this.a(mspId, customers, controlType);
            if (!response.success()) {
                this.d.a(mspId, (Set<String>)customers, response.getErrorCode());
                return response;
            }
            a.info("mspId={} restore beginning...", (Object)mspId);
            boolean isExecuteSuccess = com.tplink.smb.omada.common.concurrent.thread.b.a(() -> {
                a.debug("mspId={} is downloading file from the remote file server", (Object)mspId);
                h serverSetting = this.a(mspId, restoreVO);
                OperationResponse<InputStream> ops = this.i.a(serverSetting, mspId, restoreVO.getFilePath());
                if (!ops.success()) {
                    a.warn("mspId={} fail to download file from the remote file server", (Object)mspId);
                    this.d.a(mspId, (Set<String>)customers, ops.getErrorCode());
                    this.j.a(mspId, AuditLogKeyEnumDTO.MSP_RESTORE.name(), currentUser, (String)localUserIp.orElse(null), Boolean.valueOf(false), new String[0]);
                } else {
                    this.g.a(mspId, serverSetting, com.tplink.smb.omada.maintenance.common.a.o.a);
                    this.a(mspId, customers, (InputStream)ops.getResult(), currentUser, (String)localUserIp.orElse(null), (boolean)restoreVO.getSkipConfirm(), Boolean.TRUE.equals(restoreVO.getSkipDevice()));
                }
            });
            if (!isExecuteSuccess) {
                this.d.a(mspId, (Set<String>)customers, com.tplink.smb.omada.common.g.b.eh.b());
                this.j.a(mspId, AuditLogKeyEnumDTO.MSP_RESTORE.name(), currentUser, (String)localUserIp.orElse(null), Boolean.valueOf(false), new String[0]);
                return new OperationResponse(com.tplink.smb.omada.common.g.b.eh);
            }
        }
        catch (Exception e2) {
            a.warn("mspId={} restore failed", (Object)mspId, (Object)e2);
            this.d.a(mspId, (Set<String>)customers, com.tplink.smb.omada.common.g.b.eh.b());
            this.j.a(mspId, AuditLogKeyEnumDTO.MSP_RESTORE.name(), currentUser, (String)localUserIp.orElse(null), Boolean.valueOf(false), new String[0]);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.eh);
        }
        return OperationResponse.SUCCESS;
    }

    public OperationResponse a(String omadacId, String siteId, String fileId, String fileName, UserDTO currentUser, String ip, Consumer<OperationResponse> completeConsumer) {
        OperationResponse response = this.b(omadacId);
        if (!response.success()) {
            this.d.b(omadacId, response.getErrorCode());
            this.j.a(omadacId, siteId, AuditLogKeyEnumDTO.RESTORE.name(), currentUser, ip, Boolean.valueOf(false), new String[0]);
            completeConsumer.accept(response);
            return response;
        }
        a.info("omadacId={} site={} restoring beginning...", (Object)omadacId, (Object)siteId);
        long setRestoreStatusTimeNs = System.nanoTime();
        boolean success = this.l.a(omadacId, setRestoreStatusTimeNs, () -> {
            OperationResponse ops = new OperationResponse(com.tplink.smb.omada.common.g.b.eh);
            try {
                if (!this.o.c()) {
                    a.debug("omadacId={} cloud server site restore reach limit", (Object)omadacId);
                    this.d.b(omadacId, com.tplink.smb.omada.common.g.b.bA.b());
                    this.j.a(omadacId, siteId, AuditLogKeyEnumDTO.RESTORE.name(), currentUser, ip, Boolean.valueOf(false), new String[0]);
                    completeConsumer.accept(response);
                    return;
                }
                OperationResponse inOps = this.p.a(fileId, fileName);
                if (inOps.success()) {
                    InputStream inputStream = (InputStream)inOps.getResult();
                    ops = this.a(inputStream, new c(omadacId), new d(siteId), currentUser);
                } else {
                    this.d.b(omadacId, inOps.getErrorCode());
                    ops = inOps;
                    this.j.a(omadacId, siteId, AuditLogKeyEnumDTO.RESTORE.name(), currentUser, ip, Boolean.valueOf(false), new String[0]);
                }
            }
            catch (Exception e2) {
                a.error("omadacId={} siteId={} restore failed.", new Object[]{omadacId, siteId, e2});
            }
            finally {
                if (!ops.success()) {
                    this.d.b(omadacId, ops.getErrorCode());
                } else {
                    this.d.b(omadacId);
                }
                this.o.e();
                this.j.a(omadacId, siteId, AuditLogKeyEnumDTO.RESTORE.name(), currentUser, ip, Boolean.valueOf(ops.success()), new String[0]);
                completeConsumer.accept(ops);
            }
        });
        if (!success) {
            this.d.b(omadacId, com.tplink.smb.omada.common.g.b.eh.b());
            this.j.a(omadacId, siteId, AuditLogKeyEnumDTO.RESTORE.name(), currentUser, ip, Boolean.valueOf(false), new String[0]);
            completeConsumer.accept(new OperationResponse(com.tplink.smb.omada.common.g.b.eh));
        }
        return OperationResponse.SUCCESS;
    }

    public OperationResponse a(String omadacId, String fileId, String fileName, UserDTO currentUser, String ip, boolean autobackup) {
        a.info("omadacId={} restoring beginning...", (Object)omadacId);
        long setRestoreStatusTimeNs = System.nanoTime();
        boolean isExecuteSuccess = this.l.a(omadacId, setRestoreStatusTimeNs, () -> {
            OperationResponse ops = new OperationResponse(com.tplink.smb.omada.common.g.b.eh);
            if (!this.o.c()) {
                a.debug("omadacId={} cloud server restore reach limit", (Object)omadacId);
                this.d.b(omadacId, com.tplink.smb.omada.common.g.b.bA.b());
                return;
            }
            try {
                OperationResponse<InputStream> inOps = this.p.a(fileId, fileName);
                if (inOps.success()) {
                    ops = this.a(omadacId, (InputStream)inOps.getResult(), currentUser, autobackup);
                } else {
                    this.d.b(omadacId, inOps.getErrorCode());
                }
            }
            catch (Exception e2) {
                a.error("omadacId={} restore failed.", (Object)omadacId, (Object)e2);
            }
            finally {
                if (!ops.success()) {
                    this.d.b(omadacId, ops.getErrorCode());
                } else {
                    this.d.b(omadacId);
                }
                boolean restoreSuccess = ops.success();
                RestoreResult restoreResult = this.e.a(omadacId);
                if (restoreResult != null && restoreResult.getMigrationCheckResult() != null) {
                    restoreSuccess = false;
                }
                this.o.e();
                this.j.a(omadacId, null, AuditLogKeyEnumDTO.RESTORE.name(), currentUser, ip, Boolean.valueOf(restoreSuccess), new String[0]);
            }
        });
        if (!isExecuteSuccess) {
            this.d.b(omadacId, com.tplink.smb.omada.common.g.b.eh.b());
            this.j.a(omadacId, null, AuditLogKeyEnumDTO.RESTORE.name(), currentUser, ip, Boolean.valueOf(false), new String[0]);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.eh);
        }
        return OperationResponse.SUCCESS;
    }

    public OperationResponse a(String mspId, com.tplink.smb.omada.common.access.e controlType, SelfRestoreFileVO fileVO) {
        Optional omadacPOOptional = this.k.a((c)new com.tplink.smb.omada.maintenance.common.b.a.a.b(mspId));
        if (!omadacPOOptional.isPresent()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.aA);
        }
        Set customers = ((OmadacPO)omadacPOOptional.get()).getCustomers();
        OperationResponse currentInfo = this.f.a(new GetCurrentInfoDTO(SessionUtils.getSessionId(), controlType, mspId));
        if (!currentInfo.success()) {
            return new OperationResponse(currentInfo.getErrorCode(), currentInfo.getMsg(), null);
        }
        Optional localUserIp = UserIpUtils.getLocalUserIp();
        OperationResponse response = this.a(mspId, customers, controlType);
        if (!response.success()) {
            this.d.a(mspId, (Set<String>)customers, response.getErrorCode());
            return response;
        }
        a.info("mspId={} restoring beginning...", (Object)mspId);
        long setRestoreStatusTimeNs = System.nanoTime();
        boolean isExecuteSuccess = this.l.a(mspId, setRestoreStatusTimeNs, () -> {
            OperationResponse<InputStream> inOps = this.n.a(mspId, null, fileVO);
            if (inOps.success()) {
                this.a(mspId, customers, (InputStream)inOps.getResult(), (UserDTO)currentInfo.getResult(), (String)localUserIp.orElse(null), true, true);
            } else {
                this.d.a(mspId, (Set<String>)customers, com.tplink.smb.omada.common.g.b.eh.b());
            }
        });
        if (!isExecuteSuccess) {
            this.d.a(mspId, (Set<String>)customers, com.tplink.smb.omada.common.g.b.eh.b());
            this.j.a(mspId, AuditLogKeyEnumDTO.MSP_RESTORE.name(), (UserDTO)currentInfo.getResult(), (String)localUserIp.orElse(null), Boolean.valueOf(false), new String[0]);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.eh);
        }
        return OperationResponse.SUCCESS;
    }

    private OperationResponse a(String omadacId, InputStream inputStream, UserDTO currentUser, boolean autobackup) {
        return (OperationResponse)this.b.a(omadacId, () -> this.c.a(inputStream, new c(omadacId), currentUser, true, false, false, autobackup), () -> {
            a.warn("{} restore Operation failed because Omadac Busy.", (Object)omadacId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.bA);
        });
    }

    private OperationResponse a(InputStream in, c omadacId, d siteId, UserDTO currentUser) {
        return (OperationResponse)this.m.b(omadacId.a(), siteId.a(), () -> this.c.a(in, omadacId, siteId, currentUser, true), () -> {
            a.warn("omadacId={} site={} restore Operation failed because site Busy.", (Object)omadacId, (Object)siteId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.bA);
        });
    }

    private h a(String omadacId, FileServerRestoreVO restoreVO) {
        h serverSetting;
        if (restoreVO.getServerConfig() != null) {
            serverSetting = com.tplink.smb.omada.maintenance.port.mongo.f.a((FileServerConfigVO)restoreVO.getServerConfig());
        } else {
            com.tplink.smb.omada.maintenance.common.a.g protocolType = com.tplink.smb.omada.maintenance.common.a.g.a((String)restoreVO.getProtocol());
            Optional settingOptional = this.g.a(omadacId, com.tplink.smb.omada.maintenance.common.a.o.a);
            if (!settingOptional.isPresent()) {
                return null;
            }
            serverSetting = (h)((com.tplink.smb.omada.maintenance.domain.model.f.c)settingOptional.get()).c().get(protocolType);
        }
        return serverSetting;
    }

    private h a(String omadacId, String siteId, FileServerRestoreVO restoreVO) {
        h serverSetting;
        if (restoreVO.getServerConfig() != null) {
            serverSetting = com.tplink.smb.omada.maintenance.port.mongo.f.a((FileServerConfigVO)restoreVO.getServerConfig());
        } else {
            com.tplink.smb.omada.maintenance.common.a.g protocolType = com.tplink.smb.omada.maintenance.common.a.g.valueOf((String)restoreVO.getProtocol());
            Optional settingOptional = this.h.a(omadacId, siteId, com.tplink.smb.omada.maintenance.common.a.o.a);
            if (!settingOptional.isPresent()) {
                return null;
            }
            serverSetting = (h)((com.tplink.smb.omada.maintenance.domain.model.h.c)settingOptional.get()).d().get(protocolType);
        }
        return serverSetting;
    }

    private OperationResponse a(String omadacId) {
        return this.d.c(omadacId, com.tplink.smb.omada.backup.api.c.g.a);
    }

    private OperationResponse b(String omadacId) {
        if (this.d.a(omadacId, com.tplink.smb.omada.backup.api.c.g.b)) {
            return this.d.c(omadacId, com.tplink.smb.omada.backup.api.c.g.b);
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.eg);
    }

    private OperationResponse a(String mspId, Set<String> customers, com.tplink.smb.omada.common.access.e controlType) {
        if (!controlType.equals((Object)com.tplink.smb.omada.common.access.e.b) && !controlType.equals((Object)com.tplink.smb.omada.common.access.e.a)) {
            a.warn("omadacId={} not local request, forbid restore operation", (Object)mspId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.h);
        }
        return this.d.a(mspId, customers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(String omadacId, InputStream inputStream, UserDTO currentUser, String ip, boolean skipConfirm, boolean skipDevice) {
        OperationResponse response = new OperationResponse(com.tplink.smb.omada.common.g.b.eh);
        try {
            response = (OperationResponse)this.b.b(omadacId, () -> this.c.a(inputStream, new c(omadacId), currentUser, skipConfirm, skipDevice, false, false), () -> {
                a.warn("{} restore Operation failed because Omadac Busy.", (Object)omadacId);
                return new OperationResponse(com.tplink.smb.omada.common.g.b.bA);
            });
            if (!response.success()) {
                this.d.b(omadacId, response.getErrorCode());
                this.j.a(omadacId, null, AuditLogKeyEnumDTO.RESTORE.name(), currentUser, ip, Boolean.valueOf(false), new String[0]);
                return;
            }
            this.e.a(omadacId, (RestoreResult)response.getResult());
            this.d.e(omadacId);
        }
        catch (Exception e2) {
            a.warn("Restore from remote server error, file illegal or not exist", (Throwable)e2);
            this.d.b(omadacId, com.tplink.smb.omada.common.g.b.eh.b());
        }
        finally {
            if (!response.success()) {
                this.d.b(omadacId, response.getErrorCode());
                a.info("omadacId={} restore failed.", (Object)omadacId);
            } else {
                this.d.b(omadacId);
            }
            boolean restoreSuccess = response.success();
            RestoreResult restoreResult = this.e.a(omadacId);
            if (restoreResult != null && restoreResult.getMigrationCheckResult() != null) {
                restoreSuccess = false;
            }
            this.j.a(omadacId, null, AuditLogKeyEnumDTO.RESTORE.name(), currentUser, ip, Boolean.valueOf(restoreSuccess), new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(String mspId, Set<String> customers, InputStream inputStream, UserDTO currentUser, String ip, boolean skipConfirm, boolean skipDevice) {
        OperationResponse response = new OperationResponse(com.tplink.smb.omada.common.g.b.eh);
        try {
            response = (OperationResponse)this.b.b(mspId, () -> this.c.a(inputStream, new com.tplink.smb.omada.maintenance.common.b.a.a.b(mspId), currentUser, skipConfirm, skipDevice, false, false, customers), () -> {
                a.warn("{} restore Operation failed because MSP Busy.", (Object)mspId);
                return new OperationResponse(com.tplink.smb.omada.common.g.b.bA);
            });
            if (!response.success()) {
                this.d.a(mspId, customers, response.getErrorCode());
                this.j.a(mspId, AuditLogKeyEnumDTO.MSP_RESTORE.name(), currentUser, ip, Boolean.valueOf(false), new String[0]);
                return;
            }
            this.e.a(mspId, (RestoreResult)response.getResult());
            this.d.e(mspId);
        }
        catch (Exception e2) {
            a.warn("Restore from remote server error, file illegal or not exist", (Throwable)e2);
            this.d.a(mspId, customers, com.tplink.smb.omada.common.g.b.eh.b());
        }
        finally {
            if (!response.success()) {
                this.d.a(mspId, customers, response.getErrorCode());
                a.info("mspId={} restore failed.", (Object)mspId);
            } else {
                this.d.b(mspId, customers);
            }
            this.j.a(mspId, AuditLogKeyEnumDTO.MSP_RESTORE.name(), currentUser, ip, Boolean.valueOf(response.success()), new String[0]);
        }
    }
}

