/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.common.port.e;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import jakarta.annotation.Nonnull;
import java.util.HashSet;
import java.util.Set;

public class e {
    public static OperationResponse a(@Nonnull String vlans) {
        if (!vlans.matches("^[\\d|\\d-\\d]+(,[\\d|\\d-\\d]+)*$")) {
            return OperationResponse.PARAM_ERROR;
        }
        String[] splitStrings = vlans.split(",");
        if (splitStrings.length == 0) {
            return OperationResponse.PARAM_ERROR;
        }
        HashSet<Integer> vlanSet = new HashSet<Integer>(8);
        for (String splitString : splitStrings) {
            OperationResponse response = e.a(splitString, vlanSet);
            if (response.success()) continue;
            return response;
        }
        return OperationResponse.success(vlanSet);
    }

    private static OperationResponse a(String vlanString, Set<Integer> results) {
        if (vlanString.matches("[\\d]+")) {
            int vlanNum = Integer.parseInt(vlanString);
            if (vlanNum < 1 || vlanNum > 4094) {
                return new OperationResponse(b.d, "vlan should be between 1 and 4094", null);
            }
            results.add(vlanNum);
        } else if (vlanString.matches("^\\d+-\\d+$")) {
            String[] strings = vlanString.split("-");
            if (strings.length != 2) {
                return new OperationResponse(b.d, "vlan should be like begin-end instead of " + vlanString, null);
            }
            int begin = Integer.parseInt(strings[0]);
            if (begin < 1 || begin > 4094) {
                return new OperationResponse(b.d, "begin vlan should be between 1 and 4094 ", null);
            }
            int end = Integer.parseInt(strings[1]);
            if (end < 1 || end > 4094) {
                return new OperationResponse(b.d, "end vlan should be between 1 and 4094 ", null);
            }
            int beginIndex = Math.min(begin, end);
            int endIndex = Math.max(end, begin);
            for (int i2 = beginIndex; i2 <= endIndex; ++i2) {
                results.add(i2);
            }
        } else {
            return new OperationResponse(b.d, "vlan string should be like 1 or 1-100, vlan should be between 1 and 4094", null);
        }
        return OperationResponse.SUCCESS;
    }
}

