/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.common.port.cache.omadac.site;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.annotations.VisibleForTesting;
import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.omada.client.common.domain.model.shared.r;
import com.tplink.smb.omada.client.common.domain.model.shared.z;
import com.tplink.smb.omada.client.common.port.cache.omadac.site.ActiveSiteCacheProperties;
import com.tplink.smb.omada.common.util.K;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@com.tplink.smb.omada.common.spring.b
public class ActiveSiteCacheImpl
implements com.tplink.smb.omada.client.common.domain.model.b.a.a {
    private static final Logger c = LoggerFactory.getLogger(ActiveSiteCacheImpl.class);
    private static final String d = "active.sites.daily";
    private static final String e = "active.sites.weekly";
    protected final ActiveSiteCacheProperties a;
    protected final CacheService b;
    private final Set<OmadacIdSiteIdPO> f = ConcurrentHashMap.newKeySet(1024);
    private ScheduledFuture<?> g = null;

    @Autowired
    public ActiveSiteCacheImpl(ActiveSiteCacheProperties activeSiteCacheProperties, CacheService cacheService) {
        this.a = activeSiteCacheProperties;
        this.b = cacheService;
    }

    protected static String a(@Nonnull String siteId, int totalPartitions, a timestamp) {
        int partition = siteId.hashCode() & totalPartitions - 1;
        return ActiveSiteCacheImpl.a(partition, timestamp);
    }

    protected static String a(@Nonnull String siteId, int totalPartitions, b timestamp) {
        int partition = siteId.hashCode() & totalPartitions - 1;
        return ActiveSiteCacheImpl.a(partition, timestamp);
    }

    protected static String a(int partitionIdx, a timestamp) {
        return new StringJoiner(":").add("partition").add(String.valueOf(partitionIdx)).add("date").add(K.b((long)timestamp.a())).toString();
    }

    protected static String a(int partitionIdx, b timestamp) {
        return new StringJoiner(":").add("partition").add(String.valueOf(partitionIdx)).add("week").add(K.a((long)timestamp.a())).toString();
    }

    @PostConstruct
    public void a() {
        if (this.a.getFlushInterval().equals(Duration.ZERO)) {
            c.info("ActiveSitesCache period flush buf is disabled.");
            return;
        }
        long millis = this.a.getFlushInterval().toMillis();
        c.info("Scheduled ActiveSitesCache period flush buf task at fixed rate of {} millis.", (Object)millis);
        this.g = com.tplink.smb.omada.common.concurrent.thread.b.b(() -> {
            c.trace("Starting to flush buffed active ids {}", this.f);
            try {
                this.c();
            }
            catch (Exception e2) {
                c.warn("Failed to execute ActiveSiteCache.flushBuf()", (Throwable)e2);
            }
        }, (long)millis, (long)millis, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public void b() {
        if (this.g == null || this.g.isCancelled()) {
            return;
        }
        try {
            this.g.cancel(true);
            this.g = null;
            c.info("Before shutdown flush schedule job, flush active sites into cache now.");
            this.c();
        }
        catch (Exception ex) {
            c.warn("Shutdown flush schedule job failed", (Throwable)ex);
        }
    }

    @Override
    public void a(r omadacId, z siteId) {
        OmadacIdSiteIdPO po = new OmadacIdSiteIdPO(omadacId, siteId);
        if (this.a.getFlushInterval().equals(Duration.ZERO)) {
            c.trace("Saving OmadacId: {}, SiteId: {} into ActiveSitesCache buf directly", (Object)omadacId, (Object)siteId);
            int partitions = this.a.getPartitionSize();
            Set<OmadacIdSiteIdPO> set = Collections.singleton(po);
            String dailyCacheKey = ActiveSiteCacheImpl.a(siteId.a(), partitions, new a());
            this.a(dailyCacheKey, set);
            String weeklyCacheKey = ActiveSiteCacheImpl.a(siteId.a(), partitions, new b());
            this.b(weeklyCacheKey, set);
        } else {
            c.trace("Putting OmadacId: {}, SiteId: {} into ActiveSitesCache buf", (Object)omadacId, (Object)siteId);
            this.f.add(po);
        }
    }

    @Override
    public void a(Map<r, Set<z>> omadaSiteMap) {
        if (CollectionUtils.isEmpty(omadaSiteMap)) {
            return;
        }
        if (this.a.getFlushInterval().equals(Duration.ZERO)) {
            c.trace("Saving omadaSiteMap: {} into ActiveSitesCache directly", omadaSiteMap);
            HashSet<OmadacIdSiteIdPO> set = new HashSet<OmadacIdSiteIdPO>();
            omadaSiteMap.forEach((omadacId, siteIdSet) -> siteIdSet.forEach(siteId -> set.add(new OmadacIdSiteIdPO((r)omadacId, (z)siteId))));
            this.a(set, false);
        } else {
            c.trace("Putting map: {} into ActiveSitesCache buf", omadaSiteMap);
            omadaSiteMap.forEach((omadacId, siteIds) -> siteIds.forEach(siteId -> this.f.add(new OmadacIdSiteIdPO((r)omadacId, (z)siteId))));
        }
    }

    @Override
    public Map<String, Set<String>> a(int partition) {
        c.trace("Getting ActiveSites of Today by partition: {}", (Object)partition);
        long currentSec = System.currentTimeMillis() / 1000L;
        long yesterdayEndSec = ActiveSiteCacheImpl.e();
        HashSet yesterdaySet = new HashSet();
        long delta = currentSec - yesterdayEndSec;
        if (delta > 0L && delta < this.a.getDailyWarmingUpWindow().getSeconds()) {
            c.trace("Getting ActiveSites of Today by partition: {}. Currently within warming up window: {} seconds, need fetch both yesterday and today", (Object)partition, (Object)this.a.getDailyWarmingUpWindow().getSeconds());
            yesterdaySet = new HashSet(this.b.getSet(d, ActiveSiteCacheImpl.a(partition, new a(yesterdayEndSec * 1000L)), OmadacIdSiteIdPO.class));
            c.trace("Fetched Yesterday's set by partition: {}, result: {}", (Object)partition, yesterdaySet);
        }
        HashSet todaySet = new HashSet(this.b.getSet(d, ActiveSiteCacheImpl.a(partition, new a()), OmadacIdSiteIdPO.class));
        c.trace("Fetched Today's set by partition: {}, result: {}", (Object)partition, todaySet);
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        todaySet.forEach(po -> result.computeIfAbsent(po.getOmadacId(), k2 -> new HashSet()).add(po.getSiteId()));
        yesterdaySet.forEach(po -> result.computeIfAbsent(po.getOmadacId(), k2 -> new HashSet()).add(po.getSiteId()));
        c.trace("Fetched active sites of day by partition: {}, result: {}", (Object)partition, result);
        return result;
    }

    @Override
    public Map<String, Set<String>> b(int partition) {
        HashSet lastWeekSet = new HashSet(this.b.getSet(e, ActiveSiteCacheImpl.a(partition, new b(ActiveSiteCacheImpl.f() * 1000L)), OmadacIdSiteIdPO.class));
        c.trace("Fetched Last Week's set by partition: {}, result: {}", (Object)partition, lastWeekSet);
        HashSet thisWeekSet = new HashSet(this.b.getSet(e, ActiveSiteCacheImpl.a(partition, new b()), OmadacIdSiteIdPO.class));
        c.trace("Fetched This Week's set by partition: {}, result: {}", (Object)partition, thisWeekSet);
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        thisWeekSet.forEach(po -> result.computeIfAbsent(po.getOmadacId(), k2 -> new HashSet()).add(po.getSiteId()));
        lastWeekSet.forEach(po -> result.computeIfAbsent(po.getOmadacId(), k2 -> new HashSet()).add(po.getSiteId()));
        c.trace("Fetched active sites of week by partition: {}, result: {}", (Object)partition, result);
        return result;
    }

    @VisibleForTesting
    void c() {
        this.a(this.f, true);
    }

    @VisibleForTesting
    int d() {
        return this.f.size();
    }

    private void a(Set<OmadacIdSiteIdPO> paramSet, boolean removeWhenIteration) {
        int partitions = this.a.getPartitionSize();
        HashSet<OmadacIdSiteIdPO> readonlySet = new HashSet<OmadacIdSiteIdPO>(paramSet);
        HashMap<String, Set> dailyTargetMap = new HashMap<String, Set>();
        HashMap<String, Set> weeklyTargetMap = new HashMap<String, Set>();
        for (OmadacIdSiteIdPO entry : readonlySet) {
            String omadacId = entry.omadacId;
            String siteId = entry.siteId;
            String dailyCacheKey = ActiveSiteCacheImpl.a(siteId, partitions, new a());
            String weeklyCacheKey = ActiveSiteCacheImpl.a(siteId, partitions, new b());
            dailyTargetMap.computeIfAbsent(dailyCacheKey, k2 -> new HashSet()).add(new OmadacIdSiteIdPO(omadacId, siteId));
            weeklyTargetMap.computeIfAbsent(weeklyCacheKey, k2 -> new HashSet()).add(new OmadacIdSiteIdPO(omadacId, siteId));
            if (removeWhenIteration) {
                paramSet.remove(entry);
            }
            c.trace("Removed <OmadacId:{}, SiteId:{}> from buf, need write to cache", (Object)omadacId, (Object)siteId);
        }
        dailyTargetMap.forEach(this::a);
        weeklyTargetMap.forEach(this::b);
    }

    private void a(String dailyCacheKey, Set<OmadacIdSiteIdPO> set) {
        try {
            this.b.getSet(d, dailyCacheKey, OmadacIdSiteIdPO.class).addAll(set);
            if (c.isTraceEnabled()) {
                c.trace("Successfully updated cache {}:{} with values {}", new Object[]{d, dailyCacheKey, set});
            }
            this.b.expireKey(d, dailyCacheKey, this.a.getDailyKeepAlive().getSeconds(), TimeUnit.SECONDS);
            if (c.isTraceEnabled()) {
                c.trace("Successfully set expiration of {}:{} with {} seconds", new Object[]{d, dailyCacheKey, this.a.getDailyKeepAlive().getSeconds()});
            }
        }
        catch (Exception e2) {
            c.warn("Failed to flush {}, {} to {}", new Object[]{dailyCacheKey, set, d, e2});
        }
    }

    private void b(String cacheKey, Set<OmadacIdSiteIdPO> set) {
        try {
            this.b.getSet(e, cacheKey, OmadacIdSiteIdPO.class).addAll(set);
            if (c.isTraceEnabled()) {
                c.trace("Successfully updated cache {}:{} with values {}", new Object[]{e, cacheKey, set});
            }
            this.b.expireKey(e, cacheKey, this.a.getWeeklyKeepAlive().getSeconds(), TimeUnit.SECONDS);
            if (c.isTraceEnabled()) {
                c.trace("Successfully set expiration of {}:{} with {} seconds", new Object[]{e, cacheKey, this.a.getDailyKeepAlive().getSeconds()});
            }
        }
        catch (Exception e2) {
            c.warn("Failed to flush {}, {} to {}", new Object[]{cacheKey, set, e, e2});
        }
    }

    private static long e() {
        return LocalDate.now(ZoneOffset.UTC).atStartOfDay().toEpochSecond(ZoneOffset.UTC) - 1L;
    }

    private static long f() {
        return LocalDate.now(ZoneOffset.UTC).atStartOfDay().with(ChronoField.DAY_OF_WEEK, DayOfWeek.MONDAY.getValue()).toEpochSecond(ZoneOffset.UTC) - 1L;
    }

    protected static class a {
        public static final int a = 999999999;
        private final long b;

        public a() {
            this.b = LocalDateTime.ofInstant(Instant.now(), ZoneOffset.UTC).withHour(23).withMinute(59).withSecond(59).withNano(999999999).toEpochSecond(ZoneOffset.UTC);
        }

        public a(long anyMillis) {
            this.b = LocalDateTime.ofEpochSecond(TimeUnit.MILLISECONDS.toSeconds(anyMillis), 999999999, ZoneOffset.UTC).withHour(23).withMinute(59).withSecond(59).toEpochSecond(ZoneOffset.UTC);
        }

        public long a() {
            return this.b;
        }
    }

    protected static class b {
        public static final int a = 999999999;
        private final long b;

        public b() {
            this.b = LocalDateTime.ofInstant(Instant.now(), ZoneOffset.UTC).with(ChronoField.DAY_OF_WEEK, DayOfWeek.SUNDAY.getValue()).withHour(23).withMinute(59).withSecond(59).withNano(999999999).toEpochSecond(ZoneOffset.UTC);
        }

        public b(long anyMillis) {
            this.b = LocalDateTime.ofEpochSecond(TimeUnit.MILLISECONDS.toSeconds(anyMillis), 999999999, ZoneOffset.UTC).with(ChronoField.DAY_OF_WEEK, DayOfWeek.SUNDAY.getValue()).withHour(23).withMinute(59).withSecond(59).toEpochSecond(ZoneOffset.UTC);
        }

        public long a() {
            return this.b;
        }
    }

    @JsonPropertyOrder(value={"omadacId", "siteId"})
    private static class OmadacIdSiteIdPO {
        @JsonProperty(value="omadacId")
        private String omadacId;
        @JsonProperty(value="siteId")
        private String siteId;

        public OmadacIdSiteIdPO(r omadacId, z siteId) {
            this.omadacId = omadacId.a();
            this.siteId = siteId.a();
        }

        @Generated
        public String getOmadacId() {
            return this.omadacId;
        }

        @Generated
        public String getSiteId() {
            return this.siteId;
        }

        @JsonProperty(value="omadacId")
        @Generated
        public void setOmadacId(String omadacId) {
            this.omadacId = omadacId;
        }

        @JsonProperty(value="siteId")
        @Generated
        public void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        @Generated
        public String toString() {
            return "ActiveSiteCacheImpl.OmadacIdSiteIdPO(omadacId=" + this.getOmadacId() + ", siteId=" + this.getSiteId() + ")";
        }

        @Generated
        public OmadacIdSiteIdPO() {
        }

        @Generated
        public OmadacIdSiteIdPO(String omadacId, String siteId) {
            this.omadacId = omadacId;
            this.siteId = siteId;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof OmadacIdSiteIdPO)) {
                return false;
            }
            OmadacIdSiteIdPO other = (OmadacIdSiteIdPO)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$omadacId = this.getOmadacId();
            String other$omadacId = other.getOmadacId();
            if (this$omadacId == null ? other$omadacId != null : !this$omadacId.equals(other$omadacId)) {
                return false;
            }
            String this$siteId = this.getSiteId();
            String other$siteId = other.getSiteId();
            return !(this$siteId == null ? other$siteId != null : !this$siteId.equals(other$siteId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OmadacIdSiteIdPO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $omadacId = this.getOmadacId();
            result = result * 59 + ($omadacId == null ? 43 : $omadacId.hashCode());
            String $siteId = this.getSiteId();
            result = result * 59 + ($siteId == null ? 43 : $siteId.hashCode());
            return result;
        }
    }
}

