/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.common.domain.model.shared;

import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.omadac.OmadacType;
import jakarta.annotation.Nonnull;
import java.util.Map;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.CollectionUtils;

@ConfigurationProperties(prefix="omada")
@KeepClass
public class ExecutorCustomProperties {
    private static final String GLOBAL = "GLOBAL";
    private Map<String, ExecutorProperty> executors;

    @Nonnull
    public ExecutorProperty get(String key) {
        if (CollectionUtils.isEmpty(this.executors)) {
            return new ExecutorProperty();
        }
        if (key == null) {
            return this.executors.getOrDefault(GLOBAL, new ExecutorProperty());
        }
        ExecutorProperty property = this.executors.get(key);
        if (property == null) {
            return this.executors.getOrDefault(GLOBAL, new ExecutorProperty());
        }
        return property;
    }

    @Generated
    public Map<String, ExecutorProperty> getExecutors() {
        return this.executors;
    }

    @Generated
    public void setExecutors(Map<String, ExecutorProperty> executors) {
        this.executors = executors;
    }

    @Generated
    public String toString() {
        return "ExecutorCustomProperties(executors=" + this.getExecutors() + ")";
    }

    @KeepClass
    public static class ExecutorProperty {
        private int coreSize;
        private int maxSize;
        private long keepAliveMillis;
        private int queueSize;

        public ExecutorProperty() {
            this.maxSize = this.coreSize = OmadacType.s() ? 4 : Runtime.getRuntime().availableProcessors();
            this.keepAliveMillis = 30000L;
            this.queueSize = 10000;
        }

        public synchronized void setCoreSize(int coreSize) {
            if (coreSize > this.maxSize) {
                this.maxSize = coreSize;
            }
            this.coreSize = coreSize;
        }

        public synchronized void setMaxSize(int maxSize) {
            this.maxSize = maxSize;
        }

        @Generated
        public int getCoreSize() {
            return this.coreSize;
        }

        @Generated
        public int getMaxSize() {
            return this.maxSize;
        }

        @Generated
        public long getKeepAliveMillis() {
            return this.keepAliveMillis;
        }

        @Generated
        public int getQueueSize() {
            return this.queueSize;
        }

        @Generated
        public ExecutorProperty setKeepAliveMillis(long keepAliveMillis) {
            this.keepAliveMillis = keepAliveMillis;
            return this;
        }

        @Generated
        public ExecutorProperty setQueueSize(int queueSize) {
            this.queueSize = queueSize;
            return this;
        }

        @Generated
        public String toString() {
            return "ExecutorCustomProperties.ExecutorProperty(coreSize=" + this.getCoreSize() + ", maxSize=" + this.getMaxSize() + ", keepAliveMillis=" + this.getKeepAliveMillis() + ", queueSize=" + this.getQueueSize() + ")";
        }
    }
}

