/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.common.domain.model.shared;

import java.time.Duration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="client.timeout")
public class ClientTimeoutProperties {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientTimeoutProperties.class);
    private boolean clientTimeoutPatchEnable = true;
    private boolean clientTimeoutPatchMonitorEnable = false;
    private int flushMaxSize = 10000;
    private long flushMemToRedisZsetMs = 70000L;
    private Duration timeoutPreserveDuration = Duration.ofDays(1L);
    private Duration notifiedPreserveDuration = Duration.ofMinutes(10L);

    public void updateClientTimeoutPatchEnable(boolean enable) {
        this.clientTimeoutPatchEnable = enable;
        log.info("client timeout patch update set :{}", (Object)enable);
    }

    public void updateClientTimeoutPatchMonitorEnable(boolean enable) {
        this.clientTimeoutPatchMonitorEnable = enable;
        log.info("client timeout patch update monitor set :{}", (Object)enable);
    }

    @Generated
    public boolean isClientTimeoutPatchEnable() {
        return this.clientTimeoutPatchEnable;
    }

    @Generated
    public boolean isClientTimeoutPatchMonitorEnable() {
        return this.clientTimeoutPatchMonitorEnable;
    }

    @Generated
    public int getFlushMaxSize() {
        return this.flushMaxSize;
    }

    @Generated
    public long getFlushMemToRedisZsetMs() {
        return this.flushMemToRedisZsetMs;
    }

    @Generated
    public Duration getTimeoutPreserveDuration() {
        return this.timeoutPreserveDuration;
    }

    @Generated
    public Duration getNotifiedPreserveDuration() {
        return this.notifiedPreserveDuration;
    }

    @Generated
    public void setClientTimeoutPatchEnable(boolean clientTimeoutPatchEnable) {
        this.clientTimeoutPatchEnable = clientTimeoutPatchEnable;
    }

    @Generated
    public void setClientTimeoutPatchMonitorEnable(boolean clientTimeoutPatchMonitorEnable) {
        this.clientTimeoutPatchMonitorEnable = clientTimeoutPatchMonitorEnable;
    }

    @Generated
    public void setFlushMaxSize(int flushMaxSize) {
        this.flushMaxSize = flushMaxSize;
    }

    @Generated
    public void setFlushMemToRedisZsetMs(long flushMemToRedisZsetMs) {
        this.flushMemToRedisZsetMs = flushMemToRedisZsetMs;
    }

    @Generated
    public void setTimeoutPreserveDuration(Duration timeoutPreserveDuration) {
        this.timeoutPreserveDuration = timeoutPreserveDuration;
    }

    @Generated
    public void setNotifiedPreserveDuration(Duration notifiedPreserveDuration) {
        this.notifiedPreserveDuration = notifiedPreserveDuration;
    }
}

