/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.common.domain.model.shared;

import java.util.Arrays;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="client-inform.debug")
public class ClientInformDebugProperties {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientInformDebugProperties.class);
    private int informHandleTimeMsMax = 10000000;
    private int informHandleTimeMsMin = 1000000;

    public boolean inTimeRange(long deltaNano) {
        return (double)deltaNano >= (double)this.informHandleTimeMsMin * 1.0E7 && (double)deltaNano <= (double)this.informHandleTimeMsMax * 1.0E7;
    }

    public void updateInformDebugThreshold(int min, int max) {
        this.informHandleTimeMsMin = min > 0 ? min : this.informHandleTimeMsMin;
        this.informHandleTimeMsMax = max > 0 ? max : this.informHandleTimeMsMax;
        log.info("current inform debug threshold, {} ms to {} ms", (Object)this.informHandleTimeMsMin, (Object)this.informHandleTimeMsMax);
    }

    public void clientInformHandleInTimeRangeLogging(long startNanoTime, String handleProcessName, String ... message) {
        if (startNanoTime == 0L) {
            return;
        }
        long endNanoTime = System.nanoTime();
        long deltaNano = endNanoTime - startNanoTime;
        if (log.isDebugEnabled() && this.inTimeRange(deltaNano)) {
            log.debug(handleProcessName + "cost time: {} ns, message: {}", (Object)deltaNano, (Object)Arrays.toString(message));
        }
    }
}

