/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.system.domain.model;

import com.tplink.nbu.common.pii.utils.PIIMaskUtil;
import com.tplink.smb.eventcenter.api.event.DomainEventSubscriber;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.f.c;
import com.tplink.smb.omada.common.spring.b;
import com.tplink.smb.omada.device.manage.message.adopt.eap.EapControllerSetting;
import com.tplink.smb.omada.device.manage.message.adopt.osg.OsgControllerSetting;
import com.tplink.smb.omada.device.manage.message.config.ap.ApSetKeyEnum;
import com.tplink.smb.omada.device.manage.message.config.osg.OsgSetKeyEnum;
import com.tplink.smb.omada.identityaccess.api.internal.dto.OmadaRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.OmadacDTO;
import com.tplink.smb.omada.identityaccess.api.internal.l;
import com.tplink.smb.omada.manager.c.x;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.QuerySiteListDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.SiteDTO;
import com.tplink.smb.omada.manager.device.api.internal.c.c.a;
import com.tplink.smb.omada.manager.device.api.internal.c.c.a.e;
import com.tplink.smb.omada.system.domain.model.ControllerHostNameModified;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@b
@Component
public class i
implements DomainEventSubscriber<ControllerHostNameModified> {
    @Generated
    private static final Logger b = LoggerFactory.getLogger(i.class);
    public static final int a = x.a.a();
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.site.a c;
    @Autowired
    private a d;
    @Autowired
    private l e;

    @Nonnull
    private static e a(String omadacId, String siteId, String hostName, int portalHttpPort, int portalHttpsPort, Boolean preferHttpsPortal) {
        e sendSetMsgToSiteDeviceRequest = new e();
        sendSetMsgToSiteDeviceRequest.a(omadacId);
        sendSetMsgToSiteDeviceRequest.b(siteId);
        sendSetMsgToSiteDeviceRequest.c(DeviceTypeEnum.a.b());
        EapControllerSetting eapControllerSetting = new EapControllerSetting();
        eapControllerSetting.setControllerDomain(hostName);
        eapControllerSetting.setPreferHttpsPortal(preferHttpsPortal);
        HashMap<String, EapControllerSetting> configMap = new HashMap<String, EapControllerSetting>();
        configMap.put(ApSetKeyEnum.CONTROLLER_SETTING.key(), eapControllerSetting);
        sendSetMsgToSiteDeviceRequest.a(configMap);
        return sendSetMsgToSiteDeviceRequest;
    }

    @Nonnull
    private static e b(String omadacId, String siteId, String hostName, int portalHttpPort, int portalHttpsPort, Boolean preferHttpsPortal) {
        e sendSetMsgToSiteDeviceRequest = new e();
        sendSetMsgToSiteDeviceRequest.a(omadacId);
        sendSetMsgToSiteDeviceRequest.b(siteId);
        sendSetMsgToSiteDeviceRequest.c(DeviceTypeEnum.b.b());
        OsgControllerSetting osgControllerSetting = new OsgControllerSetting();
        osgControllerSetting.setControllerDomain(hostName);
        osgControllerSetting.setPreferHttpsPortal(preferHttpsPortal);
        HashMap<String, OsgControllerSetting> configMap = new HashMap<String, OsgControllerSetting>();
        configMap.put(OsgSetKeyEnum.CONTROLLER_SETTING.key(), osgControllerSetting);
        sendSetMsgToSiteDeviceRequest.a(configMap);
        return sendSetMsgToSiteDeviceRequest;
    }

    @PostConstruct
    public void a() {
        DomainEventBusHolder.getHandlerRegistry().registerSync(ControllerHostNameModified.class, (DomainEventSubscriber)this);
    }

    public void a(ControllerHostNameModified event) {
        OmadacDTO dto;
        Optional<String> optHostName = event.getNewHostName();
        String omadacId = System.getProperty("eap.omadac.id");
        OperationResponse resp = this.e.a(new OmadaRequestDTO(omadacId));
        if (!resp.success() || (dto = (OmadacDTO)resp.getResult()) == null) {
            b.warn("Failed to find Omadac by ID: {}", (Object)omadacId);
            return;
        }
        c omadacPattern = com.tplink.smb.omada.common.f.c.a((Integer)dto.getPattern());
        int portalHttpPort = event.getPortalHttpPort();
        int portalHttpsPort = event.getPortalHttpsPort();
        Boolean preferHttpsPortal = event.getPreferHttpsPortal();
        boolean clusterModeOn = Objects.equals(Boolean.TRUE, event.getClusterModeOn());
        Set<String> siteIds = event.getSites();
        if (omadacPattern == com.tplink.smb.omada.common.f.c.b) {
            b.debug("Current running MSP mode, syncing portalHostname to all customers...");
            for (String customerId : dto.getCustomers()) {
                b.debug("Syncing portalHostname to customer:{}", (Object)customerId);
                this.a(optHostName, customerId, portalHttpPort, portalHttpsPort, preferHttpsPortal, clusterModeOn, siteIds);
            }
        } else {
            b.debug("Current running Standard mode, syncing portalHostname to omadac: {}", (Object)omadacId);
            this.a(optHostName, omadacId, portalHttpPort, portalHttpsPort, preferHttpsPortal, clusterModeOn, siteIds);
        }
    }

    private void a(Optional<String> optHostName, String omadacId, int portalHttpPort, int portalHttpsPort, @Nullable Boolean preferHttpsPortal, boolean clusterModeOn, Set<String> siteIds) {
        List<String> sites;
        if (!clusterModeOn) {
            OperationResponse siteListRes = this.c.a(new QuerySiteListDTO(omadacId, Integer.valueOf(a)));
            if (!siteListRes.success() || CollectionUtils.isEmpty((Collection)((Collection)siteListRes.getResult()))) {
                b.debug("Skip sync portal domain setting, empty site list.");
                return;
            }
            sites = ((List)siteListRes.getResult()).stream().map(SiteDTO::getId).collect(Collectors.toList());
        } else {
            sites = new ArrayList<String>(siteIds);
        }
        String hostName = optHostName.orElse(null);
        for (String siteId : sites) {
            if (b.isDebugEnabled()) {
                b.debug("Syncing hostname {} to OmadacId: {}, SiteId: {}", new Object[]{i.a(hostName), omadacId, siteId});
            }
            e toApRequest = i.a(omadacId, siteId, hostName, portalHttpPort, portalHttpsPort, preferHttpsPortal);
            this.d.b(toApRequest);
            e toOsgRequest = i.b(omadacId, siteId, hostName, portalHttpPort, portalHttpPort, preferHttpsPortal);
            this.d.b(toOsgRequest);
        }
    }

    private static String a(@Nullable String origin) {
        if (origin == null) {
            return null;
        }
        return PIIMaskUtil.partMask((String)origin, (int)5, (int)5);
    }

    public /* synthetic */ void handleEvent(Object object) {
        this.a((ControllerHostNameModified)((Object)object));
    }
}

