/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.system.domain.model;

import com.tplink.eap.cloudsdk.DeviceInfo;
import com.tplink.nbu.common.utils.CollectionUtil;
import com.tplink.smb.omada.cloud.api.internal.dto.BatchGetAvailableFwChannelsRespDTO;
import com.tplink.smb.omada.cloud.api.internal.dto.BizFirmwareInfoDTO;
import com.tplink.smb.omada.cloud.api.internal.dto.GetAvailableFwChannelsRespDTO;
import com.tplink.smb.omada.cloud.api.internal.dto.GetTargetFirmwareRespDTO;
import com.tplink.smb.omada.cloud.api.internal.dto.TargetFirmwareRespDTO;
import com.tplink.smb.omada.cloud.api.internal.e;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.J;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.manager.configuration.api.internal.omadac.dto.UiInterfaceDTO;
import com.tplink.smb.omada.system.api.internal.dto.FirmwareDTO;
import com.tplink.smb.omada.system.api.web.ChannelUpgradeCheckResVO;
import com.tplink.smb.omada.system.api.web.ChannelUpgradeVO;
import com.tplink.smb.omada.system.api.web.ControllerChannelUpgradeTryBetaVO;
import com.tplink.smb.omada.system.api.web.ControllerUpdateNotificationVO;
import com.tplink.smb.omada.system.api.web.HardwareUpdateVO;
import com.tplink.smb.omada.system.api.web.SoftwareUpdateCheckResVO;
import com.tplink.smb.omada.system.api.web.SoftwareUpdateVO;
import com.tplink.smb.omada.system.domain.model.a.c;
import com.tplink.smb.omada.system.domain.model.a.d;
import com.tplink.smb.omada.system.domain.model.b;
import com.tplink.smb.omada.system.domain.model.c.a;
import com.tplink.smb.omada.system.domain.model.d;
import com.tplink.smb.omada.system.domain.model.j;
import com.tplink.smb.omada.system.domain.model.m;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class f {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(f.class);
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.omadac.b b;
    @Autowired
    @Lazy
    private e c;
    @Autowired
    private m d;
    @Autowired
    @Lazy
    private com.tplink.smb.omada.system.a.d.a e;
    @Autowired
    @Lazy
    private d f;

    public OperationResponse<ControllerUpdateNotificationVO> a(String omadacId) {
        ControllerUpdateNotificationVO updateNotificationVO = new ControllerUpdateNotificationVO();
        boolean notificationSwitch = Optional.of((UiInterfaceDTO)this.b.f(omadacId).getResult()).map(UiInterfaceDTO::getControllerNotification).orElse(true);
        boolean notificationNotConfirm = this.d.a().map(j::l).orElse(false);
        if (notificationSwitch && notificationNotConfirm) {
            if (OmadacType.q()) {
                updateNotificationVO.setSoftware(this.e());
            } else if (OmadacType.r()) {
                updateNotificationVO.setHardware(this.d());
            } else {
                a.error("omadac type is {} in omadacId {}", (Object)OmadacType.b(), (Object)omadacId);
                return new OperationResponse(com.tplink.smb.omada.common.g.b.b);
            }
        }
        return OperationResponse.success((Object)updateNotificationVO);
    }

    @Nonnull
    public FirmwareDTO a() {
        return this.d.a().map(j::i).map(swcFirmWare -> {
            FirmwareDTO swcFirmwareDTO = new FirmwareDTO();
            swcFirmwareDTO.setFwReleaseLog(swcFirmWare.d());
            swcFirmwareDTO.setFwUrl(swcFirmWare.c());
            swcFirmwareDTO.setLastFwVer(swcFirmWare.b());
            swcFirmwareDTO.setLastFwVerList(swcFirmWare.e());
            return swcFirmwareDTO;
        }).orElse(new FirmwareDTO());
    }

    public FirmwareDTO b() {
        return this.d.a().map(j::g).map(hwcFirmWare -> {
            FirmwareDTO hwcFirmwareDTO = new FirmwareDTO();
            hwcFirmwareDTO.setFwReleaseLog(hwcFirmWare.j());
            hwcFirmwareDTO.setLastFwVer(hwcFirmWare.f());
            hwcFirmwareDTO.setFwUrl(hwcFirmWare.h());
            return hwcFirmwareDTO;
        }).orElse(new FirmwareDTO());
    }

    public OperationResponse<SoftwareUpdateCheckResVO> b(String omadacId) {
        SoftwareUpdateCheckResVO softwareUpdateCheckResVO = new SoftwareUpdateCheckResVO();
        OperationResponse checkRes = this.e.a(omadacId);
        if (!checkRes.success()) {
            a.warn("Check controller update failed in {}, because of {}", (Object)omadacId, (Object)checkRes.getMsg());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a((int)checkRes.getErrorCode()));
        }
        FirmwareDTO swcFirmwareDTO = this.a();
        String controllerVersion = (String)this.b.b().getResult();
        if (swcFirmwareDTO.getLastFwVer() == null) {
            softwareUpdateCheckResVO.setUpdate(Boolean.valueOf(false));
            softwareUpdateCheckResVO.setLatestVersion(controllerVersion);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)softwareUpdateCheckResVO);
        }
        if (com.tplink.smb.omada.cloud.api.internal.d.a.a((String)swcFirmwareDTO.getLastFwVer(), (String)controllerVersion) > 0) {
            softwareUpdateCheckResVO.setUpdate(Boolean.valueOf(true));
        } else {
            softwareUpdateCheckResVO.setUpdate(Boolean.valueOf(false));
        }
        softwareUpdateCheckResVO.setLatestVersion(swcFirmwareDTO.getLastFwVer());
        softwareUpdateCheckResVO.setDownloadUrl(swcFirmwareDTO.getFwUrl());
        softwareUpdateCheckResVO.setReleaseLog(swcFirmwareDTO.getFwReleaseLog());
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)softwareUpdateCheckResVO);
    }

    public OperationResponse<ControllerChannelUpgradeTryBetaVO> c(String omadacId) {
        Optional<j> systemSettingOptional = this.d.a();
        if (!systemSettingOptional.isPresent()) {
            a.error("queryControllerUpgradeTryBeta Operation failed, system setting is not exist.");
            return new OperationResponse(com.tplink.smb.omada.common.g.b.b);
        }
        j systemSetting = systemSettingOptional.get();
        Boolean tryBetaEnable = systemSetting.q();
        ControllerChannelUpgradeTryBetaVO controllerChannelUpgradeTryBetaVO = new ControllerChannelUpgradeTryBetaVO();
        controllerChannelUpgradeTryBetaVO.setEnable(tryBetaEnable);
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)controllerChannelUpgradeTryBetaVO);
    }

    public OperationResponse<ChannelUpgradeCheckResVO> a(String omadacId, ChannelUpgradeVO channelUpgradeVO) {
        long begin = System.currentTimeMillis();
        Optional<j> systemSettingOptional = this.d.a();
        if (!systemSettingOptional.isPresent()) {
            a.error("checkControllerChannelUpdate Operation failed, system setting is not exist.");
            return new OperationResponse(com.tplink.smb.omada.common.g.b.b);
        }
        a.info("checkControllerChannelUpdate get SystemSetting cost:{} ms", (Object)(System.currentTimeMillis() - begin));
        boolean isManual = false;
        j systemSetting = systemSettingOptional.get();
        Integer currentChannel = systemSetting.p();
        if (null != channelUpgradeVO && null != channelUpgradeVO.getChannel()) {
            isManual = true;
            OperationResponse response = this.f.a(omadacId, channelUpgradeVO.getChannel());
            a.info("checkControllerChannelUpdate modifyControllerChannel cost:{} ms", (Object)(System.currentTimeMillis() - begin));
            if (!response.success()) {
                a.error("modify ControllerChannelUpdate Operation failed, omadacId:{}, resp:{}", (Object)omadacId, (Object)response);
                return new OperationResponse(com.tplink.smb.omada.common.g.b.a((int)response.getErrorCode()));
            }
            currentChannel = channelUpgradeVO.getChannel();
        }
        Boolean tryBetaEnable = systemSetting.q();
        String controllerVersion = (String)this.b.b().getResult();
        a.info("checkControllerChannelUpdate get controllerVersion cost:{} ms", (Object)(System.currentTimeMillis() - begin));
        ChannelUpgradeCheckResVO noUpgradeRes = this.a(null, tryBetaEnable);
        noUpgradeRes.setCurrentChannel(currentChannel);
        noUpgradeRes.setCurrentControllerVer(controllerVersion);
        OperationResponse<BatchGetAvailableFwChannelsRespDTO> channelFwResp = this.e.c(omadacId);
        a.info("checkControllerChannelUpdate checkControllerLastChannelFw cost:{} ms", (Object)(System.currentTimeMillis() - begin));
        if (!channelFwResp.success()) {
            a.error("Check controller channel update failed in {}, because of {}, channelVO:{}", new Object[]{omadacId, channelFwResp.getMsg(), channelUpgradeVO});
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a((int)channelFwResp.getErrorCode()), (Object)noUpgradeRes);
        }
        BatchGetAvailableFwChannelsRespDTO availableFwChannels = (BatchGetAvailableFwChannelsRespDTO)channelFwResp.getResult();
        if (null == availableFwChannels || CollectionUtil.isEmpty((Collection)availableFwChannels.getChannelList())) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)noUpgradeRes);
        }
        GetAvailableFwChannelsRespDTO availableFwChannelsRespDTO = (GetAvailableFwChannelsRespDTO)availableFwChannels.getChannelList().get(0);
        if (OmadacType.r()) {
            this.a(availableFwChannelsRespDTO, isManual, currentChannel);
        }
        ChannelUpgradeCheckResVO channelUpgradeCheckResVO = this.a(availableFwChannelsRespDTO, tryBetaEnable);
        channelUpgradeCheckResVO.setCurrentControllerVer(controllerVersion);
        channelUpgradeCheckResVO.setCurrentChannel(currentChannel);
        OperationResponse<GetTargetFirmwareRespDTO> currentControllerChannelResp = this.e.d(omadacId);
        a.info("checkControllerChannelUpdate checkCurrentControllerChannel cost:{} ms", (Object)(System.currentTimeMillis() - begin));
        if (!currentControllerChannelResp.success()) {
            a.error("get controller current channel failed in {}, because of {}, channelVO:{}", new Object[]{omadacId, currentControllerChannelResp.getMsg(), channelUpgradeVO});
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a((int)channelFwResp.getErrorCode()), (Object)noUpgradeRes);
        }
        GetTargetFirmwareRespDTO channelRespResult = (GetTargetFirmwareRespDTO)currentControllerChannelResp.getResult();
        if (null == channelRespResult || CollectionUtil.isEmpty((Collection)channelRespResult.getFwList())) {
            a.error("get controller current channel failed in {}, because of {}, channelVO:{}", new Object[]{omadacId, currentControllerChannelResp.getMsg(), channelUpgradeVO});
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)channelUpgradeCheckResVO);
        }
        TargetFirmwareRespDTO targetFirmwareRespDTO = (TargetFirmwareRespDTO)channelRespResult.getFwList().get(0);
        b firmwareChannelEnum = com.tplink.smb.omada.system.domain.model.b.b(targetFirmwareRespDTO.getChannel());
        Integer controllerChannel = null == firmwareChannelEnum ? null : firmwareChannelEnum.a();
        channelUpgradeCheckResVO.setControllerChannel(controllerChannel);
        a.info("checkControllerChannelUpdate finish checkControllerChannelUpdate cost:{} ms", (Object)(System.currentTimeMillis() - begin));
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)channelUpgradeCheckResVO);
    }

    public void a(GetAvailableFwChannelsRespDTO availableFwChannelsRespDTO, Boolean isManual, Integer channel) {
        if (null == availableFwChannelsRespDTO) {
            return;
        }
        b channelEnum = com.tplink.smb.omada.system.domain.model.b.a(channel);
        if (null == channelEnum) {
            channelEnum = com.tplink.smb.omada.system.domain.model.b.a;
        }
        ArrayList upgradeFirmwareList = new ArrayList();
        switch (channelEnum) {
            case c: {
                if (CollectionUtil.isEmpty((Collection)availableFwChannelsRespDTO.getEarlyAccess())) break;
                upgradeFirmwareList.addAll(availableFwChannelsRespDTO.getEarlyAccess());
                break;
            }
            case b: {
                if (CollectionUtil.isEmpty((Collection)availableFwChannelsRespDTO.getReleaseCandidate())) break;
                upgradeFirmwareList.addAll(availableFwChannelsRespDTO.getReleaseCandidate());
                break;
            }
            case a: {
                if (CollectionUtil.isEmpty((Collection)availableFwChannelsRespDTO.getStable())) break;
                upgradeFirmwareList.addAll(availableFwChannelsRespDTO.getStable());
                break;
            }
        }
        Optional<j> systemSettingOptional = this.d.a();
        if (!systemSettingOptional.isPresent()) {
            return;
        }
        com.tplink.smb.omada.system.domain.model.a.d hwcFirmware = systemSettingOptional.get().g();
        DeviceInfo deviceInfo = this.c.a();
        if (CollectionUtil.isEmpty(upgradeFirmwareList) || null == upgradeFirmwareList.get(0) || null == deviceInfo) {
            return;
        }
        String modelModelVersion = deviceInfo.getDeviceModel() + " " + deviceInfo.getDeviceHwVer();
        if (hwcFirmware == null) {
            hwcFirmware = ((d.a)((d.a)((d.a)((d.a)((d.a)com.tplink.smb.omada.system.domain.model.a.d.a().a(modelModelVersion)).b(com.tplink.smb.omada.common.util.b.b.c((String)deviceInfo.getHwId()))).c(com.tplink.smb.omada.common.util.b.b.c((String)deviceInfo.getOemId()))).d("en_US")).a(0L)).b();
        }
        if (Boolean.TRUE.equals(isManual)) {
            hwcFirmware.a(System.currentTimeMillis() / 1000L);
        }
        BizFirmwareInfoDTO bizFirmwareInfoDTO = (BizFirmwareInfoDTO)upgradeFirmwareList.get(0);
        hwcFirmware.h(bizFirmwareInfoDTO.getFwReleaseLog());
        hwcFirmware.i(bizFirmwareInfoDTO.getFwMD5());
        hwcFirmware.f(bizFirmwareInfoDTO.getFwSecureUrl());
        hwcFirmware.a(channelEnum.a());
        hwcFirmware.b(bizFirmwareInfoDTO.getFwType());
        hwcFirmware.g(bizFirmwareInfoDTO.getFwTitle());
        hwcFirmware.e(bizFirmwareInfoDTO.getFwVer());
        this.f.a(hwcFirmware);
    }

    private HardwareUpdateVO c() {
        HardwareUpdateVO hardwareUpdateVO = new HardwareUpdateVO();
        com.tplink.smb.omada.system.domain.model.a.d hwcFirmware = this.d.a().map(j::g).orElse(null);
        if (hwcFirmware == null) {
            hardwareUpdateVO.setUpgrade(Boolean.valueOf(false));
            return hardwareUpdateVO;
        }
        DeviceInfo deviceInfo = this.c.a();
        if (this.a(hwcFirmware.f(), deviceInfo.getFwVer())) {
            hardwareUpdateVO.setUpgrade(Boolean.valueOf(true));
            hardwareUpdateVO.setLatestVersion(hwcFirmware.f());
            hardwareUpdateVO.setFwReleaseLog(hwcFirmware.j());
            hardwareUpdateVO.setCurrentVersion(deviceInfo.getFwVer());
        } else {
            hardwareUpdateVO.setUpgrade(Boolean.valueOf(false));
        }
        return hardwareUpdateVO;
    }

    private HardwareUpdateVO d() {
        HardwareUpdateVO hardwareUpdateVO = new HardwareUpdateVO();
        Optional<j> systemSettingOptional = this.d.a();
        if (!systemSettingOptional.isPresent()) {
            hardwareUpdateVO.setUpgrade(Boolean.valueOf(false));
            return hardwareUpdateVO;
        }
        j systemSetting = systemSettingOptional.get();
        if (null == systemSetting.h()) {
            hardwareUpdateVO.setUpgrade(Boolean.valueOf(false));
            return hardwareUpdateVO;
        }
        c channelUpgradeInfo = systemSetting.h();
        DeviceInfo deviceInfo = this.c.a();
        if (null == deviceInfo || T.a((String)deviceInfo.getFwVer())) {
            hardwareUpdateVO.setUpgrade(Boolean.valueOf(false));
            return hardwareUpdateVO;
        }
        if (this.a(channelUpgradeInfo.c(), deviceInfo.getFwVer())) {
            hardwareUpdateVO.setUpgrade(Boolean.valueOf(true));
            hardwareUpdateVO.setLatestVersion(channelUpgradeInfo.c());
            hardwareUpdateVO.setFwReleaseLog(channelUpgradeInfo.e());
            hardwareUpdateVO.setCurrentVersion(deviceInfo.getFwVer());
        } else {
            hardwareUpdateVO.setUpgrade(Boolean.valueOf(false));
        }
        return hardwareUpdateVO;
    }

    private SoftwareUpdateVO e() {
        SoftwareUpdateVO softwareUpdateVO = new SoftwareUpdateVO();
        a swcFirmware = this.d.a().map(j::i).orElse(null);
        if (swcFirmware == null) {
            softwareUpdateVO.setUpgrade(Boolean.valueOf(false));
            return softwareUpdateVO;
        }
        softwareUpdateVO.setUpgrade(Boolean.valueOf(true));
        softwareUpdateVO.setLatestVersion(swcFirmware.b());
        softwareUpdateVO.setDownloadLink(swcFirmware.c());
        softwareUpdateVO.setFwReleaseLog(swcFirmware.d());
        softwareUpdateVO.setCurrentVersion((String)this.b.b().getResult());
        return softwareUpdateVO;
    }

    private boolean a(String lastFwVer, String currentFwVers) {
        return !T.a((String)lastFwVer) && com.tplink.smb.omada.cloud.api.internal.d.a.a((List)com.tplink.smb.omada.cloud.api.internal.d.a.a((String)currentFwVers), (List)com.tplink.smb.omada.cloud.api.internal.d.a.a((String)lastFwVer)) < 0;
    }

    private ChannelUpgradeCheckResVO a(GetAvailableFwChannelsRespDTO availableFwChannelsRespDTO, Boolean tryBetaEnable) {
        ChannelUpgradeCheckResVO channelUpgradeCheckResVO = new ChannelUpgradeCheckResVO();
        ArrayList<SoftwareUpdateCheckResVO> upgradeList = new ArrayList<SoftwareUpdateCheckResVO>();
        channelUpgradeCheckResVO.setUpgradeList(upgradeList);
        for (b firmwareChannelEnum : com.tplink.smb.omada.system.domain.model.b.values()) {
            if (!tryBetaEnable.booleanValue() && firmwareChannelEnum.equals((Object)com.tplink.smb.omada.system.domain.model.b.c)) continue;
            SoftwareUpdateCheckResVO softwareUpdateCheckResVO = new SoftwareUpdateCheckResVO();
            softwareUpdateCheckResVO.setChannel(firmwareChannelEnum.a());
            List<BizFirmwareInfoDTO> channelFwList = this.a(availableFwChannelsRespDTO, firmwareChannelEnum);
            if (CollectionUtil.isEmpty(channelFwList)) {
                softwareUpdateCheckResVO.setUpdate(Boolean.FALSE);
            } else {
                softwareUpdateCheckResVO.setUpdate(Boolean.TRUE);
                BizFirmwareInfoDTO bizFirmwareInfoDTO = (BizFirmwareInfoDTO)channelFwList.stream().sorted((o1, o2) -> com.tplink.smb.omada.cloud.api.internal.d.a.a((String)o2.getFwVer(), (String)o1.getFwVer()) > 0 ? 1 : -1).collect(Collectors.toList()).get(0);
                softwareUpdateCheckResVO.setLatestVersion(bizFirmwareInfoDTO.getFwVer());
                softwareUpdateCheckResVO.setDownloadUrl(bizFirmwareInfoDTO.getFwSecureUrl());
                softwareUpdateCheckResVO.setReleaseLog(bizFirmwareInfoDTO.getFwReleaseLog());
            }
            upgradeList.add(softwareUpdateCheckResVO);
        }
        return channelUpgradeCheckResVO;
    }

    private List<BizFirmwareInfoDTO> a(GetAvailableFwChannelsRespDTO availableFwChannelsRespDTO, b channel) {
        if (J.b((Object)availableFwChannelsRespDTO)) {
            return Collections.emptyList();
        }
        switch (channel) {
            case a: {
                return availableFwChannelsRespDTO.getStable();
            }
            case b: {
                return availableFwChannelsRespDTO.getReleaseCandidate();
            }
            case c: {
                return availableFwChannelsRespDTO.getEarlyAccess();
            }
        }
        return Collections.emptyList();
    }
}

