/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.web.vo.vouchergroup;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ImmutableSet;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import jakarta.validation.constraints.NotNull;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

public class VoucherScheduleVO {
    @JsonIgnore
    private static final ImmutableSet<Integer> WEEKLY_DAYS_RANGE = ImmutableSet.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object[])new Integer[]{7});
    @NotNull(message="Parameter [type] should not be null.")
    @NumberSet(value={0, 1})
    private @NotNull(message="Parameter [type] should not be null.") Integer type;
    @Range(min=0L, max=23L)
    private @Range(min=0L, max=23L) Integer dailyStartHour;
    @Range(min=0L, max=59L)
    private @Range(min=0L, max=59L) Integer dailyStartMin;
    @Range(min=0L, max=23L)
    private @Range(min=0L, max=23L) Integer dailyEndHour;
    @Range(min=0L, max=59L)
    private @Range(min=0L, max=59L) Integer dailyEndMin;
    private Set<Integer> weeklyEnableDays;

    @JsonIgnore
    public boolean validate() {
        if (Objects.equals(this.type, 0)) {
            if (this.dailyStartHour == null || this.dailyStartMin == null || this.dailyEndHour == null || this.dailyEndMin == null) {
                return false;
            }
            if (this.dailyStartHour > this.dailyEndHour) {
                return false;
            }
            if (this.dailyStartHour.equals(this.dailyEndHour) && this.dailyStartMin > this.dailyEndMin) {
                return false;
            }
        } else {
            if (CollectionUtils.isEmpty(this.weeklyEnableDays) || !WEEKLY_DAYS_RANGE.containsAll(this.weeklyEnableDays)) {
                return false;
            }
            this.weeklyEnableDays = this.weeklyEnableDays.stream().sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return true;
    }

    @Generated
    public static VoucherScheduleVOBuilder builder() {
        return new VoucherScheduleVOBuilder();
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public Integer getDailyStartHour() {
        return this.dailyStartHour;
    }

    @Generated
    public Integer getDailyStartMin() {
        return this.dailyStartMin;
    }

    @Generated
    public Integer getDailyEndHour() {
        return this.dailyEndHour;
    }

    @Generated
    public Integer getDailyEndMin() {
        return this.dailyEndMin;
    }

    @Generated
    public Set<Integer> getWeeklyEnableDays() {
        return this.weeklyEnableDays;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setDailyStartHour(Integer dailyStartHour) {
        this.dailyStartHour = dailyStartHour;
    }

    @Generated
    public void setDailyStartMin(Integer dailyStartMin) {
        this.dailyStartMin = dailyStartMin;
    }

    @Generated
    public void setDailyEndHour(Integer dailyEndHour) {
        this.dailyEndHour = dailyEndHour;
    }

    @Generated
    public void setDailyEndMin(Integer dailyEndMin) {
        this.dailyEndMin = dailyEndMin;
    }

    @Generated
    public void setWeeklyEnableDays(Set<Integer> weeklyEnableDays) {
        this.weeklyEnableDays = weeklyEnableDays;
    }

    @Generated
    public String toString() {
        return "VoucherScheduleVO(type=" + this.getType() + ", dailyStartHour=" + this.getDailyStartHour() + ", dailyStartMin=" + this.getDailyStartMin() + ", dailyEndHour=" + this.getDailyEndHour() + ", dailyEndMin=" + this.getDailyEndMin() + ", weeklyEnableDays=" + this.getWeeklyEnableDays() + ")";
    }

    @Generated
    public VoucherScheduleVO() {
    }

    @Generated
    public VoucherScheduleVO(Integer type, Integer dailyStartHour, Integer dailyStartMin, Integer dailyEndHour, Integer dailyEndMin, Set<Integer> weeklyEnableDays) {
        this.type = type;
        this.dailyStartHour = dailyStartHour;
        this.dailyStartMin = dailyStartMin;
        this.dailyEndHour = dailyEndHour;
        this.dailyEndMin = dailyEndMin;
        this.weeklyEnableDays = weeklyEnableDays;
    }

    @Generated
    public static class VoucherScheduleVOBuilder {
        @Generated
        private Integer type;
        @Generated
        private Integer dailyStartHour;
        @Generated
        private Integer dailyStartMin;
        @Generated
        private Integer dailyEndHour;
        @Generated
        private Integer dailyEndMin;
        @Generated
        private Set<Integer> weeklyEnableDays;

        @Generated
        VoucherScheduleVOBuilder() {
        }

        @Generated
        public VoucherScheduleVOBuilder type(Integer type) {
            this.type = type;
            return this;
        }

        @Generated
        public VoucherScheduleVOBuilder dailyStartHour(Integer dailyStartHour) {
            this.dailyStartHour = dailyStartHour;
            return this;
        }

        @Generated
        public VoucherScheduleVOBuilder dailyStartMin(Integer dailyStartMin) {
            this.dailyStartMin = dailyStartMin;
            return this;
        }

        @Generated
        public VoucherScheduleVOBuilder dailyEndHour(Integer dailyEndHour) {
            this.dailyEndHour = dailyEndHour;
            return this;
        }

        @Generated
        public VoucherScheduleVOBuilder dailyEndMin(Integer dailyEndMin) {
            this.dailyEndMin = dailyEndMin;
            return this;
        }

        @Generated
        public VoucherScheduleVOBuilder weeklyEnableDays(Set<Integer> weeklyEnableDays) {
            this.weeklyEnableDays = weeklyEnableDays;
            return this;
        }

        @Generated
        public VoucherScheduleVO build() {
            return new VoucherScheduleVO(this.type, this.dailyStartHour, this.dailyStartMin, this.dailyEndHour, this.dailyEndMin, this.weeklyEnableDays);
        }

        @Generated
        public String toString() {
            return "VoucherScheduleVO.VoucherScheduleVOBuilder(type=" + this.type + ", dailyStartHour=" + this.dailyStartHour + ", dailyStartMin=" + this.dailyStartMin + ", dailyEndHour=" + this.dailyEndHour + ", dailyEndMin=" + this.dailyEndMin + ", weeklyEnableDays=" + this.weeklyEnableDays + ")";
        }
    }
}

