/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.web.vo.vouchergroup;

import com.google.common.collect.ImmutableSet;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.portal.api.web.vo.vouchergroup.EditVoucherPatternVO;
import com.tplink.smb.omada.portal.api.web.vo.vouchergroup.VoucherScheduleVO;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

public class CreateVoucherGroupVO {
    private static final ImmutableSet<Integer> CODE_FORM_RANGE = ImmutableSet.of((Object)0, (Object)1);
    @NotNull(message="Parameter [name] must not be null.")
    @Length(min=1, max=32, message="Parameter [name] should be 1~32 UTF-8 characters.")
    private @NotNull(message="Parameter [name] must not be null.") @Length(min=1, max=32, message="Parameter [name] should be 1~32 UTF-8 characters.") String name;
    @NotNull
    @Range(min=1L)
    private @NotNull @Range(min=1L) Integer amount;
    @NotNull(message="Parameter [codeLength] must not be null.")
    @Range(min=6L, max=10L, message="Illegal parameter [codeLength], should from 6 to 10 (both included)")
    private @NotNull(message="Parameter [codeLength] must not be null.") @Range(min=6L, max=10L, message="Illegal parameter [codeLength], should from 6 to 10 (both included)") Integer codeLength;
    @NotNull(message="Parameter [codeForm] must not be null.")
    private @NotNull(message="Parameter [codeForm] must not be null.") Set<Integer> codeForm;
    @NotNull
    @NumberSet(value={0, 1, 2}, message="Illegal parameter [type], should be 0, 1 or 2")
    private Integer type;
    @NotNull
    @Range(min=1L, max=999L)
    private @NotNull @Range(min=1L, max=999L) Integer maxUsers;
    @NotNull
    @NumberSet(value={0, 1})
    private Integer durationType;
    @NotNull
    private Boolean upTimeLimitEnable;
    @NotNull
    @Range(min=1L)
    private @NotNull @Range(min=1L) Long duration;
    private Boolean downLimitEnable;
    @Range(min=1L, max=0xA00000L)
    private @Range(min=1L, max=0xA00000L) Long downLimit;
    private Boolean upLimitEnable;
    @Range(min=1L, max=0xA00000L)
    private @Range(min=1L, max=0xA00000L) Long upLimit;
    private String rateLimitId;
    private Boolean trafficLimitEnable;
    @Range(min=1L, max=0xA00000L)
    private @Range(min=1L, max=0xA00000L) Long trafficLimit;
    @NumberSet(value={0, 1, 2, 3})
    private Integer trafficLimitFrequency;
    private String unitPrice;
    private String totalPrice;
    private String currency;
    private List<String> portalIds;
    @NotNull(message="Parameter [applyToAllPortals] should not be null.")
    private @NotNull(message="Parameter [applyToAllPortals] should not be null.") Boolean applyToAllPortals;
    private String description;
    @NotNull(message="Parameter [voucherValidityEnable] should not be null.")
    private @NotNull(message="Parameter [voucherValidityEnable] should not be null.") Boolean voucherValidityEnable;
    private Long expirationTime;
    private Long effectiveTime;
    @Nullable
    private Boolean logout;
    @Length(max=256, message="Parameter [printCommand] should be 0~256 characters.")
    private @Length(max=256, message="Parameter [printCommand] should be 0~256 characters.") String printComments;
    @NumberSet(value={0, 1, 2})
    private Integer validityType;
    @Valid
    private VoucherScheduleVO schedule;
    @Valid
    @Nullable
    private EditVoucherPatternVO pattern;

    public boolean validateAndCompatible(int groupAmountLimit) {
        if (this.codeForm.isEmpty() || !CODE_FORM_RANGE.containsAll(this.codeForm)) {
            return false;
        }
        if (this.amount > groupAmountLimit) {
            return false;
        }
        if (this.validityType == null) {
            this.validityType = this.expirationTime == null ? 0 : 1;
        }
        switch (this.validityType) {
            case 0: {
                return this.effectiveTime == null && this.expirationTime == null && this.schedule == null;
            }
            case 1: {
                if (this.effectiveTime == null || this.expirationTime == null) {
                    return false;
                }
                if (this.expirationTime <= System.currentTimeMillis()) {
                    return false;
                }
                return this.effectiveTime < this.expirationTime;
            }
            case 2: {
                if (this.schedule == null) {
                    return false;
                }
                if (this.pattern != null) {
                    return this.pattern.validate();
                }
                return this.schedule.validate();
            }
        }
        return false;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getAmount() {
        return this.amount;
    }

    @Generated
    public Integer getCodeLength() {
        return this.codeLength;
    }

    @Generated
    public Set<Integer> getCodeForm() {
        return this.codeForm;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public Integer getMaxUsers() {
        return this.maxUsers;
    }

    @Generated
    public Integer getDurationType() {
        return this.durationType;
    }

    @Generated
    public Boolean getUpTimeLimitEnable() {
        return this.upTimeLimitEnable;
    }

    @Generated
    public Long getDuration() {
        return this.duration;
    }

    @Generated
    public Boolean getDownLimitEnable() {
        return this.downLimitEnable;
    }

    @Generated
    public Long getDownLimit() {
        return this.downLimit;
    }

    @Generated
    public Boolean getUpLimitEnable() {
        return this.upLimitEnable;
    }

    @Generated
    public Long getUpLimit() {
        return this.upLimit;
    }

    @Generated
    public String getRateLimitId() {
        return this.rateLimitId;
    }

    @Generated
    public Boolean getTrafficLimitEnable() {
        return this.trafficLimitEnable;
    }

    @Generated
    public Long getTrafficLimit() {
        return this.trafficLimit;
    }

    @Generated
    public Integer getTrafficLimitFrequency() {
        return this.trafficLimitFrequency;
    }

    @Generated
    public String getUnitPrice() {
        return this.unitPrice;
    }

    @Generated
    public String getTotalPrice() {
        return this.totalPrice;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public List<String> getPortalIds() {
        return this.portalIds;
    }

    @Generated
    public Boolean getApplyToAllPortals() {
        return this.applyToAllPortals;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Boolean getVoucherValidityEnable() {
        return this.voucherValidityEnable;
    }

    @Generated
    public Long getExpirationTime() {
        return this.expirationTime;
    }

    @Generated
    public Long getEffectiveTime() {
        return this.effectiveTime;
    }

    @Nullable
    @Generated
    public Boolean getLogout() {
        return this.logout;
    }

    @Generated
    public String getPrintComments() {
        return this.printComments;
    }

    @Generated
    public Integer getValidityType() {
        return this.validityType;
    }

    @Generated
    public VoucherScheduleVO getSchedule() {
        return this.schedule;
    }

    @Nullable
    @Generated
    public EditVoucherPatternVO getPattern() {
        return this.pattern;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    @Generated
    public void setCodeLength(Integer codeLength) {
        this.codeLength = codeLength;
    }

    @Generated
    public void setCodeForm(Set<Integer> codeForm) {
        this.codeForm = codeForm;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setMaxUsers(Integer maxUsers) {
        this.maxUsers = maxUsers;
    }

    @Generated
    public void setDurationType(Integer durationType) {
        this.durationType = durationType;
    }

    @Generated
    public void setUpTimeLimitEnable(Boolean upTimeLimitEnable) {
        this.upTimeLimitEnable = upTimeLimitEnable;
    }

    @Generated
    public void setDuration(Long duration) {
        this.duration = duration;
    }

    @Generated
    public void setDownLimitEnable(Boolean downLimitEnable) {
        this.downLimitEnable = downLimitEnable;
    }

    @Generated
    public void setDownLimit(Long downLimit) {
        this.downLimit = downLimit;
    }

    @Generated
    public void setUpLimitEnable(Boolean upLimitEnable) {
        this.upLimitEnable = upLimitEnable;
    }

    @Generated
    public void setUpLimit(Long upLimit) {
        this.upLimit = upLimit;
    }

    @Generated
    public void setRateLimitId(String rateLimitId) {
        this.rateLimitId = rateLimitId;
    }

    @Generated
    public void setTrafficLimitEnable(Boolean trafficLimitEnable) {
        this.trafficLimitEnable = trafficLimitEnable;
    }

    @Generated
    public void setTrafficLimit(Long trafficLimit) {
        this.trafficLimit = trafficLimit;
    }

    @Generated
    public void setTrafficLimitFrequency(Integer trafficLimitFrequency) {
        this.trafficLimitFrequency = trafficLimitFrequency;
    }

    @Generated
    public void setUnitPrice(String unitPrice) {
        this.unitPrice = unitPrice;
    }

    @Generated
    public void setTotalPrice(String totalPrice) {
        this.totalPrice = totalPrice;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setPortalIds(List<String> portalIds) {
        this.portalIds = portalIds;
    }

    @Generated
    public void setApplyToAllPortals(Boolean applyToAllPortals) {
        this.applyToAllPortals = applyToAllPortals;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setVoucherValidityEnable(Boolean voucherValidityEnable) {
        this.voucherValidityEnable = voucherValidityEnable;
    }

    @Generated
    public void setExpirationTime(Long expirationTime) {
        this.expirationTime = expirationTime;
    }

    @Generated
    public void setEffectiveTime(Long effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    @Generated
    public void setLogout(@Nullable Boolean logout) {
        this.logout = logout;
    }

    @Generated
    public void setPrintComments(String printComments) {
        this.printComments = printComments;
    }

    @Generated
    public void setValidityType(Integer validityType) {
        this.validityType = validityType;
    }

    @Generated
    public void setSchedule(VoucherScheduleVO schedule) {
        this.schedule = schedule;
    }

    @Generated
    public void setPattern(@Nullable EditVoucherPatternVO pattern) {
        this.pattern = pattern;
    }

    @Generated
    public String toString() {
        return "CreateVoucherGroupVO(name=" + this.getName() + ", amount=" + this.getAmount() + ", codeLength=" + this.getCodeLength() + ", codeForm=" + this.getCodeForm() + ", type=" + this.getType() + ", maxUsers=" + this.getMaxUsers() + ", durationType=" + this.getDurationType() + ", upTimeLimitEnable=" + this.getUpTimeLimitEnable() + ", duration=" + this.getDuration() + ", downLimitEnable=" + this.getDownLimitEnable() + ", downLimit=" + this.getDownLimit() + ", upLimitEnable=" + this.getUpLimitEnable() + ", upLimit=" + this.getUpLimit() + ", rateLimitId=" + this.getRateLimitId() + ", trafficLimitEnable=" + this.getTrafficLimitEnable() + ", trafficLimit=" + this.getTrafficLimit() + ", trafficLimitFrequency=" + this.getTrafficLimitFrequency() + ", unitPrice=" + this.getUnitPrice() + ", totalPrice=" + this.getTotalPrice() + ", currency=" + this.getCurrency() + ", portalIds=" + this.getPortalIds() + ", applyToAllPortals=" + this.getApplyToAllPortals() + ", description=" + this.getDescription() + ", voucherValidityEnable=" + this.getVoucherValidityEnable() + ", expirationTime=" + this.getExpirationTime() + ", effectiveTime=" + this.getEffectiveTime() + ", logout=" + this.getLogout() + ", printComments=" + this.getPrintComments() + ", validityType=" + this.getValidityType() + ", schedule=" + this.getSchedule() + ", pattern=" + this.getPattern() + ")";
    }
}

