/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.web.vo.ppsk.ppskpage;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

public class PPSKTitleVO {
    @Schema(name="enable", description="Whether to enable title")
    @NotNull(message="Parameter [enable] of PPSKTitleOpenApiVO must not be null.")
    private @NotNull(message="Parameter [enable] of PPSKTitleOpenApiVO must not be null.") Boolean enable;
    @Schema(name="content", description="Title text content")
    @Length(max=128, message="Length of Parameter [content] should less than 128.")
    private @Length(max=128, message="Length of Parameter [content] should less than 128.") String content;
    @Schema(name="color", description="Title color. Hex color code such as: #ffffff")
    @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Parameter [color] is invalid.")
    private @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Parameter [color] is invalid.") String color;
    @Schema(name="opacity", description="Title opacity, should be within the range of 0\u2013100")
    @Range(min=0L, max=100L, message="Parameter [opacity] is from 0 to 100.")
    private @Range(min=0L, max=100L, message="Parameter [opacity] is from 0 to 100.") Integer opacity;
    @Schema(name="size", description="Title size, should be within the range of 14\u201328")
    @Range(min=14L, max=28L, message="Parameter [size] is from 14 to 28.")
    private @Range(min=14L, max=28L, message="Parameter [size] is from 14 to 28.") Integer size;

    @JsonIgnore
    public OperationResponse validate() {
        if (Boolean.TRUE.equals(this.enable)) {
            if (this.content == null) {
                return new OperationResponse(b.d, "Parameter [content] of PPSKTitleOpenApiVO must not be null.", null);
            }
            if (this.color == null) {
                return new OperationResponse(b.d, "Parameter [color] of PPSKTitleOpenApiVO must not be null.", null);
            }
            if (this.opacity == null) {
                return new OperationResponse(b.d, "Parameter [opacity] of PPSKTitleOpenApiVO must not be null.", null);
            }
            if (this.size == null) {
                return new OperationResponse(b.d, "Parameter [size] of PPSKTitleOpenApiVO must not be null.", null);
            }
        }
        return OperationResponse.SUCCESS;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public String getColor() {
        return this.color;
    }

    @Generated
    public Integer getOpacity() {
        return this.opacity;
    }

    @Generated
    public Integer getSize() {
        return this.size;
    }

    @Generated
    public PPSKTitleVO setEnable(Boolean enable) {
        this.enable = enable;
        return this;
    }

    @Generated
    public PPSKTitleVO setContent(String content) {
        this.content = content;
        return this;
    }

    @Generated
    public PPSKTitleVO setColor(String color) {
        this.color = color;
        return this;
    }

    @Generated
    public PPSKTitleVO setOpacity(Integer opacity) {
        this.opacity = opacity;
        return this;
    }

    @Generated
    public PPSKTitleVO setSize(Integer size) {
        this.size = size;
        return this;
    }

    @Generated
    public String toString() {
        return "PPSKTitleVO(enable=" + this.getEnable() + ", content=" + this.getContent() + ", color=" + this.getColor() + ", opacity=" + this.getOpacity() + ", size=" + this.getSize() + ")";
    }

    @Generated
    public PPSKTitleVO(Boolean enable, String content, String color, Integer opacity, Integer size) {
        this.enable = enable;
        this.content = content;
        this.color = color;
        this.opacity = opacity;
        this.size = size;
    }

    @Generated
    public PPSKTitleVO() {
    }
}

