/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.web.vo.ppsk.ppskpage;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.portal.api.web.vo.ppsk.ppskpage.PPSKBackgroundVO;
import com.tplink.smb.omada.portal.api.web.vo.ppsk.ppskpage.PPSKLogoVO;
import com.tplink.smb.omada.portal.api.web.vo.ppsk.ppskpage.PPSKLogoutSuccessOpenApiVO;
import com.tplink.smb.omada.portal.api.web.vo.ppsk.ppskpage.PPSKRegisterSuccessVO;
import com.tplink.smb.omada.portal.api.web.vo.ppsk.ppskpage.PPSKSelfRegisterVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

public class PPSKRegisterPageVO {
    @Valid
    @Schema(name="background", description="PPSK register page background setting")
    @NotNull(message="Parameter [background] of PPSKRegisterPageOpenApiVO must not be null.")
    private @Valid @NotNull(message="Parameter [background] of PPSKRegisterPageOpenApiVO must not be null.") PPSKBackgroundVO background;
    @Valid
    @Schema(name="logo", description="PPSK register page logo setting")
    private PPSKLogoVO logo;
    @Valid
    @Schema(name="registerPage", description="PPSK self register page setting")
    @NotNull(message="Parameter [registerPage] of PPSKRegisterPageOpenApiVO must not be null.")
    private @Valid @NotNull(message="Parameter [registerPage] of PPSKRegisterPageOpenApiVO must not be null.") PPSKSelfRegisterVO registerPage;
    @Valid
    @Schema(name="registerSuccessPage", description="PPSK register success page setting")
    @NotNull(message="Parameter [registerSuccessPage] of PPSKRegisterPageOpenApiVO must not be null.")
    private @Valid @NotNull(message="Parameter [registerSuccessPage] of PPSKRegisterPageOpenApiVO must not be null.") PPSKRegisterSuccessVO registerSuccessPage;
    @Valid
    @Schema(name="logoutSuccessPage", description="PPSK logout success page setting")
    @NotNull(message="Parameter [logoutSuccessPage] of PPSKRegisterPageOpenApiVO must not be null.")
    private @Valid @NotNull(message="Parameter [logoutSuccessPage] of PPSKRegisterPageOpenApiVO must not be null.") PPSKLogoutSuccessOpenApiVO logoutSuccessPage;

    @JsonIgnore
    public OperationResponse validate() {
        OperationResponse logoRes;
        OperationResponse backgroundRes = this.background.validate();
        if (!backgroundRes.success()) {
            return backgroundRes;
        }
        if (this.logo != null && !(logoRes = this.logo.validate()).success()) {
            return logoRes;
        }
        OperationResponse registerPageRes = this.registerPage.validate();
        if (!registerPageRes.success()) {
            return registerPageRes;
        }
        OperationResponse registerSuccessPageRes = this.registerSuccessPage.validate();
        if (!registerSuccessPageRes.success()) {
            return registerSuccessPageRes;
        }
        return this.logoutSuccessPage.validate();
    }

    @JsonIgnore
    public Set<String> findAllPicIds() {
        HashSet<String> ids = new HashSet<String>();
        Optional.ofNullable(this.getBackground().getPicture()).map(pic -> Optional.ofNullable(pic.getPcPictureId()).filter(T::b).map(ids::add));
        Optional.ofNullable(this.getBackground().getPicture()).map(pic -> Optional.ofNullable(pic.getMobilePictureId()).filter(T::b).map(ids::add));
        Optional.ofNullable(this.getLogo()).map(logo -> Optional.ofNullable(logo.getPictureId()).filter(T::b).map(ids::add));
        return ids;
    }

    @JsonIgnore
    public PPSKRegisterPageVO copy() {
        return (PPSKRegisterPageVO)x.a((Object)this, PPSKRegisterPageVO.class);
    }

    @Generated
    public PPSKBackgroundVO getBackground() {
        return this.background;
    }

    @Generated
    public PPSKLogoVO getLogo() {
        return this.logo;
    }

    @Generated
    public PPSKSelfRegisterVO getRegisterPage() {
        return this.registerPage;
    }

    @Generated
    public PPSKRegisterSuccessVO getRegisterSuccessPage() {
        return this.registerSuccessPage;
    }

    @Generated
    public PPSKLogoutSuccessOpenApiVO getLogoutSuccessPage() {
        return this.logoutSuccessPage;
    }

    @Generated
    public PPSKRegisterPageVO setBackground(PPSKBackgroundVO background) {
        this.background = background;
        return this;
    }

    @Generated
    public PPSKRegisterPageVO setLogo(PPSKLogoVO logo) {
        this.logo = logo;
        return this;
    }

    @Generated
    public PPSKRegisterPageVO setRegisterPage(PPSKSelfRegisterVO registerPage) {
        this.registerPage = registerPage;
        return this;
    }

    @Generated
    public PPSKRegisterPageVO setRegisterSuccessPage(PPSKRegisterSuccessVO registerSuccessPage) {
        this.registerSuccessPage = registerSuccessPage;
        return this;
    }

    @Generated
    public PPSKRegisterPageVO setLogoutSuccessPage(PPSKLogoutSuccessOpenApiVO logoutSuccessPage) {
        this.logoutSuccessPage = logoutSuccessPage;
        return this;
    }

    @Generated
    public String toString() {
        return "PPSKRegisterPageVO(background=" + this.getBackground() + ", logo=" + this.getLogo() + ", registerPage=" + this.getRegisterPage() + ", registerSuccessPage=" + this.getRegisterSuccessPage() + ", logoutSuccessPage=" + this.getLogoutSuccessPage() + ")";
    }

    @Generated
    public PPSKRegisterPageVO(PPSKBackgroundVO background, PPSKLogoVO logo, PPSKSelfRegisterVO registerPage, PPSKRegisterSuccessVO registerSuccessPage, PPSKLogoutSuccessOpenApiVO logoutSuccessPage) {
        this.background = background;
        this.logo = logo;
        this.registerPage = registerPage;
        this.registerSuccessPage = registerSuccessPage;
        this.logoutSuccessPage = logoutSuccessPage;
    }

    @Generated
    public PPSKRegisterPageVO() {
    }
}

