/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.web.vo.ppsk.ppskpage;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.portal.api.web.vo.ppsk.ppskpage.PPSKDescriptionBackgroundVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

public class PPSKDescriptionWithTitleVO {
    @Schema(name="enable", description="Whether to enable description")
    @NotNull(message="Parameter [enable] of PPSKDescriptionWithTitleOpenApiVO must not be null.")
    private @NotNull(message="Parameter [enable] of PPSKDescriptionWithTitleOpenApiVO must not be null.") Boolean enable;
    @Schema(name="title", description="Description title content")
    @Length(max=128, message="Length of Parameter [title] should less than 128.")
    private @Length(max=128, message="Length of Parameter [title] should less than 128.") String title;
    @Schema(name="titleColor", description="Title color. Hex color code such as: #ffffff")
    @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Parameter [titleOpacity] is invalid.")
    private @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Parameter [titleOpacity] is invalid.") String titleColor;
    @Schema(name="titleOpacity", description="Title opacity, should be within the range of 0\u2013100")
    @Range(min=0L, max=100L, message="Parameter [titleOpacity] is from 0 to 100.")
    private @Range(min=0L, max=100L, message="Parameter [titleOpacity] is from 0 to 100.") Integer titleOpacity;
    @Schema(name="titleSize", description="Title size, should be within the range of 14\u201324")
    @Range(min=14L, max=24L, message="Parameter [titleSize] is from 14 to 24.")
    private @Range(min=14L, max=24L, message="Parameter [titleSize] is from 14 to 24.") Integer titleSize;
    @Schema(name="content", description="Description text content")
    @Length(max=4096, message="Length of Parameter [content] should less than 4096.")
    private @Length(max=4096, message="Length of Parameter [content] should less than 4096.") String content;
    @Schema(name="color", description="Text color. Hex color code such as: #ffffff")
    @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Parameter [color] is invalid.")
    private @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Parameter [color] is invalid.") String color;
    @Schema(name="opacity", description="Text opacity, should be within the range of 0\u2013100")
    @Range(min=0L, max=100L, message="Parameter [opacity] is from 0 to 100.")
    private @Range(min=0L, max=100L, message="Parameter [opacity] is from 0 to 100.") Integer opacity;
    @Schema(name="size", description="Text size, should be within the range of 10\u201314")
    @Range(min=10L, max=14L, message="Parameter [size] is from 10 to 14.")
    private @Range(min=10L, max=14L, message="Parameter [size] is from 10 to 14.") Integer size;
    @Valid
    @Schema(name="background", description="Description background setting")
    private PPSKDescriptionBackgroundVO background;

    @JsonIgnore
    public OperationResponse validate() {
        if (Boolean.TRUE.equals(this.enable)) {
            if (this.title == null) {
                return new OperationResponse(b.d, "Parameter [title] of PPSKDescriptionWithTitleOpenApiVO must not be null.", null);
            }
            if (this.titleColor == null) {
                return new OperationResponse(b.d, "Parameter [titleColor] of PPSKDescriptionWithTitleOpenApiVO must not be null.", null);
            }
            if (this.titleOpacity == null) {
                return new OperationResponse(b.d, "Parameter [titleOpacity] of PPSKDescriptionWithTitleOpenApiVO must not be null.", null);
            }
            if (this.titleSize == null) {
                return new OperationResponse(b.d, "Parameter [titleSize] of PPSKDescriptionWithTitleOpenApiVO must not be null.", null);
            }
            if (this.content == null) {
                return new OperationResponse(b.d, "Parameter [content] of PPSKDescriptionWithTitleOpenApiVO must not be null.", null);
            }
            if (this.color == null) {
                return new OperationResponse(b.d, "Parameter [color] of PPSKDescriptionWithTitleOpenApiVO must not be null.", null);
            }
            if (this.opacity == null) {
                return new OperationResponse(b.d, "Parameter [opacity] of PPSKDescriptionWithTitleOpenApiVO must not be null.", null);
            }
            if (this.size == null) {
                return new OperationResponse(b.d, "Parameter [size] of PPSKDescriptionWithTitleOpenApiVO must not be null.", null);
            }
            if (this.background != null) {
                return this.background.validate();
            }
        }
        return OperationResponse.SUCCESS;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getTitleColor() {
        return this.titleColor;
    }

    @Generated
    public Integer getTitleOpacity() {
        return this.titleOpacity;
    }

    @Generated
    public Integer getTitleSize() {
        return this.titleSize;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public String getColor() {
        return this.color;
    }

    @Generated
    public Integer getOpacity() {
        return this.opacity;
    }

    @Generated
    public Integer getSize() {
        return this.size;
    }

    @Generated
    public PPSKDescriptionBackgroundVO getBackground() {
        return this.background;
    }

    @Generated
    public PPSKDescriptionWithTitleVO setEnable(Boolean enable) {
        this.enable = enable;
        return this;
    }

    @Generated
    public PPSKDescriptionWithTitleVO setTitle(String title) {
        this.title = title;
        return this;
    }

    @Generated
    public PPSKDescriptionWithTitleVO setTitleColor(String titleColor) {
        this.titleColor = titleColor;
        return this;
    }

    @Generated
    public PPSKDescriptionWithTitleVO setTitleOpacity(Integer titleOpacity) {
        this.titleOpacity = titleOpacity;
        return this;
    }

    @Generated
    public PPSKDescriptionWithTitleVO setTitleSize(Integer titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    @Generated
    public PPSKDescriptionWithTitleVO setContent(String content) {
        this.content = content;
        return this;
    }

    @Generated
    public PPSKDescriptionWithTitleVO setColor(String color) {
        this.color = color;
        return this;
    }

    @Generated
    public PPSKDescriptionWithTitleVO setOpacity(Integer opacity) {
        this.opacity = opacity;
        return this;
    }

    @Generated
    public PPSKDescriptionWithTitleVO setSize(Integer size) {
        this.size = size;
        return this;
    }

    @Generated
    public PPSKDescriptionWithTitleVO setBackground(PPSKDescriptionBackgroundVO background) {
        this.background = background;
        return this;
    }

    @Generated
    public String toString() {
        return "PPSKDescriptionWithTitleVO(enable=" + this.getEnable() + ", title=" + this.getTitle() + ", titleColor=" + this.getTitleColor() + ", titleOpacity=" + this.getTitleOpacity() + ", titleSize=" + this.getTitleSize() + ", content=" + this.getContent() + ", color=" + this.getColor() + ", opacity=" + this.getOpacity() + ", size=" + this.getSize() + ", background=" + this.getBackground() + ")";
    }

    @Generated
    public PPSKDescriptionWithTitleVO(Boolean enable, String title, String titleColor, Integer titleOpacity, Integer titleSize, String content, String color, Integer opacity, Integer size, PPSKDescriptionBackgroundVO background) {
        this.enable = enable;
        this.title = title;
        this.titleColor = titleColor;
        this.titleOpacity = titleOpacity;
        this.titleSize = titleSize;
        this.content = content;
        this.color = color;
        this.opacity = opacity;
        this.size = size;
        this.background = background;
    }

    @Generated
    public PPSKDescriptionWithTitleVO() {
    }
}

