/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.web.vo.ppsk.ppskpage;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

public class PPSKDescriptionVO {
    @Schema(name="enable", description="Whether to enable description")
    @NotNull(message="Parameter [enable] of PPSKDescriptionOpenApiVO must not be null.")
    private @NotNull(message="Parameter [enable] of PPSKDescriptionOpenApiVO must not be null.") Boolean enable;
    @Schema(name="content", description="Description content")
    @Length(max=4096, message="Length of Parameter [content] should less than 4096.")
    private @Length(max=4096, message="Length of Parameter [content] should less than 4096.") String content;
    @Schema(name="color", description="Description color. Hex color code such as: #ffffff")
    @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Parameter [color] is invalid.")
    private @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Parameter [color] is invalid.") String color;
    @Schema(name="opacity", description="Description opacity, should be within the range of 0\u2013100")
    @Range(min=0L, max=100L, message="Parameter [opacity] is from 0 to 100.")
    private @Range(min=0L, max=100L, message="Parameter [opacity] is from 0 to 100.") Integer opacity;
    @Schema(name="size", description="Description size, should be within the range of 12\u201318")
    @Range(min=12L, max=18L, message="Parameter [size] is from 12 to 18.")
    private @Range(min=12L, max=18L, message="Parameter [size] is from 12 to 18.") Integer size;

    @JsonIgnore
    public OperationResponse validate() {
        if (Boolean.TRUE.equals(this.enable)) {
            if (this.content == null) {
                return new OperationResponse(b.d, "Parameter [content] of PPSKDescriptionOpenApiVO must not be null.", null);
            }
            if (this.color == null) {
                return new OperationResponse(b.d, "Parameter [color] of PPSKDescriptionOpenApiVO must not be null.", null);
            }
            if (this.opacity == null) {
                return new OperationResponse(b.d, "Parameter [opacity] of PPSKDescriptionOpenApiVO must not be null.", null);
            }
            if (this.size == null) {
                return new OperationResponse(b.d, "Parameter [size] of PPSKDescriptionOpenApiVO must not be null.", null);
            }
        }
        return OperationResponse.SUCCESS;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public String getColor() {
        return this.color;
    }

    @Generated
    public Integer getOpacity() {
        return this.opacity;
    }

    @Generated
    public Integer getSize() {
        return this.size;
    }

    @Generated
    public PPSKDescriptionVO setEnable(Boolean enable) {
        this.enable = enable;
        return this;
    }

    @Generated
    public PPSKDescriptionVO setContent(String content) {
        this.content = content;
        return this;
    }

    @Generated
    public PPSKDescriptionVO setColor(String color) {
        this.color = color;
        return this;
    }

    @Generated
    public PPSKDescriptionVO setOpacity(Integer opacity) {
        this.opacity = opacity;
        return this;
    }

    @Generated
    public PPSKDescriptionVO setSize(Integer size) {
        this.size = size;
        return this;
    }

    @Generated
    public String toString() {
        return "PPSKDescriptionVO(enable=" + this.getEnable() + ", content=" + this.getContent() + ", color=" + this.getColor() + ", opacity=" + this.getOpacity() + ", size=" + this.getSize() + ")";
    }

    @Generated
    public PPSKDescriptionVO(Boolean enable, String content, String color, Integer opacity, Integer size) {
        this.enable = enable;
        this.content = content;
        this.color = color;
        this.opacity = opacity;
        this.size = size;
    }

    @Generated
    public PPSKDescriptionVO() {
    }
}

