/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.web.vo.ppsk.ppskpage;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

public class PPSKButtonVO {
    @Schema(name="text", description="Button text content")
    @Length(max=32, message="Length of Parameter [text] should less than 32.")
    @NotNull(message="Parameter [text] of PPSKButtonOpenApiVO must not be null.")
    private @Length(max=32, message="Length of Parameter [text] should less than 32.") @NotNull(message="Parameter [text] of PPSKButtonOpenApiVO must not be null.") String text;
    @Schema(name="textSize", description="Button text size, should be within the range of 16\u201324")
    @Range(min=16L, max=24L, message="Parameter [textSize] is from 16 to 24.")
    @NotNull(message="Parameter [textSize] of PPSKButtonOpenApiVO must not be null.")
    private @Range(min=16L, max=24L, message="Parameter [textSize] is from 16 to 24.") @NotNull(message="Parameter [textSize] of PPSKButtonOpenApiVO must not be null.") Integer textSize;
    @Schema(name="textColor", description="Button text color. Hex color code such as: #ffffff")
    @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Parameter [textColor] is invalid.")
    @NotNull(message="Parameter [textColor] of PPSKButtonOpenApiVO must not be null.")
    private @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Parameter [textColor] is invalid.") @NotNull(message="Parameter [textColor] of PPSKButtonOpenApiVO must not be null.") String textColor;
    @Schema(name="textOpacity", description="Button text opacity, should be within the range of 0\u2013100")
    @Range(min=0L, max=100L, message="Parameter [textOpacity] is from 0 to 100.")
    @NotNull(message="Parameter [textOpacity] of PPSKButtonOpenApiVO must not be null.")
    private @Range(min=0L, max=100L, message="Parameter [textOpacity] is from 0 to 100.") @NotNull(message="Parameter [textOpacity] of PPSKButtonOpenApiVO must not be null.") Integer textOpacity;
    @Schema(name="buttonColor", description="Button color. Hex color code such as: #ffffff")
    @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Parameter [buttonColor] is invalid.")
    @NotNull(message="Parameter [buttonColor] of PPSKButtonOpenApiVO must not be null.")
    private @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Parameter [buttonColor] is invalid.") @NotNull(message="Parameter [buttonColor] of PPSKButtonOpenApiVO must not be null.") String buttonColor;
    @Schema(name="buttonOpacity", description="Button opacity, should be within the range of 0\u2013100")
    @Range(min=0L, max=100L, message="Parameter [buttonOpacity] is from 0 to 100.")
    @NotNull(message="Parameter [buttonOpacity] of PPSKButtonOpenApiVO must not be null.")
    private @Range(min=0L, max=100L, message="Parameter [buttonOpacity] is from 0 to 100.") @NotNull(message="Parameter [buttonOpacity] of PPSKButtonOpenApiVO must not be null.") Integer buttonOpacity;

    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public Integer getTextSize() {
        return this.textSize;
    }

    @Generated
    public String getTextColor() {
        return this.textColor;
    }

    @Generated
    public Integer getTextOpacity() {
        return this.textOpacity;
    }

    @Generated
    public String getButtonColor() {
        return this.buttonColor;
    }

    @Generated
    public Integer getButtonOpacity() {
        return this.buttonOpacity;
    }

    @Generated
    public PPSKButtonVO setText(String text) {
        this.text = text;
        return this;
    }

    @Generated
    public PPSKButtonVO setTextSize(Integer textSize) {
        this.textSize = textSize;
        return this;
    }

    @Generated
    public PPSKButtonVO setTextColor(String textColor) {
        this.textColor = textColor;
        return this;
    }

    @Generated
    public PPSKButtonVO setTextOpacity(Integer textOpacity) {
        this.textOpacity = textOpacity;
        return this;
    }

    @Generated
    public PPSKButtonVO setButtonColor(String buttonColor) {
        this.buttonColor = buttonColor;
        return this;
    }

    @Generated
    public PPSKButtonVO setButtonOpacity(Integer buttonOpacity) {
        this.buttonOpacity = buttonOpacity;
        return this;
    }

    @Generated
    public String toString() {
        return "PPSKButtonVO(text=" + this.getText() + ", textSize=" + this.getTextSize() + ", textColor=" + this.getTextColor() + ", textOpacity=" + this.getTextOpacity() + ", buttonColor=" + this.getButtonColor() + ", buttonOpacity=" + this.getButtonOpacity() + ")";
    }

    @Generated
    public PPSKButtonVO(String text, Integer textSize, String textColor, Integer textOpacity, String buttonColor, Integer buttonOpacity) {
        this.text = text;
        this.textSize = textSize;
        this.textColor = textColor;
        this.textOpacity = textOpacity;
        this.buttonColor = buttonColor;
        this.buttonOpacity = buttonOpacity;
    }

    @Generated
    public PPSKButtonVO() {
    }
}

