/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.web.vo.ppsk.ppskpage;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.portal.api.web.vo.ppsk.ppskpage.PPSKDescriptionBackgroundVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

public class PPSKAgreementiVO {
    @Schema(name="content", description="Agreement text content")
    @Length(max=4096, message="Length of Parameter [content] should less than 4096.")
    @NotNull(message="Parameter [content] of PPSKAgreementOpenApiVO must not be null.")
    private @Length(max=4096, message="Length of Parameter [content] should less than 4096.") @NotNull(message="Parameter [content] of PPSKAgreementOpenApiVO must not be null.") String content;
    @Schema(name="color", description="Agreement text color. Hex color code such as: #ffffff")
    @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Parameter [color] is invalid.")
    @NotNull(message="Parameter [color] of PPSKAgreementOpenApiVO must not be null.")
    private @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Parameter [color] is invalid.") @NotNull(message="Parameter [color] of PPSKAgreementOpenApiVO must not be null.") String color;
    @Schema(name="opacity", description="Agreement text opacity, should be within the range of 0\u2013100")
    @Range(min=0L, max=100L, message="Parameter [opacity] is from 0 to 100.")
    @NotNull(message="Parameter [opacity] of PPSKAgreementOpenApiVO must not be null.")
    private @Range(min=0L, max=100L, message="Parameter [opacity] is from 0 to 100.") @NotNull(message="Parameter [opacity] of PPSKAgreementOpenApiVO must not be null.") Integer opacity;
    @Schema(name="size", description="Agreement text size, should be within the range of 12\u201318")
    @Range(min=12L, max=18L, message="Parameter [size] is from 12 to 18.")
    @NotNull(message="Parameter [size] of PPSKAgreementOpenApiVO must not be null.")
    private @Range(min=12L, max=18L, message="Parameter [size] is from 12 to 18.") @NotNull(message="Parameter [size] of PPSKAgreementOpenApiVO must not be null.") Integer size;
    @Schema(name="checkColor", description="Agreement checkbox check mark color. Hex color code such as: #ffffff")
    @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Parameter [checkColor] is invalid.")
    @NotNull(message="Parameter [checkColor] of PPSKAgreementOpenApiVO must not be null.")
    private @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Parameter [checkColor] is invalid.") @NotNull(message="Parameter [checkColor] of PPSKAgreementOpenApiVO must not be null.") String checkColor;
    @Schema(name="checkOpacity", description="Agreement checkbox check mark opacity, should be within the range of 0\u2013100")
    @Range(min=0L, max=100L, message="Parameter [checkOpacity] is from 0 to 100.")
    @NotNull(message="Parameter [checkOpacity] of PPSKAgreementOpenApiVO must not be null.")
    private @Range(min=0L, max=100L, message="Parameter [checkOpacity] is from 0 to 100.") @NotNull(message="Parameter [checkOpacity] of PPSKAgreementOpenApiVO must not be null.") Integer checkOpacity;
    @Schema(name="checkBackgroundColor", description="Agreement checkbox background color. Hex color code such as: #ffffff")
    @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Parameter [checkBackgroundColor] is invalid.")
    @NotNull(message="Parameter [checkBackgroundColor] of PPSKAgreementOpenApiVO must not be null.")
    private @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Parameter [checkBackgroundColor] is invalid.") @NotNull(message="Parameter [checkBackgroundColor] of PPSKAgreementOpenApiVO must not be null.") String checkBackgroundColor;
    @Schema(name="checkBackgroundOpacity", description="Agreement checkbox background opacity, should be within the range of 0\u2013100")
    @Range(min=0L, max=100L, message="Parameter [checkBackgroundOpacity] is from 0 to 100.")
    @NotNull(message="Parameter [checkBackgroundOpacity] of PPSKAgreementOpenApiVO must not be null.")
    private @Range(min=0L, max=100L, message="Parameter [checkBackgroundOpacity] is from 0 to 100.") @NotNull(message="Parameter [checkBackgroundOpacity] of PPSKAgreementOpenApiVO must not be null.") Integer checkBackgroundOpacity;
    @Valid
    @Schema(name="background", description="Agreement background setting")
    private PPSKDescriptionBackgroundVO background;

    @JsonIgnore
    public OperationResponse validate() {
        if (this.background != null) {
            return this.background.validate();
        }
        return OperationResponse.SUCCESS;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public String getColor() {
        return this.color;
    }

    @Generated
    public Integer getOpacity() {
        return this.opacity;
    }

    @Generated
    public Integer getSize() {
        return this.size;
    }

    @Generated
    public String getCheckColor() {
        return this.checkColor;
    }

    @Generated
    public Integer getCheckOpacity() {
        return this.checkOpacity;
    }

    @Generated
    public String getCheckBackgroundColor() {
        return this.checkBackgroundColor;
    }

    @Generated
    public Integer getCheckBackgroundOpacity() {
        return this.checkBackgroundOpacity;
    }

    @Generated
    public PPSKDescriptionBackgroundVO getBackground() {
        return this.background;
    }

    @Generated
    public PPSKAgreementiVO setContent(String content) {
        this.content = content;
        return this;
    }

    @Generated
    public PPSKAgreementiVO setColor(String color) {
        this.color = color;
        return this;
    }

    @Generated
    public PPSKAgreementiVO setOpacity(Integer opacity) {
        this.opacity = opacity;
        return this;
    }

    @Generated
    public PPSKAgreementiVO setSize(Integer size) {
        this.size = size;
        return this;
    }

    @Generated
    public PPSKAgreementiVO setCheckColor(String checkColor) {
        this.checkColor = checkColor;
        return this;
    }

    @Generated
    public PPSKAgreementiVO setCheckOpacity(Integer checkOpacity) {
        this.checkOpacity = checkOpacity;
        return this;
    }

    @Generated
    public PPSKAgreementiVO setCheckBackgroundColor(String checkBackgroundColor) {
        this.checkBackgroundColor = checkBackgroundColor;
        return this;
    }

    @Generated
    public PPSKAgreementiVO setCheckBackgroundOpacity(Integer checkBackgroundOpacity) {
        this.checkBackgroundOpacity = checkBackgroundOpacity;
        return this;
    }

    @Generated
    public PPSKAgreementiVO setBackground(PPSKDescriptionBackgroundVO background) {
        this.background = background;
        return this;
    }

    @Generated
    public String toString() {
        return "PPSKAgreementiVO(content=" + this.getContent() + ", color=" + this.getColor() + ", opacity=" + this.getOpacity() + ", size=" + this.getSize() + ", checkColor=" + this.getCheckColor() + ", checkOpacity=" + this.getCheckOpacity() + ", checkBackgroundColor=" + this.getCheckBackgroundColor() + ", checkBackgroundOpacity=" + this.getCheckBackgroundOpacity() + ", background=" + this.getBackground() + ")";
    }

    @Generated
    public PPSKAgreementiVO(String content, String color, Integer opacity, Integer size, String checkColor, Integer checkOpacity, String checkBackgroundColor, Integer checkBackgroundOpacity, PPSKDescriptionBackgroundVO background) {
        this.content = content;
        this.color = color;
        this.opacity = opacity;
        this.size = size;
        this.checkColor = checkColor;
        this.checkOpacity = checkOpacity;
        this.checkBackgroundColor = checkBackgroundColor;
        this.checkBackgroundOpacity = checkBackgroundOpacity;
        this.background = background;
    }

    @Generated
    public PPSKAgreementiVO() {
    }
}

