/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.web.vo;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.portal.api.web.vo.AdvertisementSettingVO;
import com.tplink.smb.omada.portal.api.web.vo.PortalPictureVO;
import com.tplink.smb.omada.portal.api.web.vo.TermsOfServiceUrlVO;
import com.tplink.smb.omada.portal.api.web.vo.validate.a.a;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

public class PortalCustomizeVO {
    @NotNull(message="portalCustomize parameter [defaultLanguage] should not be null")
    private @NotNull(message="portalCustomize parameter [defaultLanguage] should not be null") Integer defaultLanguage;
    @NotNull(message="portalCustomize parameter [background] should not be null")
    @NumberSet(value={1, 2})
    @Range(min=1L, max=1L, message="Basic user only support using solid color background", groups={a.b.class})
    private @NotNull(message="portalCustomize parameter [background] should not be null") @Range(min=1L, max=1L, message="Basic user only support using solid color background", groups={a.b.class}) Integer background;
    private String backgroundPictureId;
    private String mobileBackgroundPictureId;
    private PortalPictureVO backgroundPicture;
    private PortalPictureVO mobileBackgroundPicture;
    @Pattern(regexp="^#[0-9A-Fa-f]{6}$")
    private @Pattern(regexp="^#[0-9A-Fa-f]{6}$") String backgroundColor;
    @Max(value=100L)
    private @Max(value=100L) Integer backgroundOpacity;
    private String logoPictureId;
    private PortalPictureVO logoPicture;
    @NumberSet(value={1, 2, 3})
    private Integer logoPosition;
    @NotNull(message="portalCustomize parameter [logoDisplay] should not be null")
    private @NotNull(message="portalCustomize parameter [logoDisplay] should not be null") Boolean logoDisplay;
    @Range(min=30L, max=100L, message="Value of logo size is from 30 to 100.")
    private @Range(min=30L, max=100L, message="Value of logo size is from 30 to 100.") Integer logoSize;
    @Range(min=0L, max=100L, message="Value of ratio is from 1 to 100.")
    private @Range(min=0L, max=100L, message="Value of ratio is from 1 to 100.") Float logoPositionRatio;
    @Min(value=0L)
    private @Min(value=0L) Integer logoTranslate;
    @Pattern(regexp="^#[0-9A-Fa-f]{6}$")
    private @Pattern(regexp="^#[0-9A-Fa-f]{6}$") String inputBoxColor;
    @Max(value=100L)
    private @Max(value=100L) Integer inputBoxOpacity;
    @Pattern(regexp="^#[0-9A-Fa-f]{6}$")
    private @Pattern(regexp="^#[0-9A-Fa-f]{6}$") String inputTextColor;
    @Max(value=100L)
    private @Max(value=100L) Integer inputTextOpacity;
    @Pattern(regexp="^#[0-9A-Fa-f]{6}$")
    private @Pattern(regexp="^#[0-9A-Fa-f]{6}$") String buttonColor;
    @Max(value=100L)
    private @Max(value=100L) Integer buttonOpacity;
    @Pattern(regexp="^#[0-9A-Fa-f]{6}$")
    private @Pattern(regexp="^#[0-9A-Fa-f]{6}$") String buttonTextColor;
    @Max(value=100L)
    private @Max(value=100L) Integer buttonTextOpacity;
    @NumberSet(value={1, 2, 3})
    private Integer buttonPosition;
    @Length(max=64, message="Length of button text should less than 64.")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$")
    private @Length(max=64, message="Length of button text should less than 64.") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$") String buttonText;
    @Length(max=64, message="Length of button text should less than 64.")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$")
    private @Length(max=64, message="Length of button text should less than 64.") @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$") String formAuthButtonText;
    @Range(min=0L, max=100L, message="Value of ratio is from 1 to 100.")
    private @Range(min=0L, max=100L, message="Value of ratio is from 1 to 100.") Float buttonPositionRatio;
    @Min(value=0L)
    private @Min(value=0L) Integer buttonTranslate;
    @NotNull(message="portalCustomize parameter [welcomeEnable] should not be null")
    private @NotNull(message="portalCustomize parameter [welcomeEnable] should not be null") Boolean welcomeEnable;
    @Pattern(regexp="^.{1,31}$")
    private @Pattern(regexp="^.{1,31}$") String welcomeInformation;
    @Pattern(regexp="^#[0-9A-Fa-f]{6}$")
    private @Pattern(regexp="^#[0-9A-Fa-f]{6}$") String welcomeTextColor;
    @Range(min=0L, max=100L, message="Value of opacity is from 0 to 100.")
    private @Range(min=0L, max=100L, message="Value of opacity is from 0 to 100.") Integer welcomeTextOpacity;
    @Range(min=12L, max=18L, message="font size ranges from 12 to 18.")
    private @Range(min=12L, max=18L, message="font size ranges from 12 to 18.") Integer welcomeTextFontSize;
    @NotNull(message="portalCustomize parameter [termsOfServiceEnable] should not be null")
    private @NotNull(message="portalCustomize parameter [termsOfServiceEnable] should not be null") Boolean termsOfServiceEnable;
    @Length(max=65535, message="Length of terms of service should less than 65535.")
    private @Length(max=65535, message="Length of terms of service should less than 65535.") String termsOfService;
    @Length(max=100, message="Length of terms of service should less than 100.")
    private @Length(max=100, message="Length of terms of service should less than 100.") String termsOfServiceText;
    @Range(min=12L, max=18L, message="font size ranges from 12 to 18.")
    private @Range(min=12L, max=18L, message="font size ranges from 12 to 18.") Integer termsOfServiceFontSize;
    @Size(max=3, message="Size of terms of service urls should be less than 3")
    @Valid
    private @Size(max=3, message="Size of terms of service urls should be less than 3") @Valid List<TermsOfServiceUrlVO> termsOfServiceUrlTexts;
    @NotNull(message="portalCustomize parameter [copyrightEnable] should not be null")
    private @NotNull(message="portalCustomize parameter [copyrightEnable] should not be null") Boolean copyrightEnable;
    @Length(max=200, message="Length of Copyright should less than 200.")
    private @Length(max=200, message="Length of Copyright should less than 200.") String copyright;
    @Pattern(regexp="^#[0-9A-Fa-f]{6}$")
    private @Pattern(regexp="^#[0-9A-Fa-f]{6}$") String copyrightTextColor;
    @Max(value=100L)
    private @Max(value=100L) Integer copyrightTextOpacity;
    @Range(min=12L, max=18L, message="font size ranges from 12 to 18.")
    private @Range(min=12L, max=18L, message="font size ranges from 12 to 18.") Integer copyrightTextFontSize;
    private Boolean redirectionCountDownEnable;
    @Valid
    private AdvertisementSettingVO advertisement;

    @Generated
    public static PortalCustomizeVOBuilder builder() {
        return new PortalCustomizeVOBuilder();
    }

    @Generated
    public Integer getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @Generated
    public Integer getBackground() {
        return this.background;
    }

    @Generated
    public String getBackgroundPictureId() {
        return this.backgroundPictureId;
    }

    @Generated
    public String getMobileBackgroundPictureId() {
        return this.mobileBackgroundPictureId;
    }

    @Generated
    public PortalPictureVO getBackgroundPicture() {
        return this.backgroundPicture;
    }

    @Generated
    public PortalPictureVO getMobileBackgroundPicture() {
        return this.mobileBackgroundPicture;
    }

    @Generated
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    @Generated
    public Integer getBackgroundOpacity() {
        return this.backgroundOpacity;
    }

    @Generated
    public String getLogoPictureId() {
        return this.logoPictureId;
    }

    @Generated
    public PortalPictureVO getLogoPicture() {
        return this.logoPicture;
    }

    @Generated
    public Integer getLogoPosition() {
        return this.logoPosition;
    }

    @Generated
    public Boolean getLogoDisplay() {
        return this.logoDisplay;
    }

    @Generated
    public Integer getLogoSize() {
        return this.logoSize;
    }

    @Generated
    public Float getLogoPositionRatio() {
        return this.logoPositionRatio;
    }

    @Generated
    public Integer getLogoTranslate() {
        return this.logoTranslate;
    }

    @Generated
    public String getInputBoxColor() {
        return this.inputBoxColor;
    }

    @Generated
    public Integer getInputBoxOpacity() {
        return this.inputBoxOpacity;
    }

    @Generated
    public String getInputTextColor() {
        return this.inputTextColor;
    }

    @Generated
    public Integer getInputTextOpacity() {
        return this.inputTextOpacity;
    }

    @Generated
    public String getButtonColor() {
        return this.buttonColor;
    }

    @Generated
    public Integer getButtonOpacity() {
        return this.buttonOpacity;
    }

    @Generated
    public String getButtonTextColor() {
        return this.buttonTextColor;
    }

    @Generated
    public Integer getButtonTextOpacity() {
        return this.buttonTextOpacity;
    }

    @Generated
    public Integer getButtonPosition() {
        return this.buttonPosition;
    }

    @Generated
    public String getButtonText() {
        return this.buttonText;
    }

    @Generated
    public String getFormAuthButtonText() {
        return this.formAuthButtonText;
    }

    @Generated
    public Float getButtonPositionRatio() {
        return this.buttonPositionRatio;
    }

    @Generated
    public Integer getButtonTranslate() {
        return this.buttonTranslate;
    }

    @Generated
    public Boolean getWelcomeEnable() {
        return this.welcomeEnable;
    }

    @Generated
    public String getWelcomeInformation() {
        return this.welcomeInformation;
    }

    @Generated
    public String getWelcomeTextColor() {
        return this.welcomeTextColor;
    }

    @Generated
    public Integer getWelcomeTextOpacity() {
        return this.welcomeTextOpacity;
    }

    @Generated
    public Integer getWelcomeTextFontSize() {
        return this.welcomeTextFontSize;
    }

    @Generated
    public Boolean getTermsOfServiceEnable() {
        return this.termsOfServiceEnable;
    }

    @Generated
    public String getTermsOfService() {
        return this.termsOfService;
    }

    @Generated
    public String getTermsOfServiceText() {
        return this.termsOfServiceText;
    }

    @Generated
    public Integer getTermsOfServiceFontSize() {
        return this.termsOfServiceFontSize;
    }

    @Generated
    public List<TermsOfServiceUrlVO> getTermsOfServiceUrlTexts() {
        return this.termsOfServiceUrlTexts;
    }

    @Generated
    public Boolean getCopyrightEnable() {
        return this.copyrightEnable;
    }

    @Generated
    public String getCopyright() {
        return this.copyright;
    }

    @Generated
    public String getCopyrightTextColor() {
        return this.copyrightTextColor;
    }

    @Generated
    public Integer getCopyrightTextOpacity() {
        return this.copyrightTextOpacity;
    }

    @Generated
    public Integer getCopyrightTextFontSize() {
        return this.copyrightTextFontSize;
    }

    @Generated
    public Boolean getRedirectionCountDownEnable() {
        return this.redirectionCountDownEnable;
    }

    @Generated
    public AdvertisementSettingVO getAdvertisement() {
        return this.advertisement;
    }

    @Generated
    private void setDefaultLanguage(Integer defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    @Generated
    private void setBackground(Integer background) {
        this.background = background;
    }

    @Generated
    private void setBackgroundPictureId(String backgroundPictureId) {
        this.backgroundPictureId = backgroundPictureId;
    }

    @Generated
    private void setMobileBackgroundPictureId(String mobileBackgroundPictureId) {
        this.mobileBackgroundPictureId = mobileBackgroundPictureId;
    }

    @Generated
    private void setBackgroundPicture(PortalPictureVO backgroundPicture) {
        this.backgroundPicture = backgroundPicture;
    }

    @Generated
    private void setMobileBackgroundPicture(PortalPictureVO mobileBackgroundPicture) {
        this.mobileBackgroundPicture = mobileBackgroundPicture;
    }

    @Generated
    private void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Generated
    private void setBackgroundOpacity(Integer backgroundOpacity) {
        this.backgroundOpacity = backgroundOpacity;
    }

    @Generated
    private void setLogoPictureId(String logoPictureId) {
        this.logoPictureId = logoPictureId;
    }

    @Generated
    private void setLogoPicture(PortalPictureVO logoPicture) {
        this.logoPicture = logoPicture;
    }

    @Generated
    private void setLogoPosition(Integer logoPosition) {
        this.logoPosition = logoPosition;
    }

    @Generated
    private void setLogoDisplay(Boolean logoDisplay) {
        this.logoDisplay = logoDisplay;
    }

    @Generated
    private void setLogoSize(Integer logoSize) {
        this.logoSize = logoSize;
    }

    @Generated
    private void setLogoPositionRatio(Float logoPositionRatio) {
        this.logoPositionRatio = logoPositionRatio;
    }

    @Generated
    private void setLogoTranslate(Integer logoTranslate) {
        this.logoTranslate = logoTranslate;
    }

    @Generated
    private void setInputBoxColor(String inputBoxColor) {
        this.inputBoxColor = inputBoxColor;
    }

    @Generated
    private void setInputBoxOpacity(Integer inputBoxOpacity) {
        this.inputBoxOpacity = inputBoxOpacity;
    }

    @Generated
    private void setInputTextColor(String inputTextColor) {
        this.inputTextColor = inputTextColor;
    }

    @Generated
    private void setInputTextOpacity(Integer inputTextOpacity) {
        this.inputTextOpacity = inputTextOpacity;
    }

    @Generated
    private void setButtonColor(String buttonColor) {
        this.buttonColor = buttonColor;
    }

    @Generated
    private void setButtonOpacity(Integer buttonOpacity) {
        this.buttonOpacity = buttonOpacity;
    }

    @Generated
    private void setButtonTextColor(String buttonTextColor) {
        this.buttonTextColor = buttonTextColor;
    }

    @Generated
    private void setButtonTextOpacity(Integer buttonTextOpacity) {
        this.buttonTextOpacity = buttonTextOpacity;
    }

    @Generated
    private void setButtonPosition(Integer buttonPosition) {
        this.buttonPosition = buttonPosition;
    }

    @Generated
    private void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    @Generated
    private void setFormAuthButtonText(String formAuthButtonText) {
        this.formAuthButtonText = formAuthButtonText;
    }

    @Generated
    private void setButtonPositionRatio(Float buttonPositionRatio) {
        this.buttonPositionRatio = buttonPositionRatio;
    }

    @Generated
    private void setButtonTranslate(Integer buttonTranslate) {
        this.buttonTranslate = buttonTranslate;
    }

    @Generated
    private void setWelcomeEnable(Boolean welcomeEnable) {
        this.welcomeEnable = welcomeEnable;
    }

    @Generated
    private void setWelcomeInformation(String welcomeInformation) {
        this.welcomeInformation = welcomeInformation;
    }

    @Generated
    private void setWelcomeTextColor(String welcomeTextColor) {
        this.welcomeTextColor = welcomeTextColor;
    }

    @Generated
    private void setWelcomeTextOpacity(Integer welcomeTextOpacity) {
        this.welcomeTextOpacity = welcomeTextOpacity;
    }

    @Generated
    private void setWelcomeTextFontSize(Integer welcomeTextFontSize) {
        this.welcomeTextFontSize = welcomeTextFontSize;
    }

    @Generated
    private void setTermsOfServiceEnable(Boolean termsOfServiceEnable) {
        this.termsOfServiceEnable = termsOfServiceEnable;
    }

    @Generated
    private void setTermsOfService(String termsOfService) {
        this.termsOfService = termsOfService;
    }

    @Generated
    private void setTermsOfServiceText(String termsOfServiceText) {
        this.termsOfServiceText = termsOfServiceText;
    }

    @Generated
    private void setTermsOfServiceFontSize(Integer termsOfServiceFontSize) {
        this.termsOfServiceFontSize = termsOfServiceFontSize;
    }

    @Generated
    private void setTermsOfServiceUrlTexts(List<TermsOfServiceUrlVO> termsOfServiceUrlTexts) {
        this.termsOfServiceUrlTexts = termsOfServiceUrlTexts;
    }

    @Generated
    private void setCopyrightEnable(Boolean copyrightEnable) {
        this.copyrightEnable = copyrightEnable;
    }

    @Generated
    private void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    @Generated
    private void setCopyrightTextColor(String copyrightTextColor) {
        this.copyrightTextColor = copyrightTextColor;
    }

    @Generated
    private void setCopyrightTextOpacity(Integer copyrightTextOpacity) {
        this.copyrightTextOpacity = copyrightTextOpacity;
    }

    @Generated
    private void setCopyrightTextFontSize(Integer copyrightTextFontSize) {
        this.copyrightTextFontSize = copyrightTextFontSize;
    }

    @Generated
    private void setRedirectionCountDownEnable(Boolean redirectionCountDownEnable) {
        this.redirectionCountDownEnable = redirectionCountDownEnable;
    }

    @Generated
    private void setAdvertisement(AdvertisementSettingVO advertisement) {
        this.advertisement = advertisement;
    }

    @Generated
    public String toString() {
        return "PortalCustomizeVO(defaultLanguage=" + this.getDefaultLanguage() + ", background=" + this.getBackground() + ", backgroundPictureId=" + this.getBackgroundPictureId() + ", mobileBackgroundPictureId=" + this.getMobileBackgroundPictureId() + ", backgroundPicture=" + this.getBackgroundPicture() + ", mobileBackgroundPicture=" + this.getMobileBackgroundPicture() + ", backgroundColor=" + this.getBackgroundColor() + ", backgroundOpacity=" + this.getBackgroundOpacity() + ", logoPictureId=" + this.getLogoPictureId() + ", logoPicture=" + this.getLogoPicture() + ", logoPosition=" + this.getLogoPosition() + ", logoDisplay=" + this.getLogoDisplay() + ", logoSize=" + this.getLogoSize() + ", logoPositionRatio=" + this.getLogoPositionRatio() + ", logoTranslate=" + this.getLogoTranslate() + ", inputBoxColor=" + this.getInputBoxColor() + ", inputBoxOpacity=" + this.getInputBoxOpacity() + ", inputTextColor=" + this.getInputTextColor() + ", inputTextOpacity=" + this.getInputTextOpacity() + ", buttonColor=" + this.getButtonColor() + ", buttonOpacity=" + this.getButtonOpacity() + ", buttonTextColor=" + this.getButtonTextColor() + ", buttonTextOpacity=" + this.getButtonTextOpacity() + ", buttonPosition=" + this.getButtonPosition() + ", buttonText=" + this.getButtonText() + ", formAuthButtonText=" + this.getFormAuthButtonText() + ", buttonPositionRatio=" + this.getButtonPositionRatio() + ", buttonTranslate=" + this.getButtonTranslate() + ", welcomeEnable=" + this.getWelcomeEnable() + ", welcomeInformation=" + this.getWelcomeInformation() + ", welcomeTextColor=" + this.getWelcomeTextColor() + ", welcomeTextOpacity=" + this.getWelcomeTextOpacity() + ", welcomeTextFontSize=" + this.getWelcomeTextFontSize() + ", termsOfServiceEnable=" + this.getTermsOfServiceEnable() + ", termsOfService=" + this.getTermsOfService() + ", termsOfServiceText=" + this.getTermsOfServiceText() + ", termsOfServiceFontSize=" + this.getTermsOfServiceFontSize() + ", termsOfServiceUrlTexts=" + this.getTermsOfServiceUrlTexts() + ", copyrightEnable=" + this.getCopyrightEnable() + ", copyright=" + this.getCopyright() + ", copyrightTextColor=" + this.getCopyrightTextColor() + ", copyrightTextOpacity=" + this.getCopyrightTextOpacity() + ", copyrightTextFontSize=" + this.getCopyrightTextFontSize() + ", redirectionCountDownEnable=" + this.getRedirectionCountDownEnable() + ", advertisement=" + this.getAdvertisement() + ")";
    }

    @Generated
    public PortalCustomizeVO(Integer defaultLanguage, Integer background, String backgroundPictureId, String mobileBackgroundPictureId, PortalPictureVO backgroundPicture, PortalPictureVO mobileBackgroundPicture, String backgroundColor, Integer backgroundOpacity, String logoPictureId, PortalPictureVO logoPicture, Integer logoPosition, Boolean logoDisplay, Integer logoSize, Float logoPositionRatio, Integer logoTranslate, String inputBoxColor, Integer inputBoxOpacity, String inputTextColor, Integer inputTextOpacity, String buttonColor, Integer buttonOpacity, String buttonTextColor, Integer buttonTextOpacity, Integer buttonPosition, String buttonText, String formAuthButtonText, Float buttonPositionRatio, Integer buttonTranslate, Boolean welcomeEnable, String welcomeInformation, String welcomeTextColor, Integer welcomeTextOpacity, Integer welcomeTextFontSize, Boolean termsOfServiceEnable, String termsOfService, String termsOfServiceText, Integer termsOfServiceFontSize, List<TermsOfServiceUrlVO> termsOfServiceUrlTexts, Boolean copyrightEnable, String copyright, String copyrightTextColor, Integer copyrightTextOpacity, Integer copyrightTextFontSize, Boolean redirectionCountDownEnable, AdvertisementSettingVO advertisement) {
        this.defaultLanguage = defaultLanguage;
        this.background = background;
        this.backgroundPictureId = backgroundPictureId;
        this.mobileBackgroundPictureId = mobileBackgroundPictureId;
        this.backgroundPicture = backgroundPicture;
        this.mobileBackgroundPicture = mobileBackgroundPicture;
        this.backgroundColor = backgroundColor;
        this.backgroundOpacity = backgroundOpacity;
        this.logoPictureId = logoPictureId;
        this.logoPicture = logoPicture;
        this.logoPosition = logoPosition;
        this.logoDisplay = logoDisplay;
        this.logoSize = logoSize;
        this.logoPositionRatio = logoPositionRatio;
        this.logoTranslate = logoTranslate;
        this.inputBoxColor = inputBoxColor;
        this.inputBoxOpacity = inputBoxOpacity;
        this.inputTextColor = inputTextColor;
        this.inputTextOpacity = inputTextOpacity;
        this.buttonColor = buttonColor;
        this.buttonOpacity = buttonOpacity;
        this.buttonTextColor = buttonTextColor;
        this.buttonTextOpacity = buttonTextOpacity;
        this.buttonPosition = buttonPosition;
        this.buttonText = buttonText;
        this.formAuthButtonText = formAuthButtonText;
        this.buttonPositionRatio = buttonPositionRatio;
        this.buttonTranslate = buttonTranslate;
        this.welcomeEnable = welcomeEnable;
        this.welcomeInformation = welcomeInformation;
        this.welcomeTextColor = welcomeTextColor;
        this.welcomeTextOpacity = welcomeTextOpacity;
        this.welcomeTextFontSize = welcomeTextFontSize;
        this.termsOfServiceEnable = termsOfServiceEnable;
        this.termsOfService = termsOfService;
        this.termsOfServiceText = termsOfServiceText;
        this.termsOfServiceFontSize = termsOfServiceFontSize;
        this.termsOfServiceUrlTexts = termsOfServiceUrlTexts;
        this.copyrightEnable = copyrightEnable;
        this.copyright = copyright;
        this.copyrightTextColor = copyrightTextColor;
        this.copyrightTextOpacity = copyrightTextOpacity;
        this.copyrightTextFontSize = copyrightTextFontSize;
        this.redirectionCountDownEnable = redirectionCountDownEnable;
        this.advertisement = advertisement;
    }

    @Generated
    public PortalCustomizeVO() {
    }

    @Generated
    public static class PortalCustomizeVOBuilder {
        @Generated
        private Integer defaultLanguage;
        @Generated
        private Integer background;
        @Generated
        private String backgroundPictureId;
        @Generated
        private String mobileBackgroundPictureId;
        @Generated
        private PortalPictureVO backgroundPicture;
        @Generated
        private PortalPictureVO mobileBackgroundPicture;
        @Generated
        private String backgroundColor;
        @Generated
        private Integer backgroundOpacity;
        @Generated
        private String logoPictureId;
        @Generated
        private PortalPictureVO logoPicture;
        @Generated
        private Integer logoPosition;
        @Generated
        private Boolean logoDisplay;
        @Generated
        private Integer logoSize;
        @Generated
        private Float logoPositionRatio;
        @Generated
        private Integer logoTranslate;
        @Generated
        private String inputBoxColor;
        @Generated
        private Integer inputBoxOpacity;
        @Generated
        private String inputTextColor;
        @Generated
        private Integer inputTextOpacity;
        @Generated
        private String buttonColor;
        @Generated
        private Integer buttonOpacity;
        @Generated
        private String buttonTextColor;
        @Generated
        private Integer buttonTextOpacity;
        @Generated
        private Integer buttonPosition;
        @Generated
        private String buttonText;
        @Generated
        private String formAuthButtonText;
        @Generated
        private Float buttonPositionRatio;
        @Generated
        private Integer buttonTranslate;
        @Generated
        private Boolean welcomeEnable;
        @Generated
        private String welcomeInformation;
        @Generated
        private String welcomeTextColor;
        @Generated
        private Integer welcomeTextOpacity;
        @Generated
        private Integer welcomeTextFontSize;
        @Generated
        private Boolean termsOfServiceEnable;
        @Generated
        private String termsOfService;
        @Generated
        private String termsOfServiceText;
        @Generated
        private Integer termsOfServiceFontSize;
        @Generated
        private List<TermsOfServiceUrlVO> termsOfServiceUrlTexts;
        @Generated
        private Boolean copyrightEnable;
        @Generated
        private String copyright;
        @Generated
        private String copyrightTextColor;
        @Generated
        private Integer copyrightTextOpacity;
        @Generated
        private Integer copyrightTextFontSize;
        @Generated
        private Boolean redirectionCountDownEnable;
        @Generated
        private AdvertisementSettingVO advertisement;

        @Generated
        PortalCustomizeVOBuilder() {
        }

        @Generated
        public PortalCustomizeVOBuilder defaultLanguage(Integer defaultLanguage) {
            this.defaultLanguage = defaultLanguage;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder background(Integer background) {
            this.background = background;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder backgroundPictureId(String backgroundPictureId) {
            this.backgroundPictureId = backgroundPictureId;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder mobileBackgroundPictureId(String mobileBackgroundPictureId) {
            this.mobileBackgroundPictureId = mobileBackgroundPictureId;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder backgroundPicture(PortalPictureVO backgroundPicture) {
            this.backgroundPicture = backgroundPicture;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder mobileBackgroundPicture(PortalPictureVO mobileBackgroundPicture) {
            this.mobileBackgroundPicture = mobileBackgroundPicture;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder backgroundOpacity(Integer backgroundOpacity) {
            this.backgroundOpacity = backgroundOpacity;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder logoPictureId(String logoPictureId) {
            this.logoPictureId = logoPictureId;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder logoPicture(PortalPictureVO logoPicture) {
            this.logoPicture = logoPicture;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder logoPosition(Integer logoPosition) {
            this.logoPosition = logoPosition;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder logoDisplay(Boolean logoDisplay) {
            this.logoDisplay = logoDisplay;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder logoSize(Integer logoSize) {
            this.logoSize = logoSize;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder logoPositionRatio(Float logoPositionRatio) {
            this.logoPositionRatio = logoPositionRatio;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder logoTranslate(Integer logoTranslate) {
            this.logoTranslate = logoTranslate;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder inputBoxColor(String inputBoxColor) {
            this.inputBoxColor = inputBoxColor;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder inputBoxOpacity(Integer inputBoxOpacity) {
            this.inputBoxOpacity = inputBoxOpacity;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder inputTextColor(String inputTextColor) {
            this.inputTextColor = inputTextColor;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder inputTextOpacity(Integer inputTextOpacity) {
            this.inputTextOpacity = inputTextOpacity;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder buttonColor(String buttonColor) {
            this.buttonColor = buttonColor;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder buttonOpacity(Integer buttonOpacity) {
            this.buttonOpacity = buttonOpacity;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder buttonTextColor(String buttonTextColor) {
            this.buttonTextColor = buttonTextColor;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder buttonTextOpacity(Integer buttonTextOpacity) {
            this.buttonTextOpacity = buttonTextOpacity;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder buttonPosition(Integer buttonPosition) {
            this.buttonPosition = buttonPosition;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder buttonText(String buttonText) {
            this.buttonText = buttonText;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder formAuthButtonText(String formAuthButtonText) {
            this.formAuthButtonText = formAuthButtonText;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder buttonPositionRatio(Float buttonPositionRatio) {
            this.buttonPositionRatio = buttonPositionRatio;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder buttonTranslate(Integer buttonTranslate) {
            this.buttonTranslate = buttonTranslate;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder welcomeEnable(Boolean welcomeEnable) {
            this.welcomeEnable = welcomeEnable;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder welcomeInformation(String welcomeInformation) {
            this.welcomeInformation = welcomeInformation;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder welcomeTextColor(String welcomeTextColor) {
            this.welcomeTextColor = welcomeTextColor;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder welcomeTextOpacity(Integer welcomeTextOpacity) {
            this.welcomeTextOpacity = welcomeTextOpacity;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder welcomeTextFontSize(Integer welcomeTextFontSize) {
            this.welcomeTextFontSize = welcomeTextFontSize;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder termsOfServiceEnable(Boolean termsOfServiceEnable) {
            this.termsOfServiceEnable = termsOfServiceEnable;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder termsOfService(String termsOfService) {
            this.termsOfService = termsOfService;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder termsOfServiceText(String termsOfServiceText) {
            this.termsOfServiceText = termsOfServiceText;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder termsOfServiceFontSize(Integer termsOfServiceFontSize) {
            this.termsOfServiceFontSize = termsOfServiceFontSize;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder termsOfServiceUrlTexts(List<TermsOfServiceUrlVO> termsOfServiceUrlTexts) {
            this.termsOfServiceUrlTexts = termsOfServiceUrlTexts;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder copyrightEnable(Boolean copyrightEnable) {
            this.copyrightEnable = copyrightEnable;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder copyright(String copyright) {
            this.copyright = copyright;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder copyrightTextColor(String copyrightTextColor) {
            this.copyrightTextColor = copyrightTextColor;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder copyrightTextOpacity(Integer copyrightTextOpacity) {
            this.copyrightTextOpacity = copyrightTextOpacity;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder copyrightTextFontSize(Integer copyrightTextFontSize) {
            this.copyrightTextFontSize = copyrightTextFontSize;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder redirectionCountDownEnable(Boolean redirectionCountDownEnable) {
            this.redirectionCountDownEnable = redirectionCountDownEnable;
            return this;
        }

        @Generated
        public PortalCustomizeVOBuilder advertisement(AdvertisementSettingVO advertisement) {
            this.advertisement = advertisement;
            return this;
        }

        @Generated
        public PortalCustomizeVO build() {
            return new PortalCustomizeVO(this.defaultLanguage, this.background, this.backgroundPictureId, this.mobileBackgroundPictureId, this.backgroundPicture, this.mobileBackgroundPicture, this.backgroundColor, this.backgroundOpacity, this.logoPictureId, this.logoPicture, this.logoPosition, this.logoDisplay, this.logoSize, this.logoPositionRatio, this.logoTranslate, this.inputBoxColor, this.inputBoxOpacity, this.inputTextColor, this.inputTextOpacity, this.buttonColor, this.buttonOpacity, this.buttonTextColor, this.buttonTextOpacity, this.buttonPosition, this.buttonText, this.formAuthButtonText, this.buttonPositionRatio, this.buttonTranslate, this.welcomeEnable, this.welcomeInformation, this.welcomeTextColor, this.welcomeTextOpacity, this.welcomeTextFontSize, this.termsOfServiceEnable, this.termsOfService, this.termsOfServiceText, this.termsOfServiceFontSize, this.termsOfServiceUrlTexts, this.copyrightEnable, this.copyright, this.copyrightTextColor, this.copyrightTextOpacity, this.copyrightTextFontSize, this.redirectionCountDownEnable, this.advertisement);
        }

        @Generated
        public String toString() {
            return "PortalCustomizeVO.PortalCustomizeVOBuilder(defaultLanguage=" + this.defaultLanguage + ", background=" + this.background + ", backgroundPictureId=" + this.backgroundPictureId + ", mobileBackgroundPictureId=" + this.mobileBackgroundPictureId + ", backgroundPicture=" + this.backgroundPicture + ", mobileBackgroundPicture=" + this.mobileBackgroundPicture + ", backgroundColor=" + this.backgroundColor + ", backgroundOpacity=" + this.backgroundOpacity + ", logoPictureId=" + this.logoPictureId + ", logoPicture=" + this.logoPicture + ", logoPosition=" + this.logoPosition + ", logoDisplay=" + this.logoDisplay + ", logoSize=" + this.logoSize + ", logoPositionRatio=" + this.logoPositionRatio + ", logoTranslate=" + this.logoTranslate + ", inputBoxColor=" + this.inputBoxColor + ", inputBoxOpacity=" + this.inputBoxOpacity + ", inputTextColor=" + this.inputTextColor + ", inputTextOpacity=" + this.inputTextOpacity + ", buttonColor=" + this.buttonColor + ", buttonOpacity=" + this.buttonOpacity + ", buttonTextColor=" + this.buttonTextColor + ", buttonTextOpacity=" + this.buttonTextOpacity + ", buttonPosition=" + this.buttonPosition + ", buttonText=" + this.buttonText + ", formAuthButtonText=" + this.formAuthButtonText + ", buttonPositionRatio=" + this.buttonPositionRatio + ", buttonTranslate=" + this.buttonTranslate + ", welcomeEnable=" + this.welcomeEnable + ", welcomeInformation=" + this.welcomeInformation + ", welcomeTextColor=" + this.welcomeTextColor + ", welcomeTextOpacity=" + this.welcomeTextOpacity + ", welcomeTextFontSize=" + this.welcomeTextFontSize + ", termsOfServiceEnable=" + this.termsOfServiceEnable + ", termsOfService=" + this.termsOfService + ", termsOfServiceText=" + this.termsOfServiceText + ", termsOfServiceFontSize=" + this.termsOfServiceFontSize + ", termsOfServiceUrlTexts=" + this.termsOfServiceUrlTexts + ", copyrightEnable=" + this.copyrightEnable + ", copyright=" + this.copyright + ", copyrightTextColor=" + this.copyrightTextColor + ", copyrightTextOpacity=" + this.copyrightTextOpacity + ", copyrightTextFontSize=" + this.copyrightTextFontSize + ", redirectionCountDownEnable=" + this.redirectionCountDownEnable + ", advertisement=" + this.advertisement + ")";
        }
    }
}

