/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.web.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import lombok.Generated;

public class LdapSettingVO {
    @NotNull(message="ldap parameter [ldapProfileId] should not be null")
    private @NotNull(message="ldap parameter [ldapProfileId] should not be null") String ldapProfileId;
    @NotNull
    @NumberSet(value={1, 2}, message="LdapSetting parameter [portalCustom] should be 1 or 2")
    private Integer portalCustom;
    @Pattern(regexp="http|https", message="LdapSetting parameter [externalUrlScheme] is supposed be \"http\" or \"https\"")
    private @Pattern(regexp="http|https", message="LdapSetting parameter [externalUrlScheme] is supposed be \"http\" or \"https\"") String externalUrlScheme;
    @Pattern(regexp="^(([-a-zA-Z0-9@:%._+~#=]{2,256}\\.[a-z]{2,63})|((?!255\\.255\\.255\\.255)((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\.)){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)))((:([1-9]|[1-9]\\d|[1-9]\\d{2}|[1-9]\\d{3}|[1-5]\\d{4}|6[0-4]\\d{3}|65[0-4]\\d{2}|655[0-2]\\d|6553[0-5]))?)(/([-a-zA-Z0-9@:%_+.~#?&//=]*))?$")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    private @Pattern(regexp="^(([-a-zA-Z0-9@:%._+~#=]{2,256}\\.[a-z]{2,63})|((?!255\\.255\\.255\\.255)((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\.)){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)))((:([1-9]|[1-9]\\d|[1-9]\\d{2}|[1-9]\\d{3}|[1-5]\\d{4}|6[0-4]\\d{3}|65[0-4]\\d{2}|655[0-2]\\d|6553[0-5]))?)(/([-a-zA-Z0-9@:%_+.~#?&//=]*))?$") String externalUrl;

    @JsonIgnore
    public boolean useExternalPortal() {
        return Objects.equals(2, this.portalCustom);
    }

    @Generated
    public String getLdapProfileId() {
        return this.ldapProfileId;
    }

    @Generated
    public Integer getPortalCustom() {
        return this.portalCustom;
    }

    @Generated
    public String getExternalUrlScheme() {
        return this.externalUrlScheme;
    }

    @Generated
    public String getExternalUrl() {
        return this.externalUrl;
    }

    @Generated
    public void setLdapProfileId(String ldapProfileId) {
        this.ldapProfileId = ldapProfileId;
    }

    @Generated
    public void setPortalCustom(Integer portalCustom) {
        this.portalCustom = portalCustom;
    }

    @Generated
    public void setExternalUrlScheme(String externalUrlScheme) {
        this.externalUrlScheme = externalUrlScheme;
    }

    @Generated
    public void setExternalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
    }

    @Generated
    public String toString() {
        return "LdapSettingVO(ldapProfileId=" + this.getLdapProfileId() + ", portalCustom=" + this.getPortalCustom() + ", externalUrlScheme=" + this.getExternalUrlScheme() + ", externalUrl=" + this.getExternalUrl() + ")";
    }

    @Generated
    public LdapSettingVO() {
    }

    @Generated
    public LdapSettingVO(String ldapProfileId, Integer portalCustom, String externalUrlScheme, String externalUrl) {
        this.ldapProfileId = ldapProfileId;
        this.portalCustom = portalCustom;
        this.externalUrlScheme = externalUrlScheme;
        this.externalUrl = externalUrl;
    }
}

