/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.web.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import lombok.Generated;

public class ExternalRadiusSettingVO {
    @NotNull
    private String radiusProfileId;
    @NotNull
    @NumberSet(value={1, 2}, message="ExternalRadiusSetting parameter [authMode] should be 1 or 2")
    private Integer authMode;
    @NotNull
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [nasId] should be visible ASCII, between 1 and 64 characters")
    private @NotNull @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [nasId] should be visible ASCII, between 1 and 64 characters") String nasId;
    @NotNull
    @NumberSet(value={1, 2}, message="ExternalRadiusSetting parameter [portalCustom] should be 1 or 2")
    private Integer portalCustom;
    @Pattern(regexp="http|https", message="ExternalRadiusSetting parameter [externalUrlScheme] is supposed be \"http\" or \"https\"")
    private @Pattern(regexp="http|https", message="ExternalRadiusSetting parameter [externalUrlScheme] is supposed be \"http\" or \"https\"") String externalUrlScheme;
    @Pattern(regexp="^(([-a-zA-Z0-9@:%._+~#=]{2,256}\\.[a-z]{2,63})|((?!255\\.255\\.255\\.255)((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\.)){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)))((:([1-9]|[1-9]\\d|[1-9]\\d{2}|[1-9]\\d{3}|[1-5]\\d{4}|6[0-4]\\d{3}|65[0-4]\\d{2}|655[0-2]\\d|6553[0-5]))?)(/([-a-zA-Z0-9@:%_+.~#?&//=]*))?$")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    private @Pattern(regexp="^(([-a-zA-Z0-9@:%._+~#=]{2,256}\\.[a-z]{2,63})|((?!255\\.255\\.255\\.255)((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\.)){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)))((:([1-9]|[1-9]\\d|[1-9]\\d{2}|[1-9]\\d{3}|[1-5]\\d{4}|6[0-4]\\d{3}|65[0-4]\\d{2}|655[0-2]\\d|6553[0-5]))?)(/([-a-zA-Z0-9@:%_+.~#?&//=]*))?$") String externalUrl;
    private Boolean disconnectReq;
    private Integer receiverPort;
    private Integer receiverPortStatus;
    @Nullable
    private Boolean logout;

    public void setDisconnectReq(Boolean disconnectReq) {
        if (OmadacType.s()) {
            return;
        }
        this.disconnectReq = disconnectReq;
    }

    public void setReceiverPort(Integer receiverPort) {
        if (OmadacType.s()) {
            return;
        }
        this.receiverPort = receiverPort;
    }

    @JsonIgnore
    public boolean useExternalPortal() {
        return Objects.equals(2, this.portalCustom);
    }

    @Generated
    public String getRadiusProfileId() {
        return this.radiusProfileId;
    }

    @Generated
    public Integer getAuthMode() {
        return this.authMode;
    }

    @Generated
    public String getNasId() {
        return this.nasId;
    }

    @Generated
    public Integer getPortalCustom() {
        return this.portalCustom;
    }

    @Generated
    public String getExternalUrlScheme() {
        return this.externalUrlScheme;
    }

    @Generated
    public String getExternalUrl() {
        return this.externalUrl;
    }

    @Generated
    public Boolean getDisconnectReq() {
        return this.disconnectReq;
    }

    @Generated
    public Integer getReceiverPort() {
        return this.receiverPort;
    }

    @Generated
    public Integer getReceiverPortStatus() {
        return this.receiverPortStatus;
    }

    @Nullable
    @Generated
    public Boolean getLogout() {
        return this.logout;
    }

    @Generated
    public ExternalRadiusSettingVO setRadiusProfileId(String radiusProfileId) {
        this.radiusProfileId = radiusProfileId;
        return this;
    }

    @Generated
    public ExternalRadiusSettingVO setAuthMode(Integer authMode) {
        this.authMode = authMode;
        return this;
    }

    @Generated
    public ExternalRadiusSettingVO setNasId(String nasId) {
        this.nasId = nasId;
        return this;
    }

    @Generated
    public ExternalRadiusSettingVO setPortalCustom(Integer portalCustom) {
        this.portalCustom = portalCustom;
        return this;
    }

    @Generated
    public ExternalRadiusSettingVO setExternalUrlScheme(String externalUrlScheme) {
        this.externalUrlScheme = externalUrlScheme;
        return this;
    }

    @Generated
    public ExternalRadiusSettingVO setExternalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
        return this;
    }

    @Generated
    public ExternalRadiusSettingVO setReceiverPortStatus(Integer receiverPortStatus) {
        this.receiverPortStatus = receiverPortStatus;
        return this;
    }

    @Generated
    public ExternalRadiusSettingVO setLogout(@Nullable Boolean logout) {
        this.logout = logout;
        return this;
    }

    @Generated
    public String toString() {
        return "ExternalRadiusSettingVO(radiusProfileId=" + this.getRadiusProfileId() + ", authMode=" + this.getAuthMode() + ", nasId=" + this.getNasId() + ", portalCustom=" + this.getPortalCustom() + ", externalUrlScheme=" + this.getExternalUrlScheme() + ", externalUrl=" + this.getExternalUrl() + ", disconnectReq=" + this.getDisconnectReq() + ", receiverPort=" + this.getReceiverPort() + ", receiverPortStatus=" + this.getReceiverPortStatus() + ", logout=" + this.getLogout() + ")";
    }

    @Generated
    public ExternalRadiusSettingVO() {
    }

    @Generated
    public ExternalRadiusSettingVO(String radiusProfileId, Integer authMode, String nasId, Integer portalCustom, String externalUrlScheme, String externalUrl, Boolean disconnectReq, Integer receiverPort, Integer receiverPortStatus, @Nullable Boolean logout) {
        this.radiusProfileId = radiusProfileId;
        this.authMode = authMode;
        this.nasId = nasId;
        this.portalCustom = portalCustom;
        this.externalUrlScheme = externalUrlScheme;
        this.externalUrl = externalUrl;
        this.disconnectReq = disconnectReq;
        this.receiverPort = receiverPort;
        this.receiverPortStatus = receiverPortStatus;
        this.logout = logout;
    }
}

