/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.internal.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Locale;
import lombok.Generated;
import org.springframework.http.ResponseCookie;

public class CookieDTO {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="value")
    private String value;
    @JsonProperty(value="domain")
    private String domain;
    @JsonProperty(value="maxAge")
    private Integer maxAge;
    @JsonProperty(value="path")
    private String path;
    @JsonProperty(value="secure")
    private Boolean secure = false;
    @JsonProperty(value="httpOnly")
    private Boolean httpOnly = false;

    public static CookieDTO build(ResponseCookie responseCookie) {
        CookieDTO cookieDTO = new CookieDTO();
        cookieDTO.setName(responseCookie.getName());
        cookieDTO.setValue(responseCookie.getValue());
        cookieDTO.setDomain(responseCookie.getDomain());
        cookieDTO.setMaxAge((int)responseCookie.getMaxAge().getSeconds());
        cookieDTO.setPath(responseCookie.getPath());
        cookieDTO.setSecure(responseCookie.isSecure());
        cookieDTO.setHttpOnly(responseCookie.isHttpOnly());
        return cookieDTO;
    }

    public void setDomain(String domain) {
        this.domain = domain.toLowerCase(Locale.ENGLISH);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public Integer getMaxAge() {
        return this.maxAge;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public Boolean getSecure() {
        return this.secure;
    }

    @Generated
    public Boolean getHttpOnly() {
        return this.httpOnly;
    }

    @JsonProperty(value="name")
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="value")
    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @JsonProperty(value="maxAge")
    @Generated
    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    @JsonProperty(value="path")
    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @JsonProperty(value="secure")
    @Generated
    public void setSecure(Boolean secure) {
        this.secure = secure;
    }

    @JsonProperty(value="httpOnly")
    @Generated
    public void setHttpOnly(Boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    @Generated
    public String toString() {
        return "CookieDTO(name=" + this.getName() + ", value=" + this.getValue() + ", domain=" + this.getDomain() + ", maxAge=" + this.getMaxAge() + ", path=" + this.getPath() + ", secure=" + this.getSecure() + ", httpOnly=" + this.getHttpOnly() + ")";
    }

    @Generated
    public CookieDTO() {
    }

    @Generated
    public CookieDTO(String name, String value, String domain, Integer maxAge, String path, Boolean secure, Boolean httpOnly) {
        this.name = name;
        this.value = value;
        this.domain = domain;
        this.maxAge = maxAge;
        this.path = path;
        this.secure = secure;
        this.httpOnly = httpOnly;
    }
}

