/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.app.vo;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.portal.api.app.vo.AppHotspotSettingVO;
import com.tplink.smb.omada.portal.api.web.vo.AuthTimeoutVO;
import com.tplink.smb.omada.portal.api.web.vo.SimplePasswordSettingVO;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

public class AppPortalSettingVO {
    public static final String PORTAL_NAME_REGEX = "^[^ ]$|^[^ ].{0,126}[^ ]$";
    private String id;
    @NotNull(message="Parameter [name] should not be null.")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$")
    private @NotNull(message="Parameter [name] should not be null.") @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$") String name;
    @NotNull(message="Parameter [enable] should not be null.")
    private @NotNull(message="Parameter [enable] should not be null.") Boolean enable;
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    private List<String> ssidList;
    private List<String> networkList;
    private Boolean httpsRedirectEnable;
    private Integer authType;
    @Valid
    private AppHotspotSettingVO hotspot;
    @Valid
    private AuthTimeoutVO authTimeout;
    @Valid
    private SimplePasswordSettingVO simplePassword;

    public OperationResponse<Object> validate(boolean isEssential) {
        if (this.httpsRedirectEnable == null) {
            return new OperationResponse(b.d, "Parameters [httpsRedirectEnable] should not be null.", null);
        }
        if (this.authType == null) {
            return new OperationResponse(b.d, "Parameters [authType] should not be null.", null);
        }
        if (this.authType != 0 && CollectionUtils.isEmpty(this.ssidList) && CollectionUtils.isEmpty(this.networkList)) {
            return new OperationResponse(b.d, "Parameters [ssidList] and [networkList] cannot be both empty.", null);
        }
        if (this.authType == 11 && CollectionUtils.isEmpty(this.hotspot.getEnabledTypes())) {
            return new OperationResponse(b.d, "Parameter [enabledTypes] cannot be empty.", null);
        }
        if (isEssential) {
            if (Boolean.TRUE.equals(this.enable) && this.authType != 1 && this.authType != 11) {
                return new OperationResponse(b.rU);
            }
            if (this.authType == 11 && (CollectionUtils.isEmpty(this.hotspot.getEnabledTypes()) || !Objects.equals(3, this.hotspot.getEnabledTypes().get(0)))) {
                return new OperationResponse(b.d, "Invalid auth type.", null);
            }
        } else if (Boolean.TRUE.equals(this.enable) && CollectionUtils.isEmpty(this.hotspot.getEnabledTypes())) {
            return new OperationResponse(b.rU);
        }
        if (this.authType == 1 && (this.authTimeout == null || this.simplePassword == null)) {
            return new OperationResponse(b.d, "Parameter [authTimeout] and [simplePassword] cannot be empty.", null);
        }
        return OperationResponse.SUCCESS;
    }

    @Generated
    public static AppPortalSettingVOBuilder builder() {
        return new AppPortalSettingVOBuilder();
    }

    @Generated
    public String toString() {
        return "AppPortalSettingVO(id=" + this.getId() + ", name=" + this.getName() + ", enable=" + this.getEnable() + ", ssidList=" + this.getSsidList() + ", networkList=" + this.getNetworkList() + ", httpsRedirectEnable=" + this.getHttpsRedirectEnable() + ", authType=" + this.getAuthType() + ", hotspot=" + this.getHotspot() + ", authTimeout=" + this.getAuthTimeout() + ", simplePassword=" + this.getSimplePassword() + ")";
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public List<String> getSsidList() {
        return this.ssidList;
    }

    @Generated
    public List<String> getNetworkList() {
        return this.networkList;
    }

    @Generated
    public Boolean getHttpsRedirectEnable() {
        return this.httpsRedirectEnable;
    }

    @Generated
    public Integer getAuthType() {
        return this.authType;
    }

    @Generated
    public AppHotspotSettingVO getHotspot() {
        return this.hotspot;
    }

    @Generated
    public AuthTimeoutVO getAuthTimeout() {
        return this.authTimeout;
    }

    @Generated
    public SimplePasswordSettingVO getSimplePassword() {
        return this.simplePassword;
    }

    @Generated
    public AppPortalSettingVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public AppPortalSettingVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public AppPortalSettingVO setEnable(Boolean enable) {
        this.enable = enable;
        return this;
    }

    @Generated
    public AppPortalSettingVO setSsidList(List<String> ssidList) {
        this.ssidList = ssidList;
        return this;
    }

    @Generated
    public AppPortalSettingVO setNetworkList(List<String> networkList) {
        this.networkList = networkList;
        return this;
    }

    @Generated
    public AppPortalSettingVO setHttpsRedirectEnable(Boolean httpsRedirectEnable) {
        this.httpsRedirectEnable = httpsRedirectEnable;
        return this;
    }

    @Generated
    public AppPortalSettingVO setAuthType(Integer authType) {
        this.authType = authType;
        return this;
    }

    @Generated
    public AppPortalSettingVO setHotspot(AppHotspotSettingVO hotspot) {
        this.hotspot = hotspot;
        return this;
    }

    @Generated
    public AppPortalSettingVO setAuthTimeout(AuthTimeoutVO authTimeout) {
        this.authTimeout = authTimeout;
        return this;
    }

    @Generated
    public AppPortalSettingVO setSimplePassword(SimplePasswordSettingVO simplePassword) {
        this.simplePassword = simplePassword;
        return this;
    }

    @Generated
    public AppPortalSettingVO() {
    }

    @Generated
    public AppPortalSettingVO(String id, String name, Boolean enable, List<String> ssidList, List<String> networkList, Boolean httpsRedirectEnable, Integer authType, AppHotspotSettingVO hotspot, AuthTimeoutVO authTimeout, SimplePasswordSettingVO simplePassword) {
        this.id = id;
        this.name = name;
        this.enable = enable;
        this.ssidList = ssidList;
        this.networkList = networkList;
        this.httpsRedirectEnable = httpsRedirectEnable;
        this.authType = authType;
        this.hotspot = hotspot;
        this.authTimeout = authTimeout;
        this.simplePassword = simplePassword;
    }

    @Generated
    public static class AppPortalSettingVOBuilder {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private Boolean enable;
        @Generated
        private List<String> ssidList;
        @Generated
        private List<String> networkList;
        @Generated
        private Boolean httpsRedirectEnable;
        @Generated
        private Integer authType;
        @Generated
        private AppHotspotSettingVO hotspot;
        @Generated
        private AuthTimeoutVO authTimeout;
        @Generated
        private SimplePasswordSettingVO simplePassword;

        @Generated
        AppPortalSettingVOBuilder() {
        }

        @Generated
        public AppPortalSettingVOBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public AppPortalSettingVOBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public AppPortalSettingVOBuilder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        @Generated
        public AppPortalSettingVOBuilder ssidList(List<String> ssidList) {
            this.ssidList = ssidList;
            return this;
        }

        @Generated
        public AppPortalSettingVOBuilder networkList(List<String> networkList) {
            this.networkList = networkList;
            return this;
        }

        @Generated
        public AppPortalSettingVOBuilder httpsRedirectEnable(Boolean httpsRedirectEnable) {
            this.httpsRedirectEnable = httpsRedirectEnable;
            return this;
        }

        @Generated
        public AppPortalSettingVOBuilder authType(Integer authType) {
            this.authType = authType;
            return this;
        }

        @Generated
        public AppPortalSettingVOBuilder hotspot(AppHotspotSettingVO hotspot) {
            this.hotspot = hotspot;
            return this;
        }

        @Generated
        public AppPortalSettingVOBuilder authTimeout(AuthTimeoutVO authTimeout) {
            this.authTimeout = authTimeout;
            return this;
        }

        @Generated
        public AppPortalSettingVOBuilder simplePassword(SimplePasswordSettingVO simplePassword) {
            this.simplePassword = simplePassword;
            return this;
        }

        @Generated
        public AppPortalSettingVO build() {
            return new AppPortalSettingVO(this.id, this.name, this.enable, this.ssidList, this.networkList, this.httpsRedirectEnable, this.authType, this.hotspot, this.authTimeout, this.simplePassword);
        }

        @Generated
        public String toString() {
            return "AppPortalSettingVO.AppPortalSettingVOBuilder(id=" + this.id + ", name=" + this.name + ", enable=" + this.enable + ", ssidList=" + this.ssidList + ", networkList=" + this.networkList + ", httpsRedirectEnable=" + this.httpsRedirectEnable + ", authType=" + this.authType + ", hotspot=" + this.hotspot + ", authTimeout=" + this.authTimeout + ", simplePassword=" + this.simplePassword + ")";
        }
    }
}

