/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.app.vo;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

public class AppLocaluserVO {
    private String id;
    @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$")
    @Length(min=1, max=128, message="Length of UserName is from 1 to 128.")
    @NotNull
    private @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$") @Length(min=1, max=128, message="Length of UserName is from 1 to 128.") @NotNull String userName;
    @Length(min=1, max=128, message="Length of PassWord is from 1 to 128.")
    @PII(strategy=PIIMaskStrategy.HASH)
    @NotNull
    private @Length(min=1, max=128, message="Length of PassWord is from 1 to 128.") @NotNull String password;
    @NotNull
    private Boolean enable;
    @NotNull
    private Long expirationTime;
    @NotNull
    @NumberSet(value={0, 1, 2}, message="Value of bindingType should be 0, 1 or 2")
    private Integer bindingType;
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @a
    private String macAddress;
    @Range(min=1L, max=2048L, message="Value of Maximum Users is from 1 to 2048.")
    private @Range(min=1L, max=2048L, message="Value of Maximum Users is from 1 to 2048.") Integer maxUsers;
    @NotNull
    private Boolean downLimitEnable;
    @Range(min=0L, max=0xA00000L, message="Value of limit is from 0 to 10485760 Kbps.")
    private @Range(min=0L, max=0xA00000L, message="Value of limit is from 0 to 10485760 Kbps.") Long downLimit;
    @NotNull
    private Boolean upLimitEnable;
    @Range(min=0L, max=0xA00000L, message="Value of limit is from 0 to 10485760 Kbps.")
    private @Range(min=0L, max=0xA00000L, message="Value of limit is from 0 to 10485760 Kbps.") Long upLimit;
    @NotNull
    private Boolean trafficLimitEnable;
    @Range(min=0L, max=0xA00000L, message="Value of limit is from 1 to 10485760 MB.")
    private @Range(min=0L, max=0xA00000L, message="Value of limit is from 1 to 10485760 MB.") Long trafficLimit;
    private Integer trafficLimitFrequency;
    private Boolean trafficLeft;
    private Long trafficUsed;
    private List<String> portals;
    private List<String> portalNames;
    @Nullable
    private Boolean logout;

    public OperationResponse<?> validate() {
        if (Boolean.TRUE.equals(this.downLimitEnable) && this.downLimit == null) {
            return OperationResponse.PARAM_ERROR;
        }
        if (Boolean.TRUE.equals(this.upLimitEnable) && this.upLimit == null) {
            return OperationResponse.PARAM_ERROR;
        }
        if (this.bindingType == 0 && this.maxUsers == null) {
            return OperationResponse.PARAM_ERROR;
        }
        if (this.bindingType == 1 && this.macAddress == null) {
            return OperationResponse.PARAM_ERROR;
        }
        if (CollectionUtils.isEmpty(this.portals)) {
            return new OperationResponse(b.JM);
        }
        return OperationResponse.SUCCESS;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public Long getExpirationTime() {
        return this.expirationTime;
    }

    @Generated
    public Integer getBindingType() {
        return this.bindingType;
    }

    @Generated
    public String getMacAddress() {
        return this.macAddress;
    }

    @Generated
    public Integer getMaxUsers() {
        return this.maxUsers;
    }

    @Generated
    public Boolean getDownLimitEnable() {
        return this.downLimitEnable;
    }

    @Generated
    public Long getDownLimit() {
        return this.downLimit;
    }

    @Generated
    public Boolean getUpLimitEnable() {
        return this.upLimitEnable;
    }

    @Generated
    public Long getUpLimit() {
        return this.upLimit;
    }

    @Generated
    public Boolean getTrafficLimitEnable() {
        return this.trafficLimitEnable;
    }

    @Generated
    public Long getTrafficLimit() {
        return this.trafficLimit;
    }

    @Generated
    public Integer getTrafficLimitFrequency() {
        return this.trafficLimitFrequency;
    }

    @Generated
    public Boolean getTrafficLeft() {
        return this.trafficLeft;
    }

    @Generated
    public Long getTrafficUsed() {
        return this.trafficUsed;
    }

    @Generated
    public List<String> getPortals() {
        return this.portals;
    }

    @Generated
    public List<String> getPortalNames() {
        return this.portalNames;
    }

    @Nullable
    @Generated
    public Boolean getLogout() {
        return this.logout;
    }

    @Generated
    public AppLocaluserVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public AppLocaluserVO setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    @Generated
    public AppLocaluserVO setPassword(String password) {
        this.password = password;
        return this;
    }

    @Generated
    public AppLocaluserVO setEnable(Boolean enable) {
        this.enable = enable;
        return this;
    }

    @Generated
    public AppLocaluserVO setExpirationTime(Long expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    @Generated
    public AppLocaluserVO setBindingType(Integer bindingType) {
        this.bindingType = bindingType;
        return this;
    }

    @Generated
    public AppLocaluserVO setMacAddress(String macAddress) {
        this.macAddress = macAddress;
        return this;
    }

    @Generated
    public AppLocaluserVO setMaxUsers(Integer maxUsers) {
        this.maxUsers = maxUsers;
        return this;
    }

    @Generated
    public AppLocaluserVO setDownLimitEnable(Boolean downLimitEnable) {
        this.downLimitEnable = downLimitEnable;
        return this;
    }

    @Generated
    public AppLocaluserVO setDownLimit(Long downLimit) {
        this.downLimit = downLimit;
        return this;
    }

    @Generated
    public AppLocaluserVO setUpLimitEnable(Boolean upLimitEnable) {
        this.upLimitEnable = upLimitEnable;
        return this;
    }

    @Generated
    public AppLocaluserVO setUpLimit(Long upLimit) {
        this.upLimit = upLimit;
        return this;
    }

    @Generated
    public AppLocaluserVO setTrafficLimitEnable(Boolean trafficLimitEnable) {
        this.trafficLimitEnable = trafficLimitEnable;
        return this;
    }

    @Generated
    public AppLocaluserVO setTrafficLimit(Long trafficLimit) {
        this.trafficLimit = trafficLimit;
        return this;
    }

    @Generated
    public AppLocaluserVO setTrafficLimitFrequency(Integer trafficLimitFrequency) {
        this.trafficLimitFrequency = trafficLimitFrequency;
        return this;
    }

    @Generated
    public AppLocaluserVO setTrafficLeft(Boolean trafficLeft) {
        this.trafficLeft = trafficLeft;
        return this;
    }

    @Generated
    public AppLocaluserVO setTrafficUsed(Long trafficUsed) {
        this.trafficUsed = trafficUsed;
        return this;
    }

    @Generated
    public AppLocaluserVO setPortals(List<String> portals) {
        this.portals = portals;
        return this;
    }

    @Generated
    public AppLocaluserVO setPortalNames(List<String> portalNames) {
        this.portalNames = portalNames;
        return this;
    }

    @Generated
    public AppLocaluserVO setLogout(@Nullable Boolean logout) {
        this.logout = logout;
        return this;
    }

    @Generated
    public String toString() {
        return "AppLocaluserVO(id=" + this.getId() + ", userName=" + this.getUserName() + ", password=" + this.getPassword() + ", enable=" + this.getEnable() + ", expirationTime=" + this.getExpirationTime() + ", bindingType=" + this.getBindingType() + ", macAddress=" + this.getMacAddress() + ", maxUsers=" + this.getMaxUsers() + ", downLimitEnable=" + this.getDownLimitEnable() + ", downLimit=" + this.getDownLimit() + ", upLimitEnable=" + this.getUpLimitEnable() + ", upLimit=" + this.getUpLimit() + ", trafficLimitEnable=" + this.getTrafficLimitEnable() + ", trafficLimit=" + this.getTrafficLimit() + ", trafficLimitFrequency=" + this.getTrafficLimitFrequency() + ", trafficLeft=" + this.getTrafficLeft() + ", trafficUsed=" + this.getTrafficUsed() + ", portals=" + this.getPortals() + ", portalNames=" + this.getPortalNames() + ", logout=" + this.getLogout() + ")";
    }

    @Generated
    public AppLocaluserVO() {
    }

    @Generated
    public AppLocaluserVO(String id, String userName, String password, Boolean enable, Long expirationTime, Integer bindingType, String macAddress, Integer maxUsers, Boolean downLimitEnable, Long downLimit, Boolean upLimitEnable, Long upLimit, Boolean trafficLimitEnable, Long trafficLimit, Integer trafficLimitFrequency, Boolean trafficLeft, Long trafficUsed, List<String> portals, List<String> portalNames, @Nullable Boolean logout) {
        this.id = id;
        this.userName = userName;
        this.password = password;
        this.enable = enable;
        this.expirationTime = expirationTime;
        this.bindingType = bindingType;
        this.macAddress = macAddress;
        this.maxUsers = maxUsers;
        this.downLimitEnable = downLimitEnable;
        this.downLimit = downLimit;
        this.upLimitEnable = upLimitEnable;
        this.upLimit = upLimit;
        this.trafficLimitEnable = trafficLimitEnable;
        this.trafficLimit = trafficLimit;
        this.trafficLimitFrequency = trafficLimitFrequency;
        this.trafficLeft = trafficLeft;
        this.trafficUsed = trafficUsed;
        this.portals = portals;
        this.portalNames = portalNames;
        this.logout = logout;
    }
}

