/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.ratelimit.configuration;

import com.tplink.smb.omada.common.obfuscate.KeepClass;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="omada.rate-limit")
@KeepClass
public class OmadaRateLimiterProperties {
    private Map<String, CountingWindowLimiterProp> countingWindowLimiters = new HashMap<String, CountingWindowLimiterProp>();
    private Map<String, TokenBucketLimiterProp> tokenBucketLimiters = new HashMap<String, TokenBucketLimiterProp>();

    @Nullable
    public CountingWindowLimiterProp getLimiter(@Nonnull String limiterName) {
        if (this.countingWindowLimiters == null) {
            return null;
        }
        return this.countingWindowLimiters.get(limiterName);
    }

    @Nullable
    public TokenBucketLimiterProp getTokenBucketLimiter(@Nonnull String tokenBucketName) {
        if (this.tokenBucketLimiters == null) {
            return null;
        }
        return Optional.ofNullable(this.tokenBucketLimiters).map(tokenBucketLimiterPropMap -> (TokenBucketLimiterProp)tokenBucketLimiterPropMap.get(tokenBucketName)).orElse(null);
    }

    @Generated
    public Map<String, CountingWindowLimiterProp> getCountingWindowLimiters() {
        return this.countingWindowLimiters;
    }

    @Generated
    public Map<String, TokenBucketLimiterProp> getTokenBucketLimiters() {
        return this.tokenBucketLimiters;
    }

    @Generated
    public void setCountingWindowLimiters(Map<String, CountingWindowLimiterProp> countingWindowLimiters) {
        this.countingWindowLimiters = countingWindowLimiters;
    }

    @Generated
    public void setTokenBucketLimiters(Map<String, TokenBucketLimiterProp> tokenBucketLimiters) {
        this.tokenBucketLimiters = tokenBucketLimiters;
    }

    @Generated
    public String toString() {
        return "OmadaRateLimiterProperties(countingWindowLimiters=" + this.getCountingWindowLimiters() + ", tokenBucketLimiters=" + this.getTokenBucketLimiters() + ")";
    }

    @KeepClass
    public static class CountingWindowLimiterProp {
        @Min(value=1L)
        private @Min(value=1L) int windowSec;
        @Min(value=1L)
        private @Min(value=1L) int concurrency;
        @NotNull
        private String cacheName;

        @Generated
        public int getWindowSec() {
            return this.windowSec;
        }

        @Generated
        public int getConcurrency() {
            return this.concurrency;
        }

        @Generated
        public String getCacheName() {
            return this.cacheName;
        }

        @Generated
        public void setWindowSec(int windowSec) {
            this.windowSec = windowSec;
        }

        @Generated
        public void setConcurrency(int concurrency) {
            this.concurrency = concurrency;
        }

        @Generated
        public void setCacheName(String cacheName) {
            this.cacheName = cacheName;
        }

        @Generated
        public String toString() {
            return "OmadaRateLimiterProperties.CountingWindowLimiterProp(windowSec=" + this.getWindowSec() + ", concurrency=" + this.getConcurrency() + ", cacheName=" + this.getCacheName() + ")";
        }
    }

    @KeepClass
    public static class TokenBucketLimiterProp {
        @Min(value=1L)
        private @Min(value=1L) int tokenCapacity;
        @Min(value=1L)
        private @Min(value=1L) int tokenRate;
        @Min(value=1L)
        private @Min(value=1L) int acquireTokenNum = 1;
        @NotNull
        private String cacheName;
        @NotNull
        private String counterDateFormat = "yyyyMMdd";
        @NotNull
        private Duration counterTimeToLive = Duration.ofDays(10L);

        @Generated
        public int getTokenCapacity() {
            return this.tokenCapacity;
        }

        @Generated
        public int getTokenRate() {
            return this.tokenRate;
        }

        @Generated
        public int getAcquireTokenNum() {
            return this.acquireTokenNum;
        }

        @Generated
        public String getCacheName() {
            return this.cacheName;
        }

        @Generated
        public String getCounterDateFormat() {
            return this.counterDateFormat;
        }

        @Generated
        public Duration getCounterTimeToLive() {
            return this.counterTimeToLive;
        }

        @Generated
        public void setTokenCapacity(int tokenCapacity) {
            this.tokenCapacity = tokenCapacity;
        }

        @Generated
        public void setTokenRate(int tokenRate) {
            this.tokenRate = tokenRate;
        }

        @Generated
        public void setAcquireTokenNum(int acquireTokenNum) {
            this.acquireTokenNum = acquireTokenNum;
        }

        @Generated
        public void setCacheName(String cacheName) {
            this.cacheName = cacheName;
        }

        @Generated
        public void setCounterDateFormat(String counterDateFormat) {
            this.counterDateFormat = counterDateFormat;
        }

        @Generated
        public void setCounterTimeToLive(Duration counterTimeToLive) {
            this.counterTimeToLive = counterTimeToLive;
        }

        @Generated
        public String toString() {
            return "OmadaRateLimiterProperties.TokenBucketLimiterProp(tokenCapacity=" + this.getTokenCapacity() + ", tokenRate=" + this.getTokenRate() + ", acquireTokenNum=" + this.getAcquireTokenNum() + ", cacheName=" + this.getCacheName() + ", counterDateFormat=" + this.getCounterDateFormat() + ", counterTimeToLive=" + this.getCounterTimeToLive() + ")";
        }
    }
}

